
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ADDRAPI.H__   1.13   13 Dec 1996 11:17:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ADDRAPI.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:17:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:48   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:02   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:14   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:28   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:02   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:35:42   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:08   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:14   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:38   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Addrapi.h
**
**  Description: Main file of the address server API
**
**  Status: Initialization
**          1996/03/05        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
******************************************************************************/

/**----------------------------------------------------------------------
 **   AdrAddrToHex
 **
 **   addr        Set to the address.
 **   adrstr      Set to the converted address text string .
 **
 **   Remark
 **      Call this function to convert an address to text string. The
 **      address descripted by the ADDRESS struct.
 **      If there is no space, the adrSpace must set to 51SPACE_UNDEFINE.
 **      The result hex string hasn't any leading zero.
 **
 **   Return value
 **      One of the enum of ADDR_RETCODE.
 **      If this return value equal to ADDR_OK, the convert is successful.
 **      (See the defination of the ADDR_RETCODE)
 **
 **      Examples
 **         char         strTemp[150];
 **         ADDR_RETCODE retCode;
 **         ADDRESS      address;
 **
 **         address.adrSpace = SPACE_PROGRAM;
 **         address.address = 100;
 **         retCode = AdrAddrToHex(address, strTemp);
 **         if (ADR_OK == retCode)
 **             // The convert is successful. The address is correct.
 **         else
 **             // The convert is failure. The address has some error
 **
 **         The address of 100 in program area will be converted to the
 **         hex text string strTemp. The parameter strTemp is change to
 **         "P:0x64".
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrAddrToHex( const ADDRESS   addr,  LPSTR    adrstr );

 ADDR_RETCODE
 AdrAddrToHex( const ADDRESS   addr,  CString  &adrstr );


/**----------------------------------------------------------------------
 **   AdrAddrToDec
 **
 **   addr     Set to the address.
 **   adrstr   Set to the converted address dec text string .
 **
 **   Remark
 **   Call this function to convert an address to dec text string. The space
 **   style's string will add to the front of the address's string.
 **   The converted address text string will store in the third parameter
 **   (adrstr).
 **   If there is no space, the adrSpace must set to 51SPACE_UNDEFINE.
 **   The result hex string hasn't any leading zero.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE)
 **
 **   Examples
 **      char         strTemp[150];
 **      ADDR_RETCODE retCode;
 **      ADDRESS      address;
 **
 **      address.adrSpace = SPACE_PROGRAM;
 **      address.address = 100;
 **      retCode = AdrAddrToDec(address, strTemp);
 **      if (ADR_OK == retCode)
 **         // The convert is successful. The address is correct.
 **      else
 **         // The convert is failure. The address has some error
 **
 **   The address of 100 in program area will be converted to the hex text
 **   string strTemp. The parameter strTemp is change to "P:100
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrAddrToDec( const ADDRESS   addr, LPSTR adrstr );

 ADDR_RETCODE
 AdrAddrToDec( const ADDRESS   addr, CString &adrstr );


/**----------------------------------------------------------------------
 **   AdrTextToAddr
 **
 **   adrstr  Set to the address text string;
 **   addr    Set to the return address(converted address)
 **
 **   Remark
 **   Call this function to convert a hex address text string.
 **   The converted address store in the second parameter(addr).
 **   The address text string will set to hex string or dec string.
 **   Distinguish the two string by the leading char "0x".
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **   If the address text string soesn't include any space, the field
 **   in ADDRESS (adrSpace) will set to SPACE_UNDEFINE.
 **
 **   Examples
 **       char            *adrStr = "r:0x64";
 **       ADDRESS         address;
 **       ADDR_RETCODE    retCode;
 **
 **       retCode = AdrHexToAddr(adrstr, address);
 **       if (ADR_OK == retCode)
 **           // The convert is successful. The address is correct.
 **       else
 **           // The convert is failure. The address has some error
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrTextToAddr(const LPSTR  adrstr, ADDRESS &addr, UINT isHex = 1);

 ADDR_RETCODE
 AdrTextToAddr(const CString& adrstr, ADDRESS &addr, UINT isHex = 1);

 // For shell window
 //  
 ADDR_RETCODE
 AdrShellToAddr(const CString& adrstr, ADDRESS &addr, 
                ADDR_SPACE Space = ADDR_SPACE(0));

 ADDR_RETCODE
 AdrShellToAddr(const LPSTR  adrstr, ADDRESS &addr, 
                ADDR_SPACE Space = ADDR_SPACE(0));
  
 // 
 // For shell window only the address is in register area
 // for Create & Query
 // 
 ADDR_RETCODE
 AdrShellSFR(const CString& adrstr, ADDRESS &addr, 
             CString& tagAdrString, ADDR_SPACE Space = ADDR_SPACE(1));
   
 ADDR_RETCODE
 AdrShellSFR(const LPSTR  adrstr, ADDRESS &addr, 
             char* tagAdrString, ADDR_SPACE Space = ADDR_SPACE(1));

/**---------------------------------------------------------------------- 
 **   CheckAddrRange
 ** 
 **   address     Set to the address
 **   
 **   Remark
 **   Call this function to check the address range
 **
 **----------------------------------------------------------------------*/

 BOOL
 AdrCheckAddrRange(ADDRESS address);
   
/**----------------------------------------------------------------------
 **   AdrCheck2Add
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string.
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrCheck2Addr(const LPSTR adrstr1, const LPSTR  adrstr2 );

 ADDR_RETCODE
 AdrCheck2Addr(const CString&   adrstr1, const CString&    adrstr2 );

 ADDR_RETCODE
 AdrCheck2Addr(ADDRESS  adddress1, ADDRESS   address2);

/**----------------------------------------------------------------------
 **   AdrShlCheck2Add
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string. Only for shell
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrShlCheck2Addr(const LPSTR adrstr1, const LPSTR  adrstr2, ADDR_SPACE space);

 ADDR_RETCODE
 AdrShlCheck2Addr(const CString&   adrstr1, const CString&    adrstr2, ADDR_SPACE space);

 ADDR_RETCODE
 AdrShlCheck2Addr(ADDRESS  adddress1, ADDRESS   address2, ADDR_SPACE space);

/**----------------------------------------------------------------------
 **   adrstr      Set to the address text string;
 **
 **   Remark
 **   Call this function to check the address text string.
 **   No converting.
 **
 **   Return value
 **   True if the address text string is correct.
 **----------------------------------------------------------------------*/
 BOOL
 AdrIsOk(const LPSTR   adrstr);

 BOOL
 AdrIsOk(const CString&  adrstr);


/**----------------------------------------------------------------------
 **   AdrErrorDeal
 **  
 **   Remark
 **   Process the address server's error.
 **   Call this function to display a message box(for general window process) if the callers don't want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
 void
 AdrErrorDeal(ADDR_RETCODE  retCode, CString &error);
 
/**----------------------------------------------------------------------
 **   Remark
 **   Process the address server's error.
 **   Call this function to display a message box(for general window process) if the callers don't want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
 void 
 AdrSetAddrRange();    // Get all address range Max and Min

/**----------------------------------------------------------------------
 **   addrstr      Set to the address text string;
 **
 **   Remark
 **   Call this function to check the address text string is in code area 
 **   or not.
 **
 **   Return value
 **   True if the address text string is correct and in code area.
 **   FASLE if the address text string is wrong or not in code area.
 **   
 **----------------------------------------------------------------------*/
 BOOL
 AdrIsP(const char* addrStr);
 
 BOOL
 AdrIsP(const CString addrStr);

 void	
 ShowErrorBank();

//////////////////////(EOF of ADDRAPI.H)/////////////////////
 
