
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/BTNBAR.H__   1.13   13 Dec 1996 11:18:02   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/BTNBAR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:02   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:54   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:20   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:26   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:47:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:38   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:02   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:24   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:08   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BTNBAR.H
//
//  Description:The header file for the class: CSuperToolBar
//
//  Author:     Roger Zhang
//
//  Date:       04/14/95
//
//  Modification:
//
//      1. 04/14/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _BTNBAR_
#define _BTNBAR_

#include "control.h"
/////////////////////////////////////////////////////////////////////////////
// CSuperToolBar

class CSuperToolBar : public CCONTROL
{
// Construction
    DECLARE_DYNAMIC(CSuperToolBar)
public:
    CSuperToolBar();
    BOOL CreateBar(CWnd * pOwner);

// Attributes
public:
	enum {
	    BTN_MODULE = 0,
	    BTN_PREV_MODULE,
	    BTN_NEXT_MODULE,
	    BTN_LOAD,
	    BTN_SEARCH,
	    BTN_SRC_MODE,
	    BTN_MIX_MODE,
	    BTN_BUS_MODE,
	    BTN_INS_MODE,
	    BTN_BP,
	    BTN_GO,
	    BTN_HALT,
	    BTN_RESET,
	    BTN_STEPI,
	    BTN_STEPO,
	    BTN_GO_OVER,
//	    BTN_GO_UNTIL,  // Modify by Gates Hua
	    BTN_TRACE_MIXED,
	    BTN_WATCH,
	    BTN_STATEMENT,
	    BTN_INST,
	    BTN_LOCAL_VAR,
	    BTN_FRAME1,
	    BTN_FRAMEn,
	    BTN_FRAME,
	    BTN_ADD_VAR,
	    BTN_DEL_VAR,
	    BTN_HELP,
	    BTN_ABOUT,
	    BTN_DIAGNOSIS,
	    BTN_GORUN,
	    BTN_MAP,
	    BTN_SHELL,
	    BTN_LISTSRC,
	    BTN_TRACE_TOGGLE,
	    BTN_SPA,
	    BTN_SRCHCOM,
	};

// Operations
public:                                      
    BOOL RemoveButton(int item);
    BOOL AddCombo(int item);
    void Del(void);
    BOOL InsertButton(int item,int idleitem,int att);
    BOOL ReplaceButton(int item,int idleitem);
    
    BOOL NewMain(void);
    BOOL NewSource(void);
    BOOL NewBrowse(void);
    BOOL NewCpu(void);
    BOOL NewPeri(void);
    BOOL NewShell(void);
    BOOL NewTrace(int id);
    BOOL NewBMem(void);
    BOOL NewVariable(void);
    BOOL NewStack(void);
    BOOL NewMemory(void);
    BOOL NewGPRF(void);
    void AddSrchText(const char * str);
    CString GetSrchText(void);
    CString GetSrchEditText(void);
    BOOL AdjustCombox();

// Added by Gates Hua
	BOOL HasFocus();
	
// Implementation
public:                    
//    int nActiveId;
         
    CComboBox m_cmbSrch;
    BOOL    m_isCmbSrch;

	CVBControl*	m_pTip;

    virtual ~CSuperToolBar();

protected:
    // Generated message map functions
    //{{AFX_MSG(CSuperToolBar)
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
//	afx_msg void OnSetcaptionMhtip1(UINT, int, CWnd*, LPVOID);
};


/////////////////////////////////////////////////////////////////////////////
// CSuperStatusBar

class CSuperStatusBar : public CStatusBar
{
// Construction
    DECLARE_DYNAMIC(CSuperStatusBar)
public:
    CSuperStatusBar();

public:
	int m_nColorFlag;
	
// Operations
public:
    void UpdateStatusBar(void);
	void UpdateStatusBar(int nIndex, const CString strPrompt);
    void UpdateColor(void);
    
// Implementation
public:                    
    virtual ~CSuperStatusBar();

protected:
    // Generated message map functions
    //{{AFX_MSG(CSuperStatusBar)
	afx_msg void OnPaint();
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////(EOF)///////////////////////////////////////////
