 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/BYADRTBL.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/BYADRTBL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:04   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:20   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:52   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:22   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:28   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:48   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:46   ZJRD
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: byadrtbl.h
**
** Title: By-address Sorted Table
**
** Purpose:
**  Class and methods for managing the by-address sorted table.  Each base
**  structure points to one by-address sorted table.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/PICSLDV/SRC/LOG/BYADRTBL.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _BYADRTBL_

                       /****************************
                        *                          *
                        *        INCLUDE FILES     *
                        *                          *
                        ****************************/
#include "mempool.h"
#include "symmgr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   TABLE_OFFSET symbolOffset;
   U32          delta;      // requested addr minus start addr of matching sym
} SYMBOL_INFO_TYPE;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class ByAddressTable : public MemPool {

public:
//---------------------------------------------------------------------------
// ByAddressTable()  constructor
//
// Purpose:
//    Initialize by-address table variables for memory management.
//---------------------------------------------------------------------------
   ByAddressTable();    // constructor


//-----------------------------------------------------------------------
// GetOffset
//
// Purpose: returns the offset to the symbol stored in the by-address table
//-----------------------------------------------------------------------
TABLE_OFFSET ByAddressTable::GetOffset(U32 index) {
   return *(HP_TABLE_OFFSET)GetHugeDataPtr(index * sizeof(TABLE_OFFSET));
   } 


//-----------------------------------------------------------------------
// GetSymbolCount
// 
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
   U32 GetSymbolCount(VOID) { return (GetAvailMemOffset()
                              / sizeof(TABLE_OFFSET)); };


//-----------------------------------------------------------------------
// SearchForAddr
//
// Purpose:
//    Searches for a symbol which has a range that contains the requested
//    address and has the smallest end address that still contains addr.
//-----------------------------------------------------------------------
   RETCODE
   ByAddressTable::SearchForAddr(OFFSET_ADDR_TYPE requestedAddr,
                                 BOOLEAN          NoPublics,
                                 SYMBOL_INFO_TYPE& symbolInfo);


//-----------------------------------------------------------------------
// SortTable
//
// Purpose: Sorts the offsets to symbols by the start address of each symbol
//
// Input parameter: NONE
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE SortTable(VOID);

//-----------------------------------------------------------------------
// CreateAddrRanges
//
// Purpose: Create address range of the specified label type.
//
// Input parameter: label type
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE CreateAddrRanges(SYM_TYPE_TYPE labelType);

   
};  // end of class ByAddressTable

#endif


#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------
// AddressCompare
//
// Purpose:
//    Provides the compare function for the QSort sort
//------------------------------------------------------------------------
int AddressCompare(const VOID FAR * first,
                   const VOID FAR * second);



//------------------------------------------------------------------------
// SortAllByAddressTables
//
// Purpose:
//    Sorts all by-address tables with addrTableDirty TRUE
//------------------------------------------------------------------------
RETCODE EXPORT
SortAllByAddressTables(VOID);


//-----------------------------------------------------------------------
// ByAddressTableGetNext
//
// Purpose:
//   Iterator to walk the bases and return the name and symbol count
//
// Input parameters:
//    startLoop: TRUE ==> starts the interation
//              FALSE ==> must be set after first access
//
// Output parameters:
//    loopPtr: call by reference; must be returned when startLoop FALSE
//    baseName: string of base name
//    entryCount: reference var returning number of symbols in this base
//    tableSize: allocated size of by-address table
//-----------------------------------------------------------------------
RETCODE
ByAddressTableGetNext(BOOLEAN       startLoop,
                      TABLE_OFFSET& loopPtr,
                      LPSTR         baseName,
                      U32&          entryCount,
                      U32&          tableSize);

//------------------------------------------------------------------------
// CreateAllAddrRanges
//
// Purpose:
//    Create address range for all public labels.
//
//------------------------------------------------------------------------
RETCODE CreateAllAddrRanges(SYM_TYPE_TYPE type);

#ifdef __cplusplus
}
#endif

#define _BYADRTBL_
#endif
/******************************** E O F *************************************/
