
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/C51ADR.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/C51ADR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:06   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:24   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:14   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:28   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:02   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:40   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:12   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:38   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      C51adr.h
**
**  Description:  The sub class C51adr deprived from the CFormatAddress
**                This class is process the 51 base family address
**                51 base family address has the format as following
**                      prefix:address
**                prefix is the space area. Those are :
**                      p: program
**                      x: external
**                      i: internal
**                      b: bit area
**                      r: SFR
**                The address has two format: Hex and Dec
**                      Hex has the prefix before address that is 0x
**                      Dec has no prefix
**
**                Another : the address is a symbol. The symbol has the format
**                as following:
**                      #ModuleName#SymbolName etc.
**                The process must deal all the statment described as before.
**
**  Status: Initialization
**          1996/02/15        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __C51ADR__H
#define __C51ADR__H


class C51Address : CFormatAddress
{
   private:
      BOOL     IsString;               // Construct from a string;
 ADDR_RETCODE  m_enumRetCode;          // Return code

      // Attribute
      CString  m_strSpace;             // The address space text string,
                                       // 'p'-->'Program';
   ADDR_SPACE  m_enumSpace;            // The enum space

   private:
      // Implenmentation
      void  Initialize();                    // Initialize all attributes
      BOOL  Process(CFormatType *format);    // Process the address server

   public:
      //Constructor
      C51Address() {
      	Initialize();
      }
      
      C51Address(const CString& str);        // from CString
      C51Address(const LPSTR lpsz);          // from LPSTR
      C51Address(const CString& str, 
                 const UINT isHex);          // from CString
      C51Address(const LPSTR lpsz,
                 const UINT isHex);          // from LPSTR
      C51Address(ADDR_SIZE dw);              // from ADDR_SIZE
      C51Address(ADDRESS  adr);              // from ADDRESS struct
      //C51Address(const C51Address &c51adr);// copy constructor

      //Inline function
      CString GetHexAddr();
      CString GetDecAddr();
 ADDR_RETCODE GetRetCode();
 ADDR_SPACE   GetSpace();
 ADDR_SIZE    GetAddress();
 
      // virtual function deprived from parent class
      virtual BOOL  ConvertCheck();                  // Convert the address and
                                                     // check it

      virtual BOOL  SplitPrefix(const char* lpsz);   // Split the prefix and
                                                     // address
};

#endif

////////////////////////////////(EOF)////////////////////////////////////////
