
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CPUCOM.CPP   1.13   13 Dec 1996 11:18:10   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CPUCOM.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:10   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:10   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:28   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:22   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:20   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:44   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:34   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:46   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:20   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:20   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:54   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:58   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:12   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:58   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUCOM.CPP
//
//  Description:The implement file of common declare for CPU window
//
//  Author:     Roger Zhang
//
//  Date:       04/16/95
//
//  Modification:
//
//      1. 04/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "uicom.h"
#include "cpucom.h"
#include "cpuwin.h"       
#include "cpuserve.h"
/////////////////////////////////////////////////////////////////////////////
//  Global variables
/////////////////////////////////////////////////////////////////////////////

int nCpuRadix = CPU_HEX;

#ifdef _ZLR_
int nMaxReg;
#else
int nMaxReg = 32;
#endif
extern CPUModule cpuModule;
UINT cpuid;
char * RegName[MAX_REGISTERS] = {
    "PC",   "DPTR", "ACC",  "B",    "SP",   "PSW",
    "R0",   "R1",   "R2",   "R3",   "R4",   "R5",
    "R6",   "R7",   "IE",   "TCON", "T2CON","IP", 
    "SCON", "TMOD", "TH0",  "TL0",  "TH1",  "TL1",
    "TH2",  "TL2",  "RCAP2H", "RCAP2L","P0","P1",
    "P2",   "P3"
};

UINT RegValue[MAX_REGISTERS] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    60, 61, 62, 63
};
                        
int RegSelect[MAX_REGISTERS] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    60, 61, 62, 63
};              

void InitRegSelect(void)
{
    int i;
    cpuid=AfxGetApp()->GetProfileInt("CpuWindow","CpuID",0);
    if(cpuid!=CPU_ID )
	{
	    cpuid=CPU_ID;
	    nCurRegs = nMaxReg;
	   	for(i = 0; i < MAX_REGISTERS; i++)
 			RegSelect[i] = i  ;
 	}		
    else
    {
    	CString strOrder;   
    	strOrder=AfxGetApp()->GetProfileString("CpuWindow","CpuConfig","");
    	if(strOrder.IsEmpty())
    	{  
		    nCurRegs = nMaxReg;
		   	for(i = 0; i < MAX_REGISTERS; i++)
 				RegSelect[i] = i;
 			return;	
    	}    
    	char szT[256],*token;
    	int Len=strOrder.GetLength(); 
    	strncpy(szT,strOrder.GetBuffer(Len),Len);
    	strOrder.ReleaseBuffer();
		szT[Len]=0;	
		token=strtok(szT,",");  
		int nT;              
		int i=0;
    	do{
	        nT=atoi(token);
    	    RegSelect[i]=nT;
	        token=strtok(NULL,",");
        	i++;
     	}while (token);    
    	nCurRegs=i;  
    }	
}
            
            
#ifdef _ZLR_            
int nCurRegs;                        
#else
int nCurRegs = 32;
#endif

/////////////////////////////////////////////////////////////////////////////
//  Global functions
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
static int RIdx2RSel(int nIdx)
{
    for(int i = 0; i < nCurRegs; i ++)
        if(RegSelect[i] == nIdx)    break;
    if(i == nCurRegs)   return  -1; // not select
    else return i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CpuShowRegValue(int /*nIdx*/)
{
    /*if(!isCpuOn)    return;
    
    CClientDC dc(pCpuWnd);
    
    CCpuWindow * p = (CCpuWindow *)pCpuWnd;
    if(p->m_nSel != -1) {
        p->ShowRegValue(&dc, p->m_nSel, RegValue[RegSelect[p->m_nSel]], 1);
        p->m_nSel = -1;
    }   
    int i;              
    if((i = RIdx2RSel(nIdx)) == -1)    return;
    p->ShowRegValue(&dc, i, RegValue[RegSelect[i]], 1);*/
/*    extern void RepaintCPU(void);
    
    if(!isCpuOn)    return;
    
    CCpuWindow * p = (CCpuWindow *)pCpuWnd;
    
    p->m_isSel = TRUE;
    
    TRACE("fgljldkg\n");

    RepaintCPU();*/
    
}

///////////////////////////////(EOF)/////////////////////////////////////////
