
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CPUREG.CPP   1.13   13 Dec 1996 11:18:10   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CPUREG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:10   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.12   22 Nov 1996 10:59:10   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:28   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:22   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:06   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:18   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:52   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:08   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:02   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:06   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:24   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUREG.CPP
//
//  Description:The implement file for the class: CRegisterDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/20/95
//
//  Modification:
//
//      1. 04/20/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "cpucom.h"
#include "cpureg.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                 
/////////////////////////////////////////////////////////////////////////////
// the list for storing the register values that been entered before
#define MAX_RVAL_LIST   20                                                   
extern int AddrToSym(U8 type , U32 addr , char *str);
extern REG_ID CpuIndexToID(int index); 
extern int CpuIDToIndex(REG_ID reg_id);
class CRegvalList : public CStringList                                 
{
public:        
    int m_nCount;           
    UINT m_Val[MAX_RVAL_LIST];
    CRegvalList() : m_nCount(0) {}  
    void AddNew(UINT uVal);
} ;                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Add new register value to the list
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegvalList::AddNew(UINT uVal)
{           
    int i;
    if(m_nCount < MAX_RVAL_LIST) {
        m_Val[m_nCount++] = uVal;
    } else {
        for(i = 1; i < MAX_RVAL_LIST; i++)  m_Val[i-1] = m_Val[i];
        m_Val[MAX_RVAL_LIST] = uVal;
    }
}

static CRegvalList RValList;                                 
/////////////////////////////////////////////////////////////////////////////
// CRegisterDialog dialog


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CRegisterDialog::CRegisterDialog(int nRegIdx,BOOL isGPRF, CWnd* pParent /*=NULL*/)
 : m_nRegIdx(nRegIdx), CDialog(CRegisterDialog::IDD, pParent)
{                                                        
	m_bIsGPRF=isGPRF;
    //{{AFX_DATA_INIT(CRegisterDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

CRegisterDialog::CRegisterDialog(int nRegIdx,int addr,BOOL isGPRF, CWnd* pParent /*=NULL*/)
 : m_nRegIdx(nRegIdx), CDialog(CRegisterDialog::IDD, pParent),m_nAddr(addr)
{                                                                 
	m_bIsGPRF=isGPRF;
    //{{AFX_DATA_INIT(CRegisterDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CRegisterDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegisterDialog, CDialog)
    //{{AFX_MSG_MAP(CRegisterDialog)
    ON_BN_CLICKED(IDC_REGISTER_DECRE, OnDecrement)
    ON_BN_CLICKED(IDC_REGISTER_INC, OnIncrement)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRegisterDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:             x
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CRegisterDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
	CString str;                  
    if(m_bIsGPRF)
    {
    	str="General Purpose Register : ";
     	char strSym[64];
	    if(0!=AddrToSym(3,m_nAddr,strSym))
    	{
       		char szAddr[8]="";
       		sprintf(szAddr,"(%0x)",m_nAddr);	
       		str += szAddr;  
    	}   	
    	else 
       		str+=strSym;
    }
    else 
    {
    	str="Register: ";   		
    	str+=RegName[m_nRegIdx];
    }	
    SetWindowText(str);
    
    char psz[256];   
    if(m_bIsGPRF)
    {                                  
    	if(m_nRegIdx==PORTC)
    	   wsprintf(psz, "0x%X", RegValue[m_nRegIdx]); 
    	else   
           wsprintf(psz, "0x%X", RegValue[m_nRegIdx]);
	}
	else   
		wsprintf(psz, "0x%X", RegValue[CpuIndexToID(m_nRegIdx)]);
    SetDlgItemText(IDC_REGISTER_HEX, psz);
    if(nCpuRadix==CPU_HEX) SetDlgItemText(IDC_REGISTER_VAL, psz);
    if(m_bIsGPRF)
   	{                                  
   		if(m_nRegIdx==PORTC)
   	   		wsprintf(psz, "%u", RegValue[m_nRegIdx]); 
   		else   
       		wsprintf(psz, "%u", RegValue[m_nRegIdx]);
	}
	else   
		wsprintf(psz, "%u", RegValue[CpuIndexToID(m_nRegIdx)]);
    SetDlgItemText(IDC_REGISTER_DEC, psz);                       
    if(nCpuRadix!=CPU_HEX) SetDlgItemText(IDC_REGISTER_VAL, psz);
        
    for(int i = 0; i < RValList.m_nCount; i ++) {
        if(nCpuRadix == CPU_HEX)
            wsprintf(psz, "0x%X", RValList.m_Val[RValList.m_nCount - i - 1]);
        else
            wsprintf(psz, "%u", RValList.m_Val[RValList.m_nCount - i - 1]);
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->AddString(psz);        
    }
                
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();

    return FALSE;                     
//    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnDecrement()
{
    // TODO: Add your control notification handler code here
    char pch[256];                    
    DWORD dw;
    
    int i, l = GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw)) {
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    -- dw;
    for(i = 0; i < l; i ++)
        if(pch[i] == 'x' || pch[i] == 'X')  break;
    if(i < l)   wsprintf(pch, "0x%lX", dw);
    else wsprintf(pch, "%lu", dw);
    SetDlgItemText(IDC_REGISTER_VAL, pch);
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnIncrement()
{
    // TODO: Add your control notification handler code here
    
    char pch[256];                    
    DWORD dw;
    
    int i, l = GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw)) {
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    ++ dw;
    for(i = 0; i < l; i ++)
        if(pch[i] == 'x' || pch[i] == 'X')  break;
    if(i < l)   wsprintf(pch, "0x%lX", dw);
    else wsprintf(pch, "%lu", dw);
    SetDlgItemText(IDC_REGISTER_VAL, pch);
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnOK()
{
    // TODO: Add extra validation here
    char pch[256];                    
    DWORD dw;
    
    GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw) ||
       ( (dw > (DWORD)0xFF)&&(m_nRegIdx>=BIT16_END) )||
       ( (dw > (DWORD)0xFFFF)&&(m_nRegIdx<BIT16_END) ) ){
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    else {                              
        int id;
        #ifdef _ZLR_        
        
	    if(m_bIsGPRF)
    	{                                  
			id=m_nRegIdx;
		}
		else   
			id=CpuIndexToID(m_nRegIdx);
// Modified by Gates Hua        
//        if(CpuSetRegfromWnd(id, UINT(dw)))
//            CpuGetAllReg();
        	if(CpuSetRegfromWnd(id, UINT(dw))) {
            	if ( TRUE != CpuGetAllReg() ) {
            		CDialog::OnCancel();
            		return;
            	}
        	}
            else {
            	CDialog::OnCancel();
            	return;
            }
        #else
            RegValue[id] = UINT(dw);            
        #endif
        RValList.AddNew(RegValue[id]);
        CDialog::OnOK();
    }
}

/////////////////////////////////////(EOF)///////////////////////////////////
