
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CPUVIEW.CPP   1.13   13 Dec 1996 11:18:12   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CPUVIEW.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:12   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:12   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:30   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:24   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:58   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:02   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:36   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:52   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:02   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:10   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:07:56   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:16   ZJRD
** Initial revision.
** 
****************************************************************************/

// cpuview.cpp : implementation file
//

#include "stdafx.h"
//#include "epsld52f.h"
#include "cpuview.h"   
#include "cpuwin.h"   

#include "uicom.h"
#include "colors.h"
//#include "cpucom.h"
#include "cpucfg.h"
#include "cpureg.h"
#include "hosterrs.h"  
#include "errcodec.h"
#include "resource.h"
#include "cpuserve.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
 
 
#define  CPU_PC     0
extern CPUModule cpuModule; 
extern REG_ID CpuIndexToID(int);
/////////////////////////////////////////////////////////////////////////////
// CCpuView

IMPLEMENT_DYNCREATE(CCpuView, CView)

CCpuView::CCpuView()
:m_nFont(STANDARD_FONT), m_ptFirst(0,0), m_isSel(FALSE)
{
}

CCpuView::~CCpuView()
{
}
           
LONG CCpuView::OnXMRepaint(UINT /*wParam*/, LONG /*lParam*/)
{
	if(!m_isSel)	SaveOldValue();
	m_isSel = FALSE;
    GetRegs();
    InvalidateRect(NULL);
    return  0;
}
           
            
            
void CCpuView::SaveOldValue(void)
{
    for(int i = 0; i < MAX_REGISTERS; i ++) {
     	m_OldValue[i] = m_NewValue[i];
    }
}

BOOL CCpuView::GetRegs(void)
{
 	if(!CpuGetAllReg())	return	FALSE;
 	 	
	for(int i = 0; i < MAX_REGISTERS; i ++)
		m_NewValue[i] = RegValue[i];
				
	return TRUE;
}

/*BOOL CCpuView::PreCreateWindow(CREATESTRUCT & cs)
{                                                  
    return CMDIFrameWnd::PreCreateWindow(cs);
} */

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Get char coordinates for register nIdx
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::CalcXY(int nIdx, int &x, int &y)
{
    ASSERT(nIdx >= 0 && nIdx < ::nCurRegs);
    
    if(nIdx < 0)    nIdx = 0;
    else if(nIdx > ::nCurRegs - 1)    nIdx = ::nCurRegs - 1;
    x = nIdx % m_nCols;
    y = nIdx / m_nCols;
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Get point coordinates
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::CalcPoint(BOOL isName, int nIdx, int &x, int &y)
{   
    CalcXY(nIdx, x, y);
    y = m_szGap.cy + y * (m_szName.cy + m_szGap.cy);
    x = m_szGap.cx + x * (m_szName.cx + m_szGap.cx 
        + m_szValue.cx + 2 * m_szGap.cx);
    if(!isName)  x += m_szName.cx + m_szGap.cx; 
    x -= m_ptFirst.x; y -= m_ptFirst.y;    
}                                                  

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Draw register cell frame
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::DrawFrame(CDC * pdc, BOOL isName, int nIdx, int nConvex)
{
    ASSERT_VALID(pdc);

    CPoint pt;
    CalcPoint(isName, nIdx, pt.x, pt.y);
    if(isName)  ::DrawFrame(pdc, CRect(pt.x, pt.y, 
        pt.x + m_szName.cx - 1, pt.y + m_szName.cy - 1), nConvex);
    else    ::DrawFrame(pdc, CRect(pt.x, pt.y, 
        pt.x + m_szValue.cx - 1, pt.y + m_szValue.cy - 1), nConvex);
}                                                 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Show register name
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::ShowRegName(CDC * pdc, int nIdx)
{
    ASSERT_VALID(pdc);

    int x, y;
    CalcPoint(TRUE, nIdx, x, y);    
    pdc->SelectStockObject(m_nFont);
    pdc->SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
    pdc->SetTextColor(PALETTEINDEX(COLOR_BLACK));
    int nLen = strlen(RegName[RegSelect[nIdx]]);
    int x1 = (m_szName.cx - 2 - nLen * m_szFont.cx) / 2;
    pdc->TextOut(x + 1 + x1, y + 1, RegName[RegSelect[nIdx]], nLen);
}
                                                             
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Show register value
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::ShowRegValue(CDC * pdc, int nIdx, UINT uVal, BOOL isNormal)
{
    ASSERT_VALID(pdc);

    int x, y;
    char tmp1[VAL_LEN+1], tmp2[VAL_LEN+1];         
    
    if(nCpuRadix == CPU_HEX) {
        if(cpuModule.RegNameID[RegSelect[nIdx]].ID<=BIT16_END)
            x = wsprintf(tmp2, "%04.4X", uVal);
        else
            x = wsprintf(tmp2, "  %02X", uVal);
    } else {               
        x = wsprintf(tmp2, "%u", uVal);
    }
    memset(tmp1, ' ', VAL_LEN);
    strcpy(tmp1 + VAL_LEN - x, tmp2);
    tmp1[VAL_LEN]=0;
    CalcPoint(FALSE, nIdx, x, y);    
    pdc->SelectStockObject(m_nFont);
    if(isNormal) {
        pdc->SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
        pdc->SetTextColor(PALETTEINDEX(COLOR_BLACK));
    } else {
        pdc->SetTextColor(PALETTEINDEX(COLOR_WHITE));
        pdc->SetBkColor(PALETTEINDEX(COLOR_BLUE));
    }
    //pdc->TextOut(x + 1, y + 1, tmp1, VAL_LEN);
    pdc->TextOut(x + 3, y + 1, tmp1, VAL_LEN);
}                                                    
                 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Called when change size or config registers
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CCpuView::Resize(int cx, int cy)
{
    SaveOldValue();
    #ifdef _ZLR_
  //  GetRegs();
    #endif

    CSize sz(m_szName.cx + m_szGap.cx + m_szValue.cx + m_szGap.cx * 2,
        m_szGap.cy + m_szName.cy);
    m_nCols = cx / sz.cx;
    if(m_nCols < 1)   m_nCols = 1;
    m_ptFirst.x = m_ptFirst.y = 0;
    m_nRows = (nCurRegs + m_nCols - 1) / m_nCols;
    
    if(sz.cx > cx) 
        m_szScroll.cx = sz.cx - cx;
    else m_szScroll.cx = 0;
    SetScrollRange(SB_HORZ, 0, m_szScroll.cx);
    
    if(m_nRows * sz.cy > cy)    
        m_szScroll.cy = m_nRows * sz.cy - cy;
    else m_szScroll.cy = 0;
    SetScrollRange(SB_VERT, 0, m_szScroll.cy);
    
    SetScrollPos(SB_HORZ, m_ptFirst.x);
    SetScrollPos(SB_VERT, m_ptFirst.y);
}            

BEGIN_MESSAGE_MAP(CCpuView, CView)
	//{{AFX_MSG_MAP(CCpuView) 
	ON_MESSAGE(XM_REPAINT, OnXMRepaint)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHexadecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
	ON_COMMAND(ID_VIEW_DECIMAL, OnViewDecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DECIMAL, OnUpdateViewDecimal)
	ON_COMMAND(ID_VIEW_CONFIGREGISTERS, OnViewConfigregisters)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CONFIGREGISTERS, OnUpdateViewConfigregisters)
	ON_WM_SETCURSOR()
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_VIEW_REGFILE, OnViewRegfile)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REGFILE, OnUpdateViewRegfile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCpuView drawing

void CCpuView::OnDraw(CDC* pDC)
{
CDocument* pDoc = GetDocument();

   for(int i = 0; i < ::nCurRegs; i ++) {
        DrawFrame(pDC, TRUE, i, 1);
        ShowRegName(pDC, i);
        DrawFrame(pDC, FALSE, i, 0);
        if(m_NewValue[CpuIndexToID(RegSelect[i])] != m_OldValue[CpuIndexToID(RegSelect[i])])
            ShowRegValue(pDC, i, m_NewValue[CpuIndexToID(RegSelect[i])], 0);
        else
            ShowRegValue(pDC, i, m_NewValue[CpuIndexToID(RegSelect[i])], 1);
    }    

}

/////////////////////////////////////////////////////////////////////////////
// CCpuView message handlers
BOOL CCpuView::PreCreateWindow( CREATESTRUCT& cs )
{
	cs.style|=WS_VSCROLL;
	cs.lpszClass=
	AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(GetStockObject(LTGRAY_BRUSH)),
            AfxGetApp()->LoadIcon(IDI_CPU));      
	return 1;            
}

int CCpuView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
    if(nCpuRadix == CPU_HEX)    pCpuWnd->SetWindowText("CPU[Hex]");
    else    pCpuWnd->SetWindowText("CPU[Dec]");
          
    // Get font size          
    TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(m_nFont);
    pDC->GetTextMetrics(&tm);
    ReleaseDC(pDC); 

    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
    
    //m_szValue.cx = m_szFont.cx * VAL_LEN + 2;
    m_szValue.cx = m_szFont.cx * VAL_LEN + 6;
    m_szValue.cy = m_szFont.cy + 2;
    m_szName.cx = m_szFont.cx * NAME_LEN + 2;
    m_szName.cy = m_szValue.cy;
    m_szGap.cx = m_szFont.cx;
    m_szGap.cy = 4;
	// TODO: Add your specialized creation code here

    #ifdef _ZLR_
    GetRegs();
    #endif
	return 0;
}

void CCpuView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	Resize(cx, cy);
	// TODO: Add your message handler code here
	
}

void CCpuView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: Add your message handler code here and/or call default
	   CRect rect;
    GetClientRect(&rect);                   
    int i;

    switch(nSBCode) {
        case SB_LINEUP:
            if(m_ptFirst.y <= 0)  break;
            if(m_ptFirst.y > 7)   i = 8;
            else i = m_ptFirst.y;
            m_ptFirst.y -= i;
            ScrollWindow(0, i);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_LINEDOWN:    
            if(m_ptFirst.y >= m_szScroll.cy)    break;
            if(m_ptFirst.y < m_szScroll.cy - 7) i = 8;
            else i = m_szScroll.cy - m_ptFirst.y;
            m_ptFirst.y += i;;
            ScrollWindow(0,-i);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_PAGEUP: 
            if(m_ptFirst.y == 0)    break;
            if(m_ptFirst.y > rect.Height()) {
                ScrollWindow(0, rect.Height());
                m_ptFirst.y -= rect.Height();
            }
            else {
                ScrollWindow(0, m_ptFirst.y);
                m_ptFirst.y = 0;
            }
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_PAGEDOWN:
            if(m_ptFirst.y >= m_szScroll.cy)    break;
            if(m_ptFirst.y + rect.Height() <= m_szScroll.cy) {
                ScrollWindow(0, -rect.Height());
                m_ptFirst.y += rect.Height();
            }
            else {
                ScrollWindow(0, -(m_szScroll.cy - m_ptFirst.y));
                m_ptFirst.y = m_szScroll.cy;
            }
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.y) break;
            ScrollWindow(0, m_ptFirst.y - nPos);
            m_ptFirst.y = nPos;
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
    }    
	CView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CCpuView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: Add your message handler code here and/or call default
	    CRect rect;
    GetClientRect(&rect);     
    int i;    
         
    switch(nSBCode) {
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  break;
            if(m_ptFirst.x > 7)   i = 8;
            else i = m_ptFirst.x; 
            m_ptFirst.x -= i;;
            ScrollWindow(i, 0);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    break;
            if(m_ptFirst.x < m_szScroll.cx - 7) i = 8;
            else i = m_szScroll.cx - m_ptFirst.x;
            m_ptFirst.x += i;;
            ScrollWindow(-i, 0);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    break;
            if(m_ptFirst.x > rect.Width()) {
                ScrollWindow(rect.Width(), 0);
                m_ptFirst.x -= rect.Width();
            }
            else {
                ScrollWindow(m_ptFirst.x, 0);
                m_ptFirst.x = 0;
            }
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_PAGERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    break;
            if(m_ptFirst.x + rect.Width() <= m_szScroll.cx) {
                ScrollWindow(-rect.Width(), 0);
                m_ptFirst.x += rect.Width();
            }
            else {
                ScrollWindow(-(m_szScroll.cx - m_ptFirst.x), 0);
                m_ptFirst.x = m_szScroll.cx;
            }
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.x) break;
            ScrollWindow(m_ptFirst.x - nPos, 0);
            m_ptFirst.x = nPos;
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
    }      	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CCpuView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	    CClientDC dc(this);
    
    
    int x, y;            
    CRect rect;  
    CRegisterDialog * pDlg;
    for(int i = 0; i < nCurRegs; i ++) {
        CalcPoint(TRUE, i, x, y);      
        rect.SetRect(x, y, x + m_szName.cx, y + m_szName.cy);
        if(rect.PtInRect(point)) {
            DrawFrame(&dc, TRUE, i, 0);
            pDlg = new CRegisterDialog(RegSelect[i],0, this);
            x = pDlg->DoModal();
            delete pDlg;
            DrawFrame(&dc, TRUE, i, 1);
            break;
        }
    }                                           
    
	if(x == IDOK) {
		SaveOldValue();    
	    m_isSel = TRUE;
	    GetRegs();
	    if(m_OldValue[0] == m_NewValue[0])
	    	RepaintWindows();
	    else
	    	OnEmulation();
    }	
    

    // Added by Chen
    SetFocus();

	CView::OnLButtonDown(nFlags, point);
}

void CCpuView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	   CMenu * pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );

    pLocalMenu->CreatePopupMenu();
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
	
//	pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REGFILE, "&Register File");
    
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_HEXADECIMAL,
                            "&Hexadecimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DECIMAL, "&Decimal");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_CONFIGREGISTERS,
                            "C&onfigure Registers...");
    pLocalMenu->SetMenuItemBitmaps(ID_VIEW_HEXADECIMAL, MF_BYCOMMAND, 
        &bmpMenuUncheck, &bmpMenuCheck);
    pLocalMenu->SetMenuItemBitmaps(ID_VIEW_DECIMAL, MF_BYCOMMAND, 
        &bmpMenuUncheck, &bmpMenuCheck);

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
	CView::OnRButtonDown(nFlags, point);
}

void CCpuView::OnViewRefresh()
{
	// TODO: Add your command handler code here
	    SaveOldValue();
    GetRegs();
    InvalidateRect(NULL); 
}

void CCpuView::OnViewHexadecimal()
{
	// TODO: Add your command handler code here
	    SaveOldValue();
    #ifdef _ZLR_
    GetRegs();
    #endif
    InvalidateRect(NULL);
	((CCpuWindow*)GetParent())->CpuChangeTitle();
    if(nCpuRadix != CPU_HEX) {
        nCpuRadix = CPU_HEX;    
        pCpuWnd->SetWindowText("CPU[Hex]");
//        InvalidateRect(NULL);
    }
    
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->Invalidate();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->UpdateWindow();

}

void CCpuView::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(nCpuRadix == CPU_HEX);    
}

void CCpuView::OnViewDecimal()
{
	// TODO: Add your command handler code here
    SaveOldValue();
    #ifdef _ZLR_
    GetRegs();
    #endif
    InvalidateRect(NULL);         
    ((CCpuWindow*)GetParent())->CpuChangeTitle();
    if(nCpuRadix != CPU_DEC) {
        nCpuRadix = CPU_DEC;    
        pCpuWnd->SetWindowText("CPU[Dec]");
//       InvalidateRect(NULL);
    }  
  
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->Invalidate();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->UpdateWindow();
  
}

void CCpuView::OnUpdateViewDecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(nCpuRadix == CPU_DEC);    	
}

void CCpuView::OnViewConfigregisters()
{
	CRegcfgDialog dlgRegcfg(this);
    int i, j;
    CRect rect;
    if(dlgRegcfg.DoModal() == IDOK) {
        for(i = 0, j = 0; i < nMaxReg; i ++) {
            if(dlgRegcfg.m_Reg[i] == TRUE)  RegSelect[j++] = i;
        }
        nCurRegs = j;
        GetClientRect(rect);
        Resize(rect.Width(), rect.Height());
        InvalidateRect(NULL);       
    }
}

void CCpuView::OnUpdateViewConfigregisters(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
}

BOOL CCpuView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	// TODO: Add your message handler code here and/or call default
	if(message == WM_RBUTTONDOWN)   return FALSE;
	return CView::OnSetCursor(pWnd, nHitTest, message);
}

void CCpuView::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
	CView::OnActivate(nState, pWndOther, bMinimized);
	#ifdef _ZLR_
    GetRegs();
    #endif         
    
    InvalidateRect(NULL);
    
    if(nState!=WA_INACTIVE)
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(nState), 
            LONG(WID_CPU));
    else 
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(nState)); 

	// TODO: Add your message handler code here
	
}

void CCpuView::OnViewRegfile()
{
	if(!((CCpuWindow*)GetParentFrame())->m_bRegFileOn)
	{
		CRect rect;
		GetParentFrame()->GetClientRect(&rect);                  
		rect.right=rect.right/2;
		((CCpuWindow*)GetParentFrame())->m_wndSplitter.SetColumnInfo(1,rect.right/2,0); 
		((CCpuWindow*)GetParentFrame())->m_wndSplitter.SetColumnInfo(0,rect.right/2,0);
	    ((CCpuWindow*)GetParentFrame())->m_bRegFileOn=1;
		GetParentFrame()->SetWindowPos(NULL,0,0,rect.right*2,rect.bottom,SWP_NOMOVE|SWP_NOZORDER);
	}    
	((CCpuWindow*)GetParent())->CpuChangeTitle();
}

void CCpuView::OnUpdateViewRegfile(CCmdUI* pCmdUI)
{
		pCmdUI->Enable(!((CCpuWindow*)GetParentFrame())->m_bRegFileOn);
}
