
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CTRCBUF.H__   1.13   13 Dec 1996 11:18:14   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CTRCBUF.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:14   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:14   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:32   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:26   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:46   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:30   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:48   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : CTRCBUF.H
** Author: Chris Fang
** Description:
**
**
**    Finished date: Apr. 29, 1996
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "basictyp.h"

struct FrameC;
class TraceSrcPage;

//only one interface routine to outside
BOOL ListTrcCToWnd(int readDirect,			//2,1,0,-1,-2
				   WORD* beginNo,           //abi frame
				   WORD* endNo,             //not care
                   WORD* LineCnt,           //viewport lines
                   FrameC* frameC);         //output buffer

void ResetTraceBuf(void);

struct HitStatus
	{
		BOOL ishit;
		int	 needline;		//up:
		WORD edgeframe;
		TraceSrcPage* phitpage;
	};
	
struct MRUSrcLine
	{
		U32 moduleDesc;
		U16 linenum;
  		U32 startAddr;
  		U32 endAddr;
		
		public:
		MRUSrcLine(){};
		MRUSrcLine(U32 md, U16 ln, U32 sa, U32 ea)
		{
			moduleDesc=md;
			linenum=ln;
			startAddr=sa;
			endAddr=ea;
		};
		const MRUSrcLine& operator=(const MRUSrcLine src)
		{
			moduleDesc=src.moduleDesc;
			linenum=src.linenum;
			startAddr=src.startAddr;
			endAddr=src.endAddr;
			return *this;
		};
		operator BOOL()
		{
			return (linenum!=0);
		}
		BOOL operator==(MRUSrcLine ob) const
		{
			return ((moduleDesc==ob.moduleDesc)&&(linenum==ob.linenum));
		}
		const MRUSrcLine next(void);
	};
	
class TraceSrcPage : public CDWordArray
{
private:
	
public:
	WORD m_wFirstFrame;
	WORD m_wLastFrame;
	int m_nFrameNum;
	TraceSrcPage* m_pNext;
	TraceSrcPage* m_pPrev;	

public:
	TraceSrcPage(TraceSrcPage* pp=NULL, TraceSrcPage* pn=NULL);
	~TraceSrcPage();
	
	BOOL isinpage(WORD frame, int& index);
	WORD getaddrfromframe(WORD frame);
	void reset(TraceSrcPage* pp=NULL, TraceSrcPage* pn=NULL);
};

class TraceSrcBuf
{
private:
	TraceSrcPage* 	m_pFirstPage;
	TraceSrcPage* 	m_pLastPage;
	HitStatus	m_Hitstatus;
	MRUSrcLine	m_MRUSrcLine[5];
	WORD		m_AddressRange[10];
	MRUSrcLine	m_MRUbak;
	int			m_nARNum;
	WORD		m_wAbiFrameNum;
	BOOL		m_bIncLib;
	BOOL		m_bOldFW;
	
private:
	TraceSrcPage* isinbuf(int readflag, WORD& fromframe,
					int linenum, int& hitindex);
	void addrrange(void);
	void setdata(TraceSrcPage* pPage, int index, FrameC* buf, int linenum);
	void compressmrusrcline(void);					//del repeat and nul data
	TraceSrcPage* addpage(WORD frame);
	int editpage(BOOL isup, WORD fromframe,
					int number, TraceSrcPage* pPage);
	TraceSrcPage* linkpage(TraceSrcPage* pPage, int direct);
	void writetopage(TraceSrcPage* pPage, BYTE& count);
	int checksameline(DWORD first, DWORD second);
	int setfirstsrcframe(WORD& fromframe, WORD toframe, TraceSrcPage* pPage);
    int setsrcframe(WORD& fromframe, WORD toframe, 
    					int number, TraceSrcPage* pPage);
    

public:
	TraceSrcBuf();
	~TraceSrcBuf();
	BOOL getctrace(int readflag, WORD& fromframe, int& linenum, FrameC* buf);
	void reset(void);
};

//export routine
//SpaListSource -- to Chen jun
int SpaListSource(unsigned short uStartAddr, unsigned short uLength,
					CStringList* & pStrlist);
