
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADCORE.CPP   1.13   13 Dec 1996 11:18:14   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADCORE.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:14   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:14   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:32   ZJRD
** PIC/SLD Versio 0.96
** 
**    Rev 1.10   06 Nov 1996 12:58:28   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:12   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:22   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:40   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:46:16   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:00   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:16   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:07:12   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:56   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadcore.cpp
** Author: Richard Guo
** Description: DAD core function explemented in this file.
**    .
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h" 
#include <ctype.h>
#include "dadcore.h"           
#include "dadconst.h"
#include "dadpub.h"

#include "symblsvr.h"

#define SFR(i)               ( (CSFR*) m_pData[i] )
#define INSTRUCT(i)          ( (CInstruction*) m_pData[i] )
#define INSTRUCT_CODE(i)     ( (CInstruction*) m_pData[i] )->m_insCode
#define INSTRUCT_FIRSTOP(i)  ( (CInstruction*) m_pData[i] )->m_OpFirst
#define INSTRUCT_SECONDOP(i) ( (CInstruction*) m_pData[i] )->m_OpSecond

extern BYTE nCurCpuId;   
extern BYTE nCurBankId; 
extern BYTE nCurTotalPage; 
extern BYTE nCurTotalBank;
extern WORD nCurPageLen;  
extern WORD nCurBankLen;    

extern BOOL isSymDsm;

int SymToAddr(char *lpStr, unsigned char* lpType, 
            unsigned long* lpAddr );  
int AddrToSym(U8 type , U32 addr , char *str);            

void 
UIntFromString(const char* szSrc, WORD &nValue, 
    int& nNum, int nBase)
{
    ASSERT(szSrc != NULL);
    
    int nSrc = 0;
    const MAXLEN = 17;
    
    nNum = 0;
    nValue = 0;
    
    for( ; szSrc[nSrc] && (!isdigit(szSrc[nSrc])); nSrc++);
    for( ; szSrc[nSrc] && (isdigit(szSrc[nSrc])
    	|| szSrc[nSrc] == 'x')  && (nNum <17) ;
        nSrc++,nNum++)
    { 
        	if (szSrc[nSrc] == 'x') nValue = nValue*nBase;
        	else
        		nValue = nValue*nBase + (szSrc[nSrc]- '0'); 
     }
}   

// no 0x or 0X, can have h or H.
BOOL
HexFromString(const char* szSrc, WORD &nValue)
{   
    ASSERT(szSrc != NULL);
    
    CString strSrc = szSrc;
    
    strSrc.TrimRight();
    strSrc.TrimLeft();    
    strSrc.MakeUpper();
    
    int nLen = strSrc.GetLength();      
    if ((strSrc[nLen-1] == 'H'))
        nLen--;
    
    nValue = 0;
    for (int i=0; i<nLen; i++)
    {
        if ((strSrc[i]<='9') && (strSrc[i]>='0'))
            nValue = nValue*16 + strSrc[i] - '0';
        else if ((strSrc[i]<='F') && (strSrc[i]>='A'))
            nValue = nValue*16 + strSrc[i] - 'A' + 10;
        else{
        	strSrc.Empty();
            return FALSE;  
           }
    }           
    
    strSrc.Empty();
    return TRUE;
}           
    
int
Token(const char* szSrc, char* szDes, char cDivide)
{
    ASSERT(szSrc != NULL);
    ASSERT(szDes != NULL);
    
    char *pBeginCur, *pEndCur;   // filter space char
    for (pBeginCur=(char*)szSrc; *pBeginCur && isspace(*pBeginCur);
         pBeginCur++);
    
    if (*pBeginCur == '\0')
    {
        szDes[0] = '\0';
        return ERR_DAD_NO_INPUT;
    }
    
    pEndCur = strchr(pBeginCur, cDivide);
    
    int nByte;
    
    if (pEndCur == NULL){ 
        nByte = strlen(szSrc);
        pEndCur = (char*)szSrc + nByte;
    }
    else nByte = pEndCur - szSrc + 1;
    
    for (char* pCur=pBeginCur; pCur<pEndCur && !isspace(*pCur); 
        *szDes++ = *pCur++);
    
    *szDes = '\0';
    
    return nByte;
}

CSFR::CSFR(WORD nAddress, const char* szName)
{
    m_nAddress = nAddress;
    m_strName = szName;
}                      

BOOL
CSFR::IsMe(char* szName, WORD nAddress)
{
    ASSERT(szName != NULL);     
    
    if (nAddress == m_nAddress) 
    {
        strcpy(szName, m_strName);
        return TRUE;
    }
    
    return FALSE;
} 

BOOL
CSFR::IsMe(const char* szName, WORD &nAddress)
{
    ASSERT(szName != NULL);     
    
    if (stricmp(szName, m_strName) == 0) 
    {      
        if (::InCurBank(m_nAddress))
        {
            nAddress = m_nAddress;
            return TRUE;
        }
    }
    
    return FALSE;
} 

CSFRArray::~CSFRArray()
{
    for (int i=0; i<m_nSize; i++)
        delete SFR(i);
}                    

BOOL 
CSFRArray::IsExist(char* szName, WORD nAddress)
{
    for (int i=0; i<m_nSize; i++)
        if (SFR(i)->IsMe(szName, nAddress))
            return TRUE;
            
    return FALSE;       
}                

BOOL 
CSFRArray::IsExist(const char* szName, WORD &nAddress)
{
    for (int i=0; i<m_nSize; i++)
        if (SFR(i)->IsMe(szName, nAddress))
            return TRUE;
            
    return FALSE;       
}                


COperand::COperand()
{
    //Init(' ', " ", 12);
}

COperand::COperand(const char* /*szCode*/, int /*nCodeLen*/)
{
}                  

void
COperand::Init(const char* szCode, int nCodeLen)
{   
    
    AnalyseCode(szCode); // set start and end bit
    
    // set operand range
    m_nMin = 0;
    DefaultMax();   
    SetHideMax();
    
    m_nShiftLen = nCodeLen - m_nBitTo - 1;
    m_nMask = ((1 << m_nBitTo - m_nBitFrom + 1) - 1);
}

COperand::~COperand()
{
}   


void 
COperand::SetHideMax()
{
        m_nHideMax = m_nMax;    
}
          
void
COperand::AnalyseCode(CString strCode)
{   // find start and end bit address in machine code.
    strCode.MakeLower();
    strCode.TrimRight();
    strCode.TrimLeft();
    
    m_nBitFrom = strCode.Find(m_cType);
    m_nBitTo = strCode.ReverseFind(m_cType);
}             


// The function is used in Disassemble
int
COperand::AsmValid(const char* szValue, WORD &nValue)
{
    int nFlag = Asm(szValue, nValue);
        
    if (nFlag >= 0)
        nValue = nValue << m_nShiftLen;
        
    return nFlag;   
}

// The function is used in assemble.
int
COperand::DasmValid(char* szValue, WORD nValue)
{
     nValue = (nValue >> m_nShiftLen) & m_nMask;
     
     return Dasm(szValue, nValue);
}

int
COperand::Asm(WORD &nValue)
{  
    int nReturn = ERR_OP_BOUND_ERROR;
    
    if (IsValid(nValue))
    {
        nReturn = EnhanceAsmValid(nValue);
        nValue &= m_nMask;                
    }       
        
    return nReturn; 
}
 
int
COperand::Asm(const char* szValue, WORD &nValue)
{                        
                                                       
    if (!HexFromString(szValue, nValue))
         return ERR_OP_PARA_ERROR;            
    
    return Asm(nValue);
}

int
COperand::Dasm(char* szValue, WORD nValue)
{
    BOOL nReturn = ERR_OP_BOUND_ERROR;
    
    if (IsValid(nValue))
    {
        ASSERT(szValue != NULL);
        nReturn = EnhanceDasmValid(nValue);
        wsprintf(szValue, "%-xH", nValue & m_nHideMax);
        StrToUpper(szValue);
    }
    
    return nReturn;
}                  


inline BOOL 
COperand::IsValid(WORD nValue)
{
    return (nValue >= m_nMin) && (nValue <= m_nHideMax);
}

int
COperand::EnhanceAsmValid(WORD /*nValue*/)
{
   return 0;
}                              

int
COperand::EnhanceDasmValid(WORD& /*nValue*/)
{
    return 0;           
} 

void
COperand::DefaultMax()
{
    if (m_nBitFrom<0 || m_nBitTo<0)
        m_nMax = -1;
    else    
        m_nMax = ( 1 << (m_nBitTo - m_nBitFrom+1)) - 1;
}

void
COperand::SetRange(WORD nMin, WORD nMax)
{
    m_nMin = nMin;
    m_nMax = nMax;
                  
    SetHideMax();
}   
                                               
WORD 
COperand::ValidCode(WORD nCode)
{
    return (nCode >> m_nShiftLen) & m_nMask;
}                                               

void
COperand::CurValue(WORD& nValue)
{
    nValue = (nValue >> m_nShiftLen) & m_nMask;
}

#ifdef _dadtest_

void
COperand::DumpData(char* szData)
{
    wsprintf(szData, 
        "  %c  0x%02x  0x%03x  0x%03x  0x%1x  %04x",
        m_cType, m_nMin, m_nMax, m_nHideMax, m_nShiftLen, m_nMask); 
}

#endif


COperandData::COperandData(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = k;
    m_cType = 'k';
    Init(szCode, CodeLen);
}

int
COperandData::Asm(const char* szValue, WORD &nValue)
{  
   if (COperand::Asm(szValue, nValue) >= 0) return 0;
   else return ERR_OP_DATA_LARGE;
}                                     

int
COperandData::Dasm(char* szValue, WORD nValue)
{
    if (COperand::Dasm(szValue, nValue) >= 0) return 0;
    else return ERR_OP_DATA_LARGE;
}

COperandAddr::COperandAddr(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = a;
    m_cType = 'a';      
    Init(szCode, CodeLen);
}

void 
COperandAddr::SetHideMax()
{
        m_nHideMax = nCurTotalPage * nCurPageLen - 1;    
}

COperandAddr::Asm(const char* szValue, WORD& nValue)
{                               
    // call symbol to see if a symbol.
    int nReturn;
    
    nReturn = COperand::Asm(szValue, nValue);   
    
    // not a digit, call symbol, perhaps a symbol
    if (nReturn == ERR_OP_PARA_ERROR){

        unsigned long lValue;
        BYTE nReturn;
    
        if ( SymToAddr((char*)szValue, &nReturn, &lValue) == 0 )
             if((nReturn==1) && (lValue < 0xffff))     
        	{
           	 	nValue = lValue;
        		return COperand::Asm(nValue);
        	}
        
        return ERR_OP_ADDR_ERROR;
        
     }
        
    return nReturn;
} 


int
COperandAddr::Dasm(char* szValue, WORD nValue)
{                                       
    // call symbol to see if a symbol
    int nReturn;
    
    nReturn = COperand::Dasm(szValue, nValue);
    
    if (nReturn < 0) return nReturn;
    
    // call symbol 

    unsigned long lValue = nValue;
	char symBuf[128];    
	if (isSymDsm)
		if (AddrToSym(1, lValue, symBuf)==0)
    		strcpy(szValue, symBuf);    
    
    char szTemp[50];
    wsprintf(szTemp, "(%xH)", nValue & m_nMask);
    strcat(szValue, szTemp);
    
    return nReturn;
}

int
COperandAddr::EnhanceAsmValid(WORD nValue)
{
    if (m_nMax==255)
        if ((nValue%GetPageLen()) > 255)
            return ERR_OP_ADDR_LIMIT;
    
    if ((nValue > m_nMax) && (nValue <= m_nHideMax))
    {
        if (!InCurPage(nValue))
            return ERR_OP_ADDR_BOUND;
    }           
                
    return 0;   
}                 

int
COperandAddr::EnhanceDasmValid(WORD& nValue)
{
    if (m_nHideMax > m_nMax)
    {
        return ::CurAddr(nValue);
    }          
    
    return 0;
} 

void
COperandAddr::CurValue(WORD& nValue)
{
    nValue = (nValue >> m_nShiftLen) & m_nMask;
    CurAddr(nValue);	
}

COperandReg::COperandReg(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = f;
    m_cType = 'f';
    Init(szCode, CodeLen);         
}

void 
COperandReg::SetHideMax()
{
        m_nHideMax = nCurBankLen * nCurTotalBank - 1;    
}

int
COperandReg::Asm(const char* szValue, WORD &nValue)
{      
    ASSERT(szValue != NULL);
    
    int nReturn = COperand::Asm(szValue, nValue);
    
    if ( nReturn == ERR_OP_PARA_ERROR)
    {
        if ( ::AsmSFR(szValue, nValue) ) // check if a SFR
            return COperand::Asm(nValue);
        else
        { // perhaps a SFR
        	                         
	        unsigned long lValue;
    	    BYTE nReturn;
    
        	if ( SymToAddr((char*)szValue, &nReturn, &lValue) == 0 )
             	if((nReturn==3) && (lValue < 0xffff))     
             	{
	                nValue = lValue;
    	    		return COperand::Asm(nValue);
    	    	}
    	}       
    	
        return ERR_OP_REG_ERROR;
    }           
    
    return nReturn;
}
                    
int
COperandReg::Dasm(char* szValue, WORD nValue)
{
    ASSERT(szValue != NULL);    
    
    int nReturn = COperand::Dasm(szValue, nValue);
    
    if (nReturn < 0) return nReturn; 

    if ( !::DasmSFR(szValue, nValue)) // first check if a SFR
    {
     // perhaps a symbol
		unsigned long lValue = nValue; 
		char symBuf[128];
		
		if (isSymDsm)    	
  		  	if (AddrToSym(3, lValue, symBuf)==0)
    			strcpy(szValue, symBuf);
    }
    
    char szTemp[50];
    wsprintf(szTemp, "(%xH)", nValue & m_nMask);
    strcat(szValue, szTemp);
    
    return nReturn;
}

int 
COperandReg::EnhanceAsmValid(WORD nValue)
{
    if ((nValue > m_nMax) && (nValue <= m_nHideMax))
    {
        if (!::InCurBank(nValue))
            return ERR_OP_REG_BOUND;
    }           
    return 0;
}           

int 
COperandReg::EnhanceDasmValid(WORD &nValue)
{
    if (m_nHideMax > m_nMax)
    {
        return ::CurReg(nValue);
    }          
    
    return 0;
}


COperandWorkReg::COperandWorkReg(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = w;
    m_cType = 'w';
    Init(szCode, CodeLen);                 
}

int
COperandWorkReg::Asm(const char* /*szValue*/, WORD &nValue)
{
    nValue = 0;
    return 0;
}

int
COperandWorkReg::Dasm(char* /*szValue*/, WORD /*nValue*/)
{            
    return 0;
}

COperandBitAddr::COperandBitAddr(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = b;
    m_cType = 'b';
    Init(szCode, CodeLen);                
}

COperandCompatible::COperandCompatible(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = x;
    m_cType = 'x';
    Init(szCode, CodeLen);                
}

int
COperandCompatible::Asm(const char* /*szValue*/, WORD &nValue)
{
    nValue = 0;
    return 0;
}

int
COperandCompatible::Dasm(char* szValue, WORD /*nValue*/)
{         
    szValue[0] = '\0';
    return 0;
}

COperandDes::COperandDes(const char* szCode, int CodeLen)
    : COperand(szCode, CodeLen)
{
    m_nType = d;
    m_cType = 'd';
    Init(szCode, CodeLen);                
}


int
COperandDes::Asm(const char* szValue, WORD &nValue)
{
    if (stricmp(szValue, "w") == 0)
    {
        nValue = 0;
        return 0;
    }
    return COperand::Asm(szValue, nValue);
}



CInstructionCode::CInstructionCode()
{
    m_nCodeLen = 0;
    m_nCode = 0; 
    m_nCycle = one;
}

CInstructionCode::CInstructionCode(const char* szName,
    const char* szCode, int nCycle, int nCodeLen)
{
    m_strName = szName; // instruction name, for example mov
    m_strName.TrimLeft();
    m_strName.TrimRight();
    m_nCodeLen = nCodeLen;  
    SetCycle(nCycle);
    AnalyseCode(szCode);
}                                              

CInstructionCode::~CInstructionCode()
{
}

void
CInstructionCode::SetCycle(int nCycle)
{
    switch(nCycle){
        case 10:
            m_nCycle = one;
            break;
        case 15:
            m_nCycle = one_or_two;
            break;
        case 20:
            m_nCycle = two;
            break;
        default:
            m_nCycle = one;
    }
}
            

void 
CInstructionCode::AnalyseCode(CString strCode)
{                           
        // for compatible
    int nCBitFrom = strCode.Find('x');
    int nCBitTo = strCode.ReverseFind('x');
    if (nCBitFrom < 0 || nCBitTo < 0)
    	m_nCompatibleMask = 0xffff;
    else
      	m_nCompatibleMask = ( 1 << (nCBitTo - nCBitFrom+1)) - 1; 

    UIntFromString(strCode, m_nCode, m_nBitLen, 2);
    
    if (m_nCodeLen<m_nBitLen) m_nCodeLen = m_nBitLen;
    
    m_nCode <<= (m_nCodeLen-m_nBitLen);
    m_nMin = 0;  
    m_nMax = (1 << m_nCodeLen-m_nBitLen) - 1;
 
    if (m_nCompatibleMask!=0xffff){
    	m_nMax +=  ((1 << (nCBitTo-nCBitFrom+1)) -1) << (m_nCodeLen-nCBitTo-1); 
    	if (nCBitTo == m_nBitLen -1) m_nCompatibleMask = 0;
    	else
    		m_nCompatibleMask = (1 << (m_nBitLen-nCBitTo-1)) -1;
    }
    else
    	m_nCompatibleMask = 0;
}                

void
CInstructionCode::SetRange(WORD nMin, WORD nMax)
{
    m_nMin = nMin;
    m_nMax = nMax;
}                 

BOOL
CInstructionCode::IsValid(WORD nCode)
{
    return (nCode >= m_nCode + m_nMin) && (nCode <= m_nCode + m_nMax)
    	&& ((nCode & m_nCompatibleMask) == 0);
}         

#ifdef _dadtest_

void
CInstructionCode::DumpData(char* szData)
{
    wsprintf(szData, 
        "  0x%04x  0x%1x  %7s  %2d",
        m_nCode, m_nBitLen, m_strName.GetBuffer(0), m_nCycle); 
}

#endif


CInstruction::CInstruction() : CObject()
{               
    m_insCode = NULL;
    m_opFirst = NULL;
    m_opSecond = NULL;
    m_nOpNum = 0;
}

CInstruction::CInstruction(const char* szName, char cFirstOp, 
    char cSecondOp, const char* szCode, int nCycle, int nLen)
    : CObject()
{
    m_insCode = new CInstructionCode(szName, szCode, nCycle, nLen); 
    
    m_nOpNum = 0;
    
    if ((m_opFirst = CreateOp(cFirstOp, szCode, nLen)) != NULL)
    {
        m_nOpNum++;
        if ((m_opSecond = CreateOp(cSecondOp, szCode, nLen)) != NULL)
            m_nOpNum++;
    }
    else m_opSecond = NULL;
} 


CInstruction::~CInstruction()
{  
    if (m_insCode != NULL) delete m_insCode;
    if (m_opFirst != NULL) delete m_opFirst;
    if (m_opSecond != NULL) delete m_opSecond;
}   

COperand*
CInstruction::CreateOp(char cType, const char* szCode, int nCodeLen)
{
    int nType;
    
    nType = tolower(cType);
    
    switch(nType){
        case 'f':   
            return (new COperandReg(szCode, nCodeLen));  // register file address
        case 'w':   
            return (new COperandWorkReg(szCode, nCodeLen));  // working register
        case 'b':   
            return (new COperandBitAddr(szCode, nCodeLen));  // bit address 
        case 'k':   
            return (new COperandData(szCode, nCodeLen));  // const data or label
        case 'x':   
            return (new COperandCompatible(szCode, nCodeLen));  // 
        case 'd':
            return (new COperandDes(szCode, nCodeLen));  // destination select
        case 'a':   
            return (new COperandAddr(szCode, nCodeLen));  // address
        default:    
            return (COperand*) NULL;
    }                    
}               

int CInstruction::OperandNum() const
{
    return m_nOpNum;
}

int
CInstruction::Disassemble(char* szSrc, WORD nCode)
{
    ASSERT(szSrc != NULL); 
    
    wsprintf(szSrc, "%-9s", m_insCode->m_strName);
    
    int nLen = strlen(szSrc);
    
    int nReturn = DasmOp(szSrc + nLen, nCode);
//    if (nReturn >= 0) StrToUpper(szSrc);
    if (nReturn < 0) strcpy(szSrc, "?" );
    return nReturn;
}
    
int
CInstruction::Assemble(const char* szSrc, WORD &nCode)
{
    ASSERT(szSrc != NULL);

    int nByte;  // byte have been handle.
    int nReturn; // return value.                   
    
    WORD nOpCode; 
    
    nReturn = AsmOp(szSrc, nByte, nOpCode);
    if (nReturn < 0)  return nReturn;
    
    // see if user input redundant characters.
    char *szDes = new char[strlen(szSrc) + 1];  
    if (Token(szSrc + nByte, szDes, ' ') > 0 ){
         delete [] szDes;
         return ERR_OP_REDUNDANT;
    }
    
    nCode = m_insCode->m_nCode | nOpCode;
    
    delete [] szDes;
    return nReturn;     
}


inline int 
CInstruction::DasmOp(char* szSrc, WORD nCode)
{
    ASSERT(szSrc != NULL);
    
    switch(m_nOpNum){
        case 0:
            return DasmZeroOp(szSrc, nCode);
        case 1:  
            return DasmOneOp(szSrc, nCode);
        case 2:
            return DasmTwoOp(szSrc, nCode);
        default:
            return ERR_OP_INTERNAL_ERROR;
    }
}   

inline int 
CInstruction::AsmOp(const char* szSrc, int &nByte, WORD &nCode)
{
    ASSERT(szSrc != NULL);
                   
    switch(m_nOpNum){
        case 0:
            return AsmZeroOp(szSrc, nByte, nCode);
        case 1:  
            return AsmOneOp(szSrc, nByte, nCode);
        case 2:
            return AsmTwoOp(szSrc, nByte, nCode);
        default:
            return ERR_OP_INTERNAL_ERROR;
    }
}   

inline int 
CInstruction::AsmZeroOp(const char* /*szSrc*/, int &nByte, WORD &nCode)
{
    nCode = 0;                     
    nByte = 0;
    return 0;
}

inline int
CInstruction::DasmZeroOp(char* szSrc, WORD /*nCode*/)
{
    szSrc[0] = '\0';
    return 0;
}
            
int 
CInstruction::AsmOneOp(const char* szSrc, int &nByte, WORD &nCode)
{
    char *szDes = new char[strlen(szSrc) + 1];
    char *szCommaDes = new char[strlen(szSrc) + 1];
    
    if ((nByte = Token(szSrc, szDes, ' ')) < 0)
    {
        delete [] szDes;
        return ERR_OP_LACK;
    } 
    
    int nCommaByte = Token(szSrc, szCommaDes, ',');
    if(nCommaByte < nByte){
    	strcpy(szDes, szCommaDes);
    	nByte = nCommaByte;
    }	
    
    int nReturn;
    nReturn = m_opFirst->AsmValid(szDes, nCode);

    delete [] szDes;
    delete [] szCommaDes;
    
    return nReturn;
}                                 

inline int
CInstruction::DasmOneOp(char* szSrc, WORD nCode)
{
    ASSERT(szSrc != NULL);
    
    return m_opFirst->DasmValid(szSrc, nCode);
}


int 
CInstruction::AsmTwoOp(const char* szSrc, int &nByte, WORD &nCode)
{
    char *szDes = new char[strlen(szSrc) + 1];
    
    if ((nByte = Token(szSrc, szDes, ',')) < 0)
    {
        delete [] szDes;
        return ERR_OP_LACK;
    }
                                         
    int nReturn;                                         
    if ((nReturn = m_opFirst->AsmValid(szDes, nCode)) < 0)
    {
        delete [] szDes;
        return nReturn;
    }                            
    
    int nByteTemp;
    WORD nCodeTemp; // second operand code.
    
    if ((nByteTemp = Token(szSrc + nByte, szDes, ' ')) < 0)
    {
        if ((m_opSecond->m_nType == COperand::d) && 
            (szSrc[nByte-1] != ',')) 
        {
            szDes[0] = '1';
            szDes[1] = '\0'; 
            nByteTemp = 0;
        }
        else{
            delete [] szDes;
            return ERR_OP_LACK;
        }
    }
    
    int nReturn2;
    if ((nReturn2 = m_opSecond->AsmValid(szDes, nCodeTemp)) < 0)
    {
        delete [] szDes;
        return nReturn2;
    }            
    
    nCode |= nCodeTemp;
    nByte += nByteTemp;
    
    delete [] szDes;
    return nReturn | nReturn2;               
}                 
                                      
int
CInstruction::DasmTwoOp(char* szSrc, WORD nCode)
{
    ASSERT(szSrc != NULL);
    
    int nReturn;
    
    if ((nReturn = DasmOneOp(szSrc, nCode)) < 0) 
        return nReturn;
        
    int nLen = strlen(szSrc);
    
    szSrc[nLen++] = ',';
    szSrc[nLen++] = ' ';
    
    int nReturn2;
    if ((nReturn2 = m_opSecond->DasmValid(szSrc + nLen, nCode)) < 0)
        return nReturn2;  
        
    return nReturn | nReturn2;      
}                          


WORD
CInstruction::PCNextAddr(WORD nAddress, WORD nCode)
{
    if (m_insCode->m_nCycle == CInstructionCode::one)
        return nAddress + 1;
    else if (m_insCode->m_nCycle == CInstructionCode::one_or_two)
        return nAddress + 2;
    else{
        if ((stricmp(m_insCode->m_strName, "call") == 0) ||
            (stricmp(m_insCode->m_strName, "goto") == 0) ) 
            return m_opFirst->ValidCode(nCode);
        return 0xffff;
    }
}

BOOL
CInstruction::IsReturn()
{       
   if (m_insCode->m_strName.CompareNoCase("RETLW") == 0)
   		return TRUE;
   if (m_insCode->m_strName.CompareNoCase("RETFIE") == 0)
   		return TRUE;
   if (m_insCode->m_strName.CompareNoCase("RETURN") == 0)
   		return TRUE;   
   		
   return FALSE;	
}

BOOL
CInstruction::IsCall(WORD& nValue)
{
	if (m_insCode->m_strName.CompareNoCase("CALL") == 0)
   	{
   		m_opFirst->CurValue(nValue);
   		return TRUE;                
   	}
   	            
   	return FALSE;	
}
                                               
#ifdef _dadtest_
void  
CInstruction::DumpData(char* szData)
{     
    char szOp1[250];
    m_insCode->DumpData(szData);
    switch(OperandNum()){
        case 0: break;
        case 1: 
            m_opFirst->DumpData(szOp1);
            strcat(szData, szOp1);
            break;
        case 2:
            m_opFirst->DumpData(szOp1);
            strcat(szData, szOp1);
            m_opSecond->DumpData(szOp1);
            strcat(szData, szOp1);
            break;
    }                
    strcat(szData, "\n");
}
#endif
                                               
CInstructArray::CInstructArray() : CObArray()
{   
    m_nIndexTable = NULL;
    m_nCodeBase = NULL;
    m_nCodeNum = NULL;        
    m_nTotalIndex = 0;
}

CInstructArray::~CInstructArray()
{    
    if (m_nCodeBase != NULL)
        delete [] m_nCodeBase;
    if (m_nCodeNum != NULL) 
        delete [] m_nCodeNum;
        
    if (m_nIndexTable != NULL)
        delete [] m_nIndexTable; 
        
    for (int i=0; i<m_nSize; i++)
        delete (CInstruction*)m_pData[i];
}             

void
CInstructArray::SetCodeBitLen(int nCodeLen, int nBitLen)
{
    m_nCodeLen = nCodeLen;
    m_nBitLen = nBitLen;
    
    m_nTotalIndex = 1 << nBitLen;
    
    if (m_nCodeBase != NULL ) delete [] m_nCodeBase;
    if (m_nCodeNum != NULL) delete [] m_nCodeNum;
    
    m_nCodeBase = new int [m_nTotalIndex];
    m_nCodeNum = new int [m_nTotalIndex];
    
    for (int i=0; i<m_nTotalIndex; i++)
        m_nCodeNum[i] = 0;
}
 
void
CInstructArray::MakeIndexTable()
{
    if (m_nSize <= 0) return;
    
    int *nMin, *nMax;      
    
    nMin = new int [m_nSize];
    nMax = new int [m_nSize];
    
    for (int i=0; i<m_nSize; i++)
    {
        nMin[i] = (INSTRUCT_CODE(i)->m_nCode >> (m_nCodeLen - m_nBitLen) )
                 & ((1 << m_nBitLen) - 1);  // shift right and mask
        nMax[i] = (INSTRUCT_CODE(i)->m_nBitLen >= m_nBitLen) ? // if some bit can change 
            nMin[i] : (nMin[i] - 1 + (1<< m_nBitLen - 
                INSTRUCT_CODE(i)->m_nBitLen) );
        
        for (int j=nMin[i]; j<=nMax[i]; j++)
            m_nCodeNum[j]++;
    }
    
    ASSERT(m_nTotalIndex > 0);
    int *nCur = new int [m_nTotalIndex];
    
    m_nCodeBase[0] = 0;
    nCur[0] = 0;
    
    for (i=1; i<m_nTotalIndex; i++)
    {
        m_nCodeBase[i] = m_nCodeBase[i-1] + m_nCodeNum[i-1];
        nCur[i] = m_nCodeBase[i];
    }
    
    int nTotal = m_nCodeBase[i-1] + m_nCodeNum[i-1];
    
    if (m_nIndexTable != NULL) delete [] m_nIndexTable;
    m_nIndexTable = new int [nTotal];
    
    for (i=0; i<nTotal; i++)
        m_nIndexTable[i] = -1;
    
    for (i=0; i<m_nSize; i++)
        for (int j=nMin[i]; j<=nMax[i]; j++)
            m_nIndexTable[nCur[j]++] = i;
            
    delete [] nMin;
    delete [] nMax; 
    delete [] nCur;
}           
            
int 
CInstructArray::Disassemble(char* szValue, WORD nCode)
{
    int nInstruct;
    
    if ( !Instruct(nCode, nInstruct) ){
        strcpy(szValue, "?");
        return ERR_INSTRUCT_ERROR;
     }
    
    ASSERT(szValue != NULL);
    
    return INSTRUCT(nInstruct)->Disassemble(szValue, nCode);
}   

BOOL
CInstructArray::Instruct(const char* szName, int &nInstruct)
{
    for (int i=0; i<m_nSize; i++)
    {   
        int nReturn;

        nReturn = stricmp(szName, INSTRUCT_CODE(i)->m_strName);
        if (nReturn == 0){
            nInstruct = i;
            return TRUE;
        }     // the instruction is sorted by alphabet
        else if(nReturn < 0) return FALSE;
    }           
    return FALSE;
}       

    
BOOL
CInstructArray::Index(WORD nCode , int &nIndex)
{
    nIndex = nCode;
    nIndex >>= m_nCodeLen - m_nBitLen;
    nIndex &= (1 << m_nBitLen) - 1;          
    
    if ((nIndex>=0) && (nIndex<m_nTotalIndex)) return TRUE;
    
    return FALSE;
}

BOOL
CInstructArray::Instruct(WORD nCode, int &nInstruct)
{                       
    int nIndex;
    if (!Index(nCode, nIndex)) return FALSE;
    
    for(int i=m_nCodeBase[nIndex]; i<m_nCodeBase[nIndex] 
        + m_nCodeNum[nIndex]; i++)
    {
        nInstruct = m_nIndexTable[i];
        if ( INSTRUCT_CODE(nInstruct)->IsValid(nCode) ) return TRUE;
    }
    
    return FALSE;
}
                                                                     
int 
CInstructArray::AsmInstruct(const char* szSrc, int &nByte)              
{
    ASSERT(szSrc);
    
    char* szDes = new char[strlen(szSrc) + 1];
    
    nByte = Token(szSrc, szDes, ' ');
    
    if (nByte < 0){
         delete [] szDes;
         return ERR_DAD_NO_INPUT;
    }       
    
    int nInstruct;
    if ( !Instruct(szDes, nInstruct) ){
        delete [] szDes;
        return ERR_INSTRUCT_ERROR;
    }
    
    delete [] szDes;
    return nInstruct;
}   

        
int
CInstructArray::Assemble(const char* szSrc, WORD &nCode)
{
    ASSERT(szSrc);

    int nByte;  // byte have been handle.
    int nReturn; // return value.                   
        
    nReturn = AsmInstruct(szSrc, nByte);
    if (nReturn < 0)  return nReturn;   
    
    return INSTRUCT(nReturn)->Assemble(szSrc + nByte, nCode);       
}

int  
CInstructArray::Cycle(WORD nCode)
{   
    int nInstruct;
    
    if (Instruct(nCode, nInstruct))
        return INSTRUCT_CODE(nInstruct)->m_nCycle;
    else return 1;      
}                 

WORD
CInstructArray::PCNextAddr(WORD nAddr, WORD nCode)
{
    int nInstruct;
    if(Instruct(nCode, nInstruct))
        return INSTRUCT(nInstruct)->PCNextAddr(nAddr, nCode);
    else return nAddr + 1;
}

BOOL
CInstructArray::IsReturn(WORD nCode)
{
	int nInstruct;
	if (Instruct(nCode, nInstruct))
		return INSTRUCT(nInstruct)->IsReturn();
		
	return FALSE;
}            

BOOL
CInstructArray::IsCall(WORD nCode, WORD &nValue)
{
	int nInstruct;
	if (Instruct(nCode, nInstruct))
		return INSTRUCT(nInstruct)->IsCall(nValue);
		
	return FALSE;
}            


#ifdef _dadtest_
void  
CInstructArray::DumpData(const char *szFile)
{
    CFile dumpFile;
    
    if (dumpFile.Open(szFile, CFile::modeReadWrite) == 0)
    { 
        AfxMessageBox("can not open file to dump");
        return;
    } 
    
    dumpFile.SeekToEnd();    
    
    char szBuf[512];          
    strcpy(szBuf,"   Code   Len    Name   cyc T  Min   Max   HMax   SLen  Mask  T   Min  Max   HMax   SLen  Mask\n");
    dumpFile.Write(szBuf, strlen(szBuf));
    
    for (int i=0; i<m_nSize; i++)  
    {                            
        memset(szBuf, '\0', 511);
        INSTRUCT(i)->DumpData(szBuf);   
        dumpFile.Write(szBuf, strlen(szBuf));
    }  
    dumpFile.Close();
}    

#endif
 
/******************************end of file*******************************/
