
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADCORE.H__   1.13   13 Dec 1996 11:18:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADCORE.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:14   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:28   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:20   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:44   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:28   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadcore.h
** Author: Richard Guo
** Description:
**    DAD basic class and function defined here.
**
**
**    Finished date: 1996.6.21
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _dadcore_h
#define _dadcore_h                                    

#include "stdafx.h" 
//#define _dadtest_

struct tagOperand
{                                                
    enum COperandType { none, f, w, b, k, x, d, a } ;  
    int m_nBitFrom;
    int m_nBitTo;
    COperandType m_nType;
};

class CSFR : public CObject
{ 
public:
    CSFR(WORD nAddress, const char* szName);
    ~CSFR() {};
    
    BOOL IsMe(char* szName, WORD nAddress); 
    BOOL IsMe(const char* szName, WORD &nAddress);

protected:
    WORD m_nAddress;
    CString m_strName;   
};   

class CSFRArray : public CObArray
{
public:
    CSFRArray() {};
    ~CSFRArray();
    
    BOOL IsExist(char* szName, WORD nAddress);
    BOOL IsExist(const char* szName, WORD &nAddress);
};
    
// instruction operand class
class COperand : public tagOperand{
public:      
    COperand();
    COperand(const char* szCode, int nCodeLen = 12); 
    virtual ~COperand();
    
protected:

    char    m_cType;
        
    WORD m_nMin;
    WORD m_nMax; 
    WORD m_nHideMax;  
    
    int  m_nShiftLen;
    WORD m_nMask;

    void    DefaultMax(); 
    virtual void    SetHideMax();

// implement
protected:  
    void    Init(const char* szCode, int nCodeLen); 
    void    AnalyseCode(CString strCode);    
    
    virtual int  Asm(const char* szValue, WORD &nValue);
    virtual int  Dasm(char* szValue, WORD nValue);
    
    virtual int  Asm(WORD &nValue);
    
    inline  BOOL IsValid(WORD nValue);  

    virtual int EnhanceAsmValid(WORD nValue); 
    virtual int EnhanceDasmValid(WORD &nValue);

public:
    void    SetRange(WORD nMin, WORD nMax);  
    WORD    ValidCode(WORD nCode);

    BOOL    AsmValid(const char* szValue, WORD &nValue);
    BOOL    DasmValid(char* szValue, WORD nValue);
    
    virtual void 	CurValue(WORD &nValue);

    
#ifdef _dadtest_
    void DumpData(char* szData);
#endif      

};                                        

class COperandData : public COperand
{
public: 
    COperandData(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandData(){};

protected:  
    virtual int Asm(const char* szValue, WORD &nValue);
    virtual int Dasm(char* szValue, WORD nValue);      
};

class COperandAddr : public COperand
{
public: 
    COperandAddr(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandAddr(){};

protected:
    virtual void    SetHideMax();
    
    virtual int Asm(const char* szValue, WORD &nValue);
    virtual int Dasm(char* szValue, WORD nValue);      
    virtual int EnhanceAsmValid(WORD nValue); 
    virtual int EnhanceDasmValid(WORD &nValue);
    
public:
	virtual void 	CurValue(WORD &nValue);

};
    
class COperandReg : public COperand
{
public: 
    COperandReg(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandReg(){};

protected:  
    virtual void    SetHideMax();

    virtual int Asm(const char* szValue, WORD &nValue);
    virtual int Dasm(char* szValue, WORD nValue);      
    virtual int EnhanceAsmValid(WORD nValue); 
    virtual int EnhanceDasmValid(WORD &nValue);

};
    
class COperandWorkReg : public COperand
{
public: 
    COperandWorkReg(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandWorkReg(){};

protected:  
    virtual int Asm(const char* szValue, WORD &nValue);
    virtual int Dasm(char* szValue, WORD nValue);      
};

class COperandBitAddr : public COperand
{
public: 
    COperandBitAddr(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandBitAddr(){};
};
    
class COperandCompatible : public COperand
{
public: 
    COperandCompatible(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandCompatible() {};

protected:  
    int virtual Asm(const char* szValue, WORD &nValue);
    int virtual Dasm(char* szValue, WORD nValue);      
};
    
class COperandDes : public COperand
{
public: 
    COperandDes(const char* szCode, int nCodeLen = 12); 
    virtual ~COperandDes(){};

protected:  
    virtual int Asm(const char* szValue, WORD &nValue);
//  virtual int Dasm(char* szValue, WORD nValue);      
};
    
               
// InstructionCode class 


class CInstructionCode 
{
public:             
    
    CInstructionCode();
    CInstructionCode(const char* szName, const char* szCode, 
        int nCycle, int nCodeLen=12);
    ~CInstructionCode();
    
public:
    enum CCycleType { one = 1, one_or_two = 3, two = 2};

    WORD  m_nCode;   // machine code  
    WORD  m_nCompatibleMask;     // for compatible
    int  m_nBitLen;  // instruction unchange partion bit num
    CString  m_strName;  
    int  m_nCycle; // instruction execute cycle
    
    
public:
    BOOL IsValid(WORD nCode);     
    void SetRange(WORD nMin, WORD nMax); // only for tris 

#ifdef _dadtest_
    void DumpData(char* szData);
#endif      

    
private:   
    WORD m_nMin, m_nMax;
    
    void SetCycle(int nCycle);
    
protected:        
    int  m_nCodeLen; // instruction length    
    
    void AnalyseCode(CString strCode);
};  

class CInstruction : public CObject
{
public:
         
    CInstruction();
    CInstruction(const char* szName, char cFirstOp, char cSecondOp, 
        const char* szCode, int nCycle, int nLen);
    virtual ~CInstruction();      
    
    CInstructionCode *m_insCode;
    COperand *m_opFirst;
    COperand *m_opSecond; 
    
    int OperandNum() const;
    
    int Assemble(const char* szSrc, WORD &nCode);
    int Disassemble(char* szSrc, WORD nCode);
    WORD PCNextAddr(WORD nAddress, WORD nCode);
    BOOL IsReturn();
    BOOL IsCall(WORD &nValue);
        
#ifdef _dadtest_
    void DumpData(char* szData);
#endif      
    
protected:      
            
    int m_nOpNum;   

protected:  
          
    COperand* CreateOp(char cType, const char* szCode, int nCodeLen);
                
    inline int AsmOp(const char* szSrc, int &nByte, WORD &nCode);
    inline int DasmOp(char* szSrc, WORD nCode);
    
    inline int AsmZeroOp(const char* szSrc, int &nByte, WORD &nCode);
    inline int DasmZeroOp(char* szSrc, WORD nCode);
    
    int AsmOneOp(const char* szSrc, int &nByte, WORD &nCode);
    inline int DasmOneOp(char* szSrc, WORD nCode);
    
    int AsmTwoOp(const char* szSrc, int &nByte, WORD &nCode);
    int DasmTwoOp(char* szSrc, WORD nCode);
};

class CInstructArray : public CObArray
{           
public:
    CInstructArray();
    virtual ~CInstructArray();   

    void MakeIndexTable();
    void SetCodeBitLen(int nCodeLen, int nBitLen);    
    
    int  Disassemble(char* szName, WORD nCode);
    int  Assemble(const char* szName, WORD &nCode);   
    int  Cycle(WORD nCode);
    WORD PCNextAddr(WORD nAddr, WORD nValue);
    BOOL IsReturn(WORD nCode);
    BOOL IsCall(WORD nCode, WORD &nValue);

#ifdef _dadtest_
    void DumpData(const char* szFile);
#endif      
    
protected:             
// we put all instruction in 2**m_nBitLen level buffer , thus we can sort 
//  specified instruction quickly.     
    int *m_nCodeBase;
    int *m_nCodeNum;
                              
    int m_nCodeLen;  // instruction length
    int m_nBitLen;  //  use first m_nBitLen bit to create sort table
    
    int *m_nIndexTable; 
    int m_nTotalIndex;  

protected:                        
    int  AsmInstruct(const char* szSrc, int &nByte);
    
    BOOL Index(WORD nCode, int& nIndex);         
    BOOL Instruct(WORD nCode, int &nInstruct);
    BOOL Instruct(const char* szName, int &nInstruct);
};  

void UIntFromString(const char* szSrc, WORD &nValue, int &nNum, int nBase);
BOOL HexFromString(const char* szSrc, WORD &nValue);
int  Token(const char* szSrc, char* szDes, char cDivide);
        
#endif
