/***************************************************************************
**
**    $Header:   
**
**    $Log: 
** 
** 
****************************************************************************/

/***************************************************************************
**
** File name : daddata.h
** Author: Richard Guo
** Description:
**    data type and function prototype defined in this file.
**
**
**    Finished date: 1996.6.21
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _daddata_h
#define _daddata_h
                        
#include <windows.h>

typedef struct
{
	WORD  nAddress; // register address
	char* szName; // register name
	unsigned long lCpuSupport;  // cpu supported
}tagSFR; // special function register

typedef struct
{
	BYTE  bAddrFrom; 
	BYTE  bAddrTo;
}tagOneGPRF;   

typedef struct
{
	BYTE  bNum;
	tagOneGPRF one;
	tagOneGPRF two;
	unsigned long lCpuSupport;
}tagGPRF;

typedef struct
{
	BYTE  bBankNum; // num of bank;
	BYTE  bBankLen; // each bank length;
	char* szRegName; // which register can determine bank
	BYTE  bBitFrom; // register from bit
	BYTE  bBitTo;  // register to bit
	unsigned long lCpuSupport;
}tagRegBank;                         
                              
typedef struct
{
	char  cType; // operand type
	WORD  nMax; // operand maximum value
}tagOpLimit;  // operand limitation


typedef struct
{
	char* szName; // assemble
	char  cOperand1; // first operand character type
	char  cOperand2; // second operand character type
	int   nCycle; // execute cycle, 10 mean one cycle, 
				  // 15 mean one or two, 20 mean two.
} tagAsm;  // assemble and disassemble
             
                   
int _export _far _pascal SetCpuId(WORD nCpuServer, unsigned long &nCpuLDad); 
int _export _far _pascal GetCpuModule(WORD nCpuServer); 

/*
int _export _far _pascal SetGPRF(WORD nCpuId, tagGPRF* &pReg);
*/

int _export _far _pascal GetInstructionLen(WORD nCpuId);

int _export _far _pascal SetRegBank(WORD nCpuId, tagRegBank* &pRegBank);

int _export _far _pascal SetSFR(WORD nCpuId, tagSFR* &pReg, int &nTotal);

int _export _far _pascal SetAsm(WORD nCpuId, tagAsm* &pAsm, int &nTotal);

int _export _far _pascal SetDasm(WORD nCpuId, char** &pDasm, int &nTotal);


#endif  


/*************************end of file*********************************/


