
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADINIT.CPP   1.13   13 Dec 1996 11:18:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADINIT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:30   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:28   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:42   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:18   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:28   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:42   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:20:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadinit.cpp
** Author: Richard Guo
** Description:
**    Load and free DAD table functions implemented in this file.
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"   
#include "daddata.h"
#include "dadcore.h"
#include "dadinit.h" 
#include "abibase.h"    
#include "dadpub.h"
#include "dadconst.h"   
#include "basictyp.h"
#include "hosterrs.h" 
          

STATUS AbiGetCpuId(UINT *nCpuId);
void ErrShow(U32 errorCode,BOOL bUI);   

CInstructArray *pInstructArray = NULL;
CSFRArray *pSFRArray = NULL; 
extern WORD nCurCpuId;
                    
BOOL InitDATable()
{
	if (pInstructArray != NULL) delete pInstructArray;
	pInstructArray = new CInstructArray();
	
	CInstruction* pInstruct;
	
	int nTotal;
	tagAsm *pAsm;  
	char** pDasm;  
	
	if (SetAsm(nCurCpuId, pAsm, nTotal) != 0){
		 ErrShow(ER_DAD_LOAD_DA_TABLE, TRUE);
		 return FALSE;   
	}
	if (SetDasm(nCurCpuId, pDasm, nTotal) != 0){
		ErrShow(ER_DAD_LOAD_DA_TABLE, TRUE);
		return FALSE;  
	}
	
	int nInstructLen = GetInstructionLen(nCurCpuId);
	for (int i=0; i<nTotal; i++)
	{
		pInstruct = new CInstruction(
			pAsm[i].szName, 
			pAsm[i].cOperand1,		
	        pAsm[i].cOperand2, 
	        pDasm[i], 
	        pAsm[i].nCycle,
	        nInstructLen);      
		if (stricmp(pDasm[i], "000000000fff") == 0)
			pInstruct->m_insCode->SetRange(5,7);  // tris is some different
				        
		pInstructArray->Add(pInstruct);
	}
	
	pInstructArray->SetCodeBitLen(nInstructLen, 6);
	pInstructArray->MakeIndexTable();            
	
#ifdef _dadtest_  
	CFile tt;
	tt.Open("d:\\pic\\test\\pic.dup", CFile::modeCreate);
	tt.Close();           
	pInstructArray->DumpData("d:\\pic\\test\\pic.dup");
#endif		
	return TRUE;
}	        
	        
void FreeDATable()
{
	if (pInstructArray != NULL)
	{
		delete pInstructArray;
		pInstructArray = NULL;
	}
}   

BOOL InitSFRTable()
{        
	if (pSFRArray != NULL) delete pSFRArray;
	pSFRArray = new CSFRArray();
	
	int nTotal;
	tagSFR *pSFRTable; 
	unsigned long nCpuDad_L;
	
	if (SetSFR(nCurCpuId, pSFRTable, nTotal) != 0){
		ErrShow(ER_DAD_LOAD_SFR_TABLE, TRUE);
		return FALSE; 
	}
	                        
	SetCpuId(nCurCpuId, nCpuDad_L);	                        
	
	CSFR* pSFR;
	for (int i=0; i<nTotal; i++)
	{                      
		if ( (pSFRTable[i].lCpuSupport & nCpuDad_L) != 0)
		{
			pSFR = new CSFR(pSFRTable[i].nAddress, pSFRTable[i].szName);
			pSFRArray->Add(pSFR);
		}
	}	
		
	return TRUE;	          
}

void FreeSFRTable()
{
	if (pSFRArray != NULL)
	{
		delete pSFRArray;
		pSFRArray = NULL;
	}
} 

void InitDAD()
{
	AbiGetCpuId((UINT*)(&nCurCpuId));
	GetPageLen();
	GetBankLen();
	GetTotalPage();
	GetTotalBank();
	GetPage();
	GetBank(); 

	if ( InitDATable())
		InitSFRTable();
} 

void FreeDAD()
{
	FreeDATable();
	FreeSFRTable();
}