
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADPUB.CPP   1.13   13 Dec 1996 11:18:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADPUB.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:28   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:42   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:51:20   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:28   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:42   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadpub.cpp
** Author: Richard Guo
** Description:
**    DAD public functions implemented here.
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"
#include "abibase.h"
#include "dad.h"  
#include "daddata.h"
#include "dadcore.h"
#include "dadconst.h"   
#include "basictyp.h"
#include "cpucom.h"
#include "cpuserve.h"
#include "hosterrs.h" 
#include "dadpub.h"


WORD nCurCpuId = 1;
BYTE nCurBankId = 0;
BYTE nCurPageId = 0; 
WORD nCurPageLen = 512;
WORD nCurBankLen = 32;     
BYTE nCurTotalPage = 1;
BYTE nCurTotalBank = 1;

extern WORD nCodeMax;

extern CInstructArray *pInstructArray;
extern CSFRArray *pSFRArray;

int GetMemoryRange(CPUMEMORYRANGE *stRange);
STATUS AbiSetMemN(ADDR addr, WORD* pchBuff, UINT uPatternLen);
STATUS AbiGetOneReg(WORD iRegId, WORD* cpuValue);
void ErrShow(U32 errorCode,BOOL bUI);   
CPURegisterFileRange GetCpuRFileRange();

          
void StrToUpper(char* szValue)
{
    for (; *szValue != 0; szValue++) 
        if ((*szValue >= 'a') && (*szValue <= 'z'))
            *szValue += 'A' - 'a';
         
}
                     
BYTE GetPage()     
{            
	int nCpuModule = GetCpuModule(nCurCpuId); 
	WORD nRegValue;
	
	nCurPageId = 0;
    
    switch(nCpuModule){
		case 1: // 16c5x
			if (AbiGetOneReg(REG_5X_STATUS, &nRegValue) ==ICE_OK)
				nCurPageId = (nRegValue & 0x60) >> 5;
			break;
		case 2:   
		case 3:
		case 4:
			if (AbiGetOneReg(REG_6X_PCLATH, &nRegValue) == ICE_OK)
				nCurPageId = (nRegValue & 0x18) >> 3;
			break;
	}  
	if (nCurPageId >= nCurTotalPage)
		nCurPageId &= nCurTotalPage - 1;

	return nCurPageId;
}                                          

BYTE GetBank()
{
	int nCpuModule = GetCpuModule(nCurCpuId); 
	WORD nRegValue;
	
	nCurBankId = 0;
    
    switch(nCpuModule){
		case 1: // 16c5x
			if (AbiGetOneReg(REG_5X_FSR, &nRegValue) == ICE_OK)
				nCurBankId = (nRegValue & 0x60) >> 5;
			break;
		case 2: 
		case 3:
		case 4:
			if (AbiGetOneReg(REG_6X_STATUS, &nRegValue) == ICE_OK)
				nCurBankId = (nRegValue & 0x60) >> 5;
			break;
	}   
	if (nCurBankId >= nCurTotalBank)
		nCurBankId &= nCurTotalBank - 1;
	return nCurBankId;

}  

BYTE GetTotalBank()
{    
	CPURegisterFileRange  rfRange;
	rfRange = GetCpuRFileRange();
    nCurTotalBank = rfRange.nBanks;
    return nCurTotalBank;
} 

BYTE GetTotalPage()
{
    CPUMEMORYRANGE stRange;
    GetMemoryRange( &stRange );        
    nCodeMax = stRange.pMax + 1;
 	nCurTotalPage = stRange.pMax/GetPageLen() + 1; 
 	return nCurTotalPage;
}
                  

WORD GetPageLen()
{
    int nCpuModule = GetCpuModule(nCurCpuId); 
		
    switch(nCpuModule){
		case 1: // 16c5x
			nCurPageLen = 512;	
	       	break;;
	    case 2: 
	    	nCurPageLen = 2048;	
	       	break;;
	    default:
	    	nCurPageLen = 2048;	
	       	break;;
	   }
	 return nCurPageLen;
}              

WORD GetBankLen()
{
    int nCpuModule = GetCpuModule(nCurCpuId); 
		
    switch(nCpuModule){
		case 1: // 16c5x 
			nCurBankLen = 32;
			break;
	    case 2:        
	    	nCurBankLen = 128;
	    	break;
	    default:
	    	nCurBankLen = 128;
	    	break;
	  }
	return nCurBankLen;
}       

int CurAddr(WORD &nAddr)
{
    if (nAddr >= nCurPageLen)
        return 0;
        
    if (nCurPageId != 0){
        nAddr = nAddr + nCurPageLen * nCurPageId; 
        return ERR_OP_ADDR_BOUND;
    }
    else    return 0;
}

int CurReg(WORD &nAddr)
{
    if (nAddr >= nCurBankLen)
        return 0;
    
    if (nCurBankId != 0){
        nAddr = nAddr + nCurBankLen * nCurBankId;
        return ERR_OP_REG_BOUND;
    }
    else    return 0;
}                                        


BOOL InCurPage(WORD nAddr)
{
//    GetPage();
    
    BYTE nPage = BYTE(nAddr/nCurPageLen);
    
    return nCurPageId == nPage;
}                            


BOOL InCurBank(WORD nAddr)
{
//    GetBank();
    
    BYTE nBank = BYTE(nAddr/nCurBankLen);
    
    return nBank == nCurBankId;
}               


int ValidAddr(WORD &nAddr, int nAddrType )
{                                      
    
    CPUMEMORYRANGE stRange;
    GetMemoryRange( &stRange );
    nCodeMax = stRange.pMax + 1;
    
    switch(nAddrType){
        case ABI_CODE_ADDR_JOHN: // ABI_CODE_ADDR_JOHN
            if ((nAddr > 0xffff) || ((WORD)nAddr > stRange.pMax))
            {
                nAddr = stRange.pMax;
                return ERR_ADDR_LARGE;
            }
            else if ((nAddr < 0) || ((WORD)nAddr < stRange.pMin))
            {
                nAddr = stRange.pMin;
                return ERR_ADDR_LITTLE;
            }   
            return 0;
        default:
            return 0;
    }
}

int ValidLen(WORD nAddr, int &nLen, int nAddrType)
{
    CPUMEMORYRANGE stRange;
    GetMemoryRange( &stRange );
    
    int nOldLen = nLen;
    switch(nAddrType){
        case 1: // ABI_CODE_ADDR_JOHN
            if (nLen > stRange.pMax - nAddr)
                nLen = stRange.pMax - nAddr + 1;
            return nLen == nOldLen;
        default:
            return 0;
    }
}  

int  Cycle(WORD nCode)
{
    if (pInstructArray != NULL)
    	return pInstructArray->Cycle(nCode);
    
    return 1;
}

WORD PCNextAddr(WORD nAddress, WORD nCode)
{
	if (pInstructArray != NULL)
		return pInstructArray->PCNextAddr(nAddress, nCode);
	
	return 0xffff;
}

BOOL IsStepReturn(WORD nCode)
{
	if (pInstructArray != NULL)
		return pInstructArray->IsReturn(nCode);	
	return FALSE;
}

BOOL IsStepCall(WORD nCode, WORD &nAddress)
{
	GetPage(); 
	if (pInstructArray != NULL)
		return pInstructArray->IsCall(nCode, nAddress);	
	return FALSE;	
}

int Assemble(const char* szName, WORD &nCode)
{
    if (pInstructArray != NULL)
        return pInstructArray->Assemble(szName, nCode);
    
    return ERR_NO_DAD_TABLE;                     
}                           

int Disassemble(char* szName, WORD nCode)
{
 
    if (pInstructArray != NULL)
        return pInstructArray->Disassemble(szName, nCode);
    
    return ERR_NO_DAD_TABLE;
}

                            
BOOL AsmSFR(const char* szValue, WORD &nValue)
{
    if (pSFRArray != NULL)
        return pSFRArray->IsExist(szValue, nValue);
    
    return FALSE;       
}                                                  

BOOL DasmSFR(char* szValue, WORD nValue)
{                           
    if (pSFRArray != NULL)
        return pSFRArray->IsExist(szValue, nValue);
    
    return FALSE;           
}       

int  FillCodeMem(WORD nAddress, WORD nCode)
{                    
    ADDR  addr;
    
    addr.addrType = ABI_CODE_ADDR_JOHN;
    addr.addr = nAddress;
    
    return AbiSetMemN(addr, &nCode, 1);      
}            

void DadErrShow(int nDadErr, BOOL bUI)
{            
    U32 errorCode;
    
    switch(nDadErr){
        case ERR_ADDR_LARGE: 
        	errorCode = ER_DAD_ADDR_LARGE;
            break;
        case ERR_ADDR_LITTLE:             
        	errorCode = ER_DAD_ADDR_LITTLE;
            break;
        case ERR_DAD_MEM_INVALID_LENGTH:   
        	errorCode = ER_DAD_MEM_INVALID_LENGTH;
            break;
        case ERR_DAD_MEM_INVALID_RANGE:           
        	errorCode = ER_DAD_MEM_INVALID_RANGE;
            break;
        case ERR_DAD_ABI_GET_MEM:                
        	errorCode = ER_DAD_ABI_GET_MEM;
            break;
        case ERR_DAD_CPU:  
            errorCode = ER_DAD_CPU;
            break;
        case ERR_OP_ADDR_BOUND:  
        	errorCode = ERI_DAD_OP_ADDR_BOUND;
            break;
        case ERR_OP_ADDR_LIMIT:   
        	errorCode = ER_DAD_OP_ADDR_LIMIT;
            break;
        case ERR_OP_ADDR_LARGE:              
        	errorCode = ER_DAD_OP_ADDR_LARGE;
            break;
        case ERR_OP_ADDR_ERROR:              
        	errorCode = ER_DAD_OP_ADDR_ERROR;
            break;
        case ERR_OP_DATA_LARGE:
        	errorCode = ER_DAD_OP_DATA_LARGE;
            break;
        case ERR_OP_DATA_ERROR:              
        	errorCode = ER_DAD_OP_DATA_ERROR;
            break;
        case ERR_OP_REG_BOUND:               
        	errorCode = ERI_DAD_OP_REG_BOUND;
            break;
        case ERR_OP_REG_ERROR:              
        	errorCode = ER_DAD_OP_REG_ERROR;
            break;
        case ERR_OP_BOUND_ERROR:            
        	errorCode = ER_DAD_OP_BOUND_ERROR;
            break;
        case ERR_OP_PARA_ERROR:               
        	errorCode = ER_DAD_OP_PARA_ERROR;
            break; 
        case ERR_OP_LACK:                    
        	errorCode = ER_DAD_OP_LACK;
            break;
        case ERR_OP_REDUNDANT:                
            errorCode = ER_DAD_OP_REDUNDANT;
            break;
        case ERR_OP_INTERNAL_ERROR:        
        	errorCode = ER_DAD_OP_INTERNAL_ERROR;
            break;
        case ERR_INSTRUCT_ERROR:                 
        	errorCode = ER_DAD_INSTRUCT_ERROR;
            break;
        case ERR_DAD_NO_INPUT:                
        	errorCode = ER_DAD_NO_INPUT;
            break;
        case ERR_NO_DAD_TABLE:          
        	errorCode = ER_DAD_NO_DAD_TABLE;
            break;
        case ERR_NO_SFR_TABLE:              
        	errorCode = ER_DAD_NO_SFR_TABLE;
            break; 
        case ERR_OP_ADDR_REG_BOUND:
        	errorCode = ERI_DAD_OP_ADDR_REG_BOUND;
        	break;
    }              
    
    ErrShow(errorCode, bUI);
}
                            
/************************end of file******************************/
