
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADPUB.H__   1.13   13 Dec 1996 11:18:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADPUB.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:42   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:20   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:30   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:42   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadpub.h
** Author: Richard Guo
** Description:
**    DAD public functions defined in this file.
**
**
**    Finished date: 1996.6.21
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#ifndef _dadpub_h
#define _dadpub_h

#include "stdafx.h"

void StrToUpper(char* szValue);

// function relevpage and bank
BYTE 	GetPage();
BYTE 	GetBank();
BYTE	GetTotalPage();
BYTE	GetTotalBank();
WORD  	GetPageLen();
WORD	GetBankLen();
int		CurAddr(WORD &nAddr);
int		CurReg(WORD &nAddr);
BOOL	InCurPage(WORD nAddr);
BOOL	InCurBank(WORD nAddr);
                                                       
// used in interface with memory, shell or trace window.                                                       
int 	ValidAddr(WORD &nAddr, int nAddrType);
int		ValidLen(WORD nAddr, int &nLen, int nAddrType);

// used in dad

int		Assemble(const char* szName, WORD &nCode);
int 	Disassemble(char* szName, WORD nCode);
BOOL	AsmSFR(const char* szName, WORD &nValue);
BOOL	DasmSFR(char* szName, WORD nValue);    

// for source window.
BOOL	IsStepReturn(WORD nCode); 
BOOL 	IsStepCall(WORD nCode, WORD &nAddress);

// for dq
int		Cycle(WORD nCode);
WORD	PCNextAddr(WORD nAddr, WORD nCode);

//
int		FillCodeMem(WORD nAddress, WORD nCode);  

// dad error show
void    DadErrShow(int nDadErr, BOOL bUI);

#endif   

