
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADTRACE.CPP   1.13   13 Dec 1996 11:18:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADTRACE.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:46   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:50:08   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:56   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:10   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:46:46   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:12   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:26   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:30:34   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:14   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadtrace.cpp
** Author: Richard Guo
** Description:
**    Functions defined in this file are prepared for the using of others.
**
**
**    Finished date: 1996.6.21
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include "dad.h"

#include "dadcore.h"
#include "dadext.h"
#include "trcsvr.h" 
#include "dadpub.h"          

WORD nCodeMax = 0x1ff;               

#define FRAME(e)        (WORD((e)&0xffff))
#define ADDRESS(e)      (WORD((e>>16)&0xffff))


STATUS AbiGetMemN(ADDR addr1, ADDR addr2,WORD* pchBuff);

BOOL IsAddrJump(TRACE_INFO* pTraceInfo)
{   
	if ( ((pTraceInfo[0].addr & 0x3fff) + 1) % nCodeMax ==
		(pTraceInfo[1].addr & 0x3fff) )
		return FALSE;                        
	
	return TRUE;		
}


// nDqIndex: the instruction number between current one and one that have dq flag
BOOL IsDqFiltered(TRACE_INFO* pTraceInfo, int nDqIndex, WORD CodeMem)
{
	if ( IsAddrJump(pTraceInfo) ) return TRUE;
	switch(nDqIndex){
		case 1: 
				return FALSE;
		case 2: 
			{
				WORD nAddr = PCNextAddr(pTraceInfo->addr, CodeMem);
				if (nAddr == 0xffff) return FALSE;
			
				if (IsAddrJump(pTraceInfo+1)) // for jump instrction
				{
					if ((nAddr - pTraceInfo[2].addr) && 0xff)
						return FALSE;
					else return TRUE;
				}					
				else
//				{			    // for condition skip instruction
//					if (nAddr == (pTraceInfo[2].addr & 0x3fff))
//						return FALSE;
//					else return TRUE;
//				}           
					return FALSE;
			}					
		default:	
				return FALSE;
	}
}
				
				

int FindNearDqFlag(TRACE_INFO* pTraceInfo, int nTraceCount, WORD CodeMem)
{             
	if (nTraceCount >= 3) nTraceCount = 3;    // we only search three instruction
	
	for(int i=1; i<nTraceCount; i++)
	{
		
		WORD nAddr = (pTraceInfo[i].addr & 0x3fff) -
			 		 (pTraceInfo[0].addr & 0x3fff);
			
		  // if the instruction followed also is a two cycle instruction,
					// the dq is set for it , not the current one.
//		if (Cycle(*(pMem+nAddr)) != CInstructionCode::one)
//				return -1;
				
		if (((pTraceInfo+i)->addr & 0x4000) != 0) // if dq bit is set
		{   // dq may be set at the current address, not minding the current instruct cycle
			
			if (IsDqFiltered(pTraceInfo, i, CodeMem))
			 	return -1;
			else return i;
		}   
	}   
	
    // if jump or return struction, perhaps we can not find dq flag
	if(Cycle(CodeMem) == CInstructionCode::two){ 
	    if (IsDqFiltered(pTraceInfo, nTraceCount, CodeMem))
	    	return -1;
		return nTraceCount;
	}
	            
	return nTraceCount == 3 ? -1 : -2; 
// -1 mean not find
// -2 mean perhaps exist dq later.	
}

BOOL PreSetDq(TRACE_INFO* pTraceInfo, int nTraceCount)
{
	if (nTraceCount > 1)
		if ((pTraceInfo[1].addr & 0x4000) != 0)
			return TRUE;
			
	return FALSE;
}

// nStartAddr : trace disassemble start address.
int
DadTrace(TRACE_INFO* pTraceInfo, int &nTraceCount,
	FrameInst* pFrameInfo, int &nFrameCount, int nMaxFrame, int nStopFrame,
	WORD* pMem, int nMemLen, BOOL &bDqFlag)
{   
	TRACE_INFO* pCurTrace = pTraceInfo;
	FrameInst*  pCurFrame = pFrameInfo;                                                         
	int			nCurTrace = 0;
	
	if (nTraceCount < 0){
		 nTraceCount = 0;
		 return -1;
	}
	int nReturn;
	
	WORD nStartAddr = pTraceInfo->addr & 0x3fff;
	int nDAddr;  // current address minus start address                           
	BOOL bStopFlag = TRUE;  // record whether meet the needed frame no.

	
	for(int i = 0; i<nTraceCount && nFrameCount<nMaxFrame && bStopFlag; 
		i++, pCurTrace++, nCurTrace++)
	{
		if (pCurTrace->frameNo == nStopFrame)
			bStopFlag = FALSE;
		if(bDqFlag & ((nFrameCount == 0) || (!IsAddrJump(pCurTrace - 1)) )) 
		{
			bDqFlag = FALSE;
			continue;
		}	 	
		
		nDAddr = (pCurTrace->addr & 0x3fff) - nStartAddr;
		
		wsprintf((char*)pCurFrame->instruction, "%04x  ", pMem[nDAddr]);
		
		nReturn = Disassemble((char*) pCurFrame->instruction + 6,
		    		pMem[nDAddr]);
		
//		if (nReturn < 0) continue;
		                                          
				                                          
		pCurFrame->phisicalNo = pCurTrace->frameNo;
		wsprintf(pCurFrame->frameNo, "%04x", pCurTrace->frameNo);
		wsprintf(pCurFrame->addr, "%04x", pCurTrace->addr & 0x3fff); 
		StrToUpper(pCurFrame->frameNo);
		StrToUpper(pCurFrame->addr);
		
		nFrameCount++;
		pCurFrame++;	

		if(Cycle(pMem[nDAddr]) != CInstructionCode::one)
		{
			switch(FindNearDqFlag(pCurTrace, nTraceCount - nCurTrace,
				 pMem[nDAddr])) 
			{
				case -1:
					bDqFlag = FALSE;
					break;
				case -2: 
					nTraceCount = nCurTrace;
					return -2;  
				default:
					bDqFlag = TRUE;
			}
		}						
	}				        
	
	nTraceCount = nCurTrace;
	if (!bStopFlag) return 2; // have meet with the need frame.
	if (nFrameCount >= nMaxFrame) return 1; // frame num is enough
	return 0;
}   


int MaxTRCMemContinue(TRACE_INFO* pTraceInfo, int &nTraceNum, int nBufNum)
{                                                                      
	if (nTraceNum <= 0) return -1;
	
	int nAddrCount;  
	int nLenMax = 1;   
	BOOL bContinue = TRUE;
	    
	for(int i=1; i<nTraceNum; i++){
		nAddrCount = (pTraceInfo[i].addr & 0x3fff) - (pTraceInfo[0].addr & 0x3fff);
		if ((nAddrCount<0) || (nAddrCount>=nBufNum-1))
				break;
		if (nAddrCount > nLenMax) nLenMax = nAddrCount;
	}
	
	nTraceNum = i;	
	
	return nLenMax+2;
}

BOOL
ReadPMem(WORD nStartAddr, WORD nLen, WORD* pMem)
{
	ADDR addrFrom, addrTo;
	
	addrFrom.addr = nStartAddr;
	addrFrom.addrType = ABI_CODE_ADDR_JOHN;

	addrTo.addr = nStartAddr + nLen - 1;
	addrTo.addrType = ABI_CODE_ADDR_JOHN;  

	if (AbiGetMemN(addrFrom, addrTo, pMem) != ICE_OK)
		return FALSE;
	return TRUE;
		
}


//This function is defined for Bright using(disassembly) and it needn't to get bytes
BOOL DADTraceDq(TRACE_INFO* pTraceInfo, int nTraceCount,
			 FrameInst*  pFrameInfo, int &nFrameCount, int nStopFrame)
{
	if ((nTraceCount<=0) || (nFrameCount<=0) )
	{
		nFrameCount = 0;
		return FALSE;
	}    
	
	WORD pMem[100];
	
    int nCurFrame = 0;
    int nCurTrace = 0;
    
    int bDqFlag = PreSetDq(pTraceInfo, nTraceCount);
    int nFirst = 1;                              
    int nTraceHandle;
    
    WORD nDqAddr = 0;

	GetPage();
	GetBank();    
    while((nCurFrame < nFrameCount) && (nCurTrace < nTraceCount))
    {
    	int MemNum;  
    	int nSkip = 0;
    	
		nTraceHandle = nTraceCount - nCurTrace;
		WORD nStartAddr = pTraceInfo->addr & 0x3fff;
		MemNum = MaxTRCMemContinue(pTraceInfo, nTraceHandle, 100);
		
		if (!ReadPMem(nStartAddr, MemNum, pMem))
			return FALSE;  
		
//		if (nFirst && Cycle(pMem[0]) == CInstructionCode::one)
			 // when first, we do not know dq, so perhaps, some
			 // instruction may need skip
//			if ((nSkip = (FindNearDqFlag(pTraceInfo, nTraceHandle, pMem)
//					+ 1) > 0))
//			{
//				pTraceInfo += nSkip;
//				nTraceHandle = nTraceHandle - nSkip;
//			}						
//			else nSkip = 0;					
			
		
		int nReturn;
		nReturn = DadTrace(pTraceInfo, nTraceHandle, 
			pFrameInfo + nCurFrame, nCurFrame, nFrameCount, nStopFrame, pMem, 
			MemNum, bDqFlag);
		
		switch(nReturn){
			case 1:
			case 2:
				break;  
		}	
			
		pTraceInfo += nTraceHandle;     
		nCurTrace += nTraceHandle;
		if ((nReturn == -2) && (nCurTrace+nTraceHandle>=nTraceCount-2))
			break;
	}		
	
	nFrameCount = nCurFrame;
						    	
	return TRUE;
}


void 
GetMinTraceNum(TRACE_INFO* &pTraceInfo, int &nTraceCount, WORD nStopFrame, 
	int nFrameCount)
{
	for(int i=0; i<nTraceCount - 1; i++)
	{
		if ((pTraceInfo+i)->frameNo >= nStopFrame)
			break;
	}                                              
	
	int nRedunt;    // two trace information for dq
	if (nTraceCount - i > 2) nRedunt = 2;
	else  nRedunt = nTraceCount - i -1;
	
	if (i > nFrameCount*2)
	{
		nTraceCount = nFrameCount*2 + nRedunt ;
		pTraceInfo += i - nTraceCount;
	}
	
}

void CopyFrame(FrameInst* pFrameFrom, FrameInst* pFrameTo, int nCount)
{
	for (int i=0; i<nCount; i++){
		pFrameTo[i].phisicalNo = pFrameFrom[i].phisicalNo;
		strcpy(pFrameTo[i].frameNo, pFrameFrom[i].frameNo);
		strcpy(pFrameTo[i].addr, pFrameFrom[i].addr);
		strcpy((char*)(pFrameTo[i].instruction), (const char*)pFrameFrom[i].instruction);
	}
		
}

BOOL TRCBinToInsText(TRACE_INFO* pTraceInfo, int nTraceCount,
			 FrameInst*  pFrameInfo, int &nFrameCount)
{
	return DADTraceDq(pTraceInfo, nTraceCount, pFrameInfo, nFrameCount, 0xfff);
}


BOOL TRCBinToInsText2(TRACE_INFO* pTraceInfo, int nTraceCount, 
		WORD nStopFrame, FrameInst* pFrameInfo, int& nFrameCount)
{                                      
	if ((nTraceCount<=0) || (nFrameCount<=0)){
		nFrameCount = 0;
		return TRUE;   
	}   
	if ((nTraceCount==1) && (pTraceInfo[0].frameNo==0))
	{
		nFrameCount = 0;
		return TRUE;
	}
		
	GetMinTraceNum(pTraceInfo, nTraceCount, nStopFrame, nFrameCount);	
	
	FrameInst *pUsedFrame = new FrameInst[nTraceCount];
	if (pUsedFrame == NULL){
		nFrameCount = 0;
		return FALSE;  
	}
	
	
	int nUsedFrame = nTraceCount;
	if (!DADTraceDq(pTraceInfo, nTraceCount, pUsedFrame, nUsedFrame,
		 nStopFrame) )
	{
		delete [] pUsedFrame;
		nFrameCount = 0;
		return FALSE;
	}		 
		 
	if (nUsedFrame <= nFrameCount){
		CopyFrame(pUsedFrame, pFrameInfo, nUsedFrame);
		nFrameCount = nUsedFrame;
	}
	else
		CopyFrame(pUsedFrame+nUsedFrame-nFrameCount-1, pFrameInfo, nFrameCount);
    
	delete [] pUsedFrame;
	
	return TRUE;
}



// isStop = TRUE, stop if one instruction is flushed.
void DadIsExecuted(BOOL isStop, DWORD * pBuffer, int nCount)
{
	ASSERT(nCount%3==0);
	
	for(int i=0; i<nCount/3; i++){	
		if ((ADDRESS(pBuffer[i*3+2]) & 0x4000) != 0){
			pBuffer[i*3] = 1;
			if (isStop) return;
		}
		else pBuffer[i*3] = 0;
	}					
 
}
                                                     
                                                     
/********************** THE END OF FILE ***********************************/
