
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DIAGNOST.CPP   1.13   13 Dec 1996 11:18:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DIAGNOST.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:32   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:16   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:36   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:26   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:44   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:22   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:10   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:16   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.1   15 Aug 1996 10:07:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:00   ZJRD
** Initial revision.
** 
****************************************************************************/

// diagnost.cpp : implementation file
//
//john chow 96.3
#include "stdafx.h"
//#include "ep-sld.h"
#include "diagnost.h"
#include  "abitype.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern ADDR retAddr;

/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox dialog


CDiagnosticBox::CDiagnosticBox(CWnd* pParent /*=NULL*/)
    : CDialog(CDiagnosticBox::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDiagnosticBox)
    m_POIResult = "";
    m_MAPRAMResult = "";
    m_EVENTADDRResult = "";
    m_EVENTDATARAMResult = "";
    m_SPOONRAMResult = "";
    m_EMULATIONRAMResult = "";
    m_TRACERAMResult = "";
    m_BHasSaved = FALSE;
    //}}AFX_DATA_INIT
}

void CDiagnosticBox::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDiagnosticBox)
    DDX_Control(pDX, IDC_EMULATIONRAM, m_buttonEmulationRam);
    DDX_Control(pDX, IDC_CHECK_TRACERAM, m_buttonCheckTraceRam);
    DDX_Control(pDX, IDC_CHECK_SPOONRAM, m_buttonCheckSpoonRam);
    DDX_Control(pDX, IDC_CHECK_PIOCTC, m_buttonCheckPIOCTC);
    DDX_Control(pDX, IDC_CHECK_MAPRAM, m_buttonCheckMapRam);
    DDX_Control(pDX, IDC_CHECK_EVENTDATARAM, m_buttonCheckEventDataRam);
    DDX_Control(pDX, IDC_CHECK_EVENTADDRRAM, m_buttonCheckEventAddrRam);
    DDX_Control(pDX, IDOK, m_buttonDetail);
    DDX_Control(pDX, ID_BUTTON_DIAGNOSTIC, m_buttonDiagnostic);
    DDX_Control(pDX, IDC_CHECK_ALL, m_buttonCheckAll);
    DDX_Text(pDX, IDC_STATIC_PIO, m_POIResult);
    DDX_Text(pDX, IDC_STATIC_MAPRAM, m_MAPRAMResult);
    DDX_Text(pDX, IDC_STATIC_EVENTADDRRAM, m_EVENTADDRResult);
    DDX_Text(pDX, IDC_STATIC_EVENTDATARAM, m_EVENTDATARAMResult);
    DDX_Text(pDX, IDC_STATIC_SPOONRAM, m_SPOONRAMResult);
    DDX_Text(pDX, IDC_STATIC_EMULATIONRAM, m_EMULATIONRAMResult);
    DDX_Text(pDX, IDC_STATIC_TRACERAM, m_TRACERAMResult);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDiagnosticBox, CDialog)
    //{{AFX_MSG_MAP(CDiagnosticBox)
    ON_BN_CLICKED(ID_BUTTON_DIAGNOSTIC, OnButtonDiagnostic)
    ON_BN_CLICKED(IDC_CHECK_ALL, OnCheckAll)
    ON_BN_CLICKED(IDC_CHECK_PIOCTC, OnCheckPioctc)
    ON_BN_CLICKED(IDC_CHECK_EVENTADDRRAM, OnCheckEventaddrram)
    ON_BN_CLICKED(IDC_CHECK_EVENTDATARAM, OnCheckEventdataram)
    ON_BN_CLICKED(IDC_CHECK_MAPRAM, OnCheckMapram)
    ON_BN_CLICKED(IDC_CHECK_SPOONRAM, OnCheckSpoonram)
    ON_BN_CLICKED(IDC_CHECK_TRACERAM, OnCheckTraceram)
    ON_BN_CLICKED(IDC_EMULATIONRAM, OnEmulationram)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox message handlers

void CDiagnosticBox::OnButtonDiagnostic()
{
    // TODO: Add your control notification handler code here 
    UpdateData(TRUE);  
    m_POIResult = "";
    m_MAPRAMResult = "";
    m_EVENTADDRResult = "";
    m_EVENTDATARAMResult = "";
    m_SPOONRAMResult = "";
    m_EMULATIONRAMResult = "";
    m_TRACERAMResult = "";
    UpdateData(FALSE);   
    
    
}

void CDiagnosticBox::OnCheckAll()
{
    // TODO: Add your control notification handler code here
    if(m_buttonCheckAll.GetCheck()) {
        m_buttonCheckPIOCTC.EnableWindow(FALSE);
        m_buttonCheckMapRam.EnableWindow(FALSE);
        m_buttonCheckEventAddrRam.EnableWindow(FALSE);
        m_buttonCheckEventDataRam.EnableWindow(FALSE);
        m_buttonCheckSpoonRam.EnableWindow(FALSE);
        m_buttonEmulationRam.EnableWindow(FALSE);
        m_buttonCheckTraceRam.EnableWindow(FALSE);
    } else { 
        m_buttonCheckPIOCTC.EnableWindow(TRUE);
        m_buttonCheckMapRam.EnableWindow(TRUE);
        m_buttonCheckEventAddrRam.EnableWindow(TRUE);
        m_buttonCheckEventDataRam.EnableWindow(TRUE);
        m_buttonCheckSpoonRam.EnableWindow(TRUE);
        m_buttonEmulationRam.EnableWindow(TRUE);
        m_buttonCheckTraceRam.EnableWindow(TRUE);
    }                            
        
    DecideDiagnosticButtonStatus();
}

void CDiagnosticBox::OnCheckPioctc()
{
    // TODO: Add your control notification handler code here 
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckEventaddrram()
{
    // TODO: Add your control notification handler code here  
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckEventdataram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
                      
}

void CDiagnosticBox::OnCheckMapram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckSpoonram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckTraceram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnEmulationram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

BOOL CDiagnosticBox::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here   
    CenterWindow();
    m_buttonDetail.EnableWindow(FALSE);
    m_buttonDiagnostic.EnableWindow(FALSE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDiagnosticBox::DecideDiagnosticButtonStatus()
{      
      BOOL bResult = FALSE;
      if(m_buttonCheckAll.GetCheck()) bResult = TRUE;
      if(m_buttonCheckPIOCTC.GetCheck()) bResult = TRUE;
      if(m_buttonCheckMapRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckEventAddrRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckEventDataRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckSpoonRam.GetCheck()) bResult = TRUE;
      if(m_buttonEmulationRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckTraceRam.GetCheck()) bResult = TRUE;
      
      m_buttonDiagnostic.EnableWindow(bResult);
 }

void CDiagnosticBox::DecideDetailButtonStatus()
{ 
      BOOL bResult = FALSE; 
      if(m_MAPRAMResult == "FAIL") bResult = TRUE;
      if(m_EVENTADDRResult == "FAIL") bResult = TRUE;
      if(m_EVENTDATARAMResult == "FAIL") bResult = TRUE;
      if(m_SPOONRAMResult == "FAIL") bResult = TRUE;
      if(m_EMULATIONRAMResult == "FAIL") bResult = TRUE;
      if(m_TRACERAMResult == "FAIL") bResult = TRUE;
      if(m_POIResult == "FAIL") bResult = TRUE;
      
      m_buttonDetail.EnableWindow(bResult);
 } 
                                                  
//support for shell window's command
void DiagnosticCmd(int nArgc, char* pszArgv[])
{                            
    
    unsigned char cpOption[30],cpResult[30];	
    int iTmp,i;   
    BOOL isCanHWReset=TRUE;
    
    for(iTmp=0;iTmp<30;iTmp++) {
    	cpOption[iTmp] = 0;
    	cpResult[iTmp] = 0;
    }		
    
    for (i=1;i<nArgc;i++) {
        CString str = strupr(pszArgv[i]);
        if ( str == "EPROM") {
        	cpOption[0] = 1;
        }
        else if (str == "SRAM"){
        	cpOption[1] = 1;
        }
        else if (str == "IO"){ 
        	cpOption[2] = 1;
        }
        else if (str == "EMM"){
        	cpOption[3] = 1;
        }
        else if (str == "BPTM"){
        	cpOption[4] = 1;
		}
        else if (str == "EMP"){
        	cpOption[5] = 1;
        }
        else if (str == "STEP"){
        	cpOption[6] = 1;
        }
        else if (str == "SPOON"){ 
        	cpOption[7] = 1;
        }
        else if (str == "GO"){
        	cpOption[8] = 1;
        }
        else if (str == "HALT"){
        	cpOption[9] = 1;
		}
        else if (str == "BPT"){
        	cpOption[10] = 1;
        }
        else if (str == "E&T"){
        	cpOption[11] = 1;
        }
        else if (str == "TR"){
        	cpOption[12] = 1;
        }
        else if (str == "TC"){
        	cpOption[13] = 1;
        }          
        else {
            ASSERT(FALSE);
        }
    }                  
    
    for(iTmp=0;iTmp<14;iTmp++) cpOption[29]+=cpOption[iTmp];
    if(0 == cpOption[29]) {        
    	for(i=0;i<14;i++) cpOption[i] = 1;
    }
    
    unsigned char bResult; 
    
    AfxGetApp()->DoWaitCursor(1);
    
    char pChar[80];
    strcpy(pChar,"Please reset your EasyPack!");
        
    ADDR tmpAddr;
    tmpAddr.addrType = 0x10;  
    
    int tmp = AbiDiagnostic(cpOption,cpResult);
    
    if (tmp != ICE_OK) {
    	ShowLine("FW ERROR!");                
    	AfxGetApp()->DoWaitCursor(-1);             
    	return;
    }	         
    
    if(1 == cpResult[0]) ShowLine("EPROM ERROR!");
    if(1 == cpResult[1]) ShowLine("SRAM ERROR!");
    if(1 == cpResult[4]) ShowLine("I/O BUFFER ERROR!");
    if(1 == cpResult[5]) ShowLine("EMULATION MEMORY ERROR!");
    if(1 == cpResult[8]) ShowLine("BREAKPOINT MEMORY ERROR!");
    if(1 == cpResult[11]) ShowLine("EMULATION PROCESSOR ERROR!");
    if(1 == cpResult[12]) ShowLine("STEP ERROR!");
    if(1 == cpResult[13]) ShowLine("SPOON ERROR!");
    if(1 == cpResult[14]) ShowLine("GO ERROR!");
    if(1 == cpResult[15]) ShowLine("HALT ERROR!");
    if(1 == cpResult[16]) ShowLine("BREAKPOINT ERROR!");
    if(1 == cpResult[17]) ShowLine("EVENT & TRIGGER ERROR!");
    if(1 == cpResult[19]) ShowLine("TRACE RAM ERROR!");
    if(1 == cpResult[21]) ShowLine("TRACE CONTROL ERROR!");
    
    ShowLine("Test Ok!");
            
   AfxGetApp()->DoWaitCursor(-1);             
   if(isCanHWReset) AbiReset(tmpAddr);
                else ShowLine(pChar);         
 } 
 
