
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DIBAPI.H__   1.13   13 Dec 1996 11:18:20   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DIBAPI.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:20   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:20   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:38   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:32   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:04   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:30   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:04   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:44   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:12   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:18   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:42   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:42   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  DIBAPI.H
//
//  Description:The header file for the DIB APIs:
//
//      PaintDIB()          - Painting routine for a DIB
//      CreateDIBPalette()  - Creates a palette from a DIB
//      FindDIBBits()       - Returns a pointer to the DIB bits
//      DIBWidth()          - Gets the width of the DIB
//      DIBHeight()         - Gets the height of the DIB
//      PaletteSize()       - Gets the size required to store the DIB's palette
//      DIBNumColors()      - Calculates the number of colors
//                            in the DIB's color table
//      CopyHandle()        - Makes a copy of the given global memory block
//      SaveDIB()           - Saves the specified dib in a file
//      ReadDIBFile()       - Loads a DIB from a file
//
//  Author:     Roger Zhang
//
//  Date:       08/18/95
//
//  Modification:
//
//      1. 08/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////


#ifndef _DIBAPI_
#define _DIBAPI_

/* Handle to a DIB */
DECLARE_HANDLE(HDIB);

/* DIB constants */
#define PALVERSION   0x300

/* DIB Macros*/

#define IS_WIN30_DIB(lpbi)  ((*(LPDWORD)(lpbi)) == sizeof(BITMAPINFOHEADER))
#define RECTWIDTH(lpRect)     ((lpRect)->right - (lpRect)->left)
#define RECTHEIGHT(lpRect)    ((lpRect)->bottom - (lpRect)->top)

// WIDTHBYTES performs DWORD-aligning of DIB scanlines.  The "bits"
// parameter is the bit count for the scanline (biWidth * biBitCount),
// and this macro returns the number of DWORD-aligned bytes needed
// to hold those bits.

#define WIDTHBYTES(bits)    (((bits) + 31) / 32 * 4)

/* Function prototypes */
BOOL      WINAPI  PaintDIB (HDC, LPRECT, HDIB, LPRECT, CPalette* pPal);
BOOL      WINAPI  CreateDIBPalette(HDIB hDIB, CPalette* cPal);
LPSTR     WINAPI  FindDIBBits (LPSTR lpbi);
DWORD     WINAPI  DIBWidth (LPSTR lpDIB);
DWORD     WINAPI  DIBHeight (LPSTR lpDIB);
WORD      WINAPI  PaletteSize (LPSTR lpbi);
WORD      WINAPI  DIBNumColors (LPSTR lpbi);
HANDLE    WINAPI  CopyHandle (HANDLE h);

BOOL      WINAPI  SaveDIB (HDIB hDib, CFile& file);
HDIB      WINAPI  ReadDIBFile(CFile& file);

#endif 

///////////////////////////////(EOF)/////////////////////////////////////////

