
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DSMGTDLG.CPP   1.13   13 Dec 1996 11:18:20   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DSMGTDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:20   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:20   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:38   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:34   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:48   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:42   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:38   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:30   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:22   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:26   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:52   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:18   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  DSMGTDLG.CPP
//
//  Description:The implement file for the class: CDsmGtDlg
//
//  Author:     Lane Li &  Daniel Lin
//      3. 03/11/1996 1.0 version       Daniel Lin
//         Modify for all address input field must be processed by Address 
//         server
//
//      2. 10/25/95, 0.1d version       Daniel Lin
//              modified function   OnInitDialog()
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// dsmgtdlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "dsmgtdlg.h"
#include "errno.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

#include "address.h"
#include "addrapi.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDsmGtDlg dialog


CDsmGtDlg::CDsmGtDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CDsmGtDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CDsmGtDlg)
      // NOTE: the ClassWizard will add member initialization here
   //}}AFX_DATA_INIT
}

void CDsmGtDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CDsmGtDlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDsmGtDlg, CDialog)
   //{{AFX_MSG_MAP(CDsmGtDlg)
        ON_BN_CLICKED(IDC_DSM_GOTO_BUTTON1, OnDsmGotoButton1)
        ON_BN_CLICKED(IDC_DSM_GOTO_BUTTON2, OnDsmGotoButton2)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDsmGtDlg message handlers
BOOL CDsmGtDlg::OnInitDialog()
{   
   //CPUMEMORYRANGE stRange;
   char text[20];
    
   CDialog::OnInitDialog();
   
   // TODO: Add extra initialization here
   m_nSpace = 1;
   
   switch (m_nSpace) {
      case 1:
           CheckRadioButton(IDC_DSM_GOTO_RADIO1,
                            IDC_DSM_GOTO_RADIO2,
                            IDC_DSM_GOTO_RADIO1);
           break;
           
      case 2:
           CheckRadioButton(IDC_DSM_GOTO_RADIO1,
                            IDC_DSM_GOTO_RADIO2,
                            IDC_DSM_GOTO_RADIO2);
           break;
           
      default:
           break;
   }
   sprintf(text,"0x%lX",m_lAddress);
   SetDlgItemText(IDC_DSM_GOTO_EDIT1,text);
   CWnd* ctrl;
   ctrl=GetDlgItem(IDC_DSM_GOTO_EDIT1);
   ((CEdit *)ctrl)->SetFocus();
   ((CEdit *)ctrl)->SetSel(0,-1);
   if (dwpMax == 0 && dwpMin == 0) {
       GetDlgItem(IDC_DSM_GOTO_RADIO1)->EnableWindow(FALSE);
   }
   if (dwxMax == 0 && dwxMin == 0) {
       GetDlgItem(IDC_DSM_GOTO_RADIO2)->EnableWindow(FALSE);     
   }

   return FALSE;  // return TRUE  unless you set the focus to a control
}

void CDsmGtDlg::OnDsmGotoButton1()
{
   // TODO: Add your control notification handler code here
   char *buf;
   char *adrerror;
   int i;              
   char value[10];
   
   // Add by Daniel Lin on 03/11/1996
   // For Address server      
   //
   CString       text;
   ADDRESS       startAddress;
   ADDR_RETCODE  retCode;
   CString       error;                    
   CWnd          *ctrl;
            
   buf = new char[25];
   ASSERT(NULL != buf);   
   adrerror = new char[60];
   ASSERT(NULL != adrerror);
   memset(adrerror, 0, sizeof(adrerror));
   memset(buf, 0, sizeof(buf));   
   strcpy(adrerror, "Input Error! The value range is ");
   i = GetCheckedRadioButton(IDC_DSM_GOTO_RADIO1,
                             IDC_DSM_GOTO_RADIO2);
   switch (i) {
      case IDC_DSM_GOTO_RADIO1:
           m_nSpace = 1;
           break;
           
      case IDC_DSM_GOTO_RADIO2:
           m_nSpace = 2;
           break;
           
     default:
           break;
   }
   
   GetDlgItemText(IDC_DSM_GOTO_EDIT1, buf, 10);
   text = buf;
   retCode = AdrTextToAddr(text, startAddress);
   if (ADR_OK != retCode) {
     MessageBeep(-1);
     AdrErrorDeal(retCode, error);      
     MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
     ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
     ((CEdit *)ctrl)->SetFocus();
     ((CEdit *)ctrl)->SetSel(0, -1);
         
     return;
   }
   
   switch( m_nSpace ) {
       case 1:
            itoa( (int)dwpMin, value, 16 );
            strcat( adrerror, "0x" );
            strcat( adrerror, value );
            strcat( adrerror, "..0x" );
            itoa( (int)dwpMax, value, 16 );
            strcat( adrerror, value );
            startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                  
            if (!AdrCheckAddrRange(startAddress)) {
                MessageBeep(-1);
                MessageBox(adrerror, "Input Error", 
                           MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0, -1);
                      
                return;
            }
            
            break;
                  
       case 2:
            itoa( (int)dwxMin, value, 16 );
            strcat( adrerror, "0x" );
            strcat( adrerror, value );
            strcat( adrerror, "..0x" );
            itoa( (int)dwxMax, value, 16 );
            strcat( adrerror, value );
            startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                                    
            if (!AdrCheckAddrRange(startAddress)) {
                MessageBeep(-1);
                MessageBox(adrerror, "Input Error", 
                           MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0, -1);
                      
                return;
            }
            
            break;
   }
   
   m_lAddress = startAddress.adrAddress;

   if (NULL != buf) delete []buf;
   if (NULL != adrerror) delete []adrerror;
   
   EndDialog(1);
}

void CDsmGtDlg::OnDsmGotoButton2()
{
   // TODO: Add your control notification handler code here
   EndDialog(0);
}
