
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUHALT.CPP   1.13   13 Dec 1996 11:18:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUHALT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:22   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.12   22 Nov 1996 10:59:22   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:40   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:36   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:14   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:50:36   ZJRD
** PIC/SLD Version 0.93
** 
**    Rev 1.7   28 Oct 1996 09:43:26   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:38   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:04   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:42   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:58   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUHALT.CPP
//
//  Description: The implementation file for the class: CEmulationHalt.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationHalt.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "basictyp.h"
#include "emuhalt.h"
#include "cpust.h"           
#include "hosterrs.h"
#include "errcodec.h"
#include "mainfrm.h"
#include "trigsvr.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
extern void ErrShow(U32 errorCode,BOOL bUI);//JOHN 96.3
void HaltCmd(int nArgc, char* pszArgv[]);
void EmuServerHalt(void);

/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiAbort();
#endif  // _SERVER_NO_ABI


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HaltCmd().
//
//  Description: The main control routine of Halt command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void HaltCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->HaltAction(nArgc, pszArgv);
        delete pEmulationHalt;
    }
    
//    CEmulationHalt objHalt;
//    objHalt.HaltAction(nArgc, pszArgv);

}   // End of HaltCmd().


// Halt server routine for Source window.
void EmuServerHalt(void)
{
    // Assertion of the input parameters.
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
    	::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->EmuServerHalt();
        delete pEmulationHalt;
    }
    
}   // End of HaltCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationHalt.

// Construction.
CEmulationHalt::CEmulationHalt()
{

}   // End of CEmulationHalt::CEmulationHalt().


// Destruction.
CEmulationHalt::~CEmulationHalt()
{

}   // End of CEmulationHalt::~CEmulationHalt().


// Emulation Halt command.
void CEmulationHalt::HaltAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Call the Halt kernel.
    HaltKernel();

}   // End of CEmulationHalt::HaltAction().

                               
// Halt kernel routine.
void CEmulationHalt::HaltKernel(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI function.
    m_nErrorID = AbiAbort();  
    
// Added by Gates Hua
    UINT uCpuStatus;             
    if (ICE_OK == AbiGetCpuStatus(&uCpuStatus)) {
	    if (  0x70 == (uCpuStatus & 0x0F0) ) {
	        GetXviewAppJohn()->m_nCpuStatus = STATUS_SLEEPING;
			// Add elapse timer.
			((CMainFrame*)((CXviewApp*)AfxGetApp())->m_pMainWnd)->ShowElapseTimer();
	        TraceWnd(TRUE, 0);     //TRACE OFF
	        return;
		}    	
	    else GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;
	}
	else     
	    GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;

//    GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;

	// Add elapse timer.
	((CMainFrame*)((CXviewApp*)AfxGetApp())->m_pMainWnd)->ShowElapseTimer();
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
    else { 
        if ( !m_isServer ) ::ErrShow(ER_EMU_TARGET_CPU_HALT,FALSE);
        GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;
        TraceWnd(TRUE, 0);     //TRACE OFF
    }

}   // End of CEmulationHalt::HaltKernel().


// Halt server.
void CEmulationHalt::EmuServerHalt(void)
{
    // Assertion of the input parameters.

    // Call the Halt kernel.
    m_isServer = TRUE;
    HaltKernel();

}   // End of CEmulationHalt::EmuServerHalt().

//halt for go fly and go
BOOL CEmulationHalt::GoFlyHalt(void)
{ 
    if(GetXviewAppJohn()->m_nCpuStatus != STATUS_GO &&
       GetXviewAppJohn()->m_nCpuStatus != STATUS_GORUN)  return FALSE;
       
    m_nErrorID = AbiAbort();
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();   
        return FALSE;
    }
    else {                  
        //GetXviewAppJohn()->m_nCpuStatusBak =  GetXviewAppJohn()->m_nCpuStatus;
         GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;   
         
		// Add elapse timer.
		((CMainFrame*)((CXviewApp*)AfxGetApp())->m_pMainWnd)->ShowElapseTimer();

        return TRUE;
    }  
    
    return TRUE;   
 }

//added by john 96.3
/**************************************************************************
**
** Name : CpuHalt()
**
** Function  support go fly function
**
**    Input  : 
**
**    return : TRUE ==> OK
**             FALSE ==> FAIL
** Notes:
**
**************************************************************************/
BOOL CpuHalt()
{      
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return FALSE;
    }
    else {
        BOOL bResult = pEmulationHalt->GoFlyHalt();
        delete pEmulationHalt;
        return bResult;
    }                  
    return TRUE;
    
 }

/**************************************************************************
**
** Name : void ErrShow(U32 errorCode,BOOL bUI);
**
** Function  show error  information
**
**    Input  : errorCode, bUI-->call showLine() or AfxMessageBox();
**
** Notes:
**
**************************************************************************/
void ErrShow(U32 errorCode,BOOL bUI)
{               
 CString errStr = "";
 if(0 == ErrGetErrorText(errorCode,errStr)) {
     if(bUI) AfxMessageBox(errStr); 
     else {
         ShowLine(errStr.GetBuffer(errStr.GetLength()+2));
         errStr.ReleaseBuffer();
     }  
 return;    
 }
#ifdef _DEBUG 
 AfxMessageBox("???");    
#endif 
 return;    
 }

//////////////////////////////// End of File ////////////////////////////////
