
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUSTEP.CPP   1.13   13 Dec 1996 11:18:24   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUSTEP.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:24   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:24   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:36   ZJRD
** PIC/SLD Version 0.95
** 
**    Rev 1.9   02 Nov 1996 09:46:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:20   ZJRD
** PIC/SLD Version 0.93
** 
**    Rev 1.7   28 Oct 1996 09:41:18   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:38   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:45:14   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:31:26   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:18   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:54   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUSTEP.CPP
//
//  Description: The implementation file for the class: CEmulationStep.
//
//  Author: Chen Jun
//
//  Date: 05/06/95
//
//  Modification:
//      1. 05/06/95, Initial version of the class: CEmulationStep.
//      2. 05/10/95, Initial version of the command: STEPOption.
//      3. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "cpucom.h"
#include "uicom.h"
                     
#include "basictyp.h"                     
#include "emustep.h"                           
#include "cpust.h"
#include "errcodec.h"
#include "DADPUB.h"
#include "mainfrm.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
// int nStepOption;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void StepCmd(int nArgc, char* pszArgv[]);
void StepoptionCmd(int nArgc, char* pszArgv);
void EmuServerStep(long lCount);
void EmuServerStepOver(long lCount);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//unsigned char TRCGetInstLen(WORD code);
//int TRCGetInst(WORD BRIGHTAddr, WORD *BRIGHTCode,
//               WORD len, WORD *BRIGHTResult);

#ifndef _SERVER_NO_ABI
    STATUS AbiGetOneReg(WORD iRegId, WORD* uRegValue);
//    STATUS AbiSetReg(int iRegId, UINT uRegValue);
    STATUS AbiSetReg(WORD iRegId, WORD uRegValue);
    STATUS AbiStepOne();
    STATUS AbiStepOver();
    STATUS AbiStepRange(ADDR stAddr, ADDR endAddr);
    STATUS AbiStepOverRange(ADDR stAddr, ADDR endAddr);
    STATUS AbiGetMemN(ADDR addr1, ADDR addr2, WORD* pchBuff);
#endif  // _SERVER_NO_ABI
                      
extern void ErrShow(U32 errorCode,BOOL bUI);                      
extern STATUS EmuSetTempBp(unsigned short uAddr);
extern STATUS EmuClrTempBp();

extern "C" {
    extern void GetLineRange(unsigned short uAddr, 
        unsigned short& uStart, unsigned short& uEnd);
    extern void GetStatementRange(unsigned short uAddr, 
        unsigned short& uStart, unsigned short& uEnd);
    extern BOOL IsLibFunction(unsigned short uAddr);
}
extern int GetLibRange(unsigned short uAddr, 
    unsigned short& uStart, unsigned short& uEnd);

void SetStepOption(int nStepOption);
int GetStepOption(void);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   StepCmd().
//
//  Description: The main control routine of Step command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void StepCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 1 && nArgc <= 6 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Step command.
    CEmulationStep* pEmulationStep = new CEmulationStep;
    if ( !pEmulationStep ) {                
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationStep->StepAction(nArgc, pszArgv);
        delete pEmulationStep;
    }

//    CEmulationStep objStep;
//    objStep.StepAction(nArgc, pszArgv);

}   // End of StepCmd().


// Step [count] server for the Source window.
void EmuServerStep(long lCount)
{
    // Assertion of the input parameters.
    ASSERT( lCount >= -4 && lCount <= 0xFFFF );
    // lCount:   1 <= lCount <= 0xFFFF - Count
    //           0 - Continuously
    //          -1 - Till Call
    //          -2 - Till Ret
    //          -3 - Into Call
    //          -4 - Over Ret

    // Step server.
    CEmulationStep* pEmulationStep = new CEmulationStep;
    if ( !pEmulationStep ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationStep->EmuServerStep(lCount);
        delete pEmulationStep;
    }

}   // End of EmuServerStep().


// Step Over [count] server for the Source window.
void EmuServerStepOver(long lCount)
{
    // Assertion of the input parameters.
    ASSERT( lCount >= -4 && lCount <= 0xFFFF );
    // lCount:   1 <= lCount <= 0xFFFF - Count
    //           0 - Continuously
    //          -1 - Till Call
    //          -2 - Till Ret
    //          -3 - Into Call
    //          -4 - Over Ret

    // Step Over server.
    CEmulationStep* pEmulationStep = new CEmulationStep;
    if ( !pEmulationStep ) {                   
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationStep->EmuServerStepOver(lCount);
        delete pEmulationStep;
    }

}   // End of EmuServerStepOver().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   StepoptionCmd().
//
//  Description: The main control routine of Stepoption command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void StepoptionCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 1 && nArgc <= 2 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Stepoption command.
    CEmulationStep* pEmulationStepOption = new CEmulationStep;
    if ( !pEmulationStepOption ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationStepOption->StepOptionAction(nArgc, pszArgv);
        delete pEmulationStepOption;
    }

//    CEmulationStep objStep;
//    objStep.StepOptionAction(nArgc, pszArgv);

}   // End of StepoptionCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationStep.

// Construction.
CEmulationStep::CEmulationStep()
{
    // Assertion of the input parameters.
    
    // Initial.
    m_isStepOver = FALSE;
    m_isStepForever = FALSE;
    m_isStepCount = FALSE;
    m_isTillCall = FALSE;
    m_isTillRet = FALSE;
    m_isAddr = FALSE;
    m_isRegMatch = FALSE;
    m_isMemMatch = FALSE;
    m_isIntoCall = FALSE;
    m_isOverRet = FALSE;

    m_uStepCount = 0;

//    ASSERT( ::nStepOption >= 0 && ::nStepOption <= 2 );
//    m_nStepOption = ::nStepOption;
    m_nStepOption = ::GetStepOption();
    ASSERT( m_nStepOption >= INSTRUCTION && m_nStepOption <= LINE );
    
}   // End of CEmulationStep::CEmulationStep().


// Destruction.
CEmulationStep::~CEmulationStep()
{
    // Assertion of the input parameters.
    
}   // End of CEmulationStep::~CEmulationStep().


// Emulation STEPOption command.
void CEmulationStep::StepOptionAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 1:
            break;
        case 2:
            if ( 0 == stricmp(pszArgv[1], "INSTRUCTION") ) {
                m_nStepOption = INSTRUCTION;
            }
            else if ( 0 == stricmp(pszArgv[1], "STATEMENT") ) {
                m_nStepOption = STATEMENT;
            }
            else if ( 0 == stricmp(pszArgv[1], "LINE") ) {
                m_nStepOption = LINE;
            }
            else {
                ASSERT( FALSE );
            }
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the STEPOption kernel.
    StepOptionKernel();

}   // End of CEmulationStep::StepOptionAction().


// Stepoption kernel routine.
void CEmulationStep::StepOptionKernel(void)
{
    // Assertion of the input parameters.
    //john 96.3
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO ) {
        if ( !m_isServer ) ::ErrShow(ER_GOFLY_ERR_MSG,FALSE);
            else ::ErrShow(ER_GOFLY_ERR_MSG,TRUE);
        return;                    
    }
    
    // Set the global variable.
//    ::nStepOption = m_nStepOption;
    ::SetStepOption(m_nStepOption);
    
    // Set the global variable.
    m_nStepOption = ::GetStepOption();
    ASSERT( m_nStepOption >= INSTRUCTION && m_nStepOption <= LINE );

    // Display the current Step Option.
    char* pszOption[] = {
        "INSTRUCTION",
        "STATEMENT",
        "LINE"
    };
    wsprintf(m_pszResult, "Step option is: %s.", pszOption[m_nStepOption]);
    ShowLine(m_pszResult);
    
}   // End of CEmulationStep::StepOptionKernel().



// Emulation Step command.
void CEmulationStep::StepAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 1 && nArgc <= 6 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 1:
            // Step
            m_isStepCount = TRUE;
            m_uInputCount = 1;
            break;
        case 2:
            if ( 0 == stricmp(pszArgv[1], "OVER") ) {
                // Step Over
                m_isStepOver = TRUE;
                m_isStepCount = TRUE;
                m_uInputCount = 1;
            }
            else if ( 0 == stricmp(pszArgv[1], "FOREVER") ) {
                // Step Forever
                m_isStepForever = TRUE;
            }
            else {
                // Step count
                m_isStepCount = TRUE;
                StrToVar(pszArgv[1]);
                m_uInputCount = (unsigned short)m_ulVar;
            }
            break;
        case 3:
            if ( 0 == stricmp(pszArgv[1], "OVER") ) {
                m_isStepOver = TRUE;
                if ( 0 == stricmp(pszArgv[2], "FOREVER") ) {
                    // Step Over Forever
                    m_isStepForever = TRUE;
                }
                else {
                    // Step Over count
                    m_isStepCount = TRUE;
                    StrToVar(pszArgv[2]);
                    m_uInputCount = (unsigned short)m_ulVar;
                }
            }
            else if ( 0 == stricmp(pszArgv[1], "TILL") ) {
                if ( 0 == stricmp(pszArgv[2], "RET") ) {
                    // Step Till Ret
                    m_isTillRet = TRUE;
                }
                else {
                    // Step Till Call
                    m_isTillCall = TRUE;
                }
            }
            else {
                // Step adr1 adr2
                m_isAddr = TRUE;
                SetAddrVar(pszArgv[1], m_FromAddr);
                SetAddrVar(pszArgv[2], m_TillAddr);
            }
            break;
        case 4:
            m_isStepOver = TRUE;
            if ( 0 == stricmp(pszArgv[2], "TILL") ) {
                if ( 0 == stricmp(pszArgv[3], "RET") ) {
                    // Step Over Till Ret
                    m_isTillRet = TRUE;
                }
                else {
                    // Step Over Till Call
                    m_isTillCall = TRUE;
                }
            }
            else {
                // Step Over adr1 adr2
                m_isAddr = TRUE;
                SetAddrVar(pszArgv[2], m_FromAddr);
                SetAddrVar(pszArgv[3], m_TillAddr);
            }
            break;
        case 5:
            if ( '@' == pszArgv[2][0] ) {
                // Step Till @reg = value
                m_isRegMatch = TRUE;
                for ( int i = 0; i < ::nMaxReg; i++ ) {
                    if ( 0 == stricmp(pszArgv[2]+1, ::RegName[i]) ) {
                        m_nRegID = i;
                        break;
                    }
                }
                ASSERT( m_nRegID >= 0 && m_nRegID < nMaxReg );
                StrToVar(pszArgv[4]);
                m_uRegData = (unsigned int)m_ulVar;
            }
            else {
                // Step Till adr = value
                m_isMemMatch = TRUE;
                SetAddrVar(pszArgv[2], m_MatchAddr);
                StrToVar(pszArgv[4]);
                m_uchMemData = (unsigned char)m_ulVar;
            }
            break;
        case 6:
            m_isStepOver = TRUE;
            if ( '@' == pszArgv[3][0] ) {
                // Step Over Till @reg = value
                m_isRegMatch = TRUE;
                for ( int i = 0; i < ::nMaxReg; i++ ) {
                    if ( 0 == stricmp(pszArgv[3]+1, ::RegName[i]) ) {
                        m_nRegID = i;
                        break;
                    }
                }
                ASSERT( m_nRegID >= 0 && m_nRegID < nMaxReg );
                StrToVar(pszArgv[5]);
                m_uRegData = (unsigned int)m_ulVar;
            }
            else {
                // Step Over Till adr = value
                m_isMemMatch = TRUE;
                SetAddrVar(pszArgv[3], m_MatchAddr);
                StrToVar(pszArgv[5]);
                m_uchMemData = (unsigned char)m_ulVar;
            }
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
// Added by Gates Hua
	AfxGetApp()->BeginWaitCursor();

    // Call the Step kernel.
    if ( m_isStepCount ) {
        StepKernel();
    }
    else {
        StepKernel();
    }

// Added by Gates Hua
	AfxGetApp()->EndWaitCursor();

}   // End of CEmulationStep::StepAction().


// Step kernel routine.
// AbiStepOne() & AbiStepOver().
extern STATUS AbiGetCpuStatus(UINT *uCpuStatus);
void CEmulationStep::StepKernel(void)
{
    // Assertion of the input parameters.
    
    //john 96.3
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO ) {
        if ( !m_isServer ) ::ErrShow(ER_GOFLY_ERR_MSG,FALSE);
            else ::ErrShow(ER_GOFLY_ERR_MSG,TRUE);
        return;                    
    }                          
// Added by Gates Hua
    else if(GetXviewAppJohn()->m_nCpuStatus == STATUS_SLEEPING ) {
        if ( !m_isServer ) ::ErrShow(ER_ICE_OK+0x20,FALSE);
            else ::ErrShow(ER_ICE_OK+0x20,TRUE);
        return;                    
    }                          

    // Get the source line range.   
    m_nStepOption = ::GetStepOption();
    unsigned short uStart, uEnd;
    if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
        GetStepRange(uStart, uEnd);
        if ( ICE_OK != m_nErrorID ) {
            return;
        }
    }

    // The Step loop.
    BOOL isStepAgain = FALSE;
    UINT uCpuStatus;             

    do {
        // High level Step range detection.
    
        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) 
            return;
// Modified by Gates Hua
//        if (uCpuStatus&0x70==0x70)
        if ((uCpuStatus&0x70)==0x70)
            break;

        if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
            if ( !m_isStepOver ) {
                // Step.
                if ( StepMatchCall() ) {
                    // Is match CALL?
                    if ( IsLibFunction(m_TestAddr.m_uAddr) ) {
                        // Frank support to fix EP-RUNNING.
//  Modified by Gates Hua
//                        ::EmuSetTempBp(m_uBpAddr);

                        // Skip the library function calling.
                        m_nErrorID = AbiStepOver();
		                while( TRUE ) {
					        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) 
					            return;
					        if ((uCpuStatus&0x70)!=0x40)
					            break;              
						    if ( TestKey(VK_ESCAPE) == 1 ) { 
						       return;
						    }                  
		                }
                        
                        // Frank support to fix EP-RUNNING.
//                        ::EmuClrTempBp();
                    }
                    else {
                        m_nErrorID = AbiStepOne();
                    }
                }
                else {
                    m_nErrorID = AbiStepOne();
                }
            }
            else {
                // Frank support to fix EP-RUNNING.
//   Modified by Gates Hua.                
//                ::EmuSetTempBp(m_uBpAddr);

                // Step Over.
                m_nErrorID = AbiStepOver();

                while( TRUE ) {
			        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) 
			            return;
			        if ((uCpuStatus&0x70)!=0x40)
			            break;              
				    if ( TestKey(VK_ESCAPE) == 1 ) { 
				       return;
				    }                  
                }

                // Frank support to fix EP-RUNNING.
//                ::EmuClrTempBp();
            }
        }
        else {
            // Low level Step instruction.
            if ( !m_isStepOver ) {
                m_nErrorID = AbiStepOne();
            }
            else {               
                m_nErrorID = AbiStepOver();
// Modified by Gates Hua                
                while( TRUE ) {
			        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) 
			            return;
			        if ((uCpuStatus&0x70)!=0x40)
			            break;              
				    if ( TestKey(VK_ESCAPE) == 1 ) { 
				       return;
				    }                  
                }
            }
            // Mixed or Assemble mode.
            m_uStepCount++;
        }

        // Detect ABI error.
        if ( ICE_OK != m_nErrorID ) {             
            DisplayErrorMessage();
            return;
        }

        // ESC to cancel Step process.
        if ( EscapeAbort() ) {
            return;
        }
        
        // Step again?
        if ( m_isStepForever ) {
            // Step [Over] Forever.
            if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
                // Get the current PC.
                WORD uPC;
                m_nErrorID = AbiGetOneReg(0, &uPC);
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    return;
                }
                if ( uPC < uStart || uPC > uEnd ) {
                    // Update windows.
                    UpdateAllWindows();
                    // Get step range.
                    GetStepRange(uStart, uEnd);
                    if ( ICE_OK != m_nErrorID ) {
                        return;
                    }
                }
            }
            else {
                // Update windows: Low level.
                UpdateAllWindows();
            }
            isStepAgain = TRUE;
        }
        else if ( m_isStepCount ) {
            // Step [Over] count.
            if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
                // Get the current PC.
                WORD uPC;
                m_nErrorID = AbiGetOneReg(0, &uPC);
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    return;
                }
                if ( uPC < uStart || uPC > uEnd ) {
                    m_uStepCount++;
                    // Get step range.
                    GetStepRange(uStart, uEnd);
                    if ( ICE_OK != m_nErrorID ) {
                        return;
                    }
                }
            }
            isStepAgain = StepMatchCount() ? FALSE : TRUE;
        }
        else if ( m_isTillCall ) {
            // Step [Over] Till Call.
            if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
                if ( StepMatchCall() && 
                     !IsLibFunction(m_TestAddr.m_uAddr) ) {
                    isStepAgain = FALSE;
                }
                else {
                    isStepAgain = TRUE;
                }
            }
            else {
                isStepAgain = StepMatchCall() ? FALSE : TRUE;
            }
        }
        else if ( m_isTillRet ) {
            // Step [Over] Till Ret.
            isStepAgain = StepMatchRet() ? FALSE : TRUE;
        }
        else if ( m_isAddr ) {
            if ( !isStepAgain ) {
                m_nErrorID = AbiSetReg(0, m_FromAddr.m_uAddr);    // Set PC.
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    return;
                }
            }
            isStepAgain = StepMatchAddr() ? FALSE : TRUE;
        }
        else if ( m_isRegMatch ) {
            isStepAgain = StepMatchReg() ? FALSE : TRUE;
        }
        else if ( m_isMemMatch ) {
            isStepAgain = StepMatchMem() ? FALSE : TRUE;
        }
        else if ( m_isIntoCall ) {
            // Go Into Call (only for Server).
            if ( StepMatchCall() ) {
                if ( (LINE == m_nStepOption || STATEMENT == m_nStepOption) && !IsLibFunction(m_TestAddr.m_uAddr) ) {
                    m_isStepOver = FALSE;
                    m_isIntoCall = FALSE;
                }
                else if ( LINE != m_nStepOption && STATEMENT != m_nStepOption ) {
                    m_isStepOver = FALSE;
                    m_isIntoCall = FALSE;
                }
            }
            isStepAgain = TRUE;
        }
        else if ( m_isOverRet ) {
            // Go Over Ret (only for Server).
            if ( StepMatchRet() ) {
                m_isOverRet = FALSE;
            }
            isStepAgain = TRUE;
        }
        else {
            isStepAgain = FALSE;
        }

    } while ( isStepAgain );
    
    // Display the step count.
    DisplayStepCount();        
	((CMainFrame*)((CXviewApp*)AfxGetApp())->m_pMainWnd)->UpdateCpuStatus();
    
    
}   // End of CEmulationStep::StepKernel().


// Step kernel routine.
// AbiStepOne(), AbiStepOver(), AbiStepRange() & AbiStepOverRange().
void CEmulationStep::StepRangeKernel(void)
{
    // Assertion of the input parameters.
    
    // The Step loop.
    BOOL isStepAgain = FALSE;
    WORD uStart, uEnd;
    WORD uPC;
    
    //john 96.4
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO ) {
        if ( !m_isServer ) ::ErrShow(ER_GOFLY_ERR_MSG,FALSE);
            else ::ErrShow(ER_GOFLY_ERR_MSG,TRUE);
        return;                    
    }
    
    do {
        // Get the step option.
        m_nStepOption = ::GetStepOption();

        // High level Step range detection.
        if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {

            // Get the source line range.
            GetStepRange(uStart, uEnd);
            if ( ICE_OK != m_nErrorID ) {
                return;
            }

            // Set the Step range.
            m_FromAddr = CMemoryAddr(uStart, MEM_PROGRAM);
            m_TillAddr = CMemoryAddr(uEnd, MEM_PROGRAM);

            // Call Abi routine.
            if ( !m_isStepOver ) {
                // Step range.
                m_nErrorID = 
                    AbiStepRange((ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
            }
            else {
                // Step Over range.
                m_nErrorID = 
                    AbiStepOverRange((ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
            }
                
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
        
            // ESC to cancel Step process.
            if ( EscapeAbort() ) {
                return;
            }

            // Get the current PC.
            m_nErrorID = AbiGetOneReg(0, &uPC);
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }

            // Detect PC is already in the range of the lib function.
            // Step range version.
            while ( IsLibFunction((unsigned short)uPC) ) {
                // Get the step range.
                unsigned short uStart, uEnd;
                if ( 0 == GetLibRange((unsigned short)uPC, uStart, uEnd) ) {
                    ASSERT( uStart <= uEnd );
                    if ( uStart > uEnd ) {
                        AfxMessageBox("Load format error.");
                        m_nStepOption = INSTRUCTION;
                        ::SetStepOption(m_nStepOption);
                        break;
                    }
                }
                else {
                    m_nStepOption = INSTRUCTION;
                    ::SetStepOption(m_nStepOption);
                    break;
                }

                // Set the Step range.
                m_FromAddr = CMemoryAddr(uStart, MEM_PROGRAM);
                m_TillAddr = CMemoryAddr(uEnd, MEM_PROGRAM);

                // Step [Over] range.
                m_nErrorID = 
                    AbiStepRange((ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    return;
                }

                // ESC to cancel Step process.
                if ( EscapeAbort() ) {
                    return;
                }

                // Get the current PC.
                m_nErrorID = AbiGetOneReg(0, &uPC);
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    return;
                }
            }
        }
        else {
            // Low level Step instruction.
            if ( !m_isStepOver ) {
                m_nErrorID = AbiStepOne();
            }
            else {
                m_nErrorID = AbiStepOver();
// Modified by Gates Hua                
			    UINT uCpuStatus;             
                while( TRUE ) {
			        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) 
			            return;
			        if ((uCpuStatus&0x70)!=0x40)
			            break;              
				    if ( TestKey(VK_ESCAPE) == 1 ) { 
				       return;
				    }                  
                }
            }
            // Detect ABI error.
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
            // Mixed or Assemble mode.
            m_uStepCount++;
        }
        
        // ESC to cancel Step process.
        if ( EscapeAbort() ) {
            return;
        }
        
        // Step again?
        if ( m_isStepCount ) {
            // Step [Over] count.
            if ( LINE == m_nStepOption || STATEMENT == m_nStepOption ) {
                if ( uPC < uStart || uPC > uEnd ) {
                    m_uStepCount++;
                }
            }
            isStepAgain = StepMatchCount() ? FALSE : TRUE;
        }
        else {
            isStepAgain = FALSE;
        }

    } while ( isStepAgain );
    
    // Display the step count.
    DisplayStepCount();
    
}   // End of CEmulationStep::StepRangeKernel().


// Get step range based on the source level.
void CEmulationStep::GetStepRange(unsigned short& uStart,
                                  unsigned short& uEnd)
{
    // Assertion of the input parameters.
    ASSERT( ICE_OK == m_nErrorID );
    ASSERT( LINE == m_nStepOption || STATEMENT == m_nStepOption );
    
    // Get the current PC.
    WORD uPC;
    m_nErrorID = AbiGetOneReg(0, &uPC);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }

    // Get the step range.
    if ( LINE == m_nStepOption ) {
        GetLineRange((unsigned short)uPC, uStart, uEnd);
    }
    else {
        GetStatementRange((unsigned short)uPC, uStart, uEnd);
    }
    ASSERT( uStart <= uEnd );
    if ( uStart > uEnd ) {
        ::ErrShow(ER_EMU_LOAD_FORMAT_ERROR,TRUE);
        m_nStepOption = INSTRUCTION;
        ::SetStepOption(m_nStepOption);
    }

    
    // Frank told me to add this function to fix EP_RUNNING.
    m_uBpAddr = uEnd+1;

}   // End of CEmulationStep::GetStepRange().


// Display the step count.
void CEmulationStep::DisplayStepCount(void)
{
    // Assertion of the input parameters.

    // Get the current PC.
    WORD uRegValue;
    m_nErrorID = AbiGetOneReg(0, &uRegValue);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
    
    // Get one byte from PC.
    CMemoryAddr StartAddr((unsigned short) uRegValue, MEM_PROGRAM);
    CMemoryAddr EndAddr = StartAddr;
    
    WORD pchData[8];
    m_nErrorID = AbiGetMemN((ADDR&)StartAddr, (ADDR&)EndAddr, pchData);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
    
    // Get the instruction length.
//    unsigned char uchInsLen = TRCGetInstLen((unsigned char)pchData[0]);
//    ASSERT( uchInsLen >= 1 && uchInsLen <= 3 );
    
    // Get the specific length data from PC.
/*    
    unsigned char uchInsLen;
    EndAddr = StartAddr + (unsigned short)uchInsLen;
    m_nErrorID = AbiGetMemN((ADDR&)StartAddr, (ADDR&)EndAddr, pchData);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
*/    
    // Get the Object code and Instruction.
/*
    char pszTemp[255];       
    
    if ( 0 == TRCGetInst((WORD)uRegValue, (WORD*)pchData, 
                         uchInsLen, (WORD*)pszTemp) ) {
        if ( strlen(pszTemp) > 200 ) {
            ASSERT( FALSE );
            return;
        }
        sprintf(m_pszResult, "P:%04X    %s", uRegValue, pszTemp);
        ShowLine(m_pszResult);
    }
    else {
        sprintf(m_pszResult, "Step completed.");
        ShowLine(m_pszResult);
    }
*/
}   // End of CEmulationStep::DisplayStepCount().


// If match the count?
BOOL CEmulationStep::StepMatchCount(void)
{
    // Assertion of the input parameters.
    
    // Attain the count.
    return (m_uStepCount == m_uInputCount) ? TRUE : FALSE;

}   // End of CEmulationStep::StepMatchCount().


// If match the CALL?
BOOL CEmulationStep::StepMatchCall(void)
{
    // Assertion of the input parameters.

    // Get current PC.
    WORD uRegValue;
    m_nErrorID = AbiGetOneReg(0, &uRegValue);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }

    // Get the special address memory.
    WORD pchData[4];
    m_TestAddr.m_uAddr = (unsigned short)uRegValue;
    m_TestAddr.m_uchType = MEM_PROGRAM;                               
//  Modified by Gates Hua    
//    m_nErrorID = 
//        AbiGetMemN((ADDR&)m_TestAddr, (ADDR&)(m_TestAddr+2), pchData);
    m_nErrorID = 
        AbiGetMemN((ADDR&)m_TestAddr, (ADDR&)(m_TestAddr), pchData);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
    
    // Check ACALL or LCALL.
/*    
    if ( 0x012 == pchData[0] ) {
        // LCALL addr16.
        m_TestAddr.m_uAddr = (unsigned short)
        ( ((((WORD)pchData[1])<<8)&0xFF00) | (((WORD)pchData[2])&0x0FF) );
        return (TRUE);
    }
    else if ( 0x011 == (pchData[0]&0x01F) ) {
        // ACALL addr11.
        WORD w1 = (m_TestAddr.m_uAddr + 2) & 0xF800;
        WORD w2 = ( (((((WORD)pchData[0]&0x0E0)<<3) | 
                    ((WORD)pchData[1])&0x0FF) & 0x07FF) ) & 0x07FF;
        m_TestAddr.m_uAddr = (unsigned short)(w1|w2);
        return (TRUE);
    }
    else {
        return (FALSE);
    }
*/
// for PIC  ; Modified by Gates Hua
    m_TestAddr.m_uAddr = (unsigned short)pchData[0];
    return IsStepCall(pchData[0], m_TestAddr.m_uAddr);
//    return (0x011==pchData[0]&0x01F || 0x012==pchData[0]) ? TRUE : FALSE;
    
}   // End of CEmulationStep::StepMatchCall().


// If match the RET?
BOOL CEmulationStep::StepMatchRet(void)
{
    // Assertion of the input parameters.

    // Get current PC.
    WORD uRegValue;
    m_nErrorID = AbiGetOneReg(0, &uRegValue);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }

    // Get the special address memory.
    WORD pchData[2];
    m_TestAddr.m_uAddr = (unsigned short)uRegValue;
    m_TestAddr.m_uchType = MEM_PROGRAM;
    m_nErrorID = AbiGetMemN((ADDR&)m_TestAddr,(ADDR&)m_TestAddr,pchData);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
      
    //for pic
      return IsStepReturn(pchData[0]);
    // Check RET or RETI.
    //return (0x022==pchData[0] || 0x032==pchData[0]) ? TRUE : FALSE;
    
}   // End of CEmulationStep::StepMatchRet().


// If match the address?
BOOL CEmulationStep::StepMatchAddr(void)
{
    // Assertion of the input parameters.

    // Get current PC.
    WORD uRegValue;
    m_nErrorID = AbiGetOneReg(0, &uRegValue);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
    else {
//        return (uRegValue==m_TillAddr.m_uAddr) ? TRUE : FALSE;
        
        // Modified by Chen, 05/30/96
        if ( uRegValue < m_FromAddr.m_uAddr || uRegValue > m_TillAddr.m_uAddr ) {
            return TRUE;
        }
        else {
            return FALSE;
        }
    }
    
}   // End of CEmulationStep::StepMatchAddr().


// If match the register?
BOOL CEmulationStep::StepMatchReg(void)
{
    // Assertion of the input parameters.

    // Get the special Register value.
    WORD uRegValue;
    m_nErrorID = AbiGetOneReg(m_nRegID, &uRegValue);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
    else {
        return (uRegValue==m_uRegData) ? TRUE : FALSE;
    }
    
}   // End of CEmulationStep::StepMatchReg().


// If match the memory?
BOOL CEmulationStep::StepMatchMem(void)
{
    // Assertion of the input parameters.

    // Get the special address memory.
    WORD pchData[2];
    m_nErrorID = AbiGetMemN((ADDR&)m_MatchAddr,(ADDR&)m_MatchAddr,pchData);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
    else {
        return ((unsigned char)pchData[0]==m_uchMemData) ? TRUE : FALSE;
    }
    
}   // End of CEmulationStep::StepMatchMem().


// Step [count] server.
void CEmulationStep::EmuServerStep(long lCount)
{
    // Assertion of the input parameters.
    ASSERT( lCount >= -4 && lCount <= 0xFFFF );
    // lCount:   1 <= lCount <= 0xFFFF - Count
    //           0 - Continuously
    //          -1 - Till Call
    //          -2 - Till Ret
    //          -3 - Into Call
    //          -4 - Over Ret

    // Set the parameter.
    if ( 0 == lCount ) {
        // Step Forever.
        m_isStepForever = TRUE;
    }
/*    
    else if ( -1 == lCount ) {
        // Step Till Call.
        m_isTillCall = TRUE;
    }
    else if ( -2 == lCount ) {
        // Step Till Ret.
        m_isTillRet = TRUE;
    }
    else if ( -3 == lCount ) {
        // Step Into Call.
        m_isIntoCall = TRUE;
    }
    else if ( -4 == lCount ) {
        // Step Over Ret.
        m_isOverRet = TRUE;
    }
*/
    else if ( lCount >= 1 && lCount <= 0xFFFF ) {
        // Step count.
        m_isStepCount = TRUE;
        m_uInputCount = (unsigned short)lCount;
    }
    else {
        ASSERT( FALSE );
    }
    
// Added by Gates Hua
	AfxGetApp()->BeginWaitCursor();

    // Call the Step kernel.
    m_isServer = TRUE;
    if ( m_isStepCount ) {
        StepKernel();
    }
    else {
        StepKernel();
    }

// Added by Gates Hua
	AfxGetApp()->EndWaitCursor();
}   // End of CEmulationStep::EmuServerStep().


// Step Over [count] server.
void CEmulationStep::EmuServerStepOver(long lCount)
{
    // Assertion of the input parameters.
    ASSERT( lCount >= -4 && lCount <= 0xFFFF );
    // lCount:   1 <= lCount <= 0xFFFF - Count
    //           0 - Continuously
    //          -1 - Till Call
    //          -2 - Till Ret
    //          -3 - Into Call
    //          -4 - Over Ret

    // Set the parameter.
    if ( 0 == lCount ) {
        // Step Over Forever.
        m_isStepForever = TRUE;
    }
    else if ( -1 == lCount ) {
        // Step Over Till Call.
        m_isTillCall = TRUE;
    }
    else if ( -2 == lCount ) {
        // Step Over Till Ret.
        m_isTillRet = TRUE;
    }
    else if ( -3 == lCount ) {
        // Step Over Into Call.
        m_isIntoCall = TRUE;
    }
    else if ( -4 == lCount ) {
        // Step Over Over Ret.
        m_isOverRet = TRUE;
    }
    else if ( lCount >= 1 && lCount <= 0xFFFF ) {
        // Step Over count.
        m_isStepCount = TRUE;
        m_uInputCount = (unsigned short)lCount;
    }
    else {
        ASSERT( FALSE );
    }
    
// Added by Gates Hua
	AfxGetApp()->BeginWaitCursor();

    // Call the Step kernel.
    m_isStepOver = TRUE;
    m_isServer = TRUE;
    if ( m_isStepCount ) {
        StepKernel();
    }
    else {
        StepKernel();
    }

// Added by Gates Hua
	AfxGetApp()->EndWaitCursor();

}   // End of CEmulationStep::EmuServerStepOver().

// Update all the windows.
void CEmulationStep::UpdateAllWindows(void)
{
    // Assertion of the input parameters.

    // Added by Chen, 06/05/96.
    // Return if EP is not halt.
    unsigned char uchStatus;
    if ( FALSE == ::GetCpuStatus(uchStatus) ) {
        return;
    }
    else if ( STATUS_HALT != uchStatus && STATUS_GOMONI != uchStatus ) {
        return;
    }
    

    // Repaint all the windows.
    ::OnEmulation();

    // Update the related window at once.
//    if ( ::isShellOn ) {
//        ::pShellWnd->UpdateWindow();
//    }
    if ( ::isSourceOn ) {
        ::pSourceWnd->UpdateWindow();
    }
    if ( ::isVariableOn ) {
        ::pVariableWnd->UpdateWindow();
    }
    if ( ::isStackOn ) {
        ::pStackWnd->UpdateWindow();
    }
    if ( ::isCpuOn ) {
        ::pCpuWnd->UpdateWindow();
    }
    if ( ::isTraceOn[0] ) {
        ::pTraceWnd[0]->UpdateWindow();
    }
    if ( ::isTraceOn[1] ) {
        ::pTraceWnd[1]->UpdateWindow();
    }
    if ( ::isPeriOn ) {
        ::pPeriWnd->UpdateWindow();
    }
    if ( ::isBMemOn ) {
        ::pBMemWnd->UpdateWindow();
    }
    for ( int i = 0; i <= 2; i++ ) {
        if ( ::isMemOn[i] ) {
            ::pMemWnd[i]->UpdateWindow();
        }
    }
}

//////////////////////////////// End of File ////////////////////////////////
