
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FIREWND.CPP   1.13   13 Dec 1996 11:18:28   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FIREWND.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:40   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:58   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:32   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:12   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:38   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:12   ZJRD
** Initial revision.
** 
****************************************************************************/

// firewnd.cpp : implementation file
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include "firewnd.h"

#include <math.h> // for HSI conversion

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define WIDTHBYTES(bits) ((((bits) + 31) / 32) * 4)
#define BASEDELAY 55

static RGBQUAD rgbStd256[] =
{
	{   0,  0,  0, 0 },	{   0,  0,128, 0 },	{   0,128,  0, 0 },	{   0,128,128, 0 },
	//{ 128,  0,  0, 0 },	{ 128,  0,128, 0 },	{ 128,128,  0, 0 },	{ 192,192,192, 0 }, 
	{ 0,  0,  0, 0 },	{ 0,  0,  0, 0 },	{ 128,128,  0, 0 },	{ 192,192,192, 0 },
	
	{ 192,220,192, 0 },	{ 240,202,166, 0 },	{ 238,238,238, 0 },	{ 221,221,221, 0 },
	{ 204,204,204, 0 },	{ 187,187,187, 0 },	{ 170,170,170, 0 },	{ 153,153,153, 0 },
	{ 136,136,136, 0 },	{ 119,119,119, 0 },	{ 102,102,102, 0 },	{  85, 85, 85, 0 },
	{  68, 68, 68, 0 },	{  51, 51, 51, 0 },	{  34, 34, 34, 0 },	{  17, 17, 17, 0 },
	{ 204,255,255, 0 },	{ 153,255,255, 0 },	{ 102,255,255, 0 },	{  51,255,255, 0 },
	{ 255,204,255, 0 },	{ 204,204,255, 0 },	{ 153,204,255, 0 },	{ 102,204,255, 0 },
	{  51,204,255, 0 },	{   0,204,255, 0 },	{ 255,153,255, 0 },	{ 204,153,255, 0 },
	{ 153,153,255, 0 },	{ 102,153,255, 0 },	{  51,153,255, 0 },	{   0,153,255, 0 },
	{ 255,102,255, 0 },	{ 204,102,255, 0 },	{ 153,102,255, 0 },	{ 102,102,255, 0 },
	{  51,102,255, 0 },	{   0,102,255, 0 },	{ 255, 51,255, 0 },	{ 204, 51,255, 0 },
	{ 153, 51,255, 0 },	{ 102, 51,255, 0 },	{  51, 51,255, 0 },	{   0, 51,255, 0 },
	{ 204,  0,255, 0 },	{ 153,  0,255, 0 },	{ 102,  0,255, 0 },	{  51,  0,255, 0 },
	{ 255,255,204, 0 },	{ 204,255,204, 0 },	{ 153,255,204, 0 },	{ 102,255,204, 0 },
	{  51,255,204, 0 },	{   0,255,204, 0 },	{ 255,204,204, 0 },	{ 153,204,204, 0 },
	{ 102,204,204, 0 },	{  51,204,204, 0 },	{   0,204,204, 0 },	{ 255,153,204, 0 },
	{ 204,153,204, 0 },	{ 153,153,204, 0 },	{ 102,153,204, 0 },	{  51,153,204, 0 },
	{   0,153,204, 0 },	{ 255,102,204, 0 },	{ 204,102,204, 0 },	{ 153,102,204, 0 },
	{ 102,102,204, 0 },	{  51,102,204, 0 },	{   0,102,204, 0 },	{ 255, 51,204, 0 },
	{ 204, 51,204, 0 },	{ 153, 51,204, 0 },	{ 102, 51,204, 0 },	{  51, 51,204, 0 },
	{   0, 51,204, 0 },	{ 255,  0,204, 0 },	{ 204,  0,204, 0 },	{ 153,  0,204, 0 },
	{ 102,  0,204, 0 },	{  51,  0,204, 0 },	{ 255,255,153, 0 },	{ 204,255,153, 0 },
	{ 153,255,153, 0 },	{ 102,255,153, 0 },	{  51,255,153, 0 },	{   0,255,153, 0 },
	{ 255,204,153, 0 },	{ 204,204,153, 0 },	{ 153,204,153, 0 },	{ 102,204,153, 0 },
	{  51,204,153, 0 },	{   0,204,153, 0 },	{ 255,153,153, 0 },	{ 204,153,153, 0 },
	{ 102,153,153, 0 },	{  51,153,153, 0 },	{   0,153,153, 0 },	{ 255,102,153, 0 },
	{ 204,102,153, 0 },	{ 153,102,153, 0 },	{ 102,102,153, 0 },	{  51,102,153, 0 },
	{   0,102,153, 0 },	{ 255, 51,153, 0 },	{ 204, 51,153, 0 },	{ 153, 51,153, 0 },
	{ 102, 51,153, 0 },	{  51, 51,153, 0 },	{   0, 51,153, 0 },	{ 255,  0,153, 0 },
	{ 204,  0,153, 0 },	{ 153,  0,153, 0 },	{ 102,  0,153, 0 },	{  51,  0,153, 0 },
	{ 255,255,102, 0 },	{ 204,255,102, 0 },	{ 153,255,102, 0 },	{ 102,255,102, 0 },
	{  51,255,102, 0 },	{   0,255,102, 0 },	{ 255,204,102, 0 },	{ 204,204,102, 0 },
	{ 153,204,102, 0 },	{ 102,204,102, 0 },	{  51,204,102, 0 },	{   0,204,102, 0 },
	{ 255,153,102, 0 },	{ 204,153,102, 0 },	{ 153,153,102, 0 },	{ 102,153,102, 0 },
	{  51,153,102, 0 },	{   0,153,102, 0 },	{ 255,102,102, 0 },	{ 204,102,102, 0 },
	{ 153,102,102, 0 },	{  51,102,102, 0 },	{   0,102,102, 0 },	{ 255, 51,102, 0 },
	{ 204, 51,102, 0 },	{ 153, 51,102, 0 },	{ 102, 51,102, 0 },	{  51, 51,102, 0 },
	{   0, 51,102, 0 },	{ 255,  0,102, 0 },	{ 204,  0,102, 0 },	{ 153,  0,102, 0 },
	{ 102,  0,102, 0 },	{  51,  0,102, 0 },	{ 255,255, 51, 0 },	{ 204,255, 51, 0 },
	{ 153,255, 51, 0 },	{ 102,255, 51, 0 },	{  51,255, 51, 0 },	{   0,255, 51, 0 },
	{ 255,204, 51, 0 },	{ 204,204, 51, 0 },	{ 153,204, 51, 0 },	{ 102,204, 51, 0 },
	{  51,204, 51, 0 },	{   0,204, 51, 0 },	{ 255,153, 51, 0 },	{ 204,153, 51, 0 },
	{ 153,153, 51, 0 },	{ 102,153, 51, 0 },	{  51,153, 51, 0 },	{   0,153, 51, 0 },
	{ 255,102, 51, 0 },	{ 204,102, 51, 0 },	{ 153,102, 51, 0 },	{ 102,102, 51, 0 },
	{  51,102, 51, 0 },	{   0,102, 51, 0 },	{ 255, 51, 51, 0 },	{ 204, 51, 51, 0 },
	{ 153, 51, 51, 0 },	{ 102, 51, 51, 0 },	{   0, 51, 51, 0 },	{ 255,  0, 51, 0 },
	{ 204,  0, 51, 0 },	{ 153,  0, 51, 0 },	{ 102,  0, 51, 0 },	{  51,  0, 51, 0 },
	{ 204,255,  0, 0 },	{ 153,255,  0, 0 },	{ 102,255,  0, 0 },	{  51,255,  0, 0 },
	{ 255,204,  0, 0 },	{ 204,204,  0, 0 },	{ 153,204,  0, 0 },	{ 102,204,  0, 0 },
	{  51,204,  0, 0 },	{ 255,153,  0, 0 },	{ 204,153,  0, 0 },	{ 153,153,  0, 0 },
	{ 102,153,  0, 0 },	{   0,  0,238, 0 },	{   0,  0,221, 0 },	{   0,  0,204, 0 },
	{   0,  0,187, 0 },	{   0,  0,170, 0 },	{   0,  0,153, 0 },	{   0,  0,136, 0 },
	{   0,  0,119, 0 },	{   0,  0,102, 0 },	{   0,  0, 85, 0 },	{   0,  0, 68, 0 },
	{   0,  0, 51, 0 },	{   0,  0, 34, 0 },	{   0,  0, 17, 0 },	{   0,238,  0, 0 },
	{   0,221,  0, 0 },	{   0,204,  0, 0 },	{   0,187,  0, 0 },	{   0,170,  0, 0 },
	{   0,153,  0, 0 },	{   0,136,  0, 0 },	{   0,119,  0, 0 },	{   0,102,  0, 0 },
	{   0, 85,  0, 0 },	{   0, 68,  0, 0 },	{   0, 51,  0, 0 },	{   0, 34,  0, 0 },
	{   0, 17,  0, 0 },	{ 238,  0,  0, 0 },	{ 221,  0,  0, 0 },	{ 204,  0,  0, 0 },
	{ 187,  0,  0, 0 },	{ 170,  0,  0, 0 },	{ 153,  0,  0, 0 },	{ 136,  0,  0, 0 },
	{ 119,  0,  0, 0 },	{ 102,  0,  0, 0 },	{  85,  0,  0, 0 },	{  68,  0,  0, 0 },
	{   0,  0,  0, 0 },	{   0,  0,  0, 0 },	{ 240,251,255, 0 },	{ 164,160,160, 0 },
//	{  51,  0,  0, 0 },	{  34,  0,  0, 0 },	{ 240,251,255, 0 },	{ 164,160,160, 0 },
	{ 128,128,128, 0 },	{   0,  0,255, 0 },	{   0,255,  0, 0 },	{   0,255,255, 0 },
	{ 255,  0,  0, 0 },	{ 255,  0,255, 0 },	{ 255,255,  0, 0 },	{ 255,255,255, 0 }
};					   

/////////////////////////////////////////////////////////////////////////////
// CFireWnd

// Initialize the seed for random number generation.  For a more random
// flame this could be initialized by a call to ::rand().  Declaring it
// this way causes the same flame to be drawn each time the application
// is executed.
unsigned long CFireWnd::m_RandSeed = 0x38549391;

CFireWnd::CFireWnd(DWORD dwDelay,            //=30000(30s),
                   DWORD *dwSafePoint,       //0
                   int   nFlameColor,       //red
	               int   nunion,            //=30,
	               int   nflame)          //=180; 
{
	m_nDecay = 5;
	m_nFlammability = 385;
	m_nMaxHeat = 223;
	m_nSpreadRate = 20;
	m_nSmoothness = 1;
	m_nDistribution = 1;
	m_nChaos = 50;            
	m_nFlameColor=nFlameColor;
	m_pdwSafePoint=dwSafePoint;
    
	m_nSize = 0;
	m_MaxBurn = 0;
	m_Fire = NULL;
	m_pBits=NULL;   
	m_lpbi=NULL;
	m_union=nunion;
    m_flame=nflame;
    m_bCanClose=0;
    m_uTimerID=0;    
    m_bNowQuit=0;
    m_dwExitDelay=dwDelay+GetTickCount();
    
    m_hFireBitmap=NULL;
    m_hBitmap=NULL;
    m_hWinDC =NULL;
    m_hMemDC =NULL;
    m_hFireDC=NULL;
	m_hOldBitmap=NULL;
	m_lpLogPal=NULL;
	
}

CFireWnd::~CFireWnd()
{          
}     

void CFireWnd::delay(int nCount)
{
    DWORD dwClick=dwClick=GetTickCount();   
    MSG   msg;
    while(GetTickCount()<dwClick+nCount)
	{
	  if( (m_bNowQuit==0) && ::PeekMessage(&msg,NULL,0,0,PM_REMOVE) )
	     DispatchMessage(&msg);
	}             
		              
}

void CFireWnd::SetOption(
                         int nDecay,          //5   (1~100)
                         int nFlammability,   //385 (1~399)
               			 int nMaxHeat,        //223 (0~223)
               			 int nSpreadRate,     //20  (1~100) 
               			 int nSize,           //85  (40~170)
               			 int nSmoothness,     //1   (0~5)
               			 int nDistribution,   //1   (0~10)
                		 int nChaos           //50  (1~100)
               			)	
{                        
	m_nDecay        = nDecay;
	m_nFlammability = nFlammability;
	m_nMaxHeat      = nMaxHeat;
	m_nSpreadRate   = nSpreadRate;
	m_nSize         = nSize;
	m_nSmoothness   = nSmoothness;
	m_nDistribution = nDistribution;
	m_nChaos        = nChaos;

}

BOOL CFireWnd::CreateWnd(LPSTR lpTitle, LPSTR lpVersion, LPSTR lpCompany)
{                                             
    m_strTitle  =lpTitle;                       
    m_strVersion=lpVersion;                 
    m_strCompany=lpCompany;
   
	LOGFONT logFont;
	memset(&logFont, 0, sizeof(LOGFONT));
	logFont.lfHeight=28;
	logFont.lfWeight=1000;
	logFont.lfItalic=1;
	lstrcpy(logFont.lfFaceName,"Arial");
	m_TitleFont.CreateFontIndirect(&logFont);
	
	memset(&logFont, 0, sizeof(LOGFONT));
	logFont.lfHeight=18;
	logFont.lfWeight=800;
	logFont.lfItalic=1;
	lstrcpy(logFont.lfFaceName,"Arial");
	m_VerFont.CreateFontIndirect(&logFont);
	
	memset(&logFont, 0, sizeof(LOGFONT));
	logFont.lfHeight=16;
	logFont.lfWeight=400;
	logFont.lfItalic=1;
	lstrcpy(logFont.lfFaceName,"Arial");
	m_CompanyFont.CreateFontIndirect(&logFont);

    BOOL bCreate=
           CreateEx(                                          
                    WS_EX_TOPMOST,
                    AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_OWNDC,
                                        0,
                                        (HBRUSH)GetStockObject(BLACK_BRUSH),
                                        (HCURSOR)::LoadCursor(NULL,IDC_ARROW)),//0),
                    NULL,
                    WS_POPUP|WS_VISIBLE|WS_OVERLAPPED|WS_THICKFRAME,//WS_BORDER,//WS_THICKFRAME|,
                    0,0,326,185,
                    NULL,
                    NULL,
                    NULL
                   );              
   	delay(400);
   	return bCreate;
}

void CFireWnd::ReleaseItem()
{                           

	if (m_hMemDC != NULL)
	{      
	    RestoreDC(m_hMemDC,-1);    
		::DeleteDC(m_hMemDC);
		m_hMemDC = NULL;
	}

	if (m_hFireDC != NULL)
	{      
	    RestoreDC(m_hFireDC,-1);    
		::DeleteDC(m_hFireDC);
		m_hFireDC = NULL;
	}

	if (m_hBitmap!= NULL)
		::DeleteObject(m_hBitmap);

	if (m_hFireBitmap!= NULL)
		::DeleteObject(m_hFireBitmap);


	if (m_hWinDC != NULL)
	{                               
	    RestoreDC(m_hWinDC,-1);    
		::ReleaseDC(m_hWnd,m_hWinDC);
		m_hWinDC = NULL;
	}

	if (m_Fire != NULL)
	{
		delete [] (LPBYTE)m_Fire;
		m_Fire = NULL;
	}

    if(m_lpbi!=NULL)
    {     
        delete [] (LPBYTE)m_lpbi;
        m_lpbi=NULL;
    }

    m_TitleFont.DeleteObject();
    m_VerFont.DeleteObject();
    m_CompanyFont.DeleteObject();
}

BOOL CFireWnd::ProcessMsg(MSG *pMsg)
{         
       MSG msg;            
       switch(pMsg->message)
       {               
          case WM_KEYDOWN:
          case WM_KEYUP:{         
               while(::PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE) );
               return TRUE;
               }
               
          default: break;     
               
       }   

    return FALSE;
}
                                                                          
                                                                          
BEGIN_MESSAGE_MAP(CFireWnd, CWnd)
	//{{AFX_MSG_MAP(CFireWnd)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_NCPAINT()
	ON_WM_DESTROY()
	ON_WM_PALETTECHANGED()
	ON_WM_QUERYNEWPALETTE()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_CLOSE()
	ON_WM_NCLBUTTONDOWN()
	ON_WM_NCRBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFireWnd Operations
int CFireWnd::OnCreate(LPCREATESTRUCT pcs)
{
	int nResult=CWnd::OnCreate(pcs);
	m_bOpen=1;
	CenterWindow();
	InitFire(m_nFlameColor);
	
	SetCapture();
 
    for(int i=0; i<12; i++,RenderFlame());
          
	m_uTimerID=SetTimer(0x451, BASEDELAY, NULL); 
	
	return nResult;
}                  

void CFireWnd::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	CWnd::OnTimer(nIDEvent);

	if(nIDEvent==m_uTimerID && m_bOpen)
	{  
	   if(!m_bNowQuit && m_dwExitDelay<=GetTickCount())//m_dwExitDelay>0 && (--m_dwExitDelay)<=0)
	   {             
	        m_bNowQuit=1;        
			SendMessage(WM_CLOSE);
			return;
	   }
	         

	   RenderFlame(); 
       PaintDIBitmap(m_hWinDC);
     
//	   PaintFlame();
/*	   
       if(!m_bNowQuit)
       {
	     MSG msg;
	     while(::PeekMessage(&msg, NULL, WM_TIMER, WM_TIMER, PM_REMOVE) );	    
	   }  
*/	   
	}
	
}
                  
void CFireWnd::InitFire(int nColor)
{
	CSize size;
    CRect rect;

	GetClientRect(&rect);
	m_WndSize = rect.Size();
	m_FlameSize.cx=100;
	m_FlameSize.cy=m_flame;
	m_MaxBurn = (int)(m_FlameSize.cy *3/4);
	m_nSize   = (int)(m_FlameSize.cx *9/10);


    UINT uLength = (UINT)(WIDTHBYTES((DWORD)m_FlameSize.cx * 8) * m_FlameSize.cy);
    ASSERT( long(uLength)<65535l );
    m_pBits=(BYTE far *) new BYTE[uLength];
    ASSERT(AfxIsValidAddress(m_pBits, uLength));
    _fmemset(m_pBits,0,uLength);

	CreatePalette(nColor);
	CreateBitmap();
    ReleaseCapture();
    
    CWnd* pActiveWnd = CWnd::GetActiveWindow();
	if (pActiveWnd != NULL)
	    pActiveWnd->SendMessage(WM_QUERYNEWPALETTE);
}

CPalette* CFireWnd::GetPalette()
{
	if (m_Palette.m_hObject != NULL)
		return &m_Palette;
	else
		return NULL;
}

void CFireWnd::CreatePalette(int nColor)
{
	UINT i;

	if (m_Palette.m_hObject != NULL)
		m_Palette.DeleteObject();

	memcpy( m_rgbPalette, rgbStd256, sizeof(RGBQUAD) * 256 );

	int r,g,b;

	switch(nColor)
	{
	case blue:
		b =	256+256+255;
		g =	256+255;
		r = 255;
		break;
	case green:
		g =	256+256+255;
		r = 256+255;
		b =	255;
		break;
	case red:
	default:
		r =	256+256+255;
		g =	256+255;
		b = 255;
		break;
	}

	for(i = 239; i > 15; i--)
	{
		m_rgbPalette[i].rgbRed = (r > 255) ? 255 : r;
		m_rgbPalette[i].rgbGreen = (g > 255) ? 255 : g;
		m_rgbPalette[i].rgbBlue = (b > 255) ? 255 : b;
		r = (r > 3) ? (r - 4) : 0;
		g = (g > 3) ? (g - 4) : 0;
		b = (b > 3) ? (b - 4) : 0;
	}

	m_lpLogPal = (LPLOGPALETTE) new BYTE[sizeof(LOGPALETTE) + ((255) * sizeof(PALETTEENTRY))];
	m_lpLogPal->palVersion = 0x0300;
	m_lpLogPal->palNumEntries = 256;

	for (i = 0; i < 256; i++)
	{
		m_lpLogPal->palPalEntry[i].peRed   = m_rgbPalette[i].rgbRed;
		m_lpLogPal->palPalEntry[i].peGreen = m_rgbPalette[i].rgbGreen;
		m_lpLogPal->palPalEntry[i].peBlue  = m_rgbPalette[i].rgbBlue;
		m_lpLogPal->palPalEntry[i].peFlags = 0;
	}

	m_Palette.CreatePalette( m_lpLogPal ); 
	
	if(m_lpLogPal)
	{
	   delete [] (BYTE *)m_lpLogPal;
       m_lpLogPal=NULL;
    }   

}

CSize CFireWnd::GetBitmapSize()
{
    return m_FlameSize;
}


void CFireWnd::CreateBitmap()
{              
	
	// Fill in the BITMAPINFOHEADER

	m_Fire = new BYTE[m_FlameSize.cx];

	m_lpbi = (LPBYTE) new BYTE[sizeof(BITMAPINFOHEADER) + (256 * sizeof(RGBQUAD))];
	LPBITMAPINFO lpbi=(LPBITMAPINFO)m_lpbi;
	lpbi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	lpbi->bmiHeader.biWidth = m_FlameSize.cx;
	lpbi->bmiHeader.biHeight = m_FlameSize.cy;
	lpbi->bmiHeader.biPlanes = 1;
	lpbi->bmiHeader.biBitCount = 8;
	lpbi->bmiHeader.biCompression = BI_RGB;
	lpbi->bmiHeader.biSizeImage = WIDTHBYTES((DWORD)m_FlameSize.cx * 8) * m_FlameSize.cy;
	lpbi->bmiHeader.biXPelsPerMeter = 0;
	lpbi->bmiHeader.biYPelsPerMeter = 0;
	lpbi->bmiHeader.biClrUsed = 0;
	lpbi->bmiHeader.biClrImportant = 0;
	memcpy( lpbi->bmiColors, m_rgbPalette, sizeof(RGBQUAD) * 256 );

	m_hWinDC =::GetDC(m_hWnd);
	m_hMemDC =::CreateCompatibleDC(m_hWinDC);
    m_hFireDC=::CreateCompatibleDC(m_hWinDC);
    ::SaveDC(m_hWinDC);
    ::SaveDC(m_hMemDC);
    ::SaveDC(m_hFireDC);
    
    ::SelectPalette(m_hWinDC, (HPALETTE)m_Palette.GetSafeHandle(), FALSE );
    ::RealizePalette(m_hWinDC);
    ::SelectPalette(m_hMemDC, (HPALETTE)m_Palette.GetSafeHandle(), FALSE );
	m_hBitmap=::CreateCompatibleBitmap(m_hWinDC, m_WndSize.cx, m_WndSize.cy);
    ASSERT(m_hBitmap!=NULL);
    m_hOldBitmap=(HBITMAP)::SelectObject(m_hMemDC,m_hBitmap);    
    ::PatBlt(m_hMemDC,0,0,m_WndSize.cx,m_WndSize.cy,BLACKNESS);

    ::SetBkMode(m_hMemDC, TRANSPARENT);

    m_hFireBitmap=CreateDIBitmap(m_hWinDC,
                                 (LPBITMAPINFOHEADER) m_lpbi,
                                 CBM_INIT,
                                 m_pBits,
                                 (LPBITMAPINFO) m_lpbi,
                                 DIB_RGB_COLORS);      
    ASSERT(m_hFireBitmap!=NULL);                             
    ::SelectObject(m_hFireDC,m_hFireBitmap);    
    
	for (int y = 0; y < m_FlameSize.cy; y++ )
	{
		BYTE* pRow = (m_pBits + WIDTHBYTES((DWORD)m_FlameSize.cx * 8) * y);
   		for (int x = 0; x < m_FlameSize.cx; x++ )
			*pRow++ = 16;
	}

	for (int x = 0; x < m_FlameSize.cx; x++ )
		m_Fire[x] = 16;
}

//
//	This routine was adapted from a pascal routine written by
//	Frank Jan Sorensen Alias:Frank Patxi (fjs@lab.jt.dk)
//
//	See AboutBox for a special thank you for all his work.
//

void CFireWnd::RenderFlame()
{
	
	CSize size = GetBitmapSize();
	int xStart, xEnd, x, y;
	BYTE* pRow;
	BYTE* pNextRow;

	xStart = (size.cx - m_nSize) / 2;
	xEnd = xStart + m_nSize + 1;

	{
		pRow = m_pBits;
		for (x=0;x<size.cx;x++)
		{
			if (x < (xStart + m_nDistribution) || x >= (xEnd - m_nDistribution))
				m_Fire[x] = 16;
			*pRow++ = m_Fire[x];
		}
	}

	for (y = m_MaxBurn; y > 0; y--)
	{
		pRow = (m_pBits + WIDTHBYTES((DWORD)size.cx * 8) * y);
		pNextRow = (m_pBits + WIDTHBYTES((DWORD)size.cx * 8) * (y - 1));

		if ((rand() % 2) == 0)
		{
			for (x = 0; x < size.cx; x++)
			{
				BurnPoint(pRow, pNextRow);
				pRow++;
				pNextRow++;
			}
		}
		else
		{
			pRow += size.cx - 1;
			pNextRow += size.cx - 1;
			for (x = 0; x < size.cx; x++)
			{
				BurnPoint(pRow, pNextRow);
				pRow--;
				pNextRow--;
			}
		}
	}

	int MaxHeat = m_nMaxHeat + 16;

	if ( rand() % (400 - m_nFlammability) == 0)
	{
		int off = m_nSize - 5;
		off = rand() % off;
		off += xStart;

		for (x = off; x < off + 5; x++)
			m_Fire[x] = 239;
	}

	for (x = xStart; x < xEnd; x++)
	{
		if (m_Fire[x] < MaxHeat)
		{
			int val = rand() % m_nChaos+1;
			val -= m_nChaos / 2;
			val += m_nSpreadRate;
			val += m_Fire[x];

			if ( val > MaxHeat) 
				m_Fire[x] = MaxHeat;
			else if ( val < 16)
				m_Fire[x] = 16;
			else
				m_Fire[x] = val;
 		}
		else
			m_Fire[x] = MaxHeat;
	}

	if (m_nSmoothness > 0)
	{
		xStart += m_nSmoothness;
		xEnd -= m_nSmoothness;
		for (x = xStart; x < xEnd; x++)
		{
			int val = 0;
			for (y = x - m_nSmoothness; y < x + 1 + m_nSmoothness; y++)
				val += m_Fire[y];

			m_Fire[x] = val / (2*m_nSmoothness+1);
		}
	}          
	       
}

void CFireWnd::PaintDIBitmap(HDC hDC)
{    
  //::SaveDC(m_hMemDC);
  const int nWidth=m_FlameSize.cx-m_union*2;                    
  static int uCount=55; 
  static int uFlash=16;           
  static BOOL bBlack=0;
  PALETTEENTRY palEntrey[2];
  
  
  ::SetDIBits(m_hWinDC, 
              m_hFireBitmap, 
              0, m_FlameSize.cy,                               
              m_pBits,
              (LPBITMAPINFO) m_lpbi,
              DIB_RGB_COLORS);


	for(int xorg=0; xorg<m_WndSize.cx; xorg+=nWidth)
	{  			    
    	BitBlt(m_hMemDC,
        	   xorg, 
         	   m_WndSize.cy-m_FlameSize.cy,
       		   nWidth,
               m_FlameSize.cy,
         	   m_hFireDC,
         	   m_union,
        	   0,
               SRCCOPY);
	}   
	
  
  DWORD dwExtent;
  if(uCount>=247)
  {            
     uCount=251;
     m_bCanClose=1;
  }
  else uCount+=4;
            
  if(uFlash>=240 && uFlash<242)
  {
     uFlash=bBlack?uFlash-1:uFlash+1;
  }           
  else if(uFlash<240)
  {  
     uFlash=bBlack?uFlash-16:uFlash+16;   
          
     if(uFlash<16)
     {
        bBlack=0;
        uFlash=16;
     }   
  }  
  else if(uFlash>=242)
  {
       bBlack=1;
       uFlash=241;
  }

   if(uCount==191) return;
          
   palEntrey[0].peBlue  = BYTE(uCount);           
   palEntrey[0].peRed   = 0;//uCount;           //0;
   palEntrey[0].peGreen = BYTE(uCount);           //0;
   palEntrey[0].peFlags = 0;	        
	   
   palEntrey[1].peBlue = BYTE(uFlash);
   palEntrey[1].peRed  = BYTE(uFlash);
   palEntrey[1].peGreen= BYTE(uFlash);
   palEntrey[1].peFlags = 0;	        
   
   m_Palette.SetPaletteEntries(4,2,palEntrey);   
  ::RealizePalette(m_hMemDC);

//Set title text
  ::SelectObject(m_hMemDC, (HFONT)m_TitleFont.GetSafeHandle());
  dwExtent=::GetTextExtent(m_hMemDC, (LPCSTR)m_strTitle,m_strTitle.GetLength());
  ::SetTextColor(m_hMemDC, PALETTEINDEX(3));
  ::TextOut(m_hMemDC, (m_WndSize.cx-LOWORD(dwExtent))/2+3,20,
           (LPCSTR)m_strTitle,m_strTitle.GetLength());
  ::SetTextColor(m_hMemDC, PALETTEINDEX(4));
  ::TextOut(m_hMemDC, (m_WndSize.cx-LOWORD(dwExtent))/2,17,
            (LPCSTR)m_strTitle,m_strTitle.GetLength());
  
//Set version text
  ::SelectObject(m_hMemDC, m_VerFont.GetSafeHandle());
   dwExtent=::GetTextExtent(m_hMemDC, (LPCSTR)m_strVersion,m_strVersion.GetLength());
 
  ::SetTextColor(m_hMemDC, RGB(0,128,128));//PALETTEINDEX(3));
  ::TextOut(m_hMemDC, (m_WndSize.cx-LOWORD(dwExtent))-30+2,80+2,
            (LPCSTR)m_strVersion,m_strVersion.GetLength());
 
  ::SetTextColor(m_hMemDC, PALETTEINDEX(5));
  ::TextOut(m_hMemDC, (m_WndSize.cx-LOWORD(dwExtent))-30,80,
            (LPCSTR)m_strVersion,m_strVersion.GetLength());
  
//Set company text
  ::SelectObject(m_hMemDC, m_CompanyFont.GetSafeHandle());
  ::SetTextColor(m_hMemDC, RGB(0,0,255));//,nRgb,nRgb));

  ::TextOut(m_hMemDC, 8,m_WndSize.cy-18,
            (LPCSTR)m_strCompany,m_strCompany.GetLength());

  ::BitBlt(hDC, 0,0,m_WndSize.cx,m_WndSize.cy,m_hMemDC,0,0,SRCCOPY);
  
  //::RestoreDC(m_hMemDC, -1);
}                  
///////////////////////////////////////////////////////////////////////////
/*  
    SetDIBitsToDevice(memDC.m_hDC,
                      xorg,m_WndSize.cy-m_FlameSize.cy,
                      (i>=def_part-1)?m_FlameSize.cx-def_union/2:m_FlameSize.cx-def_union,
                      def_flame,
                      def_union/2,0,//m_FlameSize.cy,//-def_flame,
                      0,def_flame,
                      m_pBits,
                      (LPBITMAPINFO) m_lpbi,
                      DIB_RGB_COLORS
                      );
*/
////////////////////////////////////////////////////////////////////////////

void CFireWnd::PaintFlame(CDC* pDC)
{   
     PaintDIBitmap(m_hWinDC);
}

void CFireWnd::SetMaxBurn(int nMax)
{
	if (m_Palette.m_hObject != NULL )// && m_Bitmap.m_hObject != NULL)
	{
		CSize size = GetBitmapSize();

		m_MaxBurn = (int)(size.cy * (nMax/100.0));

		for (int y = size.cy; y > m_MaxBurn; y-- )
		{
			BYTE* pRow = (m_pBits + WIDTHBYTES((DWORD)size.cx * 8) * y);
	   		for (int x = 0; x < size.cx; x++ )
				*pRow++ = 16;
		}
	}
}

int CFireWnd::GetMaxBurn()
{
	return m_MaxBurn;
}

/////////////////////////////////////////////////////////////////////////////
// CFireWnd message handlers

void CFireWnd::OnDestroy() 
{            
    if(m_uTimerID>0)
    {
	   KillTimer(m_uTimerID);
	   m_uTimerID=0;
	}               
	
    ReleaseCapture();

	if (m_Palette.m_hObject != NULL)
	{
	   m_Palette.DeleteObject();
	}	

    ReleaseItem();
	
    m_bOpen=0;
    
	CWnd::OnDestroy();
}

void CFireWnd::OnNcPaint() 
{                          
//    CWnd::OnNcPaint();
    CWindowDC dc(this);
    dc.SaveDC();                            
    CSize size;
    CRect rectWin, rectClient;
    GetWindowRect(&rectWin);
    GetClientRect(&rectClient);
    size.cx=rectWin.Width()-rectClient.Width();
    size.cy=rectWin.Height()-rectClient.Height();
    int nWidth=size.cx>size.cy?size.cx:size.cy;
    
    CPen penWhite(PS_SOLID, 1, RGB(255,255,255));
    CPen penGray(PS_SOLID, nWidth, GetSysColor(COLOR_INACTIVEBORDER));
    size=rectWin.Size();
    dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(NULL_BRUSH)));
    dc.SelectObject(&penGray);
    dc.Rectangle(0,0,size.cx,size.cy);
    dc.SelectObject(&penWhite);
    dc.Rectangle(1,1,size.cx-1,size.cy-1);
    dc.RestoreDC(-1);
}

void CFireWnd::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	PaintFlame(&dc);
}

void CFireWnd::OnPaletteChanged(CWnd* pFocusWnd) 
{
	if (pFocusWnd == this || IsChild(pFocusWnd))
		return;

	OnQueryNewPalette();
}

BOOL CFireWnd::OnQueryNewPalette() 
{
	if (GetPalette() == NULL)
		return FALSE;

	{
		CClientDC dc(this);
		CPalette* pOldPalette = dc.SelectPalette(&m_Palette,
			GetCurrentMessage()->message == WM_PALETTECHANGED);
		UINT nChanged = dc.RealizePalette();
		dc.SelectPalette(pOldPalette, TRUE);

		if (nChanged == 0)	// no change to our mapping
			return FALSE;
	}

	// some changes have been made; invalidate
	Invalidate(FALSE);

	return TRUE;
}

void CFireWnd::AutoClose(CPoint point)
{   
    CRect rect;                              
	GetClientRect(&rect);
	if(m_bNowQuit==0)
	{
		if(rect.PtInRect(point)==0 && m_bCanClose)
		{        
	       m_bNowQuit=1;
		   PostMessage(WM_CLOSE);
		}   
		else  
		{
		   ReleaseCapture();
		   SetCapture();
		}   
    } 
}

void CFireWnd::OnRButtonDown(UINT nFlags, CPoint point)
{
	if(m_bNowQuit==0)
	{
		CWnd::OnRButtonDown(nFlags, point);
		AutoClose(point);
	}	
}


void CFireWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	if(m_bNowQuit==0)
	{
	    CWnd::OnLButtonDown(nFlags, point);
		AutoClose(point);
	}	
}


void CFireWnd::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	if(m_bNowQuit==0) return;
	
	m_nDecay=98;
	if(m_uTimerID)  
	{
	   KillTimer(m_uTimerID);
	   m_uTimerID=0;
	}  
	
	for(int i=0; i<10; i++)
	{ 
	   RenderFlame();      
	   PaintFlame();
	}
	   
	CWnd::OnClose();
}

void CFireWnd::PostNcDestroy()
{   
     if(AfxGetApp()->m_pMainWnd)
        AfxGetApp()->m_pMainWnd->BringWindowToTop();
     
     if(m_pdwSafePoint!=NULL)
     {                
        *m_pdwSafePoint=NULL;
        delete this;
     }   
}

void CFireWnd::OnNcLButtonDown(UINT nHitTest, CPoint point)
{
}

void CFireWnd::OnNcRButtonDown(UINT nHitTest, CPoint point)
{
}
