
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FIREWND.H__   1.13   13 Dec 1996 11:18:28   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FIREWND.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:50   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:26   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:00   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:40   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:32   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:54   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:30   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:17:42   ZJRD
** Initial revision.
** 
****************************************************************************/

// firewnd.h : header file
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

/////////////////////////////////////////////////////////////////////////////
// CFireWnd window

class CFireWnd : public CWnd
{
// Construction
public:
	CFireWnd(DWORD  dwDelay=12000,            //=30000 base on secand,
             DWORD *dwSafePoint=NULL,       //=0
             int   nFlameColor=red,         //red
	         int   nunion=30,
	         int   nflame=100
            );

	BOOL CreateWnd(LPSTR lpTitle, LPSTR lpVersion, LPSTR lpCompany);
    BOOL IsWindowOpen();               
    void CloseFireWnd();
    void SetOption(
                   
                   int nDecay=5,            //5   (1~100)
                   int nFlammability=385,   //385 (1~399)
                   int nMaxHeat=200,        //223 (0~223)
                   int nSpreadRate=20,      //20  (1~100) 
                   int nSize=85,            //85  (40~170)
                   int nSmoothness=1,       //1   (0~5)
                   int nDistribution=1,     //1   (0~10)
                   int nChaos=50            //50  (1~100)
                  );
    virtual BOOL ProcessMsg(MSG *pMsg);


// Attributes
public:

	// Fire Attributes
	int m_nDecay;
	int m_nFlammability;
	int m_nMaxHeat;
	int m_nSpreadRate;
	int m_nSize;
	int m_nSmoothness;
	int m_nDistribution;
	int m_nChaos;        
	enum { red = 1, green = 2, blue = 3 };
protected:	
    //using attributes
    CString m_strTitle; 
    CString m_strVersion;
    CString m_strCompany;
    
	
protected:	             
	HDC          m_hMemDC;
	HDC          m_hWinDC; 
	HDC          m_hFireDC;
	HBITMAP      m_hBitmap;
	HBITMAP      m_hFireBitmap;
	HBITMAP      m_hOldBitmap;
	LPLOGPALETTE m_lpLogPal;
	CFont        m_TitleFont;
	CFont        m_VerFont;
	CFont        m_CompanyFont;
	int          m_nFlameColor;

protected:
    
	UINT   m_uTimerID;
	BOOL   m_bNowQuit;
	DWORD  m_dwExitDelay;
	
	BOOL   m_bOpen;
	BOOL   m_bCanClose;
	DWORD  *m_pdwSafePoint;
    CSize  m_FlameSize;
    CSize  m_WndSize;
    
	int m_MaxBurn;      
	int m_union;
	int m_flame;      
	
	LPBYTE   m_Fire;
	LPBYTE   m_pBits;
	LPBYTE   m_lpbi;
	static unsigned long m_RandSeed;


	// Device Context Attributes

	// Palette Attributes
	RGBQUAD m_rgbPalette[256];
	CPalette m_Palette;

	// Bitmap Attributes
	CBitmap* m_pOldBitmap;

// Operations
protected:
	void InitFire(int nColor);
	CPalette* GetPalette();
	void RenderFlame();
	void PaintFlame(CDC* pDC = NULL);
	void SetMaxBurn(int nMax);
	int GetMaxBurn();
	CSize GetBitmapSize();
    void delay(int nCount);
    
private:    
	void CreateBitmap();
	
protected:              
    void ReleaseItem();
	void CreatePalette(int nColor);
    void PaintDIBitmap(HDC hDC);
	void BurnPoint(BYTE* pRow, BYTE* pNextRow);
    virtual void AutoClose(CPoint point);
	// This function replaces the crt lib rand() function.
	// The CRT lib function is very slow.  Since rand() is
	// one of the most frequently called functions it was
	// necessary to optimize it.  This function may be
	// inlined and is computationally simple.
	unsigned long Rand();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFireWnd)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CFireWnd();

	// Generated message map functions
protected:
     virtual void PostNcDestroy();
	//{{AFX_MSG(CFireWnd)
	afx_msg int  OnCreate(LPCREATESTRUCT pcs);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnPaint();
	afx_msg void OnNcPaint();
	afx_msg void OnDestroy();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg BOOL OnQueryNewPalette();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnClose();
	afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
	afx_msg void OnNcRButtonDown(UINT nHitTest, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

inline unsigned long CFireWnd::Rand()
{
	// Using the current seed, generate a new random value
	// and seed and return it.  The random value is shifted
	// to reduce some of the noise and produce a more
	// realistic flame.
	return (m_RandSeed = 1664525L * m_RandSeed + 1013904223L) >> 5;
}

inline void CFireWnd::BurnPoint(BYTE* pRow, BYTE* pNextRow)
{
	BYTE* pTarget;

	int off = int(Rand() % (m_nDistribution + 1));

	int val = m_nDecay + 1;
	val = int(Rand() % val);
	val = *pNextRow - val;

	if (Rand() & 1)
		pTarget = pRow + off;
	else
		pTarget = pRow - off;

	if (val > 16)
		*pTarget = (BYTE)val;
	else
		*pTarget = 16;
}

inline BOOL CFireWnd::IsWindowOpen()
{
    return m_bOpen;
}

inline void CFireWnd::CloseFireWnd()
{
    PostMessage(WM_CLOSE);
}
/////////////////////////////////////////////////////////////////////////////
