/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FMTHEX.CPP   1.13   13 Dec 1996 11:18:30   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FMTHEX.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:30   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:30   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:48   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:20   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:36   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:32   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:02   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:52   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:58   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:26   ZJRD
** PIC/SLD Version 0.20
**
****************************************************************************/

/****************************************************************************
**
**  Name:      FmtHex.cpp
**
**  Description:  This file describe the hexadecimal string class. Deprivde
**                from the class CFormatString.
**                This class process the hex string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/04        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatHexStr                                                    **
 **       Constructor of the CFormatHexStr                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(CString& str)
{
   m_strOriginHexStr = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatHexStr                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(char* lpsz)
{
   m_strOriginHexStr = lpsz;
}

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        COnvert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatHexStr :: Convert()      // Process the convert
{
   char *psz1 = new char[m_strOriginHexStr.GetLength()+2];
   char *psz2 = new char[m_strOriginHexStr.GetLength()+2];
   
   ASSERT(NULL != psz1);
   ASSERT(NULL != psz2);
   memset(psz1, 0, m_strOriginHexStr.GetLength()+2);
   memset(psz2, 0, m_strOriginHexStr.GetLength()+2);
   strcpy(psz1, m_strOriginHexStr.GetBuffer(m_strOriginHexStr.GetLength()));
   strcpy(psz2, psz1+2);   //Skip head leading '0x'
   m_bIsOk = Hex2Num(psz2, m_dwData);
   delete []psz1;
   delete []psz2;
   
   return;
}

