/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FMTSYM.CPP   1.13   13 Dec 1996 11:18:32   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FMTSYM.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:32   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:32   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:50   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:44   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:24   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:12   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:26   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:02   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:40   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:04   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:10   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:36   ZJRD
** PIC/SLD Version 0.20
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Fmtsym.cpp
**
**  Description:  This file describe the symbol string class. Deprivde
**                from the class CFormatString.
**                This class process the symbol string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/11        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file
//#include "symuser.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern int SymToAddr(char *lpStr , unsigned char* lpType , DWORD* lpAddr);
extern int GetUserVarValue(char*, short&);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatSymbol                                                    **
 **       Constructor of the CFormatSymbol                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const CString& str)
{
   m_strOriginSymbol = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatSymbol                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const char* lpsz)
{
   m_strOriginSymbol = lpsz;
}

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        Convert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatSymbol :: Convert()      // Process the convert
{
   char *psz = new char[m_strOriginSymbol.GetLength()+2];
   DWORD dwNum = 0;

   ASSERT(NULL != psz);
   strcpy(psz, m_strOriginSymbol.GetBuffer(m_strOriginSymbol.GetLength()));
   
   //
   // Call Symbol Server
   // Symbol To Address
   //        
   short uSymbolData = 0;
   
   switch (m_uSymData) {
      case  0:             // Symbol (# as leading char)
            if (0 == ::SymToAddr(psz, &m_uchType, &m_dwData))
               m_bIsOk = TRUE;
            else
               m_bIsOk = FALSE;   
            break;               
            
      case  1:             // Symbol Data ($ as leading char)
            if (0 == ::GetUserVarValue(psz, uSymbolData)) {
               m_dwData = (DWORD)uSymbolData;
               m_bIsOk = TRUE;
            }               
            else
               m_bIsOk = FALSE;   
            break;               
   }            
      
   delete []psz;
}
