 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/GREGVW.H__   1.11   13 Dec 1996 11:18:34   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/GREGVW.H__  $
** 
**    Rev 1.11   13 Dec 1996 11:18:34   ZJRD
** No change.
** 
**    Rev 1.10   22 Nov 1996 10:59:34   ZJRD
** No change.
** 
**    Rev 1.9   11 Nov 1996 12:46:52   ZJRD
** No change.
** 
**    Rev 1.8   06 Nov 1996 12:58:46   ZJRD
** No change.
** 
**    Rev 1.7   02 Nov 1996 09:48:46   ZJRD
** No change.
** 
**    Rev 1.6   30 Oct 1996 12:51:12   ZJRD
** No change.
** 
**    Rev 1.5   28 Oct 1996 09:44:02   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   21 Oct 1996 09:18:10   ZJRD
** No change.
** 
**    Rev 1.3   09 Oct 1996 13:47:44   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.2   23 Sep 1996 10:37:14   ZJRD
** No change.
** 
**    Rev 1.1   06 Sep 1996 13:52:02   ZJRD
** No change.
** 
**    Rev 1.0   02 Sep 1996 11:33:08   ZJRD
** Initial revision.
**
****************************************************************************/

// memwivw.h : interface of the CGRegView class
//
/////////////////////////////////////////////////////////////////////////////
//#include "cpuserve.h"
#ifndef __GPRF__
#define __GPRF__
#include "gregwnd.h"
#endif

#define BANKWIDTH  40   
	
class CGRegView : public CView
{
protected: // create from serialization only
	CGRegView();
	DECLARE_DYNCREATE(CGRegView)

// Attributes
public:
    CString m_searchStr;

// Operations
public:

// Implementation
public:
	virtual ~CGRegView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
    CPoint m_ptFirst; 
    CSize m_szScroll;
//    CMemLayout * m_pMemLayout;
    CRect m_rectClient; 
    int m_nCellEndPos; 
    BOOL m_isSelected;

public:
	int m_nCellsPerLine;  //8 or 16
    BOOL m_isByte; 
	BOOL m_isSigned;
	int m_nHexORDec;           
private:
    
	int m_nLineHeight;
	int m_nColWidth; 
	int m_nAddrColWidth;
	CaretPos m_ptCaretPos; 
    CSize m_szFont;           


	int m_nFirstViewCol; 
	int m_nFirstViewLine;  
	int m_nLastViewLine;
//	int m_nEndLine;   

//  void DigitRefresh(int);	
	void SetCellEndPos();
	void CaretMove(int flag);  
    
    G_Register_Cell Caret2GReg(CaretPos);  
    CaretPos Point2Caret(CPoint pt);
    G_Register_Cell Point2Cell(CPoint);  
    void Caret2Rect(CaretPos cp,CRect& rect);
    void Addr2CaretPos(int address,CaretPos& cp);
// Operations
public:
    BOOL IsBankSeperator(int line);
    
// Implementation
public:
    int GetGridWidth();
	// Generated message map functions
protected:          
    void GotoAddress(long address); 
	BOOL CaretOnWndEdge();
	BOOL InputCheck( UINT nChar,int N, BOOL bSign,BOOL isByte); 
	void DrawGrid(CDC* pDC,int nCols,int nRows);
	void DrawLine(CDC* pDC,int line,UINT ,BYTE*,int num);  
	void DrawNewData(CDC* pDC);
	void SetMemCaretPos(CaretPos);
	
	BOOL HitTest(CPoint);
	//{{AFX_MSG(CGRegView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnViewSigned();
	afx_msg void OnViewUnsigned();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditSearch();
	afx_msg void OnEditSearchnext();
	afx_msg void OnEditGoto();
	afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
	afx_msg void OnGroupMemory();
	afx_msg void OnViewHexadecimal();
	afx_msg void OnViewByte();
	afx_msg LONG OnXMRepaint(UINT /*wParam*/, LONG /*lParam*/);
	afx_msg void OnViewWord();
	afx_msg void OnUpdateViewWord(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewByte(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewRefresh();
	//}}AFX_MSG
//	afx_msg LONG ONTmRefresh(UINT w,LONG l);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in memwivw.cpp
#endif

/////////////////////////////////////////////////////////////////////////////
