 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/HEAP.H__   1.13   13 Dec 1996 11:18:36   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/HEAP.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:36   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:36   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:52   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:48   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:16   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:20   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:44   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:28   ZJRD
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  heap.h
**
**  Description:
**     prototypes for Malloc() and Free() routines.
**
**  Status:  CODED
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/HEAP.H__   1.13   13 Dec 1996 11:18:36   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HEAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  TFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via Malloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**        randomPointer: A pointer returned by Malloc().
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**     ER_NOT_FOUND       -- could not find pointer info.  Is it ours?
**     ER_HEAP_CORRUPT    -- someone wrote outside of their allocation,
**                           and all over our internal data structures.
**                           This is FATAL for us!!
**
*****************************************************************************/
RETCODE EXPORT TFree( LPSTR randomPointer ) ;



/****************************************************************************
**
**  TMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the heap!!
**
**  Parameters:
**     input:
**        numBytes: the number of bytes to allocate (< 64KB)
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/
LPSTR EXPORT TMalloc( U32 numBytes ) ;   /* numBytes < 64 KB */


#ifdef __cplusplus
}
#endif

#define _HEAP_
#endif
/******************************** E O F ***********************************/
