 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/INDEXTBL.H__   1.13   13 Dec 1996 11:18:40   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/INDEXTBL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:40   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:40   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:58   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:52   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:24   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:46   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:52   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:26   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:46   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:34   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:08   ZJRD
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: indextbl.h
**
** Title: Index Table
**
** Purpose:
**  Supports the creation of a Base Index Table and Type Index Table and
**  provides methods for adding an index and retrieving an offset for an index
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/PICSLDV/SRC/LOG/INDEXTBL.H__   1.13   13 Dec 1996 11:18:40   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _INDEXTBL_
                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include "memmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 TABLE_INDEX;                     // may be large numbers of types


                  /*********************************************
                   *                                           *
                   *   MEMBER FUNCTION PROTOTYPES AND INLINES  *
                   *                                           *
                   *********************************************/

class IndexTable : public Table {

private:
   U32 entryCount;            // number of entries in the table

protected:
   U32 maxIndex;              // largest index allowed

public:
//---------------------------------------------------------------------------
// IndexTable
//
// Purpose:
//    Initialize index table variables to default values.
//    Does not create the table or fix up the size (SetIndexTableSize)
//      because a constructor cannot return a parameter, and there can
//      be an out-of-memory error resulting from creation of table.
//---------------------------------------------------------------------------
IndexTable();    // constructor


//---------------------------------------------------------------------------
// GetEntryCount
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the index entries put into the
//    table so far.
//---------------------------------------------------------------------------
U32 GetEntryCount() { return entryCount; };


//---------------------------------------------------------------------------
// AddIndex
//
// Purpose:
//    Add an index into the index table with its offset to the item.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//    itemOffset: offset into the symbol table to be stored at table[index]
//
// Output parameters: None
//
// Error:
//    Reports ER_INDEX_ALREADY_EXISTS if the index already has a legitimate
//    value in the index location in the table.
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the maximum table size
//------------------------------------------------------------------------
RETCODE AddIndex(TABLE_INDEX index, TABLE_OFFSET itemOffset);


//---------------------------------------------------------------------------
// GetOffset
//
// Purpose:
//    Retrieve offset of item in symbol table given the index to the index
//    table.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the table size
//------------------------------------------------------------------------
RETCODE GetOffset(TABLE_INDEX index, TABLE_OFFSET& itemOffset);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetMaxIndex
//
// Purpose:
//    Set the maximum index value <maxIndex>
//------------------------------------------------------------------------
VOID SetMaxIndex(U32 index)  { maxIndex = index; };


//---------------------------------------------------------------------------
// UpdateOffset
//
// Purpose:
//    Updates the table offset of the type index specified.  This is to
//    be used by the type table manager when creating new types.  If a 
//    type extends past a 64k boundary the type offset needs to be modified.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//    newOffset: TABLE_OFFSET to be inserted in place of the existing value.
//
// Output parameters:
//    none:
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the table size
//------------------------------------------------------------------------
RETCODE UpdateOffset(TABLE_INDEX index, TABLE_OFFSET newOffset);

};
#define _INDEXTBL_
#endif
/******************************** E O F *************************************/
