
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/JSYNLIB.H__   1.13   13 Dec 1996 11:18:42   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/JSYNLIB.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:42   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:42   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:58   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:54   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:00   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:24   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:12   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:26   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:00   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:38   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:02   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:10   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.H
//
//  Description: The header file for the class: CSyntaxLibJ.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLibJ.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNLIB_
#define _SYNLIB_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxLibJ class.
class CSyntaxLibJ : public CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxLibJ();
    ~CSyntaxLibJ();
    
// Member variables.
public:
    // Local macro definition.
    enum { MAX_FILL_SIZE = 32 };
    
    // Maximum of the memory type.
    unsigned long m_ulMaxTypeP;
    unsigned long m_ulMaxTypeX;
    unsigned long m_ulMaxTypeI;
    unsigned long m_ulMaxTypeR;
    unsigned long m_ulMaxTypeB;
    
// Implementations.
public:
    unsigned long StrToVar(char* pszConvStr) const;

    // Syntax check lib routine.
    BOOL IsAddr(char* pszArgv) const;
    BOOL IsPAddr(char* pszArgv) const;
    BOOL IsPAddrDefault(char* pszArgv) const;
    BOOL IsXAddr(char* pszArgv) const;
    BOOL IsXAddrDefault(char* pszArgv) const;
    BOOL IsIAddr(char* pszArgv) const;
    BOOL IsRAddr(char* pszArgv) const;
    BOOL IsBAddr(char* pszArgv) const;
    BOOL IsBAddrDefault(char* pszArgv) const;

    BOOL IsAddrLen(char* pszArgv) const;
    BOOL IsKeywordLength(char* pszArgv) const;
    BOOL IsLengthRange(char* pszAddr, char* pszLen) const;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2) const;
    
    BOOL IsMapStartAddr(char* pszArgv) const;
    BOOL IsMapEndAddr(char* pszArgv) const;
    BOOL IsMapAddrLen(char* pszArgv) const;
    BOOL IsMapMemType(char* pszArgv) const;
    BOOL IsMapAttr(char chType, char* pszArgv) const;
    
    BOOL IsRegName(char* pszRegName) const;
    BOOL IsRegData(char* pszRegName, char* pszRegData) const;
    
    BOOL IsKeywordAll(char* pszArgv) const;
    
    BOOL IsFilename(char* pszArgv) const;
    BOOL IsLoadOption(int nArgc, char* pszArgv[]) const;
    BOOL IsModuleName(char* pszArgv) const;
    
    BOOL IsArgument(char* pszArgv) const;
    BOOL IsBackLevel(char* pszArgv) const;
    BOOL IsVariableName(char* pszArgv) const;
    
    BOOL IsData(char* pszArgv) const;
    BOOL IsDataBit(char* pszArgv) const;
    BOOL IsDataWord(char* pszArgv) const;
    BOOL IsDataLong(char* pszArgv) const;
    BOOL IsString(char* pszArgv) const;
    BOOL IsDataRange(int nArgc, char* pszArgv[]) const;
    BOOL IsStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordInsensitive(char* pszArgv) const;
    BOOL IsCaseStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordRun(char* pszArgv) const;
    BOOL IsKeywordFrom(char* pszArgv) const;
    BOOL IsKeywordTill(char* pszArgv) const;
    
    BOOL IsKeywordOver(char* pszArgv) const;
    BOOL IsKeywordForever(char* pszArgv) const;
    BOOL IsKeywordRet(char* pszArgv) const;
    BOOL IsKeywordCall(char* pszArgv) const;
    BOOL IsStepCount(char* pszArgv) const;
    BOOL IsAddrData(char* pszArgv) const;
    
    BOOL IsKeywordInstruction(char* pszArgv) const;
    BOOL IsKeywordStatement(char* pszArgv) const;
    BOOL IsKeywordLine(char* pszArgv) const;
    
    BOOL IsKeywordWith(char* pszArgv) const;
    BOOL IsKeywordClear(char* pszArgv) const;
    
    BOOL IsEventID(char* pszArgv) const;
    BOOL IsKeywordHigh(char* pszArgv) const;
    BOOL IsKeywordLow(char* pszArgv) const;
    BOOL IsKeywordRange(char* pszArgv) const;
    BOOL IsWildcardAddr(char* pszArgv) const;
    BOOL IsWildcardData(char* pszArgv) const;
    BOOL IsEventData(char* pszArgv) const;
    
    BOOL IsListOption(char* pszArgv) const;
    BOOL IsListFrame(char* pszArgv) const;
    
    BOOL IsKeywordTrace(char* pszArgv) const;
    BOOL IsKeywordTimer(char* pszArgv) const;
    BOOL IsKeywordOn(char* pszArgv) const;
    BOOL IsKeywordOff(char* pszArgv) const;
    BOOL IsEventSequence(char* pszArgv) const;

    BOOL IsKeywordReset(char* pszArgv) const;
    BOOL IsKeywordEa(char* pszArgv) const;
    BOOL IsKeywordEnable(char* pszArgv) const;
    BOOL IsKeywordDisable(char* pszArgv) const;
    BOOL IsKeywordBit(char* pszArgv) const;
    BOOL IsKeywordByte(char* pszArgv) const;

    BOOL IsCpuModule(char* pszArgv) const;
    BOOL IsPort(char* pszArgv) const;
    BOOL IsBitNo(char* pszArgv) const;
    BOOL IsBitData(char* pszArgv) const;
    BOOL IsByteData(char* pszArgv) const;
    
    BOOL IsKeywordGlobal(char* pszArgv) const;
    BOOL IsLineNo(char* pszArgv) const;

    BOOL IsKeywordClose(char* pszArgv) const;
    BOOL IsKeywordAppend(char* pszArgv) const;
    BOOL IsKeywordCommand(char* pszArgv) const;

    BOOL IsKeywordLv1(char* pszArgv) const;
    BOOL IsKeywordLv2(char* pszArgv) const;
    BOOL IsKeywordForward(char* pszArgv) const;
    BOOL IsKeywordBackward(char* pszArgv) const;
    BOOL IsKeywordCenter(char* pszArgv) const;
    BOOL IsKeywordDelay(char* pszArgv) const;
    BOOL IsKeywordThen(char* pszArgv) const;
    
    BOOL IsKeywordModule(char* pszArgv) const;
    
    BOOL IsCommand(char* pszArgv) const;

};  // End of class: CSyntaxLibJ.

#endif
//////////////////////////////// End of File ////////////////////////////////
