/*************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/LDRPIC.H__   1.13   13 Dec 1996 11:18:46   ZJRD  $   
**
**    $Log:   D:/PICSLDV/SRC/LOG/LDRPIC.H__  $   
** 
**    Rev 1.13   13 Dec 1996 11:18:46   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:46   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:04   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:58   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:52   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:40   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:50   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.4   23 Sep 1996 10:36:34   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:14   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:26   ZJRD
** PIC/SLD Version 0.20
** 
**************************************************************************/

/****************************************************************************
**
**  Name:  ldrpic.cpp
**
**  Description:
**      Defines the class behaviors for the application for pic loader.
**
**  Status:  CODED
**
**  Author:  Daniel Lin
**
**  Date:    15 May, 1996
**    Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
/*
char *SymbolTypes[152] = {
     "A_REG                   \r\n\0" ,    //0 register ??? 
     "X_REG                   \r\n\0" ,    //1 register ???
     "C_SHORT                 \r\n\0" ,    //2 int variable
     "C_LONG                  \r\n\0" ,    //3 long variable
     "C_USHORT                \r\n\0" ,    //4 char, unsigned char/int variable
     "C_ULONG                 \r\n\0" ,    //5 unsigned long variable
     "C_POINTER               \r\n\0" ,    //6 int/long pointer
     "C_UPOINTER              \r\n\0" ,    //7 char, usigned char/int pointer
     "TABLE                   \r\n\0" ,    //8
     "M_BYTE                  \r\n\0" ,    //9
     "M_BOOLEAN               \r\n\0" ,    //10
     "M_INDEX                 \r\n\0" ,    //11
     "BYTE_ARRAY              \r\n\0" ,    //12 char/int array. eg. int iArray[10]
     "U_BYTE_ARRAY            \r\n\0" ,    //13 char, unsigned char/int array
     "WORD_ARRAY              \r\n\0" ,    //14 long array
     "U_WORD_ARRAY            \r\n\0" ,    //15 usigned long array
     "FUNC_VOID_NONE          \r\n\0" ,    //16 void func(void) or void func()
     "FUNC_VOID_BYTE          \r\n\0" ,    //17 void func(int) or void func(char)
     "FUNC_VOID_TWOBYTE       \r\n\0" ,    //18 two parameter: void func(int, int)
     "FUNC_VOID_LONG          \r\n\0" ,    //19 void func(long):not support
     "FUNC_VOID_UNDEF         \r\n\0" ,    //20 ????
     "FUNC_INT_NONE           \r\n\0" ,    //21 int func(void) or int func()
     "FUNC_INT_BYTE           \r\n\0" ,    //22 int func(int) or int func(char)
     "FUNC_INT_TWOBYTE        \r\n\0" ,    //23 two parameter: int func(int, int)
     "FUNC_INT_LONG           \r\n\0" ,    //24 int func(long):not support
     "FUNC_INT_UNDEF          \r\n\0" ,    //25 ????
     "FUNC_LONG_NONE          \r\n\0" ,    //26 long func(void) or int func()
     "FUNC_LONG_BYTE          \r\n\0" ,    //27 long func(int) or int func(char)
     "FUNC_LONG_TWOBYTE       \r\n\0" ,    //28 two parameter: long func(int, int)
     "FUNC_LONG_LONG          \r\n\0" ,    //29 long func(long):not support
     "FUNC_LONG_UNDEF         \r\n\0" ,    //30
     "PFUN_VOID_NONE          \r\n\0" ,    //31
     "PFUN_VOID_BYTE          \r\n\0" ,    //32
     "PFUN_VOID_TWOBYTE       \r\n\0" ,    //33
     "PFUN_VOID_LONG          \r\n\0" ,    //34
     "PFUN_VOID_UNDEF         \r\n\0" ,    //35
     "PFUN_INT_NONE           \r\n\0" ,    //36
     "PFUN_INT_BYTE           \r\n\0" ,    //37
     "PFUN_INT_TWOBYTE        \r\n\0" ,    //38
     "PFUN_INT_LONG           \r\n\0" ,    //39
     "PFUN_INT_UNDEF          \r\n\0" ,    //40
     "PFUN_LONG_NONE          \r\n\0" ,    //41
     "PFUN_LONG_BYTE          \r\n\0" ,    //42
     "PFUN_LONG_TWOBYTE       \r\n\0" ,    //43
     "PFUN_LONG_LONG          \r\n\0" ,    //44
     "PFUN_LONG_UNDEF         \r\n\0" ,    //45
     "ADDRESS                 \r\n\0" ,    //46
     "CONSTANT                \r\n\0" ,    //47 eg. #define; const int; enum element
     "BAD_UND                 \r\n\0" ,    //48
     "BR_UND                  \r\n\0" ,    //49
     "UPPER_UND               \r\n\0" ,    //50
     "BYTE_UND                \r\n\0" ,    //51
     "ADD_UND                 \r\n\0" ,    //52
     "M_KEYWORD               \r\n\0" ,    //53
     "ADD_MI_UND              \r\n\0" ,    //54
     "VECTOR                  \r\n\0" ,    //55
     "PORT_W                  \r\n\0" ,    //56 port_w   register
     "PORT_R                  \r\n\0" ,    //67 port_r   register
     "PORT_RW                 \r\n\0" ,    //58 port_rw  register
     "PORT_RMW                \r\n\0" ,    //59 port_rmw register
     "ENDIF                   \r\n\0" ,    //60
     "EXUNDEF                 \r\n\0" ,    //61
     "MACRO_S                 \r\n\0" ,    //62
     "MACRO_A                 \r\n\0" ,    //63
     "MACRO_C                 \r\n\0" ,    //64
     "C_KEYWORD               \r\n\0" ,    //65
     "uVOID                   \r\n\0" ,    //66
     "C_ENUM                  \r\n\0" ,    //67 typedef of enum. eg. enum ENUM,
     "C_TYPEDEF1              \r\n\0" ,    //68
     "C_UTYPEDEF1             \r\n\0" ,    //69
     "C_TYPEDEF2              \r\n\0" ,    //70
     "C_UTYPEDEF2             \r\n\0" ,    //71
     "CP_TYPEDEF1             \r\n\0" ,    //72
     "CP_UTYPEDEF1            \r\n\0" ,    //73
     "CP_TYPEDEF2             \r\n\0" ,    //74
     "CP_UTYPEDEF2            \r\n\0" ,    //75
     "C_STRUCT                \r\n\0" ,    //76 struct/union typedef
     "I_STRUCT                \r\n\0" ,    //77 variable of struct/union
     "L_CONST                 \r\n\0" ,    //78
     "S_SHORT                 \r\n\0" ,    //79 int element int struct/union
     "S_USHORT                \r\n\0" ,    //80 char, unsigned char/int elment
     "S_LONG                  \r\n\0" ,    //81 long element in struct/union
     "S_ULONG                 \r\n\0" ,    //82 unsigned long in struct/union
     "SA_SHORT                \r\n\0" ,    //83
     "SA_USHORT               \r\n\0" ,    //84
     "SA_LONG                 \r\n\0" ,    //85
     "SA_ULONG                \r\n\0" ,    //86
     "SP_SHORT                \r\n\0" ,    //87
     "SP_USHORT               \r\n\0" ,    //88
     "SP_LONG                 \r\n\0" ,    //89
     "SP_ULONG                \r\n\0" ,    //90
     "FIXEDPOINTER            \r\n\0" ,    //91
     "POINTERFUNCTION         \r\n\0" ,    //92
     "CC_REG                  \r\n\0" ,    //93
     "PTRF_VOID_NONE          \r\n\0" ,    //94
     "PTRF_VOID_BYTE          \r\n\0" ,    //95
     "PTRF_VOID_TWOBYTE       \r\n\0" ,    //96
     "PTRF_VOID_LONG          \r\n\0" ,    //97
     "PTRF_VOID_UNDEF         \r\n\0" ,    //98
     "PTRF_INT_NONE           \r\n\0" ,    //99
     "PTRF_INT_BYTE           \r\n\0" ,    //100
     "PTRF_INT_TWOBYTE        \r\n\0" ,    //101
     "PTRF_INT_LONG           \r\n\0" ,    //102
     "PTRF_INT_UNDEF          \r\n\0" ,    //103
     "PTRF_LONG_NONE          \r\n\0" ,    //104
     "PTRF_LONG_BYTE          \r\n\0" ,    //105
     "PTRF_LONG_TWOBYTE       \r\n\0" ,    //106
     "PTRF_LONG_LONG          \r\n\0" ,    //107
     "PTRF_LONG_UNDEF         \r\n\0" ,    //108
     "PFAR_VOID_NONE          \r\n\0" ,    //109
     "PFAR_VOID_BYTE          \r\n\0" ,    //110
     "PFAR_VOID_TWOBYTE       \r\n\0" ,    //111
     "PFAR_VOID_LONG          \r\n\0" ,    //112
     "PFAR_VOID_UNDEF         \r\n\0" ,    //113
     "PFAR_INT_NONE           \r\n\0" ,    //114
     "PFAR_INT_BYTE           \r\n\0" ,    //115
     "PFAR_INT_TWOBYTE        \r\n\0" ,    //116
     "PFAR_INT_LONG           \r\n\0" ,    //117
     "PFAR_INT_UNDEF          \r\n\0" ,    //118
     "PFAR_LONG_NONE          \r\n\0" ,    //119
     "PFAR_LONG_BYTE          \r\n\0" ,    //120
     "PFAR_LONG_TWOBYTE       \r\n\0" ,    //121
     "PFAR_LONG_LONG          \r\n\0" ,    //122
     "PFAR_LONG_UNDEF         \r\n\0" ,    //123
     "FWDLIT                  \r\n\0" ,    //124
     "PFUNC                   \r\n\0" ,    //125
     "MGOTO                   \r\n\0" ,    //126
     "MCGOTO                  \r\n\0" ,    //127
     "MCGOTO2                 \r\n\0" ,    //128
     "MCGOTO3                 \r\n\0" ,    //129
     "MCGOTO4                 \r\n\0" ,    //130
     "MCGOTO74                \r\n\0" ,    //131
     "MCGOTO17                \r\n\0" ,    //132
     "MCCALL17                \r\n\0" ,    //133
     "MCALL                   \r\n\0" ,    //134
     "MC_CALL                 \r\n\0" ,    //135
     "RES_WORD                \r\n\0" ,    //136
     "LOCAL                   \r\n\0" ,    //137
     "PICUNKNOWN              \r\n\0" ,    //138
     "VARLABEL                \r\n\0" ,    //139
     "EXTERN                  \r\n\0" ,    //140
     "GLOBAL                  \r\n\0" ,    //141
     "SEGMENT                 \r\n\0" ,    //142
     "BANKADDR                \r\n\0" ,    //143
     "BIT_0                   \r\n\0" ,    //145
     "BIT_1                   \r\n\0" ,    //146
     "BIT_2                   \r\n\0" ,    //147
     "BIT_3                   \r\n\0" ,    //148
     "BIT_4                   \r\n\0" ,    //149
     "BIT_5                   \r\n\0" ,    //150
     "BIT_6                   \r\n\0" ,    //151
     "BIT_7                   \r\n\0"      //152
};
*/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#ifndef PICWORD
    #define PICWORD    unsigned int
#endif

#ifndef PICBYTE
    #define PICBYTE    unsigned char
#endif

#ifndef PICLONG
    #define PICLONG    long
#endif

#ifndef PICBOOL
    #define PICBOOL    int
#endif    

#ifndef FALSE
   #define FALSE  0
#endif

#ifndef TRUE
   #define TRUE   !FALSE
#endif
                        
#define     NoticeLength    63
#define     VersionLength   19
#define     CompilerLength  11
#define     SourceLength    63
#define     SpareLength     41
#define     BLOCKSIZE       512


//
// The block has 512 bytes
// This structure descript the directroy block's information 
// in .cod file
//
typedef struct tagDirectoryBlock {      
/* Type     Name                        Bytes Description */

   PICWORD     Index[128];                 // 256  Index[]
   char        SourceLen;                  // 1    Source file name length
   char        Source[SourceLength];       // 63   Source file name
   char        DateLen;                    // 1    Date string length
   char        Date[7];                    // 7    Date string
   PICWORD     Time;                       // 2    Time(hour=Time/100;Min=Time%100
   char        VersionLen;                 // 1    Version string length
   char        Version[VersionLength];     // 19   Version string
   char        CompilerLen;                // 1    Compiler string length
   char        Compiler[CompilerLength];   // 11   Compiler which produce the file
   char        NoticeLen;                  // 1    Notice string length
   char        Notice[NoticeLength];       // 63   Notice string(include Copyright)
   PICWORD     Symtab;                     // 2    the first symbol block number
   PICWORD     Symend;                     // 2    the last symbol block number
   PICWORD     Namtab;                     // 2    the first source file name block
   PICWORD     Namend;                     // 2    the last source file name block
   PICWORD     Lsttab;                     // 2    the first line infor block
   PICWORD     Lstend;                     // 2    the last line infor block
   PICBYTE     Addrsize;                   // 1    always 0
   PICWORD     HighAddr;                   // 2    upper 16 bits
   PICWORD     NextDir;                    // 2    another directory block
   PICWORD     MemMapOfs;                  // 2    the first memory map block
   PICWORD     MemMapend;                  // 2    the last memory map block
   PICWORD     LocalVARS;                  // 2    the first local symbol infor
   PICWORD     Localend;                   // 2    the last local symbol infor
   PICWORD     CODType;                    // 2    .cod file type
   char        ProcessorLen;               // 1    processor string length
   char        Processor[8];               // 8    the processor string
   PICWORD     LSymTab;                    // 2    first long symbol infor block
   PICWORD     LSymEnd;                    // 2    last long symbol infor block
   PICWORD     MessTab;                    // 2    first debug message block
   PICWORD     MessEnd;                    // 2    last debug message block
   PICBYTE     Spare[SpareLength];         // 42   fill field(always zero)
}DirectoryBlock;

//
//Symbol information, in this struct, the symbol is truncted to a length of 12
//For the complete symbol names, refer to the long symbol table block
//
typedef struct tagSSymbol {             // 16 bytes
   char        NameLen;                    // 1
   char        SymbolName[12];             // 12   Symbol name
   PICBYTE     SymbolType;                 // 1    Symbol Type
   PICWORD     SymbolValue;                // 2    Symbol value
}SSymbol;

//
//File module name information
//
typedef struct tagNameTab {
   PICBYTE  namelen;                        // 1     Module name length
   char     modulename[63];                 // 64    Module name string
}NameTab;

//
// Line information
//
typedef struct tagLineInfor{
   PICBYTE     SourceNum;              // 1     the number indicate
                                        //       to the name tab index
   PICBYTE     Flag;                    // 1     describe the list file line
   PICWORD     SourceLine;              // 1     the line ot the source being
                                        //       assenbled.
   PICWORD     CodeAddress;             // 2     the native address of the first
                                        //       machine indtruction generated
                                        //       by the source line
}LineInfor;

//
// Local Symbol header define
//
typedef struct tagLocalVARSHead {                      // 16 bytes
   char     HeaderLen;                  // 1
   char     LocalHeader[7];             // always "__LOCAL"
   int      LStartAddress;              // 4 ????
   int      HStartAddress;
   int      LEndAddress;                // 4 ????
   int      HEndAddress;
}LocalVARSHead;

//
// Local variables information
//
/*
typedef struct tagLocalVars {
   LocalVARSHead  VarsHead;             // 16   local variables head information
   SSymbol        VarSymbol;            // 16   local variables symbol infor
}LocalVars;
*/

typedef struct tagLocalVars {
   LONG     lBlockStartAddress;
   LONG     lBlockEndAddress;
   SSymbol  VarSymbol;
}LocalVars;

enum tagSymbolTypes {
     A_REG = 0               ,    //0 register ???
     X_REG                   ,    //1 register ???
     C_SHORT                 ,    //2 int variable
     C_LONG                  ,    //3 long variable
     C_USHORT                ,    //4 char, unsigned char/int variable
     C_ULONG                 ,    //5 unsigned long variable
     C_POINTER               ,    //6 int/long pointer
     C_UPOINTER              ,    //7 char, usigned char/int pointer
     TABLE                   ,    //8
     M_BYTE                  ,    //9
     M_BOOLEAN               ,    //10
     M_INDEX                 ,    //11
     BYTE_ARRAY              ,    //12 char/int array. eg. int iArray[10]
     U_BYTE_ARRAY            ,    //13 char, unsigned char/int array
     WORD_ARRAY              ,    //14 long array
     U_WORD_ARRAY            ,    //15 usigned long array
     FUNC_VOID_NONE          ,    //16 void func(void) or void func()
     FUNC_VOID_BYTE          ,    //17 void func(int) or void func(char)
     FUNC_VOID_TWOBYTE       ,    //18 two parameter: void func(int, int)
     FUNC_VOID_LONG          ,    //19 void func(long):not support
     FUNC_VOID_UNDEF         ,    //20 ????
     FUNC_INT_NONE           ,    //21 int func(void) or int func()
     FUNC_INT_BYTE           ,    //22 int func(int) or int func(char)
     FUNC_INT_TWOBYTE        ,    //23 two parameter: int func(int, int)
     FUNC_INT_LONG           ,    //24 int func(long):not support
     FUNC_INT_UNDEF          ,    //25 ????
     FUNC_LONG_NONE          ,    //26 long func(void) or int func()
     FUNC_LONG_BYTE          ,    //27 long func(int) or int func(char)
     FUNC_LONG_TWOBYTE       ,    //28 two parameter: long func(int, int)
     FUNC_LONG_LONG          ,    //29 long func(long):not support
     FUNC_LONG_UNDEF         ,    //30
     PFUN_VOID_NONE          ,    //31
     PFUN_VOID_BYTE          ,    //32
     PFUN_VOID_TWOBYTE       ,    //33
     PFUN_VOID_LONG          ,    //34
     PFUN_VOID_UNDEF         ,    //35
     PFUN_INT_NONE           ,    //36
     PFUN_INT_BYTE           ,    //37
     PFUN_INT_TWOBYTE        ,    //38
     PFUN_INT_LONG           ,    //39
     PFUN_INT_UNDEF          ,    //40
     PFUN_LONG_NONE          ,    //41
     PFUN_LONG_BYTE          ,    //42
     PFUN_LONG_TWOBYTE       ,    //43
     PFUN_LONG_LONG          ,    //44
     PFUN_LONG_UNDEF         ,    //45
     ADDRESS                 ,    //46
     CONSTANT                ,    //47 eg. #define; const int; enum element
     BAD_UND                 ,    //48
     BR_UND                  ,    //49
     UPPER_UND               ,    //50
     BYTE_UND                ,    //51
     ADD_UND                 ,    //52
     M_KEYWORD               ,    //53
     ADD_MI_UND              ,    //54
     VECTOR                  ,    //55
     PORT_W                  ,    //56 port_w   register
     PORT_R                  ,    //67 port_r   register
     PORT_RW                 ,    //58 port_rw  register
     PORT_RMW                ,    //59 port_rmw register
     ENDIF                   ,    //60
     EXUNDEF                 ,    //61
     MACRO_S                 ,    //62
     MACRO_A                 ,    //63
     MACRO_C                 ,    //64
     C_KEYWORD               ,    //65
     uVOID                   ,    //66
     C_ENUM                  ,    //67 typedef of enum. eg. enum ENUM,
     C_TYPEDEF1              ,    //68
     C_UTYPEDEF1             ,    //69
     C_TYPEDEF2              ,    //70
     C_UTYPEDEF2             ,    //71
     CP_TYPEDEF1             ,    //72
     CP_UTYPEDEF1            ,    //73
     CP_TYPEDEF2             ,    //74
     CP_UTYPEDEF2            ,    //75
     C_STRUCT                ,    //76 struct/union typedef
     I_STRUCT                ,    //77 variable of struct/union
     L_CONST                 ,    //78
     S_SHORT                 ,    //79 int element in struct/union
     S_USHORT                ,    //80 char, unsigned char/int elment
     S_LONG                  ,    //81 long element in struct/union
     S_ULONG                 ,    //82 unsigned long in struct/union
     SA_SHORT                ,    //83
     SA_USHORT               ,    //84
     SA_LONG                 ,    //85
     SA_ULONG                ,    //86
     SP_SHORT                ,    //87
     SP_USHORT               ,    //88
     SP_LONG                 ,    //89
     SP_ULONG                ,    //90
     FIXEDPOINTER            ,    //91
     POINTERFUNCTION         ,    //92
     CC_REG                  ,    //93
     PTRF_VOID_NONE          ,    //94
     PTRF_VOID_BYTE          ,    //95
     PTRF_VOID_TWOBYTE       ,    //96
     PTRF_VOID_LONG          ,    //97
     PTRF_VOID_UNDEF         ,    //98
     PTRF_INT_NONE           ,    //99
     PTRF_INT_BYTE           ,    //100
     PTRF_INT_TWOBYTE        ,    //101
     PTRF_INT_LONG           ,    //102
     PTRF_INT_UNDEF          ,    //103
     PTRF_LONG_NONE          ,    //104
     PTRF_LONG_BYTE          ,    //105
     PTRF_LONG_TWOBYTE       ,    //106
     PTRF_LONG_LONG          ,    //107
     PTRF_LONG_UNDEF         ,    //108
     PFAR_VOID_NONE          ,    //109
     PFAR_VOID_BYTE          ,    //110
     PFAR_VOID_TWOBYTE       ,    //111
     PFAR_VOID_LONG          ,    //112
     PFAR_VOID_UNDEF         ,    //113
     PFAR_INT_NONE           ,    //114
     PFAR_INT_BYTE           ,    //115
     PFAR_INT_TWOBYTE        ,    //116
     PFAR_INT_LONG           ,    //117
     PFAR_INT_UNDEF          ,    //118
     PFAR_LONG_NONE          ,    //119
     PFAR_LONG_BYTE          ,    //120
     PFAR_LONG_TWOBYTE       ,    //121
     PFAR_LONG_LONG          ,    //122
     PFAR_LONG_UNDEF         ,    //123
     FWDLIT                  ,    //124
     PFUNC                   ,    //125
     MGOTO                   ,    //126
     MCGOTO                  ,    //127
     MCGOTO2                 ,    //128
     MCGOTO3                 ,    //129
     MCGOTO4                 ,    //130
     MCGOTO74                ,    //131
     MCGOTO17                ,    //132
     MCCALL17                ,    //133
     MCALL                   ,    //134
     MC_CALL                 ,    //135
     RES_WORD                ,    //136
     LOCAL                   ,    //137
     PICUNKNOWN              ,    //138
     VARLABEL                ,    //139
     EXTERN                  ,    //140
     GLOBAL                  ,    //141
     SEGMENT                 ,    //142
     BANKADDR                ,    //143
     BIT_0                   ,    //145
     BIT_1                   ,    //146
     BIT_2                   ,    //147
     BIT_3                   ,    //148
     BIT_4                   ,    //149
     BIT_5                   ,    //150
     BIT_6                   ,    //151
     BIT_7                        //152
};


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
                        
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

class CPicLoader : public LoaderServer       // Derived from LoaderServer
{
// Attributes
public:
   CString  m_strCodFileName;    // The file name
   char* m_strFileName;
   CFile    m_CodeFile;          // The file handel
   int      m_nOnDemand;         // On demand load(always 1)
   int      m_nFlag;             // Load flag
   int      m_nLoadCode;         // Fill code to ICE
   CFileStatus m_nStatus;        // File status;
   int      m_nCodeBlock;        // Code block count
   char     *m_chBuffer;      // Store the binary code      
         
protected:
   UINT     m_nDirBlockCount;          // Directory block count
   UINT     m_nSSymBlockCount;         // Short symbol count
   UINT     m_nNameBlockCount;         // Name block count
   UINT     m_nLineBlockCount;         // Line number count
   UINT     m_nMapBlockCount;          // Map block count
   UINT     m_nLocalVarBlockCount;     // Local var count
   UINT     m_nLSymBlockCount;         // Long symbol count   
   UINT     m_nDbMsgBlockCount;        // Debug block count

   BOOL     m_bHaveGlobleSym;
   BOOL     m_bHaveNameBlock;
   BOOL     m_bHaveLineBlock;
   BOOL     m_bHaveMapBlock;
   BOOL     m_bHaveLocalVars;
   BOOL     m_bHaveLongSym;
   BOOL     m_bHaveDbMsg;
   
   DirectoryBlock m_dirBlock;    // Directory block
   
   SSymbol     **m_symBlock;     // Store every symbol block pointer
   LONG        **m_symbolPointer;// Point to every symbol block address
   
   NameTab     **m_nameTab;      // Store every name block pointer
   LONG        **m_namePointer;
   
   NameTab     **m_moduleBlock;  // For the module(Exclude lib file)
   int         m_nModuleCount;   // The module number
   int         m_nIndex[20];     
   
   LineInfor   **m_lineInfor;    // Store every lineinfor block pointer
   LONG        **m_linePointer;
   
   LocalVars   **m_localVars;    // Store every local vars lock pointer
   int         m_nVarsCount;

// Implementation   
public:
         CPicLoader();
         ~CPicLoader();   
   BOOL  DoLoad();      
   BOOL  LinkToSymbol();   
   void  InitPicLoader();
   void  FillCode();
   void  DeleteContent();
   void	 TestCancel();
      
protected:
   BOOL  OpenCodFile( CString& );
   void  GetDirBlock( DirectoryBlock* );
   void  GetSymbolShortInfor( PICWORD, SSymbol* );
   void  GetFileInfor( PICWORD, NameTab* );
   void  GetLineInfor( PICWORD, LineInfor* );
   void  GetLocalVarHead( LocalVARSHead* );
   void  GetLocalVars( SSymbol* );
   
   RETCODE  StartAddSymbol();
   void     EndAddSymbol();
   
   BOOL     LoadGlobleVariable();         // Store globle variable
   
   RETCODE  StartAddModule(int nModule);
   RETCODE  EndAddModule();

   BOOL     LoadPicFuncType(int nType);   
   BOOL     ConvertType(int nWhich, int nType, TYPE_INDEX& typeIndex);
   BOOL     ConvertGlobleType(int nWhich, int nType, TYPE_INDEX& typeIndex);
   
   BOOL     SymIsFunc(PICBYTE  nSymbolType);
   BOOL     IsStatement(const int flag);
   
   BOOL     IsPointer(int nWhich, int /*nType*/);
   BOOL     IsGloblePointer(int nWhich, int /*nType*/);
   BOOL     GetPointerType(int nPicTypeIndex, WORD& wSymTypeIndex);

   BOOL     SetLineInfor();
   BOOL     GetBlockInfor();
   BOOL     LocalVarIsFunction(const int nType);

   BOOL     GetStructType(int, int, WORD&);
   BOOL     GetGlobleStructType(int, int, WORD&);
   
   BOOL     IsStructElement(int nType);
   BOOL     ConvStrctElemtType(int nType, TYPE_INDEX& typeIndex);
   void     PreProcessStruct(int nWhich, int nPicTypeIndex, 
                             int& size, int& StructOrUnion);
   void     PreProcessGlobleStruct(int nWhich, int nPicTypeIndex, 
                                   int& size, int& StructOrUnion);
                             
   BOOL     GetArrayType(int nWhich, int nPicTypeIndex, 
                         WORD& wSymTypeIndex);
   BOOL     GetGlobleArrayType(int nWhich, int nPicTypeIndex, 
                               WORD& wSymTypeIndex);
                               
   BOOL     GetBitfieldType(WORD& wSymTypeIndex);
                         
   WORD     CalcArraySize(int, int);

   BOOL     SetLoadFileInfo(char * str);
};

//////////////////(EOF of PLOADER.H)///////////////////////

