////////////////////////////////////////////////////////////////////////
// CFireWnd window
//#include "utils.h"

class CLogoWnd : public CWnd
{
// Construction
public:
	CLogoWnd(DWORD dwDelay=30000, DWORD *dwSafePoint=NULL);
	BOOL CreateWnd(LPSTR lpszTitle, LPSTR lpszVer,int nTitleHeight, int nVerHeight);
    BOOL IsWindowOpen();               
    void CloseLogoWnd();
    virtual BOOL ProcessMsg(MSG *pMsg);
    virtual void AutoClose(CPoint point);


// Attributes
public:

protected:
	CString m_strTitle;
    CString m_strVer;          
    HFONT   m_hTitleFont;
    HFONT   m_hVerFont;
                  
protected:	
    //using attributes
	BOOL	m_bOpen;
	DWORD  *m_pdwSafePoint;
	BOOL	m_bQuitNow;
	BOOL	m_bCanClose;
			
protected:
    BOOL	InitGDI(); 
    BOOL	InitBitmap();
    BOOL	FreeGDI();
	
protected:	             
    //GDI attributs
    HDC     m_hViewDC; 
    HDC     m_hMemDC;
    HDC     m_hStarCDC;
    HDC     m_hStarMDC;
    HDC     m_hBackDC;
    HDC     m_hFlameDC;
    HBITMAP m_hStarCBit;
    HBITMAP m_hStarMBit;
    HBITMAP m_hMemBit;
    HBITMAP m_hBackBit;
    UINT	m_uTimerID;
    BITMAP  m_BackBitmapInfo;
    DWORD	m_dwExitDelay;
    
protected:
	// Device Context Attributes

	// Palette Attributes
	RGBQUAD m_rgbPalette[256];
	CPalette m_Palette;

	// Bitmap Attributes

// Operations
protected:
	virtual void PaintBitmap();
    HPALETTE CreatePalette(RGBQUAD FAR *rgbPalette,int nColor);

private:    
	void CreateBitmap();
	void delay(int nCount);
protected:              
    void ReleaseItem();
	void CreatePalette(int nColor);
    void PaintDIBitmap(HDC hDC);

// Implementation
public:
	virtual ~CLogoWnd();

	// Generated message map functions
protected:
     virtual void PostNcDestroy();
	//{{AFX_MSG(CFireWnd)
	afx_msg int  OnCreate(LPCREATESTRUCT pcs);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnPaint();
	afx_msg void OnNcPaint();
	afx_msg void OnDestroy();
//  afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
//	afx_msg BOOL OnQueryNewPalette();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
//	afx_msg void OnClose();
	afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
	afx_msg void OnNcRButtonDown(UINT nHitTest, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

inline BOOL CLogoWnd::IsWindowOpen()
{
    return m_bOpen;
}

inline void CLogoWnd::CloseLogoWnd()
{
    SendMessage(WM_CLOSE);
}
/////////////////////////////////////////////////////////////////////////////
