 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MAINFRM.CPP   1.13   13 Dec 1996 11:18:48   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MAINFRM.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:48   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.12   22 Nov 1996 10:59:48   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:06   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:02   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:46   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:50:08   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:56   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:10   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:46   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:10   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:24   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:32   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:10   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:19:24   ZJRD
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MAINFRM.CPP
//
//  Description:The implement file for the class: CMainFrame
//
//  Author:     Roger Zhang
//
//  Date:       03/05/95
//
//  Modification:
//
//      1. 07/23/95, Initial version 0.1  for PIC/SLD
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "zqueue.h"
#include "uicom.h"
#include "srccom.h"
#include "zlist.h"
#include "srclist.h"
#include "srcmdl.h"
#include "srcfile.h"
#include "meter.h"
#include "srcdlg1.h"
#include "btnbar.h"
#include "savecfg.h"
#include "trcgrpdi.h"
#include "srcgrp.h"
#include "mainfrm.h"
#include "loaddlg.h"
#include "tabdll11.h"   //lane
#include "tabvbmfc.h"
#include "grid.h"
#include "nwmemwnd.h"
#include "nwmem.h" // lane
#include "myedit2.h"
#include "spin.h"
#include "mapdlg.h"   
#include "toolsdlg.h"  

//added by john 96.3
#include "cpust.h"

// Added by Chen, phase-II, 03/21/96
#include "spagrp.h"
#include "diagnost.h"
#include "diagnres.h"
#include "mempage.h"
#include "memdlg.h"
#include "emumon.h"
#include "trigsvr.h"        //for TraceWnd, by chris

// Added by Chen, 06/21/96.
#include "spamsg.h"
#include "spafrm.h"
#include "spaline.h"
#include "spatdoc.h"
#include "spatvw.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

extern HHOOK hookStkKeyFilter;

void SaveConfig(LPCSTR filename, int option);
void LoadConfig(LPCSTR filename, int option);

void SrcPreStep(void);
BOOL CpuReset(WORD addr);
void ShlStopAsm(void);
void ShlRunInclude(const char * pszFileName);
    
void EmuServerGo(int nMode, unsigned short uAddr);
void EmuServerStepOver(long lCount);
void EmuServerHalt(void);
void EmuServerJump(unsigned short uAddr);
void EmuServerStep(long lCount);
    
void SaveAllConfig(void);
void RestoreAllConfig(void);

extern void MinAllMemWnd();
extern void ShellShowTop(void);

BOOL GetElapseTime(CString& strTime, int fromshell=0);
//void TraceWnd(unsigned char trace);

BOOL EditProject(CWnd *pParent);
BOOL NewProject(CWnd * pParent);
BOOL OpenProject(CWnd * pParent);
BOOL CloseProject(void);
BOOL ProjectValid(void);
void SetOption(CWnd *pParent);
void BuildProject(void);
void EditorProject(void);

BOOL g_bLoadFile=0;

extern  void ShlRunMacro(char *, int);
void NewMemoryOpenWindow(CMDIFrameWnd *pParent,int no);
extern STATUS  GetCurTraceBufferId(int& bufid);


// Added by Chen, 06/21/96.
extern int nFwSupport;
extern CSpaCodeFrame* pSpaCodeWnd;

void OpenCodeCoverageWindow(void);
void UpdateCodeCoverageWindow(const COVERAGEGETINFO& CodeGetData);


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
    //{{AFX_MSG_MAP(CMainFrame)
    ON_MESSAGE(XM_MDIACTIVE, OnXMMDIActive)
    ON_WM_CREATE()
    ON_UPDATE_COMMAND_UI(ID_INDICATOR_OVR, OnUpdateInsert)
    ON_COMMAND(ID_TOGGLE_INSERT, OnToggleInsert)
    ON_COMMAND(ID_FILE_INCLUDE, OnFileInclude)
    ON_WM_SETCURSOR()
    ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
    ON_COMMAND(ID_FILE_SAVECONFIGURATION, OnFileSaveconfiguration)
    ON_COMMAND(ID_FILE_RESTORECONFIGURATION, OnFileRestoreconfiguration)
    ON_COMMAND(ID_GROUP_TRACE, OnGroupTrace)
    ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
    ON_COMMAND(ID_FILE_BROWSEMODULE, OnFileBrowsemodule)
    ON_UPDATE_COMMAND_UI(ID_FILE_BROWSEMODULE, OnUpdateFileBrowsemodule)
    ON_COMMAND(ID_RUN_BREAKPOINT, OnRunBreakpoint)
    ON_COMMAND(ID_RUN_GO, OnRunGo)
    ON_COMMAND(ID_RUN_GOUNTILCALL, OnRunGountilcall)
    ON_UPDATE_COMMAND_UI(ID_RUN_GOUNTILCALL, OnUpdateRunGountilcall)
    ON_COMMAND(ID_RUN_GOUNTILRETURN, OnRunGountilreturn)
    ON_UPDATE_COMMAND_UI(ID_RUN_GOUNTILRETURN, OnUpdateRunGountilreturn)
    ON_COMMAND(ID_RUN_HALT, OnRunHalt)
    ON_UPDATE_COMMAND_UI(ID_RUN_HALT, OnUpdateRunHalt)
    ON_COMMAND(ID_RUN_JUMP, OnRunJump)
    ON_COMMAND(ID_RUN_RESET, OnRunReset)
    ON_COMMAND(ID_RUN_RESETANDGO, OnRunResetandgo)
    ON_COMMAND(ID_RUN_STEPINTO, OnRunStepinto)
    ON_COMMAND(ID_RUN_STEPINTOCONTINUOUSLY, OnRunStepintocontinuously)
    ON_COMMAND(ID_RUN_STEPOVER, OnRunStepover)
    ON_COMMAND(ID_RUN_STEPOVERCONTINUOUSLY, OnRunStepovercontinuously)
    ON_COMMAND(ID_OPTIONS_LOADOPTIONS, OnOptionsLoadoptions)
    ON_COMMAND(ID_GROUP_SOURCE, OnGroupSource)
    ON_COMMAND(ID_OPTIONS_INTOCALL, OnOptionsIntocall)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_INTOCALL, OnUpdateOptionsIntocall)
    ON_COMMAND(ID_OPTIONS_OVERRETURN, OnOptionsOverreturn)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_OVERRETURN, OnUpdateOptionsOverreturn)
    ON_COMMAND(ID_OPTIONS_UNTILCALL, OnOptionsUntilcall)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_UNTILCALL, OnUpdateOptionsUntilcall)
    ON_COMMAND(ID_OPTIONS_UNTILRETURN, OnOptionsUntilreturn)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_UNTILRETURN, OnUpdateOptionsUntilreturn)
    ON_COMMAND(ID_OPTIONS_RUNACCESS, OnOptionsRunaccess)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_RUNACCESS, OnUpdateOptionsRunaccess)
    ON_COMMAND(IDM_STEP_STATEMENT, OnStepStatement)
    ON_UPDATE_COMMAND_UI(IDM_STEP_STATEMENT, OnUpdateStepStatement)
    ON_COMMAND(IDM_STEP_INSTRUCTION, OnStepInstruction)
    ON_UPDATE_COMMAND_UI(IDM_STEP_INSTRUCTION, OnUpdateStepInstruction)
    ON_WM_CLOSE()
    ON_COMMAND(ID_OPTIONS_SAVELAYOUTNOW, OnOptionsSavelayoutnow)
    ON_COMMAND(ID_OPTIONS_SAVELAYOUTONEXIT, OnOptionsSavelayoutonexit)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_SAVELAYOUTONEXIT, OnUpdateOptionsSavelayoutonexit)
    ON_COMMAND(ID_WINDOW_CPU, OnWindowCpu)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_CPU, OnUpdateWindowCpu)
    ON_COMMAND(ID_WINDOW_MEMORY1, OnWindowMemory1)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY1, OnUpdateWindowMemory1)
    ON_COMMAND(ID_WINDOW_MEMORY2, OnWindowMemory2)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY2, OnUpdateWindowMemory2)
    ON_COMMAND(ID_WINDOW_MEMORY3, OnWindowMemory3)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY3, OnUpdateWindowMemory3)
    ON_COMMAND(ID_WINDOW_SHELL, OnWindowShell)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_SHELL, OnUpdateWindowShell)
    ON_COMMAND(ID_WINDOW_SOURCE, OnWindowSource)
    ON_COMMAND(ID_WINDOW_BROWSE, OnWindowBrowse)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_SOURCE, OnUpdateWindowSource)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_BROWSE, OnUpdateWindowBrowse)
    ON_COMMAND(ID_WINDOW_STACK, OnWindowStack)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_STACK, OnUpdateWindowStack)
    ON_COMMAND(ID_WINDOW_VARIABLE, OnWindowVariable)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_VARIABLE, OnUpdateWindowVariable)
    ON_COMMAND(ID_WINDOW_CLOSEALL, OnWindowCloseall)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_CLOSEALL, OnUpdateWindowCloseall)
    ON_COMMAND(ID_WINDOW_PERIPHERAL, OnWindowPeripheral)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_PERIPHERAL, OnUpdateWindowPeripheral)
    ON_WM_ACTIVATE()
    ON_WM_ENTERIDLE()
    ON_COMMAND(ID_OPTION_DIAGNOSTIC, OnOptionDiagnostic)
    ON_UPDATE_COMMAND_UI(ID_OPTION_DIAGNOSTIC, OnUpdateOptionDiagnostic)
    ON_COMMAND(ID_GROUP_SPA, OnGroupSpa)
    ON_WM_TIMER()
    ON_COMMAND(ID_RUN_GORUN, OnRunGorun)
    ON_COMMAND(ID_RUN_GOMONITOR, OnRunGomonitor)
    ON_COMMAND(ID_GOTO_SHELL, OnGotoShell)
    ON_UPDATE_COMMAND_UI(ID_PROJECT_BUILDPROJECT, OnUpdateProjectBuildproject)
    ON_COMMAND(ID_PROJECT_BUILDPROJECT, OnProjectBuildproject)
    ON_UPDATE_COMMAND_UI(ID_PROJECT_CLOSE, OnUpdateProjectClose)
    ON_COMMAND(ID_PROJECT_CLOSE, OnProjectClose)
    ON_UPDATE_COMMAND_UI(ID_PROJECT_EDIT, OnUpdateProjectEdit)
    ON_COMMAND(ID_PROJECT_EDIT, OnProjectEdit)
    ON_COMMAND(ID_PROJECT_NEW, OnProjectNew)
    ON_COMMAND(ID_PROJECT_OPEN, OnProjectOpen)
    ON_UPDATE_COMMAND_UI(ID_PROJECT_OPTIONS, OnUpdateProjectOptions)
    ON_COMMAND(ID_PROJECT_OPTIONS, OnProjectOptions)
    ON_UPDATE_COMMAND_UI(ID_GROUP_SPA, OnUpdateGroupSpa)
    ON_UPDATE_COMMAND_UI(ID_TOGGLE_TRACE, OnUpdateToggleTrace)
    ON_COMMAND(ID_TOGGLE_TRACE, OnToggleTrace)
    ON_COMMAND(ID_PROJECT_EDITOR, OnProjectEditor)
    ON_UPDATE_COMMAND_UI(ID_PROJECT_EDITOR, OnUpdateProjectEditor)
    ON_COMMAND(IDM_CUSTOM, OnCustom)
    ON_COMMAND(ID_WINDOW_TRACE1, OnWindowTrace1)
    ON_COMMAND(ID_WINDOW_TRACE2, OnWindowTrace2)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_TRACE1, OnUpdateWindowTrace1)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_TRACE2, OnUpdateWindowTrace2)
	ON_COMMAND(ID_WINDOW_GPRF, OnWindowGprf)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_GPRF, OnUpdateWindowGprf)
	ON_UPDATE_COMMAND_UI(ID_PROJECT_NEW, OnUpdateProjectNew)
	ON_UPDATE_COMMAND_UI(ID_PROJECT_OPEN, OnUpdateProjectOpen)
	//}}AFX_MSG_MAP
    // Global help commands
    ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
    ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
    ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
    ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
    ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
    ON_COMMAND(ID_USER1,OnUser1)
    ON_COMMAND(ID_USER2,OnUser2)
    ON_COMMAND(ID_USER3,OnUser3)
    ON_COMMAND(ID_USER4,OnUser4)
    ON_COMMAND(ID_USER5,OnUser5)
    ON_COMMAND(ID_USER6,OnUser6)
    ON_COMMAND(ID_USER7,OnUser7)
    ON_COMMAND(ID_USER8,OnUser8)                        
    ON_UPDATE_COMMAND_UI(ID_USER1, OnUpdateUser1)
    ON_UPDATE_COMMAND_UI(ID_USER2, OnUpdateUser2)
    ON_UPDATE_COMMAND_UI(ID_USER3, OnUpdateUser3)
    ON_UPDATE_COMMAND_UI(ID_USER4, OnUpdateUser4)
    ON_UPDATE_COMMAND_UI(ID_USER5, OnUpdateUser5)
    ON_UPDATE_COMMAND_UI(ID_USER6, OnUpdateUser6)
    ON_UPDATE_COMMAND_UI(ID_USER7, OnUpdateUser7)
    ON_UPDATE_COMMAND_UI(ID_USER8, OnUpdateUser8)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize status bars

static UINT BASED_CODE indicators[] =
{
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_SEPARATOR,
    ID_INDICATOR_OVR
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::CMainFrame()
{
    // TODO: add member initialization code here
    m_nTimerID = 0; //john 96.3
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::~CMainFrame()
{                        
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   PreCreateWindow
//
//  Description: Delete the auto add title style
//
//  Input:  CREATESTRUCT
//  
//  Output: CREATESTRUCT
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT & cs)
{                                                  
    if(cs.style & FWS_ADDTOTITLE)   cs.style ^= FWS_ADDTOTITLE;
    return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // create a timer john 96.3
    m_nTimerID =SetTimer(1,1000,NULL);
    if ( m_nTimerID == 0 ) {
        AfxMessageBox("No more timers!");
        return -1;
    }                            
                      
    // Create Status Bar                      
    if (!m_wndStatusBar.Create(this) ||
        !m_wndStatusBar.SetIndicators(indicators,
          sizeof(indicators)/sizeof(UINT))) {
        TRACE("Failed to create status bar\n");
        return -1;      
    }
    else {
        m_wndStatusBar.UpdateStatusBar();
        m_wndStatusBar.UpdateStatusBar(6, "0000.00s");
    }
    
    // Create Tool Bar                // modify by carl                
    if (!m_wndToolBar.CreateBar(this)) {
        TRACE("Failed to create tool bar");
        return -1;
    }       
    m_wndToolBar.SetHeight(30);
    void TstIdentify(CString &, CString &, CString &, 
        CString &, CString &, CString &);
    CString strDos, strWindows, strVer, strFWVer, strCPU, strClock;
                                                      
    TstIdentify(strCPU, strFWVer, strVer, 
        strDos, strWindows, strClock);
#ifdef _PLUS_
    strDos = "EasyPack/SLD Plus for PIC";
#else    
    strDos = "EasyPack/SLD for PIC";
#endif    
//    strDos += strVer;
    strDos += " -- ";
    strDos += strCPU;    
    SetWindowText(strDos);
    
/*    // Create Menu Check Bitmap
    if (!CreateMenuCheckBMP()) {
        TRACE("Failed to create Menu Check Bitmap");
        return -1;
    }             
    
    // Set Main Menu Check Bitmap    
    CMenu * menu = GetMenu();
    ASSERT(menu);
    SetMainMenuCheck(*menu);     */
    
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
    CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
    CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
// Toggle Insert Status
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateInsert(CCmdUI* pCmdUI)
{
//    pCmdUI->Enable(!isInsertOn);
    
    pCmdUI->Enable(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnToggleInsert()
{
    // Toggle Ins/Ovr flag.
    ::isInsertOn = !::isInsertOn;

    // Show to status bar.
    CString strPrompt = ::isInsertOn ? "INS" : "OVR";
    m_wndStatusBar.UpdateStatusBar(8, strPrompt);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnStepStatement()
{
    if(SrcDispMode() == MODE_SOURCE && SrcEmu.m_isStatement) {
        if(SrcEmu.m_nStepOpt == STEP_STATEMENT)  
            SrcEmu.m_nStepOpt = STEP_LINE;
        else    SrcEmu.m_nStepOpt = STEP_STATEMENT;
    } 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateStepStatement(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck(SrcEmu.m_nStepOpt == STEP_STATEMENT);
    pCmdUI->Enable(SrcDispMode() == MODE_SOURCE && 
        SrcEmu.m_isStatement);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnStepInstruction()
{
    if(SrcDispMode() == MODE_SOURCE) {
        if(SrcEmu.m_nStepOpt == STEP_INSTRUCTION)  
            SrcEmu.m_nStepOpt = STEP_LINE;
        else    SrcEmu.m_nStepOpt = STEP_INSTRUCTION;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateStepInstruction(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck(SrcEmu.m_nStepOpt == 0);
    pCmdUI->Enable(SrcDispMode() == MODE_SOURCE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Close Window
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnClose()
{
    // TODO: Add your message handler code here and/or call default
    
    // Save Window Placement
    if(AfxMessageBox(IDS_PRM_EXIT, MB_YESNO) == IDYES) {
        if(isSaveLayoutOnExit) SaveWindowPlacement();
    
        // Delete Menu Check Bitmap    
        //DeleteMenuCheckBMP();
    
        CMDIFrameWnd::OnClose();               
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Update Tool Bar
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnXMMDIActive(UINT wParam, LONG lParam)
{                              
    // Delete Old Tool Bar
    m_wndToolBar.Del();   
    
    // Add New Tool Bar
    if(wParam) {
        switch(lParam) {
            case WID_SOURCE:
                m_wndToolBar.NewSource();
                break;
            case WID_BROWSE:             
                m_wndToolBar.NewBrowse();
                break;
            case WID_CPU:
                m_wndToolBar.NewCpu();
                break;
            case WID_PERI:
                m_wndToolBar.NewPeri();
                break;
            case WID_SHELL:
                m_wndToolBar.NewShell();
                break;               
            case WID_BMEM:
                m_wndToolBar.NewBMem();
                break;               
            case WID_TRACE1:
                m_wndToolBar.NewTrace(1);
            case WID_TRACE2:
                m_wndToolBar.NewTrace(2);
                break;               
            case WID_STACK:
                m_wndToolBar.NewStack();
                break;               
            case WID_MEMORY:
                m_wndToolBar.NewMemory();
                break;               
            case WID_VARIABLE:
                m_wndToolBar.NewVariable();
                break;               
            case WID_GPRF:
                m_wndToolBar.NewGPRF();
                break;               
            default:
                m_wndToolBar.NewMain();
                break;               
        }                                  
    } else m_wndToolBar.NewMain();
    
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Do local menu
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if(pWnd != this &&
        nHitTest == HTCLIENT && message == WM_RBUTTONDOWN) {
        CMenu * pLocalMenu = new CMenu;
        ASSERT( NULL != pLocalMenu );

        pLocalMenu->CreatePopupMenu();
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_CPU,
                            "CP&U");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_MEMORY1,
                            "P&rogram");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_GPRF,
                            "GPR&F");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_SHELL,
                            "S&hell");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_SOURCE,
                            "S&ource");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_BROWSE,
                            "Bro&wse");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_STACK,
                            "Stac&k");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_TRACE1,
                            "Trace&1");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_TRACE2,
                            "Trace&2");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_VARIABLE,
                            "&Variable");
//        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_BITMEMORY,
//                            "&BitMemory");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_PERIPHERAL,
                            "&Peripheral");
        pLocalMenu->AppendMenu(MF_SEPARATOR);
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_TOOLBAR,
                            "&Toolbar");
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_STATUS_BAR,
                            "&Status Bar");

        CRect rect;
        pWnd->GetClientRect(&rect);
        CPoint pt(rect.left + 200, rect.top + 80);
        GetCursorPos(&pt);
        //ClientToScreen(&pt);
        pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, this);

        delete pLocalMenu;
        return TRUE;
    } else return CMDIFrameWnd::OnSetCursor(pWnd, nHitTest, message);
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- File Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
class CIncludeDialog : public CFileDialog
{
public:                         
    CIncludeDialog( BOOL bOpenFileDialog, LPCSTR lpszDefExt = NULL, 
        LPCSTR lpszFileName = NULL, 
        DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
        LPCSTR lpszFilter = NULL, CWnd* pParentWnd = NULL )
    : CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags,
        lpszFilter, pParentWnd)
    { m_nIDHelp = IDD_INCLUDE; }        

    virtual BOOL OnInitDialog()
    {
        CFileDialog::OnInitDialog();
        CenterWindow();
        return TRUE;  // return TRUE  unless you set the focus to a control
    }
};


void CMainFrame::OnFileInclude()
{
    // TODO: Add your command handler code here  
    CString strFilter;
    strFilter.LoadString(IDS_INC_FILTER);
    CIncludeDialog dlgInc(TRUE, NULL, "*.inc", 
        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, strFilter);
    dlgInc.m_ofn.lpstrTitle = "Include";
    if(dlgInc.DoModal() == IDOK) {
        strIncludeFile = dlgInc.GetPathName();
//        AfxMessageBox(strIncludeFile);
        if(!isShellOn)  ShlOpenWindow(this, FALSE);
        else pShellWnd->BringWindowToTop();
        //ShlStopAsm();
        ShlRunInclude(strIncludeFile);
    }
}

// Load Source File

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void LoadSourceFile(CString strFileName)
{     
    g_bLoadFile=1;
    LoadInfo.m_strFile = strFileName;

    if(LoadOpt.m_isStatus) {
        CLoadProgDialog dlg;             
        dlg.DoModal();
    } else {    
        SrcLoadFile(strFileName);       
    }    
    
    void SrcPostLoad(void);
    
    void BwsPostLoad(void);
    BwsPostLoad();
    SrcPostLoad();      
    
    RepaintCPU();
    RepaintMemory();
//    RepaintBMemory();
    RepaintStack();
    RepaintVariable();
}
                   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoFileLoad(void)
{
    CLoadDialog dlgLoad;
    g_bLoadFile=1;
    CString strLoadFile;
    if(dlgLoad.DoModal() == IDOK) {
        strLoadFile = dlgLoad.GetPathName();
        AfxGetApp()->DoWaitCursor(1);
        LoadSourceFile(strLoadFile);
        AfxGetApp()->DoWaitCursor(-1);
    }
}
                   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileLoad()
{
    // TODO: Add your command handler code here
    DoFileLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileSaveconfiguration()
{
    // TODO: Add your command handler code here
    int i;
    
    CSavecfgDialog dlgCfg(TRUE);
    i = 0;
    if(dlgCfg.DoModal() == IDOK) {
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i+=1;
        if(dlgCfg.m_nEvent)     i+=2;
        if(dlgCfg.m_nTrigger)   i+=4;
        BeginWaitCursor();
        SaveConfig(str,i);
        EndWaitCursor();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileRestoreconfiguration()
{
    // TODO: Add your command handler code here
    int i;
    
    CSavecfgDialog dlgCfg(FALSE);
    i = 0;
    if(dlgCfg.DoModal() == IDOK) {
        i = 0;
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i+=1;
        if(dlgCfg.m_nEvent)     i+=2;
        if(dlgCfg.m_nTrigger)   i+=4;
        BeginWaitCursor();
        LoadConfig(str,i);
        EndWaitCursor();
    }    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoBrowseModule(CSrcBrowse &dlg)
{                                   
    unsigned long dwModule;
//    if(dlg.m_nTab == 1) { // Browse module
        if(dlg.m_strMdl_2 != "") {
            if(SrcGetModuleFullName(dlg.m_strMdl_2) == "" ||
                SrcModuleName2Index(dlg.m_strMdl_2, dwModule) == -1 ||
                SrcLoadModule(dwModule) == SRC_LOAD_ERROR) {
                CString str("Can't open module: ");
                str += dlg.m_strMdl_2;
                AfxMessageBox(str);
                return;
            }
            int n = SrcEmu.m_nStepOpt;
            if(!isSourceOn) {
                SrcOpenWindow(FALSE, 
                    (CMDIFrameWnd *)(AfxGetApp()->m_pMainWnd));
            } else SrcResetView();    
            SrcEmu.m_nStepOpt = n;
        }
//    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileBrowsemodule()
{
    // TODO: Add your command handler code here
    CSrcGrpDlg    dlg(3, this);
    dlg.DoModal();
/*
    CSourceGroup    dlg(1, this);
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg);
    }   
*/    
    RepaintSource();   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateFileBrowsemodule(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(MdlInfo.m_uModules == 0) {
        pCmdUI->Enable(FALSE);
    } else {
        for(int i = 0; i < int(MdlInfo.m_uModules); i ++) {
            if(SrcCheckModuleHasLineInfo(MdlInfo.m_pModule[i]) == 0) {
                pCmdUI->Enable(TRUE);
                return;
            }               
        }
    }
    pCmdUI->Enable(FALSE);    
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Group Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupTrace()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this);
    dlg.DoModal();    
    if((isTraceOn[0]||isTraceOn[1])&&dlg.m_bDisplayChange)
    {
        if(isTraceOn[0])
            pTraceWnd[0]->SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
        if(isTraceOn[1])
            pTraceWnd[1]->SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
    }   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupMemory()
{
    // TODO: Add your command handler code here
    CMemDlg memoryDlg(this);
    memoryDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupSource()
{
    // TODO: Add your command handler code here
    CSrcGrpDlg    dlg(0, this,g_bBrowseActive);
    dlg.DoModal();
    
/*
    CSourceGroup    dlg(0, this);
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg); 
    }    
*/    
    RepaintSource();   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*
// Marked by Chen, 04/02/96
void CMainFrame::OnGroupMap()
{
    // TODO: Add your command handler code here
    HINSTANCE hLib;
    int i = 1;
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        AfxMessageBox("Can't find MUSCROLL.DLL");
        i = 0;
    }
    CMapDlg dlg(this);
    int result = dlg.DoModal();
    if(i) FreeLibrary(hLib);
}
*/

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Run Submenu
/////////////////////////////////////////////////////////////////////////////
void DoBreakPoint(CWnd * pParent)
{
    CSrcGrpDlg    dlg(5, pParent);
    dlg.DoModal() ;        
    RepaintSource();   
/*
    CSourceGroup    dlg(5, pParent);
    if(dlg.DoModal() == IDOK) {    
        DoBrowseModule(dlg);
    }    
    RepaintSource();   
*/    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunBreakpoint()
{
    // TODO: Add your command handler code here
    DoBreakPoint(this);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGo()
{
    // TODO: Add your command handler code here
    BeginWaitCursor();
    ::MinAllMemWnd();
    EmuServerGo(1, 0);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGountilcall()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    if(SrcEmu.m_isIntoCall) EmuServerStepOver(-3);
    else EmuServerStepOver(-1);   
        
    OnEmulation();
    EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunGountilcall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(SrcEmu.m_isIntoCall) pCmdUI->SetText("Go Into C&all");    
    else    pCmdUI->SetText("Go Until &Call");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGountilreturn()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    if(SrcEmu.m_isOverReturn) EmuServerStepOver(-4);
    else EmuServerStepOver(-2);   
        
    OnEmulation();
    EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunGountilreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(SrcEmu.m_isOverReturn) pCmdUI->SetText("Go Over Retur&n");    
    else    pCmdUI->SetText("Go &Until Return\tF6");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunHalt()
{
    // TODO: Add your command handler code here
    EmuServerHalt();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunHalt(CCmdUI* /*pCmdUI*/)
{
    // TODO: Add your command update UI handler code here
    
}                      

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL DoJump(CWnd * pParent)
{
    CJumpDialog dlg(pParent);
    if(dlg.DoModal() == IDOK) {
        if(!JumpData.m_isInitPC)
            EmuServerJump((unsigned short)(JumpData.m_uAddr));
        else {
            EmuServerJump((unsigned short)(LoadInfo.m_lPC));
        }
        return TRUE;
    } else return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunJump()
{
    // TODO: Add your command handler code here
    BeginWaitCursor();
    if(DoJump(this)) {
        OnEmulation();    
    }
    EndWaitCursor();
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoReset(void)
{
    CpuReset((WORD)(LoadInfo.m_lPC));
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunReset()
{
    // TODO: Add your command handler code here
    if(AfxMessageBox("Confirm reset operation?", MB_YESNO|MB_ICONQUESTION)
        == IDNO)    
        return;
        
    BeginWaitCursor();
    DoReset();
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunResetandgo()
{
    // TODO: Add your command handler code here
    if(AfxMessageBox("Confirm reset operation?", MB_YESNO|MB_ICONQUESTION)
        == IDNO)    
        return;
        
    BeginWaitCursor();

    CpuReset(WORD(LoadInfo.m_lPC));
    EmuServerGo(1, 0);

    EndWaitCursor();

    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepinto()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStep(SrcEmu.m_nStepCount);
    EndWaitCursor();

    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepintocontinuously()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStep(0);
    EndWaitCursor();

    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepover()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStepOver(SrcEmu.m_nStepCount);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepovercontinuously()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStepOver(0);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Options Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnOptionsStepoptions()
{
    // TODO: Add your command handler code here
    CStepOptionDialog dlg(this);
    dlg.DoModal();    
}*/

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsLoadoptions()
{
    // TODO: Add your command handler code here
    CSrcGrpDlg dlg(0, this);
    dlg.DoModal();
/*
    CSourceGroup dlg(0, this);
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg); 
    }    
*/    
    RepaintSource();   
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsIntocall()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isIntoCall = TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsIntocall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(SrcEmu.m_isIntoCall);  
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsOverreturn()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isOverReturn = TRUE;   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsOverreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(SrcEmu.m_isOverReturn);    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsUntilcall()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isIntoCall = FALSE;    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsUntilcall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(!SrcEmu.m_isIntoCall); 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsUntilreturn()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isOverReturn = FALSE;  
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsUntilreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(!SrcEmu.m_isOverReturn);   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsRunaccess()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isRunAccess = SrcEmu.m_isRunAccess ? FALSE : TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsRunaccess(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(SrcEmu.m_isRunAccess); 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsSavelayoutnow()
{
    // TODO: Add your command handler code here
    SaveWindowPlacement();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsSavelayoutonexit()
{
    // TODO: Add your command handler code here
    isSaveLayoutOnExit = isSaveLayoutOnExit ? FALSE : TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsSavelayoutonexit(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isSaveLayoutOnExit);    
}

/////////////////////////////////////////////////////////////////////////////
// Open/Close Child Windows
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowCpu()
{
    // TODO: Add your command handler code here
    if(!isCpuOn) {
        BeginWaitCursor();
        CpuOpenWindow(this);
        EndWaitCursor();
    } else pCpuWnd->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowCpu(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isCpuOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory1()
{
    // TODO: Add your command handler code here
    if(!isMemOn[0]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,0);
        EndWaitCursor();
    } else pMemWnd[0]->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory1(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
   pCmdUI->SetCheck(isMemOn[0]);
   unsigned char uchCpuStatus;
    
   if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        if (isMemOn[0]){
            pCmdUI->Enable(TRUE);           
        }
        else
            pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory2()
{
    // TODO: Add your command handler code here
    if(!isMemOn[1]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,1);
        EndWaitCursor();
    } else pMemWnd[1]->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory2(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isMemOn[1]);
   unsigned char uchCpuStatus;
    
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        if (isMemOn[1]){
            pCmdUI->Enable(TRUE);           
        }
        else
            pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory3()
{
    // TODO: Add your command handler code here
    if(!isMemOn[2]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,2);
        EndWaitCursor();
    } else pMemWnd[2]->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory3(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isMemOn[2]);
   unsigned char uchCpuStatus;
    
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        if (isMemOn[2]){
            pCmdUI->Enable(TRUE);           
        }
        else
            pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowShell()
{
    // TODO: Add your command handler code here
    if(!isShellOn) {
        BeginWaitCursor();
        ShlOpenWindow(this);
        EndWaitCursor();
    } else pShellWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowShell(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isShellOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowBrowse()
{
    // TODO: Add your command handler code here
    if(!isBrowseOn) {
        BeginWaitCursor();         
        //bwsLoadPCModule();
        BwsOpenWindow(/*FALSE*/TRUE, this);
        EndWaitCursor();
    } else pBrowseWnd->SendMessage(WM_CLOSE);
}
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowBrowse(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(MdlInfo.m_uModules == 0) {
        pCmdUI->Enable(FALSE);
    } else {
        for(int i = 0; i < int(MdlInfo.m_uModules); i ++) {
            if(SrcCheckModuleHasLineInfo(MdlInfo.m_pModule[i]) == 0) {
                pCmdUI->Enable(TRUE);
                pCmdUI->SetCheck(isBrowseOn);
                return;
            }               
        }
    }
    pCmdUI->Enable(FALSE);    

 //   pCmdUI->Enable(g_bLoadFile);
    pCmdUI->SetCheck(isBrowseOn);//&&g_bLoadFile);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowSource()
{
    // TODO: Add your command handler code here
    if(!isSourceOn) {
        BeginWaitCursor();         
        SrcLoadPCModule();
        SrcOpenWindow(/*FALSE*/TRUE, this);
        EndWaitCursor();
    } else pSourceWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowSource(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isSourceOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowStack()
{
    // TODO: Add your command handler code here
    if(!isStackOn) {
        BeginWaitCursor();
        StkOpenWindow(this);
        EndWaitCursor();
    } else StkCloseWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowStack(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isStackOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowTrace1()
{
    // TODO: Add your command handler code here
    if(!isTraceOn[0]) {
        BeginWaitCursor();
        TrcOpenWindow(this, 1);
        EndWaitCursor();
    } else pTraceWnd[0]->SendMessage(WM_CLOSE);
}

void CMainFrame::OnWindowTrace2()
{
    // TODO: Add your command handler code here
    if(!isTraceOn[1]) {
        BeginWaitCursor();
        TrcOpenWindow(this, 2);
        EndWaitCursor();
    } else pTraceWnd[1]->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowTrace1(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isTraceOn[0]); 
}

void CMainFrame::OnUpdateWindowTrace2(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isTraceOn[1]); 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowVariable()
{
    // TODO: Add your command handler code here
    if(!isVariableOn) {
        BeginWaitCursor();
        VarOpenWindow(this);
        EndWaitCursor();
    } else VarCloseWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowVariable(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isVariableOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowPeripheral()
{
    // TODO: Add your command handler code here
    if(!isPeriOn) {
        BeginWaitCursor();
        PeriOpenWindow(this);
        EndWaitCursor();
    } else pPeriWnd->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowPeripheral(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isPeriOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Close All Child Windows
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowCloseall()
{
    // TODO: Add your command handler code here          
    CMDIChildWnd * pWnd;
    
    for (;;) {
        pWnd = MDIGetActive();        
        if(pWnd) {  
            if(pWnd->SendMessage(WM_CLOSE) != 0)    break;
        } else    break;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowCloseall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(MDIGetActive() != 0);
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- View Submenu
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnViewRefresh()
{
    // TODO: Add your command handler code here
    RepaintSource();
    RepaintCPU();
    RepaintMemory();
    RepaintBMemory();
    RepaintTrace();
    RepaintStack();
    RepaintVariable();    
}
*/
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnUpdateViewRefresh(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(isCpuOn||isSourceOn||isVariableOn||isStackOn||
        isMemOn[0]||isMemOn[1]||isMemOn[2]||isBMemOn||isTraceOn);
}
*/

///////////////////////////////////(EOF)/////////////////////////////////////



void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
    CMDIFrameWnd::OnActivate(nState, pWndOther, bMinimized);
    
    // TODO: Add your message handler code here
}


////////////////////////////////////////////////////////////////////////
// Added by Chen Jun.
void CMainFrame::OnEnterIdle(UINT nWhy, CWnd* pWho)
{
    CMDIFrameWnd::OnEnterIdle(nWhy, pWho);
    
    // TODO: Add your message handler code here
    
    // Remove the hook function from the hook chain.
    if ( ::hookStkKeyFilter ) {
        UnhookWindowsHookEx(::hookStkKeyFilter);
        ::hookStkKeyFilter = 0;
    }
}


////////////////////////////////////////////////////////////////////////
// Added by Chen Jun, 03/21/96, phase-II.

void CMainFrame::OnOptionDiagnostic()
{
    // TODO: Add your command handler code here
    
    //SHOW WARNING     
    CDiagnosticBox *diagnosticBox = new CDiagnosticBox;
    
                                    
    if(IDOK == diagnosticBox->DoModal()) { 
      CDiagnResultBox *diagnResultBox = new CDiagnResultBox;
      CString strTmp="";
      
      strTmp.LoadString(IDS_DIAGNOSTIC_RESULT);
      diagnResultBox->m_ShowInfo = strTmp + "\r\n\r\n";
      if(diagnosticBox->m_POIResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_PIO_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_MAPRAMResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_MAP_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_EVENTADDRResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_EVENTADDR_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_EVENTDATARAMResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_EVENTDATA_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_SPOONRAMResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_SPOON_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_EMULATIONRAMResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_EMULATION_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      if(diagnosticBox->m_TRACERAMResult == "FAIL") {
          strTmp.LoadString(IDS_DIAGNOSTIC_TRACE_ERR);
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp + "\r\n\r\n";    
      }
      
      diagnResultBox->DoModal();                            
      delete diagnResultBox;
     } 
    
    //restore hw settings    
    if (diagnosticBox->m_BHasSaved) {
        BeginWaitCursor();
        RestoreAllConfig();
        EndWaitCursor();
    }       
        
    delete diagnosticBox; 
}

void CMainFrame::OnUpdateOptionDiagnostic(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable menu item.
    pCmdUI->Enable();
}

void CMainFrame::OnGroupSpa()
{
	// TODO: Add your command handler code here
                           
	// Save HW configuration.
	BeginWaitCursor();
	::AbiAbort();
	::SaveAllConfig();
	EndWaitCursor();

	// Open the SPA group.
	CSpaGroupSheet dlgSpa;
	int nRet(dlgSpa.DoModal());

	// Update All windows.
	UpdateAllWindows();
	
	// Open the Code Coverage window.
//	if ( IDOK == nRet ) {
//		::OpenCodeCoverageWindow();
//		::UpdateCodeCoverageWindow(dlgSpa.m_CodeGetData);
//	}
}

void CMainFrame::OnUpdateGroupSpa(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    
    // Enable menu item.         
#ifdef _PLUS_    
    pCmdUI->Enable(1==::nFwSupport);
#else
    pCmdUI->Enable(FALSE);
#endif    
}


extern STATUS AbiGetCpuStatus(UINT *uCpuStatus);
void CMainFrame::OnTimer(UINT nIDEvent) 
{
    // TODO: Add your message handler code here and/or call default
    if ( m_nTimerID != nIDEvent) {
        CMDIFrameWnd::OnTimer(nIDEvent);
        return;
    }

    //added by john 96.4    
    switch(GetXviewAppJohn()->m_nCpuStatus) {
            case STATUS_GO : 
                //TRACE("GO\n"); 
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GORUN : 
                //TRACE("GORUN\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GOFLY : 
                //TRACE("GOFLY\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_HALT : 
                //TRACE("HALT\n");
                m_wndStatusBar.UpdateStatusBar(2, "Halt");
                break;    
            case STATUS_SLEEPING :
                m_wndStatusBar.UpdateStatusBar(2, "Sleeping");
                break;    
        }
    
    if ( GetXviewAppJohn()->m_bTraceOn ) {
        int bufid;

        GetCurTraceBufferId(bufid);
        switch( bufid ) {
        case 1 :
            m_wndStatusBar.UpdateStatusBar(4, "Buffer1 On");
            break;
        case 2 :
            m_wndStatusBar.UpdateStatusBar(4, "Buffer2 On");
            break;
        default :   
            m_wndStatusBar.UpdateStatusBar(4, "Trace On");
            break;
        }
    }
    else {
        m_wndStatusBar.UpdateStatusBar(4, "Trace Off");
    }
    
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_HALT) return;
// Modified by Gates Hua    
//    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_SLEEPING) return;
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GOMONI) return;
    if(!(GetXviewAppJohn()->m_bCanTimer)) return; //the abi communication is on
    UINT uCpuStatus;             
    
    GetXviewAppJohn()->m_bCanTimer = FALSE;      
    
    if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) return;
    
    if (  0x70 == (uCpuStatus & 0x0F0) ) {
    
	    if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) return;
	    if (  0x70 == (uCpuStatus & 0x0F0) ) {
    	    GetXviewAppJohn()->m_nCpuStatus = STATUS_SLEEPING;
    	}
	}    	
    else if (  0x40==(uCpuStatus & 0x070) ) {
        GetXviewAppJohn()->m_nCpuStatus = GetXviewAppJohn()->m_nCpuStatus; 
    }
    else {
        GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;
        TraceWnd(TRUE,0); //TRACE off 
        if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) return;
        UpdateAllWindows();
        // Add elapse timer.
        ShowElapseTimer();
    }   
    
    if ( 0x04 == (uCpuStatus & 0x04)) 
        GetXviewAppJohn()->m_bTraceOn = TRUE;
    else GetXviewAppJohn()->m_bTraceOn = FALSE;      
    
    GetXviewAppJohn()->m_bCanTimer = TRUE;
}        

void CMainFrame::UpdateCpuStatus(void)
{
    UINT uCpuStatus;             
    
//    GetXviewAppJohn()->m_bCanTimer = FALSE;      
    
    if (ICE_OK != AbiGetCpuStatus(&uCpuStatus)) return;
    
    if (  0x70 == (uCpuStatus & 0x0F0) ) {
        GetXviewAppJohn()->m_nCpuStatus = STATUS_SLEEPING;
	}    	
    else if (  0x40==(uCpuStatus & 0x070) ) 
        GetXviewAppJohn()->m_nCpuStatus = GetXviewAppJohn()->m_nCpuStatus; 
    else {
        GetXviewAppJohn()->m_nCpuStatus = STATUS_HALT;
    }   
    
    if ( 0x04 == (uCpuStatus & 0x04)) 
        GetXviewAppJohn()->m_bTraceOn = TRUE;
    else GetXviewAppJohn()->m_bTraceOn = FALSE;      
    
//    GetXviewAppJohn()->m_bCanTimer = TRUE;
    switch(GetXviewAppJohn()->m_nCpuStatus) {
            case STATUS_GO : 
                //TRACE("GO\n"); 
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GORUN : 
                //TRACE("GORUN\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GOFLY : 
                //TRACE("GOFLY\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_HALT : 
                //TRACE("HALT\n");
                m_wndStatusBar.UpdateStatusBar(2, "Halt");
                break;    
            case STATUS_SLEEPING :
                m_wndStatusBar.UpdateStatusBar(2, "Sleeping");
                break;    
        }
    
    if ( GetXviewAppJohn()->m_bTraceOn ) {
        int bufid;

        GetCurTraceBufferId(bufid);
        switch( bufid ) {
        case 1 :
            m_wndStatusBar.UpdateStatusBar(4, "Buffer1 On");
            break;
        case 2 :
            m_wndStatusBar.UpdateStatusBar(4, "Buffer2 On");
            break;
        default :   
            m_wndStatusBar.UpdateStatusBar(4, "Trace On");
            break;
        }
    }
    else {
        m_wndStatusBar.UpdateStatusBar(4, "Trace Off");
    }
}

void CMainFrame::OnRunGorun() 
{
    // TODO: Add your command handler code here

    // Go run.
    EmuServerGo(7, 0);
}

void CMainFrame::OnRunGomonitor() 
{
    // TODO: Add your command handler code here

    // Open Go Monitor dialog.
    CGoMonitorDlg* dlg = new CGoMonitorDlg;
    ASSERT (dlg != NULL);
    if ( IDOK == dlg->DoModal() ) {
        ::EmuServerGo(8, (unsigned short)dlg->m_nCount);
    }        
    if (dlg != NULL) delete dlg;
}
               
//added by john 96.4 to update all windows when the cpu status is changed
//from run to halt               
void CMainFrame::UpdateAllWindows(void)
{
    // Assertion of the input parameters.

    // Added by Chen, 06/05/96.
    // Return if EP is not halt.
    unsigned char uchStatus;
    if ( FALSE == ::GetCpuStatus(uchStatus) ) {
        return;
    }
    else if ( STATUS_HALT != uchStatus && STATUS_GOMONI != uchStatus ) {
        return;
    }


    // Repaint all the windows.
    ::OnEmulation();

    // Update the related window at once.
//    if ( ::isShellOn ) {
//        ::pShellWnd->UpdateWindow();
//    }
    if ( ::isSourceOn ) {
        ::pSourceWnd->UpdateWindow();
    }
    if ( ::isVariableOn ) {
        ::pVariableWnd->UpdateWindow();
    }
    if ( ::isStackOn ) {
        ::pStackWnd->UpdateWindow();
    }
    if ( ::isCpuOn ) {
        ::pCpuWnd->UpdateWindow();
    }
    if ( ::isTraceOn[0] ) {
        ::pTraceWnd[0]->UpdateWindow();
    }
    if ( ::isTraceOn[1] ) {
        ::pTraceWnd[1]->UpdateWindow();
    }
    if ( ::isPeriOn ) {
        ::pPeriWnd->UpdateWindow();
    }
    if ( ::isBMemOn ) {
        ::pBMemWnd->UpdateWindow();
    }
    for ( int i = 0; i <= 2; i++ ) {
        if ( ::isMemOn[i] ) {
            ::pMemWnd[i]->UpdateWindow();
        }
    }
} 

void CMainFrame::OnGotoShell() 
{
    // TODO: Add your command handler code here
    ShellShowTop(); 
}

void CMainFrame::ShowElapseTimer(void)
{
    // Get the elapse time.
    CString strTime;
    if ( ::GetElapseTime(strTime) ) {
        // Show on the status bar.
        m_wndStatusBar.UpdateStatusBar(6, strTime);
    }
}

// Added by Reger.
void CMainFrame::OnUpdateProjectBuildproject(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(::ProjectValid());   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
} 

void CMainFrame::OnProjectBuildproject() 
{
    // TODO: Add your command handler code here
    
    ::BuildProject();   
}

void CMainFrame::OnUpdateProjectClose(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(::ProjectValid());   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnProjectClose() 
{
    // TODO: Add your command handler code here
    
    ::CloseProject();   
}

void CMainFrame::OnUpdateProjectNew(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(TRUE);   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnUpdateProjectOpen(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(TRUE);   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnUpdateProjectEdit(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(::ProjectValid());   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnProjectEdit() 
{
    // TODO: Add your command handler code here
    
    ::EditProject(this);
}

void CMainFrame::OnProjectNew() 
{
    // TODO: Add your command handler code here
    
    ::NewProject(this);
}

void CMainFrame::OnProjectOpen() 
{
    // TODO: Add your command handler code here
    
    ::OpenProject(this);
}

void CMainFrame::OnUpdateProjectOptions(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(::ProjectValid());   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnProjectOptions() 
{
    // TODO: Add your command handler code here
    
    ::SetOption(this);  
}

void CMainFrame::OnProjectEditor() 
{
    // TODO: Add your command handler code here
    
    ::EditorProject(); 
}

void CMainFrame::OnUpdateProjectEditor(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
#ifdef _PLUS_    
    pCmdUI->Enable(::ProjectValid());   
#else
    pCmdUI->Enable(FALSE);   
#endif	    
}

void CMainFrame::OnUpdateToggleTrace(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here

    // Detect the current trace status.
    if ( ((CXviewApp*)AfxGetApp())->m_bTraceOn ) {
        pCmdUI->SetCheck(1);
    }
    else {
        pCmdUI->SetCheck(0);
    }
}

void CMainFrame::OnToggleTrace() 
{
    // TODO: Add your command handler code here

    // Detect the current trace status.
    if ( ((CXviewApp*)AfxGetApp())->m_bTraceOn ) {
        TraceWnd(TRUE, 0);
    }
    else {
        TraceWnd(TRUE, 1);
    }
}


////////////////////////////////////////////////////////////////////////
//    The following is added by jerry to support float                //
//    and configrable tool bar on May, 1996                           //
//                                                                    //        
////////////////////////////////////////////////////////////////////////

void CMainFrame::OnCustom()
{
    // TODO: Add your command handler code here
    CToolsDlg *ptoolsdlg=new CToolsDlg;
    ptoolsdlg->DoModal();
    delete ptoolsdlg;   
}
      
 
 
      
void CMainFrame::OnUser1()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[0];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len),len);  
    str.ReleaseBuffer();

}      

void CMainFrame::OnUser2()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[1];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser3()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[2];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser4()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[3];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser5()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[4];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser6()
{ 
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[5];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser7()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[6];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      
void CMainFrame::OnUser8()
{
    if(!isShellOn)  ShlOpenWindow(this, FALSE);
    else pShellWnd->BringWindowToTop();
    CString str;
    int len;
    str= m_wndToolBar.m_strUsrDefComm[7];
    len=str.GetLength();
    ShlRunMacro(str.GetBuffer(len+1),len);  
    str.ReleaseBuffer();
}      



void CMainFrame::OnUpdateUser1(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[0].IsEmpty()); 
}
void CMainFrame::OnUpdateUser2(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[1].IsEmpty()); 
}

void CMainFrame::OnUpdateUser3(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[2].IsEmpty()); 
}

void CMainFrame::OnUpdateUser4(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[3].IsEmpty()); 
}

void CMainFrame::OnUpdateUser5(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[4].IsEmpty()); 
}

void CMainFrame::OnUpdateUser6(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[5].IsEmpty()); 
}

void CMainFrame::OnUpdateUser7(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[6].IsEmpty()); 
}

void CMainFrame::OnUpdateUser8(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!m_wndToolBar.m_strUsrDefComm[7].IsEmpty()); 
}

void CMainFrame::OnWindowGprf()
{
	// TODO: Add your command handler code here
    if(!isGROn) {
        BeginWaitCursor();         
        GROpenWindow(this,0);
        EndWaitCursor();
    } else pGRWnd->SendMessage(WM_CLOSE);
}

void CMainFrame::OnUpdateWindowGprf(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isGROn);

// Added by Gates Hua    
   unsigned char uchCpuStatus;
   if (GetCpuStatus(uchCpuStatus)) {
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        if (isGROn){
            pCmdUI->Enable(TRUE);           
        }
        else
            pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
}

