
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MAPDLG.CPP   1.13   13 Dec 1996 11:18:50   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MAPDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:50   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:50   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:08   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:46   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:30   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:48   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MAPDLG.CPP
//
//  Description:The implement file for the class: CMapDlg
//
//  Author:     Lane Li  &   Daniel Lin
//
//  Modification:
//      4. 03/08/1996 ~ 03/??/1996, 1.0 version        Daniel Lin
//          Modify any input radix to C convention
//            Use address server to process the address
//             Modified function 
//                OnMapSave()
//                OnMapRestore()
//                OnMapAdd()
//                GetMap()          ; Use address server to process address
//             Add function
//                DoMapSave()       ; Do the map saving.
//                DaMapRestore()    ; Do the map restoring.
//      
// 
//      3. 1/29/96, 0.35 version          Daniel Lin
//                   Modified function       OnInitialize()    // Fix the bug 
//                                                             // by Gary Wang
//    
//
//      2. 10/19/95, 0.1d version          Daniel Lin
//                   Modified function CMapDlg::OnMapAdd()
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "xview.h"
#include "myedit2.h"
#include "spin.h"
#include "mapdlg.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

// For address server
//
#include "address.h"
#include "addrapi.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

//extern void MemServerSetMap(const unsigned short uStart,
//                            const unsigned short uEnd,
//                            const unsigned char uchType,
//                            const char chMapAttr);
                            
//extern BOOL MemServerGetMap(unsigned short& uStart,
//                            unsigned short& uEnd,
//                            unsigned char& uchType,
//                            char& chMapAttr);

extern void SaveConfig(LPCSTR filename, int option);
extern void LoadConfig(LPCSTR filename, int option);
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);

extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/*                        
static char BASED_CODE szFilter[] = 
            "Map File(*.sav) | *.sav |All Files (*.*) | *.* ||";    
*/            
                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/
char  strSelectItem[100];
char  *strPosition;
char  strStartAddress[10];
char  strEndAddress[10];
char  strLength[10];
char  strAttrib[30];
char  strSpace[40];

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
void DoMapRestore();             // Restore the map setting from the file
void DoMapSave();                // Save the map setting to the file

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////////////////
// CMapDlg dialog

CMapDlg::CMapDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CMapDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMapDlg)
    //}}AFX_DATA_INIT
}

void CMapDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CMapDlg)
    DDX_Control(pDX, IDC_MAP_LIST1, m_ListBox);
    DDX_Control(pDX, IDC_MAP_COMBO2, m_Combo2);
    DDX_Control(pDX, IDC_MAP_COMBO1, m_Combo1);
    //}}AFX_DATA_MAP
}

/**----------------------------------------------------------------------
 **   GetMap
 **
 **   Remark
 **      Call this function to get the current map setting.
 **      Call the map server
 **
 **   Return value
 **      none
 **----------------------------------------------------------------------*/

void CMapDlg::GetMap()
{
    ADDRESS    startAddress, endAddress;
    unsigned char space;
    long length;
    char attribute;
    char *buf;
    char *p;
    CWnd* ctrl;
    CFont font;
    int i;

    buf = new char[100];
    ASSERT(NULL != buf);
    if (NULL == buf) {
       MessageBox("Insufficent memory!", "Alloc memory error",
                  MB_OK|MB_ICONEXCLAMATION);
       return;
    }                  
    
    ctrl = GetDlgItem(IDC_MAP_LIST1);
    ((CListBox *)ctrl)->ResetContent();
    font.Attach(::GetStockObject(ANSI_FIXED_FONT));
    ctrl->SetFont(&font, FALSE);
        
    unsigned short sAddress, eAddress;

    // Get program memory map
    //              
    space = 1;    // Program
    startAddress.adrAddress = dwpMin;
    startAddress.adrSpace = (ADDR_SPACE)space;
    endAddress.adrAddress = dwpMax;             // Program max memory
    endAddress.adrSpace = (ADDR_SPACE)space;
    // Add by Daniel Lin on 1996.03.25
    // For the map address range
    //
    if ( startAddress.adrAddress == 0 &&
         endAddress.adrAddress == 0 &&
         startAddress.adrAddress == endAddress.adrAddress)
       return;
       
    do{ 
        sAddress = (unsigned short)startAddress.adrAddress;
        eAddress = (unsigned short)endAddress.adrAddress;
         
        for(i=0; i<100; i++)
            buf[i]=' ';
        buf[99]='\0';
#ifdef _LANE
//        MemServerGetMap(sAddress,
//                        eAddress,
//                        space,
//                        attribute);
#endif        
        endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
        startAddress.adrAddress = (ADDR_SIZE)sAddress;
        
        length = endAddress.adrAddress- startAddress.adrAddress + 1;
        
        p = buf;
        sprintf(p, "0x%X,", startAddress.adrAddress);
        i = lstrlen(buf);
        buf[i] = ' ';

        p = buf + 7;
        sprintf(p, "0x%X,", endAddress.adrAddress);
        i = lstrlen(buf);
        buf[i] = ' ';

        p = buf + 14;
        sprintf(p, "0x%lX,", length);
        i = lstrlen(buf);
        buf[i] = ' ';

        p = buf + 22;
        switch(attribute) {
            case 0:
                lstrcpy(p,"Internal Read/Write,");
                break;
            case 1:
                lstrcpy(p,"Internal Read Only,");
                break;
            case 2:
                lstrcpy(p,"External Read/Write,");
                break;
            case 3:
                lstrcpy(p,"External Read Only,");
                break;
            case 4:
                lstrcpy(p,"Combination Read/Write,");
                break;
            case 5:
                lstrcpy(p,"Combination Read Only,");
                break;
            case 6:
                lstrcpy(p,"Guard,");
                break;
        }
        i = lstrlen(buf);
        buf[i]=' ';

        p=buf + 45;
        lstrcpy(p, "Program");
        i = strlen(buf);
        buf[i] = '\0';

        ((CListBox *)ctrl)->AddString(buf);
        startAddress.adrAddress = endAddress.adrAddress + 1;
    }while (endAddress.adrAddress<dwpMax);
    
    
    // Get data memory map
    //
    space = 2;       // Data
    startAddress.adrAddress = dwxMin;
    startAddress.adrSpace = (ADDR_SPACE)space;
    endAddress.adrAddress = dwxMax;
    endAddress.adrSpace = (ADDR_SPACE)space;
    
    // Add by Daniel Lin on 1996.03.25
    // For the map address range
    //
    if ( startAddress.adrAddress == 0 &&
         endAddress.adrAddress == 0 &&
         startAddress.adrAddress == endAddress.adrAddress)
       return;
       
    do{
        for(i=0; i<100; i++)
            buf[i]=' ';
        buf[99] = '\0';
        
        sAddress = (unsigned short)startAddress.adrAddress;
        eAddress = (unsigned short)endAddress.adrAddress;
#ifdef _LANE
//        MemServerGetMap(sAddress,
//                        eAddress,
//                        space,
//                        attribute);
#endif                        
        endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
        startAddress.adrAddress = (ADDR_SIZE)sAddress;
                        
        length = endAddress.adrAddress - startAddress.adrAddress + 1;
        p = buf;
        sprintf(p,"0x%X,", startAddress.adrAddress);
        i = lstrlen(buf);
        buf[i]=' ';

        p = buf+7;
        sprintf(p,"0x%X,", endAddress.adrAddress);
        i = lstrlen(buf);
        buf[i]=' ';

        p = buf+14;
        sprintf(p,"0x%lX,", length);
        i = lstrlen(buf);
        buf[i]=' ';

        p = buf+22;
        switch(attribute) {
            case 0:
                lstrcpy(p,"Internal Read/Write,");
                break;
                
            case 1:
                lstrcpy(p,"Internal Read Only,");
                break;
                
            case 2:
                lstrcpy(p,"External Read/Write,");
                break;
                
            case 3:
                lstrcpy(p,"External Read Only,");
                break;
                
            case 4:
                lstrcpy(p,"Combination Read/Write,");
                break;
                
            case 5:
                lstrcpy(p,"Combination Read Only,");
                break;
                
            case 6:
                lstrcpy(p,"Guard,");
                break;
        }
        i = lstrlen(buf);
        buf[i]=' ';

        p=buf+45;
        lstrcpy(p, "Data");
        i = lstrlen(buf);
        buf[i]='\0';

        ((CListBox *)ctrl)->AddString(buf);
        startAddress.adrAddress = endAddress.adrAddress + 1;
    }while (endAddress.adrAddress<dwxMax);
    delete []buf;
}

BEGIN_MESSAGE_MAP(CMapDlg, CDialog)
   //{{AFX_MSG_MAP(CMapDlg)
   ON_BN_CLICKED(IDC_MAP_RADIO1, OnMapRadio1)
   ON_BN_CLICKED(IDC_MAP_RADIO2, OnMapRadio2)
   ON_BN_CLICKED(IDC_MAP_ADD, OnMapAdd)
   ON_BN_CLICKED(IDC_MAP_CLOSE, OnMapClose)
   ON_BN_CLICKED(IDC_MAP_RESTORE, OnMapRestore)
   ON_BN_CLICKED(IDC_MAP_SAVE, OnMapSave)
   ON_LBN_SELCHANGE(IDC_MAP_LIST1, OnSelchangeMapList1)
   ON_WM_CREATE()
   ON_CBN_SELCHANGE(IDC_MAP_COMBO1, OnSelchangeMapCombo1)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapDlg message handlers
//

/**----------------------------------------------------------------------
 **   OnInitDialog
 **
 **   Remark
 **      This function is initialize the map dialog. Initialize some 
 **      dialog member in this routine
 **
 **   Return value
 **----------------------------------------------------------------------*/

BOOL CMapDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();

   // TODO: Add extra initialization here
   RECT rect, editrect;
   CWnd* ctrl;

   SetDlgItemText(IDC_MAP_EDIT1, "0x0");
   SetDlgItemText(IDC_MAP_EDIT2, "0x7f");
   m_edit1.SubclassEdit(IDC_MAP_EDIT1, this, PES_NUMBERS);
   m_edit1.SetRange(dwpMin/*0*/, /*0xFFFF*/dwpMax);  // Should be changed
   m_edit1.m_uWhichEdit = 1;
   m_edit1.m_uAddOrLen = 0;
    
   m_edit1.GetWindowRect(&editrect);
   ScreenToClient(&editrect);
   rect.left = editrect.right + 1;
   rect.right = rect.left + 15;
   rect.top = editrect.top;
   rect.bottom = editrect.bottom;
       
   m_spin1.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT1);
   m_spin1.SetAssociate(&m_edit1);

   m_edit2.SubclassEdit(IDC_MAP_EDIT2,this,PES_NUMBERS);
   m_edit2.SetRange(dwpMin/*0*/, dwpMax/*0xFFFF*/);  // Should be changed
   m_edit2.m_uWhichEdit = 2;
   m_edit2.m_uAddOrLen = 0;    
   
   m_edit2.GetWindowRect(&editrect);
   ScreenToClient(&editrect);
   rect.left = editrect.right + 1;
   rect.right = rect.left + 15;
   rect.top = editrect.top;
   rect.bottom = editrect.bottom;
   
   m_spin2.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT2);
   m_spin2.SetAssociate(&m_edit2);

   ctrl=GetDlgItem(IDC_MAP_COMBO1);
   ((CComboBox *)ctrl)->SetCurSel(0);

   ctrl=GetDlgItem(IDC_MAP_COMBO2);
   ((CComboBox *)ctrl)->SetCurSel(2);

   CheckRadioButton(IDC_MAP_RADIO1,IDC_MAP_RADIO2,IDC_MAP_RADIO1);
   if (dwpMax == 0 && dwpMin == 0) {
      GetDlgItem(IDC_MAP_RADIO1)->EnableWindow(FALSE);
   }
   if (dwxMax == 0 && dwxMin == 0) {
      GetDlgItem(IDC_MAP_RADIO2)->EnableWindow(FALSE);
   }

   GetMap();
   m_ListBox.SetCurSel(0);
   OnSelchangeMapList1();
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

////////////////////////////////////////////////////////////////////////////
// Program radio button
//
void CMapDlg::OnMapRadio1()
{
    // TODO: Add your control notification handler code here
    CWnd* ctrl;
    int count;
    int sel;

    ctrl=GetDlgItem(IDC_MAP_COMBO2);
    count = ((CComboBox *)ctrl)->GetCount();
    if (7 == count) {
       sel = ((CComboBox *)ctrl)->GetCurSel();
       if ((sel == 5) || (sel == 6))
          ((CComboBox *)ctrl)->SetCurSel(2);
       ((CComboBox *)ctrl)->DeleteString(5);
       ((CComboBox *)ctrl)->DeleteString(5);
    }
    // Add by Daniel Lin on 1996.03.28
    //
    m_edit1.SetRange(dwpMin, dwpMax);
}

////////////////////////////////////////////////////////////////////////////
// Data(External) radio button
//
void CMapDlg::OnMapRadio2()
{
    // TODO: Add your control notification handler code here
    CWnd* ctrl;
    int count;

    ctrl = GetDlgItem(IDC_MAP_COMBO2);
    count = ((CComboBox *)ctrl)->GetCount();
    if (5 == count) {
       ((CComboBox *)ctrl)->AddString("Combination Read/Write");
       ((CComboBox *)ctrl)->AddString("Combination Read Only");
    }
    // Add by Daniel Lin on 1996.03.28
    //
    m_edit1.SetRange(dwxMin, dwxMax);
}

/**----------------------------------------------------------------------
 **   OnMapAdd
 **
 **   Remark
 **      This function is process the map 'Set' button
 **      Edit the start & end address, set the attribute & space area
 **      Call map server
 **
 **   Return value
 **      None
 **----------------------------------------------------------------------*/

void CMapDlg::OnMapAdd()
{
    // TODO: Add your control notification handler code here
    int attribute;
    int space;

    unsigned short uStart;
    unsigned short uEnd;
    unsigned char  uchType;
    char           chMapAttr;

    char buf[25];
    int i = 0;
    CWnd* ctrl;

    // Add by Daniel Lin on 03/08/1996
    // For Address server      
    //
    CString       text;
    ADDRESS       startAddress, endAddress;
    ADDR_RETCODE  retCode;
    CString       error;
    DWORD         dwLength;   // Idicate to the select is Length. Not the 
                              // end address

    startAddress.adrSpace = (ADDR_SPACE)1;
    startAddress.adrAddress = 0;
    endAddress.adrSpace = (ADDR_SPACE)1;
    endAddress.adrAddress = 0;
    
    i = GetCheckedRadioButton(IDC_MAP_RADIO1, IDC_MAP_RADIO2);
    if (i==IDC_MAP_RADIO1) 
      space = 1;
    else 
      space = 2;

    // Initial string array
    memset(buf, 0, sizeof(buf));
    
    // Get start address  
    GetDlgItemText(IDC_MAP_EDIT1, buf, 20);
    text = buf;
    // Use Address server  
    retCode = AdrTextToAddr(text, startAddress);
    
    if (ADR_OK != retCode) {
      MessageBeep(-1);
      AdrErrorDeal(retCode, error);      
      MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
      ctrl = GetDlgItem(IDC_MAP_EDIT1);
      ((CEdit *)ctrl)->SetFocus();
      ((CEdit *)ctrl)->SetSel(0, -1);
      
      return;
    }

    ctrl = GetDlgItem(IDC_MAP_COMBO1);
    int nInt = ((CComboBox *)ctrl)->GetCurSel();

    memset(buf, 0, sizeof(buf));    
    // Get end address
    GetDlgItemText(IDC_MAP_EDIT2, buf, 20);
    text = buf;
    // Use Address server  
    if (0 == nInt) {          // End address select
       //
       // If the start address's space is different to end address's space
       // It's error!!!
       //
    
       retCode = AdrTextToAddr(text, endAddress);
    }    
    else {                  // Length select
       retCode = AdrTextToAddr(text, endAddress, 0);  // Convert length
    }           
        
    if (ADR_OK != retCode) {
      MessageBeep(-1);
      AdrErrorDeal(retCode, error);      
      MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
      ctrl = GetDlgItem(IDC_MAP_EDIT2);
      ((CEdit *)ctrl)->SetFocus();
      ((CEdit *)ctrl)->SetSel(0, -1);
      
      return;
    }

    if (0 == nInt) {          // End address select
       //
       // If the start address's space is different to end address's space
       // It's error!!!
       //
    }    
    else {                  // Length select
         if (SPACE_UNDEFINE != endAddress.adrSpace) {
            MessageBeep(-1);
            AdrErrorDeal(retCode, error);      
            MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
            ctrl = GetDlgItem(IDC_MAP_EDIT2);
            ((CEdit *)ctrl)->SetFocus();
            ((CEdit *)ctrl)->SetSel(0, -1);
      
            return;
         }   

         // Set to length
         dwLength = (DWORD)endAddress.adrAddress;
         // Set to end addresss
         endAddress.adrAddress = startAddress.adrAddress+dwLength-1;
         endAddress.adrSpace = startAddress.adrSpace;
    }

    // Check every address's range
    // 
    if (SPACE_UNDEFINE == startAddress.adrSpace)
       startAddress.adrSpace = (ADDR_SPACE)space;
    if (SPACE_UNDEFINE == endAddress.adrSpace)
       endAddress.adrSpace = (ADDR_SPACE)space;
       
    if (!AdrCheckAddrRange(startAddress)) {
       MessageBeep(-1);
       MessageBox("Over Range", "EPSLD52F Input Error", 
                  MB_OK|MB_ICONEXCLAMATION);
       ctrl = GetDlgItem(IDC_MAP_EDIT1);
       ((CEdit *)ctrl)->SetFocus();
       ((CEdit *)ctrl)->SetSel(0, -1);
       
       return;
    }
    
    if (!AdrCheckAddrRange(endAddress)) {
       MessageBeep(-1);
       MessageBox("Over Range","EPSLD52F Input Error", 
                  MB_OK|MB_ICONEXCLAMATION);
       ctrl = GetDlgItem(IDC_MAP_EDIT2);
       ((CEdit *)ctrl)->SetFocus();
       ((CEdit *)ctrl)->SetSel(0, -1);
       
       return;
    }
               
    // Check the two addrss
    //                 
    retCode = AdrCheck2Addr(startAddress, endAddress);
    if (ADR_OK != retCode) {
       MessageBeep(-1);
       AdrErrorDeal(retCode, error);
       MessageBox(error, "EPSLD52F Input Error", MB_OK|MB_ICONEXCLAMATION);
       ctrl = GetDlgItem(IDC_MAP_EDIT1);      // Set error to end address
       ((CEdit *)ctrl)->SetFocus();
       ((CEdit *)ctrl)->SetSel(0, -1);
       
       return;
    }
    
    ctrl = GetDlgItem(IDC_MAP_COMBO2);
    i = ((CComboBox *)ctrl)->GetCurSel();
    switch (i) {
        case 0:
            attribute = 0;
            break;
            
        case 1:
            attribute = 1;
            break;
            
        case 2:
            attribute = 6;
            break;
            
        case 3:
            attribute = 2;
            break;
            
        case 4:
            attribute = 3;
            break;
            
        case 5:
            attribute = 4;
            break;
            
        case 6:
            attribute = 5;
            break;
    }
    
#ifdef _LANE
    uStart = (unsigned short)startAddress.adrAddress;
    uEnd = (unsigned short)endAddress.adrAddress;
    uchType = (unsigned char)space;
    chMapAttr = (char)attribute;

//    MemServerSetMap(uStart, uEnd, uchType, chMapAttr);

    GetMap();
    ::RepaintMemory();
//    ::RepaintBMemory();
    ::RepaintStack();
    ::RepaintVariable();
#endif
}

void CMapDlg::OnMapClose()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}

/**----------------------------------------------------------------------
 **   OnMapRestore
 **
 **      Respont the Restore button
 **   Remark
 **      Restore map setting from the file 'map.sav'
 **      The 'map.sav' is under the excute file(EPSLD52F.EXE)'s directory 
 **
 **   Return value
 **----------------------------------------------------------------------*/

void CMapDlg::OnMapRestore()
{
    // TODO: Add your control notification handler code here
    DoMapRestore();
    GetMap();        // Repaint the map list box
    m_ListBox.SetCurSel(0);      // Set current select to the first
    // Repaint any window relateed to the memory
    //
    ::RepaintMemory();
//    ::RepaintBMemory();
    ::RepaintStack();
    ::RepaintVariable();
}

/**----------------------------------------------------------------------
 **   OnMapSave
 **
 **   Remark
 **      Respont the Save button
 **      Save the current map settingto the file 'map.sav'
 **      The 'map.sav' is under the excute file(EPSLD52F.EXE)'s directory
 **
 **   Return value
 **----------------------------------------------------------------------*/

void CMapDlg::OnMapSave()
{
    // TODO: Add your control notification handler code here
    DoMapSave();   
}
 
// 
// Modified to fixed the bug by 12/28/95 fax
//
void CMapDlg::OnSelchangeMapList1()
{
   // TODO: Add your control notification handler code here
   UINT  iCount;
   
   memset(strSelectItem, 0, 100);
   memset(strStartAddress, 0, 10);   
   memset(strEndAddress, 0, 10);   
   memset(strLength, 0, 10);   
   memset(strAttrib, 0, 30);   
   memset(strSpace, 0, 40);      
   
   m_ListBox.GetText(m_ListBox.GetCurSel(), strSelectItem);
   strPosition = strSelectItem;
   strncpy(strStartAddress, strPosition, 7);
   strncpy(strEndAddress, strPosition+7, 7);
   strncpy(strLength, strPosition+14, 7);
   strncpy(strAttrib, strPosition+22, 23);
   strncpy(strSpace, strPosition+45, 40);   
   
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strStartAddress[iCount]) {
         strStartAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strEndAddress[iCount]) {
         strEndAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strLength[iCount]) {
         strLength[iCount] = '\0';
         break;
      }
   }
   for (iCount = 23; iCount > 0; iCount--) {
      if (',' == strAttrib[iCount]) {
         strAttrib[iCount] = '\0';
         break;
      }
   }
   for (iCount = 40; iCount > 0; iCount--) {
      if (',' == strSpace[iCount]) {
         strSpace[iCount] = '\0';
         break;
      }
   }
   
   SetDlgItemText(IDC_MAP_EDIT1, strStartAddress);
   m_Combo1.SetCurSel(0);  // Set EndAddress select
   SetDlgItemText(IDC_MAP_EDIT2, strEndAddress);
   if (0 == strcmp(strSpace, "Program")) {
      CheckRadioButton(IDC_MAP_RADIO1, IDC_MAP_RADIO2, IDC_MAP_RADIO1);
      OnMapRadio1();
   }      
   else {
      if (0 == strcmp(strSpace, "Data")) {
         CheckRadioButton(IDC_MAP_RADIO1, IDC_MAP_RADIO2, IDC_MAP_RADIO2);
         OnMapRadio2();
      }   
   }
         
   int iAttribIndex = 0;
   if (0 == strcmp(strAttrib, "Internal Read/Write")) {
      iAttribIndex = 0;
      goto SETSEL;
   }
   if (0 == strcmp(strAttrib, "Internal Read Only")) {
      iAttribIndex = 1;
      goto SETSEL;
   }
   if (0 == strcmp(strAttrib, "Guard")) {
      iAttribIndex = 2;
      goto SETSEL;
   }           
   if (0 == strcmp(strAttrib, "External Read/Write")) {
      iAttribIndex = 3;
      goto SETSEL;
   }           
   if (0 == strcmp(strAttrib, "External Read Only")) {
      iAttribIndex = 4;
      goto SETSEL;
   }           
   if (0 == strcmp(strAttrib, "Combination Read/Write")) {
      iAttribIndex = 5;
      goto SETSEL;
   }           
   if (0 == strcmp(strAttrib, "Combination Read Only")) {
      iAttribIndex = 6;
      goto SETSEL;
   }
   
SETSEL:  
   m_Combo2.SetCurSel(iAttribIndex);   
}


int CMapDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   if (CDialog::OnCreate(lpCreateStruct) == -1)
      return -1;
   
   // TODO: Add your specialized creation code here
   return 0;
}

void CMapDlg::OnSelchangeMapCombo1()
{
   // TODO: Add your control notification handler code here
   int Select = 0;
   
   Select = m_Combo1.GetCurSel();
   if (0 == Select) {   // Address
      m_edit2.m_uAddOrLen = 0;      
   }
   else
     if (1 == Select) { // Length
      m_edit2.m_uAddOrLen = 1;           
     }
     
   switch(Select) {
      case  0:
            SetDlgItemText(IDC_MAP_EDIT2, strEndAddress);      
            break;
            
      case  1:
            SetDlgItemText(IDC_MAP_EDIT2, strLength);
            break;
   }           
}


////////////////////////////////////////////////////////////////////////////
// DoMapSave
//
// Save the map setting to the file map.sav.
// The file is under the execution file's path
// 
// parameter
//    none
//
// return value
//    none
//
////////////////////////////////////////////////////////////////////////////

void DoMapSave()
{
    unsigned short sAddress, eAddress;
    unsigned char space;
    char attribute;
    int count = 0;
    WORD w = 0;
    ADDRESS startAddress, endAddress;
    

    // Do the first get map setting is for getting the map setting count
    //
    // Get Program area map setting
    //
    if (dwpMax != 0) {        // Have code area
       space = 1;
       startAddress.adrAddress = dwpMin/*0*/;
       startAddress.adrSpace = (ADDR_SPACE)space;
       endAddress.adrAddress = dwpMax/*0xffff*/;
       endAddress.adrSpace = (ADDR_SPACE)space;
       do{
           sAddress = (unsigned short)startAddress.adrAddress;
           eAddress = (unsigned short)endAddress.adrAddress;
           #ifdef _LANE        
//               MemServerGetMap(sAddress,
//                               eAddress,
//                               space, 
//                               attribute);
           #endif                        
           endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
           startAddress.adrAddress = (ADDR_SIZE)sAddress;
                           
           startAddress.adrAddress = endAddress.adrAddress + 1;
           count++;
       }while (endAddress.adrAddress < /*0xffff*/dwpMax);
    }
    
    // Get Data area map setting
    if (dwxMax != 0) {        // Have code area
       space = 2;
       startAddress.adrAddress = dwxMin/*0*/;
       startAddress.adrSpace = (ADDR_SPACE)space;
       endAddress.adrAddress = dwxMax/*0xffff*/;
       endAddress.adrSpace = (ADDR_SPACE)space;
       
       do{
           sAddress = (unsigned short)startAddress.adrAddress;
           eAddress = (unsigned short)endAddress.adrAddress;
           
           #ifdef _LANE
//               MemServerGetMap(sAddress,
//                               eAddress,
//                               space, 
//                               attribute);
           #endif
   
           endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
           startAddress.adrAddress = (ADDR_SIZE)sAddress;
       
           startAddress.adrAddress = endAddress.adrAddress + 1;
           count++;
       }while (endAddress.adrAddress < dwxMax/*0xffff*/);
    }
    
    char exefilename[125];
    
    ::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
    int pp = 0;
    for (pp = strlen(exefilename); pp > 0; pp--) {
      if (exefilename[pp] == '\\')
         break;
   }        
    
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");
    CFile file(exefilename, CFile::modeCreate|CFile::modeWrite);
    CArchive ar(&file,CArchive::store);
    
    CString flag = "MICROTEK MAP FILE.";
    ar << flag;
    w = (WORD)count;
    ar << w;
    
    // Do the second get map setting is for getting the map setting
    //
    // Program area map setting
    //
    if (dwpMax != 0) {        // Have code area
       space = 1;
       startAddress.adrAddress = dwpMin/*0*/;
       startAddress.adrSpace = (ADDR_SPACE)space;
       endAddress.adrAddress = dwpMax/*0xffff*/;
       endAddress.adrSpace = (ADDR_SPACE)space;
       
       do{
           sAddress = (unsigned short)startAddress.adrAddress;
           eAddress = (unsigned short)endAddress.adrAddress;
           
           #ifdef _LANE    
//               MemServerGetMap(sAddress,
//                               eAddress,
//                               space, 
//                               attribute);
           #endif                        
   
           endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
           startAddress.adrAddress = (ADDR_SIZE)sAddress;
                           
           w = (WORD)startAddress.adrAddress;
           ar << w;
           w = (WORD)endAddress.adrAddress;
           ar << w;
           w = (WORD)space;
           ar << w;
           w = (WORD)attribute;
           ar << w;
   
           startAddress.adrAddress = endAddress.adrAddress + 1;
       }while (endAddress.adrAddress < dwpMax/*0xffff*/);
    }
                                    
    // Data area map setting
    //                                    
    if (dwxMax != 0) {        // Have data area
       space = 2;
       startAddress.adrAddress = dwxMin/*0*/;
       startAddress.adrSpace = (ADDR_SPACE)space;
       endAddress.adrAddress = dwxMax/*0xffff*/;
       endAddress.adrSpace = (ADDR_SPACE)space;
   
       do{
           sAddress = (unsigned short)startAddress.adrAddress;
           eAddress = (unsigned short)endAddress.adrAddress;
           
           #ifdef _LANE 
//               MemServerGetMap(sAddress,
//                               eAddress,
//                               space, 
//                               attribute);
           #endif                        
   
           endAddress.adrAddress = (ADDR_SIZE)eAddress;                         
           startAddress.adrAddress = (ADDR_SIZE)sAddress;
                           
           w = (WORD)startAddress.adrAddress;
           ar << w;
           w = (WORD)endAddress.adrAddress;
           ar << w;
           w = (WORD)space;
           ar << w;
           w = (WORD)attribute;
           ar << w;
   
           startAddress.adrAddress = endAddress.adrAddress + 1;
       }while (endAddress.adrAddress < dwxMax/*0xffff*/);
    }
    
    ar.Close();
    file.Close();
}     // End of DoMapSave()


///////////////////////////////////////////////////////////////////////////  
// DoMapRestore
//
// Restore the map setting from the file map.sav.
// The file is under the execution file's path
//
// parameter
//    none
//
// return value
//    none
//
////////////////////////////////////////////////////////////////////////////

void DoMapRestore()
{
    unsigned short startAddress,endAddress;
    unsigned char space;
    char attribute;
    int count;
    int i;
    WORD w;
    CFile file;
    BOOL b;

    char exefilename[125];
    ::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
    int pp = 0;
    for (pp = strlen(exefilename); pp > 0; pp--) {
      if (exefilename[pp] == '\\')
         break;
    }        
    
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");
    
    b = file.Open(exefilename, CFile::modeRead);
    if (!b) {
        file.Abort();
        AfxMessageBox("Error Open Map File",
                      MB_OK|MB_ICONHAND|MB_ICONSTOP);
        return;
    }

    CArchive ar(&file, CArchive::load);

    CString flag;
    ar >> flag;
    ar >> w;
    count = (int)w;

    for(i=1; i<=count; i++) {
        ar >> w;
        startAddress = (unsigned short)w;
        ar >> w;
        endAddress = (unsigned short)w;
        ar >> w;
        space = (unsigned char)w;
        ar >> w;
        attribute = (char)w;

        #ifdef _LANE
            // Call memory server
//            MemServerSetMap(startAddress, endAddress, space, attribute);
        #endif
    }

    ar.Close();
    file.Close();
}     // End of DoRestoreMap()

/////////////////////////////(EOF of MAPDLG.CPP)/////////////////////////////
