
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMBASE.H__   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMBASE.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:18   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:10   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:50   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:02   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:02   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:50   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBASE.H
//
//  Description: The header file for the class: CMemoryBase.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryBase.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMBASE_
#define _MEMBASE_

//#ifndef _SERVER_NO_ABI
#include "abitype.h"
//#endif  // _SERVER_NO_ABI

#include "syntest.h"
#include "memaddr.h"

/////////////////////////////////////////////////////////////////////////////
// CMemoryBase class.
class CMemoryBase : public CSyntaxTest, public CMemoryAddr
{
// Construction & Destruction.
public:
    CMemoryBase();
    ~CMemoryBase();
    
// Member variables.
private:
    enum { LINE_LENGTH = 255 };

    enum { MAX_DIGIT = 34 };

protected:
    enum { MEM_UNDEFINE = 0,
           MEM_PROGRAM  = 1,
           MEM_EXTERNAL = 2,
           MEM_INTERNAL = 3,
           MEM_SFR      = 4,
           MEM_BIT      = 5
    };

    // Used by StrToVar() & VarToStr().
    unsigned long m_ulVar;
    char* m_pszVar;
    
    // Result which will be displayed.
    char* m_pszResult;
                                      
    // ABI Error ID.
    int m_nErrorID;
/*
    enum { 
        ICE_OK = 0,
        ICE_FAIL_STEP,
        ICE_FAIL_MEM_WRITE,
        ICE_FAIL_MAP_INCLUDE,
        ICE_FAIL_MAP_BOUNDARY,
        ICE_NOT_FOUND,
        ICE_FOUND,
        ICE_TIME_OUT,
        ICE_PARA_ERROR,
            
        ICE_EP_RUNNING = 0x10,
        ICE_TRACE_RUNNING,
        ICE_TRACE_READ_OVER,
        ICE_COMMAND_INVALID,

        ICE_FLASH_SW_ERROR  = 0x40,
        ICE_FLASH_EC_ERROR,
        ICE_FLASH_PRG_ERROR,
        ICE_FLASH_REC_ERROR,
    };
*/

// Implementations.
protected:
    void StrToVar(char* pszConvStr);
    void VarToStr(unsigned long ulConvVar);

    void SetAddrVar(char* pszAddr, CMemoryAddr& addr);
    void SetAddrVar(char* pszAddr, char* pszLength, CMemoryAddr& addr);
    void SetAddrVar(int nType, unsigned long ulAddr, CMemoryAddr& addr);
    
    BOOL EscapeAbort(void);

    void DisplayErrorMessage(void) const;
    
};  // End of class: CMemoryBase.

#endif
//////////////////////////////// End of File ////////////////////////////////
