
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMDUMP.CPP   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMDUMP.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:54   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:12   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:08   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:16   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:14   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:15:36   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:10   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:18   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:00   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:08   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:46   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:48   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMDUMP.CPP
//
//  Description: The implementation file for the class: CMemoryDump.
//
//  Author: Chen Jun
//
//  Date: 04/21/95
//
//  Modification:
//      1. 04/21/95, Initial version of the class: CMemoryDump.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <ctype.h>
#include "memdump.h"
#include "hosterrs.h"
#include "cpucom.h"
#include "cpuserve.h"
#include "abiextfn.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void MemoryCmd(int nArgc, char* pszArgv[]);
//long MemServerDump(BYTE* bDump, long lAddr, long lSize, int nType);
long MemServerDump(WORD* bDump, long lAddr, long lSize, int nType);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern CPURegisterFileRange GetCpuRFileRange();


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiGetMemN(ADDR addr1, ADDR addr2, char* pchBuff);
//#endif  // _SERVER_NO_ABI



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   MemoryCmd().
//
//  Description: The main control routine of Memory command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void MemoryCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc || 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Dump EMM contents.
    char error[128];
    
    CMemoryDump* pMemoryDump = new CMemoryDump;
    if ( !pMemoryDump ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryDump->DumpAction(nArgc, pszArgv);
            delete pMemoryDump;
          }           
       }   
    }

//    CMemoryDump objDump;
//    objDump.GetMemoryDump(nArgc, pszArgv);

}   // End of MemoryCmd().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   MemServerDump().
//
//  Description: The main control routine of Memory Server.
//
//  Input:  lAddr - Start address.
//          lSize - Dumped size.
//          nType - Memory space type.
//
//  Output: pbDump - To store the Dump contents.
//
//  Return: The size which has been dumped.
//
/////////////////////////////////////////////////////////////////////////////
long MemServerDump(WORD* pbDump, long lAddr, long lSize, int nType)
{
    // Assertion of the input parameters.
    ASSERT( pbDump );
    ASSERT( lSize >= 1 && lSize <= 256 );
    ASSERT( nType >= 1 && nType <= 5 );
//    ASSERT( nType == 1 );
    
    // Dump EMM contents.
    CMemoryDump* pMemoryDump = new CMemoryDump;
    if ( !pMemoryDump ) {
//        AfxMessageBox("Insufficient Memory !");
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
        ASSERT( FALSE );
        return (0);
    }
    else {
        long lRetAddr = 
            pMemoryDump->MemServerDump(pbDump, (WORD&)lAddr,
                                       (int&)lSize, nType);
        delete pMemoryDump;
        return (lRetAddr);
    }
    
//    CMemoryDump objDump;
//    long lRetAddr = 
//      objDump.MemServerDump((char*)pbDump,(WORD&)lAddr,(int&)lSize,nType);
//    return (lRetAddr);

}   // End of MemServerDump().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryDump.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryDump::CMemoryDump().
//
//  Description: The construction of the class: CMemoryDump.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryDump::CMemoryDump()
{

}   // End of CMemoryDump::CMemoryDump().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryDump::~CMemoryDump().
//
//  Description: The destruction of the class: CMemoryDump.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryDump::~CMemoryDump()
{

}   // End of CMemoryDump::~CMemoryDump().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryDump::DumpAction().
//
//  Description: Get the current EMM contents.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryDump::DumpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc || 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 2 == nArgc ) {
        // Memory adr1.
        SetAddrVar(pszArgv[1], m_StartAddr);
        if ( ':' != pszArgv[1][1] ) {
//            m_StartAddr.m_uchType = MEM_EXTERNAL;
            m_StartAddr.m_uchType = MEM_PROGRAM;
        }

        CPUMEMORYRANGE stRange;
        GetMemoryRange(&stRange);
        switch ( m_StartAddr.m_uchType ) {
            case MEM_PROGRAM:
//                if ( m_StartAddr > 0x0FF00 ) {
//                    SetAddrVar("P:FFFF", m_EndAddr);
                if ( m_StartAddr > stRange.pMax - 0xFF ) {
                    SetAddrVar(MEM_PROGRAM,stRange.pMax, m_EndAddr);
                }
                else {
                    SetAddrVar(pszArgv[1], "100", m_EndAddr);
                }
                break;
            case MEM_EXTERNAL:
                if ( m_StartAddr > 0x0FF00 ) {
                    SetAddrVar("X:FFFF", m_EndAddr);
                }
                else {
                    SetAddrVar(pszArgv[1], "100", m_EndAddr);
                }
                break;
            case MEM_INTERNAL:
			{
//                SetAddrVar("I:FF", m_EndAddr);
//                SetAddrVar(MEM_INTERNAL,stRange.iMax, m_EndAddr);
				CPURegisterFileRange bankRange;
				bankRange = GetCpuRFileRange();
				m_EndAddr = m_StartAddr;
				for ( int i = 0; i < bankRange.nBanks; i++ ) {
					if ( m_StartAddr.m_uAddr <= (unsigned short)
								bankRange.RFileRange[i].nEndAddr &&
						 m_StartAddr.m_uAddr >= (unsigned short)
								bankRange.RFileRange[i].nStartAddr ) {
						SetAddrVar(MEM_INTERNAL,
							bankRange.RFileRange[i].nEndAddr, m_EndAddr);
						break;
					}
				}
                break;
			}
            case MEM_SFR:
                SetAddrVar("R:FF", m_EndAddr);
                break;
            case MEM_BIT:
                SetAddrVar("B:FF", m_EndAddr);
                break;
            default:
                ASSERT( FALSE );
                break;
        }
    }
    else if ( 3 == nArgc ) {
        // Memory adr1 adr2 
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
    }
    else if ( 4 == nArgc ) {
        // Memory adr1 Length length
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        if (m_StartAddr.m_uchType == MEM_PROGRAM) {
	        CPUMEMORYRANGE stRange;
	        GetMemoryRange(&stRange);
            if ( m_EndAddr.m_uAddr > stRange.pMax) 
            	m_EndAddr.m_uAddr = stRange.pMax;
        }
	        
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Display the head message.
    DisplayDumpHead();
        
    // Memory Dump kernel routine.
    MemoryDumpKernel();
        
}   // End of CMemoryDump::DumpAction().


void CMemoryDump::MemoryDumpKernel(void)
{
    // Assertion of the input parameters.

/*    
    // Get from EP each line.
    for ( unsigned short u = m_StartAddr.m_uAddr / 0x10;
        u <= m_EndAddr.m_uAddr / 0x10; u++ ) {
        // 
    }
*/    
    
    // Call Abi routine.
    CMemoryAddr StartAddr = m_StartAddr;
    CMemoryAddr EndAddr;
        
    do {

        EndAddr = m_EndAddr;
        if ( EndAddr - StartAddr >= MAX_DUMP_SIZE ) {
            EndAddr = (StartAddr+MAX_DUMP_SIZE-1)-(StartAddr.m_uAddr%0x10);
//            EndAddr = (StartAddr+MAX_DUMP_SIZE-1)-(StartAddr.m_uAddr%0x8);
        }
        
        m_uSize = (EndAddr - StartAddr).m_uAddr + 1;
        m_nErrorID = AbiGetMemN((ADDR&)StartAddr, (ADDR&)EndAddr, m_pchDump);

        if ( EscapeAbort() ) {
            return;
        }
                    
        if ( ICE_OK != m_nErrorID ) {
            DisplayErrorMessage();
            return;
        }
        else {
            FormatDumpInfo(StartAddr);
            StartAddr = EndAddr + 1;
        }
        
    } while ( EndAddr < m_EndAddr );

}   // End of CMemoryDump::MemoryDumpKernel().


void CMemoryDump::FormatDumpInfo(const CMemoryAddr& StartAddr)
{
    // Assertion of the input parameters.
    
    // Display the Dump contents.
    int Nums = 16;
    if ( StartAddr.m_uchType == MEM_PROGRAM ) Nums = 8;
    int nCount = 0;
//    int nBegin = StartAddr.m_uAddr % 0x010;
    int nBegin = StartAddr.m_uAddr % Nums;
    unsigned short ulEndAddr = 0;
    
    for ( int i = 0; i <= (nBegin+(int)m_uSize-1)/Nums; i++ ) {
        int nOffset = (StartAddr.m_uAddr + nCount) % Nums;  // 0x010;
        char pszTemp[10];
        
        memset(m_pszData, ' ', sizeof(m_pszData));
		if ( StartAddr.m_uchType == MEM_PROGRAM ) 
			m_pszData[nOffset*5] = 0;
		else m_pszData[nOffset*3] = 0;

        memset(m_pszASCII, ' ', sizeof(m_pszASCII)-1);
        m_pszASCII[16] = 0;

        char ch;
        switch ( StartAddr.m_uchType ) {
            case MEM_PROGRAM:
                ch = 'P';
                break;
            case MEM_EXTERNAL:
                ch = 'X';
                break;
            case MEM_INTERNAL:
                ch = 'R';
//                ch = 'I';
                break;
            case MEM_SFR:
                ch = 'R';
                break;
            case MEM_BIT:
                ch = 'B';
                break;
            default:
                ASSERT( FALSE );
                break;
        }
                                            
        wsprintf(m_pszAddr, "%c:%03X ", ch, StartAddr.m_uAddr+nCount-nOffset);

//        for ( int j = nOffset; j <= 0x0F; j++ ) {
        for ( int j = nOffset; j < Nums; j++ ) {
            if ( ulEndAddr >= 
                (unsigned long)StartAddr.m_uAddr + (unsigned long)m_uSize ) {
                break;
            }
    		if ( StartAddr.m_uchType == MEM_PROGRAM ) 
            	wsprintf(pszTemp, "%04X", m_pchDump[nCount]);
            else {
            	m_pszASCII[j] = 
                	//isprint(m_pchDump[nCount]) ? m_pchDump[nCount] : '.';
                	(m_pchDump[nCount]>=0x20 && m_pchDump[nCount]<=0x7e) ? m_pchDump[nCount] : '.';
            	wsprintf(pszTemp, "%02X", (unsigned char)m_pchDump[nCount]);
            }

            strcat(m_pszData, pszTemp);
            strcat(m_pszData, " ");
            nCount++;
            ulEndAddr = StartAddr.m_uAddr + nCount;
        }
        
   		if ( StartAddr.m_uchType == MEM_PROGRAM ) 
        	wsprintf(m_pszResult, "%-6s  %-40s",
                 m_pszAddr, m_pszData);
        else
	        wsprintf(m_pszResult, "%-6s  %-48s  %-16s",
                 m_pszAddr, m_pszData, m_pszASCII);
        ShowLine(m_pszResult);
    }
    
}   // End of CMemoryDump::FormatDumpInfo().


void CMemoryDump::DisplayDumpHead(void)
{
    // Assertion of the input parameters.
    
    char* pszDumpHead1 = 
      "        00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F   ASCII CODE";
    char* pszDumpHead = 
      "        0000 0001 0002 0003 0004 0005 0006 0007";
    
	if (m_StartAddr.m_uchType == MEM_PROGRAM)
    	ShowLine(pszDumpHead);
    else
    	ShowLine(pszDumpHead1);

}   // End of CMemoryDump::DisplayDumpHead().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryDump::MemServerDump().
//
//  Description: Dump memory contents for UI.
//
//  Input:  uAddr - Start address.
//          nSize - Dumped size.
//          nType - Memory space type.
//
//  Output: pchDump - To store the Dump contents.
//
//  Return: The size which has been dumped.
//
/////////////////////////////////////////////////////////////////////////////
long CMemoryDump::MemServerDump(WORD* pchDump,WORD uAddr,int nSize,int nType)
{
    // Assertion of the input parameters.
    ASSERT( pchDump );
    ASSERT( nSize >= 1 && nSize <= 256 );
    ASSERT( nType >= 1 && nType <= 5 );

    // Set the parameters.
    CMemoryAddr StartAddr(uAddr, (unsigned char)nType);
    CMemoryAddr EndAddr(uAddr + nSize - 1, (unsigned char)nType);

    // Call ABI routine.
    m_nErrorID = AbiGetMemN((ADDR&)StartAddr, (ADDR&)EndAddr, pchDump);
    m_isServer = TRUE;
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }

    return ((long)nSize);

}   // End of CMemoryDump::MemServerDump().


//////////////////////////////// End of File ////////////////////////////////
