
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMFILL.H__   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMFILL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:10   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:40   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:02   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:40   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:00   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:12   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:18   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:02   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:20   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMFILL.H
//
//  Description: The header file for the class: CMemoryFill.
//
//  Author: Chen Jun
//
//  Date: 04/26/95
//
//  Modification:
//      1. 04/26/95, Initial version of the class: CMemoryFill.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMFILL_
#define _MEMFILL_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryFill class.
class CMemoryFill : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryFill();
    ~CMemoryFill();
    
// Member variables.
private:
    CMemoryAddr m_StartAddr, m_EndAddr, m_FailAddr;
    
    enum { MAX_FILL_SIZE = 32 };
//    char m_pchFill[MAX_FILL_SIZE+1];
    WORD m_pchFill[MAX_FILL_SIZE+1];
    
    unsigned int m_uPatternLen;
    
// Implementations.
private:
    void SetPattern(char* pszPattern);
    void MemoryFillKernel(void);

public:
    void FillAction(int nArgc, char* pszArgv[]);

    int MemServerFill(WORD wAddr, WORD wValue, int nType);
    void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                       const unsigned char uchType, WORD* pwData);
    void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                       const unsigned char uchType, char* pszPattern);

};  // End of class: CMemoryFill.

#endif
//////////////////////////////// End of File ////////////////////////////////
