
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMGTDLG.CPP   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMGTDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:10   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:20   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:36   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:12   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:54   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:54   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:06   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:07:06   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMGTDLG.CPP
//
//  Description:The implement file for the class: CMemGtDlg
//
//  Author:     Lane Li & Daniel Lin
//
//  Modification:
//       
//      5. 03/11/96, 1.0 Version          Daniel Lin
//                 Modify for the Address server. All input address must be 
//          processed by address server.   
//                 modify function:     OnMemGotoButton1()
//
//      4. 10/31/95, 0.1g version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//      3. 10/24/95, 0.1d version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//      2. 10/18/95, 0.1d version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memgtdlg.cpp : implementation file

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "resource.h"
//#include "xview.h"
#include "memgtdlg.h"
#include "errno.h"
#include "cpucom.h"
//#include "abibase.h"
#include "cpuserve.h"

// For address server
//
#include "address.h"
#include "addrapi.h"


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


//extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address
extern ADDR_SIZE  dwiMax;        // internal max address
extern ADDR_SIZE  dwiMin;        // internal min address


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

long linLastStartAddr;
unsigned char    linLastCheck; 
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/////////////////////////////////////////////////////////////////////////////
// CMemGtDlg dialog

/****************************************************************************
**  Name: CMemGtDlg
**
**
**  Description:
**        Constructor of CMemGtDlg
**
**  Parameters:
**
*****************************************************************************/
CMemGtDlg::CMemGtDlg(CWnd* pParent /*=NULL*/)
        : CDialog(CMemGtDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMemGtDlg)
          m_memdt_edit = "";
        //}}AFX_DATA_INIT
}

void CMemGtDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CMemGtDlg)
        DDX_Text(pDX, IDC_MEM_GOTO_EDIT1, m_memdt_edit);
        DDV_MaxChars(pDX, m_memdt_edit, 10);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemGtDlg, CDialog)
        //{{AFX_MSG_MAP(CMemGtDlg)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON1, OnMemGotoButton1)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON2, OnMemGotoButton2)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO1, OnUpdateRadio1)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO2, OnUpdateRadio2)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO3, OnUpdateRadio3)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
**
**  CMemGtDlg :: OnInitDialog
**
**  Description:
**     Initial the dialog box
**
**  Parameters:
**     input:
**        none
**
**     output:
**        BOOL:
**
*****************************************************************************/

BOOL CMemGtDlg::OnInitDialog()
{
// In this routine, it should be added into some other routine that is what
//    data's address range the cpu supported.
//    CPUMEMORYRANGE stRange;

    CDialog::OnInitDialog();
    CenterWindow();

    // TODO: Add extra initialization here
    char text[20];
//add by jerry
//  m_nSpace=1;
    m_lAddress = linLastStartAddr;
    //m_nSpace = linLastCheck;

    switch (m_nSpace) {
      case 1:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO1);
         	GetDlgItem(IDC_MEM_GOTO_RADIO3)->EnableWindow(FALSE);
           break;
      case 2:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO2);
           break;
      case 3:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO3);    
           GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
           break;
      default:
           break;
    }
    sprintf(text, "%X", m_lAddress);
    SetDlgItemText(IDC_MEM_GOTO_EDIT1, text);
    CWnd* ctrl;
    ctrl=GetDlgItem(IDC_MEM_GOTO_EDIT1);
    ((CEdit *)ctrl)->SetFocus();
    ((CEdit *)ctrl)->SetSel(0,-1);
    // if the are has a map, remarked by Daniel Lin on 11/10/95
    
//    if (dwpMax == 0 && dwpMin == 0) {
//       GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
//    }
//    if (dwxMax == 0 && dwxMin == 0) {
//           GetDlgItem(IDC_MEM_GOTO_RADIO2)->EnableWindow(FALSE);
//    }
//    if (dwiMax == 0 && dwiMin == 0) {
//       GetDlgItem(IDC_MEM_GOTO_RADIO3)->EnableWindow(FALSE);
//    }
    
    return FALSE;  // return TRUE  unless you set the focus to a control
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton1
**
**  Description:
**     Deal the OK button
**     Modify on 03/11/1996 because all input address field must be processed
**     by Address server
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/

void CMemGtDlg::OnMemGotoButton1()
{
        // TODO: Add your control notification handler code here
        char *buf;
        char *adrerror;
        char value[10];
        int iWhichButton;
        CWnd* ctrl;
        
        // Add by Daniel Lin on 03/11/1996
        // For Address server      
        //
        CString       text;
        ADDRESS       startAddress;
        ADDR_RETCODE  retCode;
        CString       error;
                 
        buf = new char[25];
        ASSERT(NULL != buf);
        adrerror = new char[60];
        ASSERT(NULL != adrerror);
        
        memset(buf, 0, sizeof(buf));
        strcpy(adrerror, "Input Error! The value range is ");
//#ifdef _server_
        iWhichButton = GetCheckedRadioButton(IDC_MEM_GOTO_RADIO1,
                                             IDC_MEM_GOTO_RADIO3);
//#else               
//		iWhichButton=IDC_MEM_GOTO_RADIO1;
//#endif		
		                                             
        switch ( iWhichButton ) {
          case IDC_MEM_GOTO_RADIO1:
                   m_nSpace = 1;
                   linLastCheck = 1;
                   break;
                   
          case IDC_MEM_GOTO_RADIO2:
                   m_nSpace = 2;
                   linLastCheck = 2;
                   break;
                   
          case IDC_MEM_GOTO_RADIO3:
                   m_nSpace = 3;
                   linLastCheck = 3;
                   break;
                   
          default:
                   break;
        }
        
        GetDlgItemText( IDC_MEM_GOTO_EDIT1, buf, 20 );
        text = buf;   
//#ifdef _server_                                            
        retCode = AdrTextToAddr(text, startAddress);
//#else   
//		retCode =ADR_OK; 
		startAddress.adrSpace=SPACE_UNDEFINE;
//#endif        
        if (ADR_OK != retCode) {
          MessageBeep(-1);
//#ifdef _server_                                    
          AdrErrorDeal(retCode, error);            
//#endif          
          MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
          ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
          ((CEdit *)ctrl)->SetFocus();
          ((CEdit *)ctrl)->SetSel(0, -1);
         
          return;
        }
        
        if (SPACE_UNDEFINE != startAddress.adrSpace) {
            MessageBeep(-1);
            MessageBox("Input Error.\nCan not add space area.", "Error", 
                       MB_OK|MB_ICONEXCLAMATION);
            ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
            ((CEdit *)ctrl)->SetFocus();
            ((CEdit *)ctrl)->SetSel(0, -1);
            
            return;
        }    
            
        switch( m_nSpace ) {
             case 1:
                  itoa( (int)dwpMin, value, 16 );
                  strcat( adrerror, "0x" );
                  strcat( adrerror, value );
                  strcat( adrerror, "..0x" );
                  itoa( (int)dwpMax, value, 16 );
                  strcat( adrerror, value );
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
//#ifdef _server_                                                      
                  if (!AdrCheckAddrRange(startAddress)) {
//#else
//				  if(0){
//#endif				                    
                      MessageBeep(-1);
                      MessageBox(adrerror, "Input Error", 
                                 MB_OK|MB_ICONEXCLAMATION);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
             case 2:
                  itoa( (int)dwxMin, value, 16 );
                  strcat( adrerror, "0x" );
                  strcat( adrerror, value );
                  strcat( adrerror, "..0x" );
                  itoa( (int)dwxMax, value, 16 );
                  strcat( adrerror, value );
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;

//#ifdef _server_                                    
                  if (!AdrCheckAddrRange(startAddress)) {
//#else
//				  if(0){
//#endif				  				   	                  
                      MessageBeep(-1);
                      MessageBox(adrerror, "Input Error", 
                                 MB_OK|MB_ICONEXCLAMATION);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
             case 3:
                  itoa( (int)dwiMin, value, 16 );
                  strcat( adrerror, "0x" );
                  strcat( adrerror, value );
                  strcat( adrerror, "..0x" );
                  itoa( (int)dwiMax, value, 16 );
                  strcat( adrerror, value );
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
//#ifdef _server_                                    
                  if (!AdrCheckAddrRange(startAddress)) {
//#else            
//				  if (0) {	      
//#endif				  
                      MessageBeep(-1);
                      MessageBox(adrerror, "Input Error", 
                                 MB_OK|MB_ICONEXCLAMATION);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
        }
        m_lAddress = startAddress.adrAddress;
        linLastStartAddr = startAddress.adrAddress;
        
        if (NULL != buf)   delete []buf;
        if (NULL != adrerror) delete []adrerror;
        
        EndDialog(1);
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton2
**
**  Description:
**     Deal the Cancel button
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/

void CMemGtDlg::OnMemGotoButton2()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}

void CMemGtDlg :: OnUpdateRadio1(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}

void CMemGtDlg :: OnUpdateRadio2(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}

void CMemGtDlg :: OnUpdateRadio3(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}
