 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMMANAG.H__   1.13   13 Dec 1996 11:18:58   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMMANAG.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:58   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:10   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:40   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:10   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:44   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:46   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:40   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:44   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:04   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:24   ZJRD
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: memmanag.h
**
** Title: Memory Manager header
**
** Purpose:
**  Define the interface for the memory manager routines.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/PICSLDV/SRC/LOG/MEMMANAG.H__   1.13   13 Dec 1996 11:18:58   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _MEMMANAG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"
#include "hosterrs.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define INITIAL_TABLE_SIZE (1024L * 8L)
#define MIN_EXPAND_SIZE    (1024L * 8L)

#define NULL_DESCRIPTOR 0L


typedef U32 TABLE_OFFSET;
typedef U8 huge * HPU8;                        // huge pointer to U8
typedef TABLE_OFFSET huge * HP_TABLE_OFFSET;   // huge pointer to TABLE_OFFSET

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/
#ifdef __cplusplus
class Table
   {
protected:
   HANDLE tableHandle;        //Windows handle to table memory
   HPU8 hpTableObject;        //huge pointer to top of table memory
   TABLE_OFFSET tableSize;    //how big the table is
   U32 initialSize;           //size of initial GlobalAlloc
   U32 expandSize;            //size of incremental expansion


public:

//---------------------------------------------------------------------------
// Table    // constructor
// Purpose:
//    Table constructor.  Initializes private and protected variables.
//---------------------------------------------------------------------------
Table() {   // constructor
   tableHandle = 0;
   tableSize = 0L;
   initialSize = INITIAL_TABLE_SIZE;
   expandSize = MIN_EXPAND_SIZE;
}; // end of Table constructor


//---------------------------------------------------------------------------
// GetExpandSize
//
// Purpose:
//    Return the value of the variable that holds the amount of bytes to
//    expand the table with a ReAlloc
// 
//---------------------------------------------------------------------------
U32 GetExpandSize() { return expandSize; };


//---------------------------------------------------------------------------
// GetHugeDataPtr
//
// Purpose:
//    Returns a huge pointer to the item in the table referenced from the
//    tableDataOffset offset.  Does the pointer arithmetic.
//---------------------------------------------------------------------------
HPU8 GetHugeDataPtr(TABLE_OFFSET tableDataOffset)  {
   return (hpTableObject + tableDataOffset);
}; // end of GetHugeDataPtr


//---------------------------------------------------------------------------
// GetInitialSize
//
// Purpose:
//    Return the value of the variable that holds the initial size of table
//    allocation
//---------------------------------------------------------------------------
U32 GetInitialSize() { return initialSize; };


//---------------------------------------------------------------------------
// GetTableSize
//
// Purpose:
//    Return the size of the table that has been alloc'ed to date
//---------------------------------------------------------------------------
TABLE_OFFSET GetTableSize() { return tableSize; };

   
//------------------------------------------------------------------------
// InitOrExtendTable
//
// Purpose:
//    Initialize table if tableSize = 0 else
//    extend the table by <expandSize>.
//
// Input parameters:
//    allocFlag:
//       0 if memory does not need to be zeroed upon initialization
//       GMEM_ZEROINIT if memory needs to be zeroed upon initialization
//
// Output parameters: None
//
// Error:
//    Reports ER_SYM_OUT_OF_MEMORY if memory cannot be Alloc'ed or ReAlloc'ed
//------------------------------------------------------------------------
RETCODE InitOrExtendTable(WORD zeroInitFlag);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetExpandSize
//
// Purpose:
//    Sets the amount of size increase of a ReAlloc when the table is full
//---------------------------------------------------------------------------
VOID SetExpandSize(U32 size) { expandSize = size; };


//---------------------------------------------------------------------------
// SetInitialSize
//
// Purpose:
//    Set initial table size
//---------------------------------------------------------------------------
VOID SetInitialSize(U32 size) { initialSize = size; };

};  // end of class Table
#endif

#define _MEMMANAG_
#endif
/******************************** E O F *************************************/
