
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMSCHDG.CPP   1.13   13 Dec 1996 11:19:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMSCHDG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:58   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:16   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:12   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:26   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:46   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:20   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:50   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:45:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:42   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:16   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMSCHDG.CPP
//
//  Description:The implement file for the class: CMemSearchDlg
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memschdg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"   

#include "address.h"
#include "addrapi.h"
#include "memschdg.h"
#include "ctype.h"  
#include "cpuserve.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//#ifdef _server_
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern int GetTokenNum(char* string);
extern BOOL MemServerSearch(unsigned short uStart, 
                            unsigned short uEnd,
                            unsigned char uchType, 
                            char* pszPattern, 
                            int nInsensitive,
                            unsigned short& uRetAddr);
//#endif
/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg dialog
//

CMemSearchDlg::CMemSearchDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMemSearchDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMemSearchDlg)
      // NOTE: the ClassWizard will add member initialization here
   //}}AFX_DATA_INIT
}

void CMemSearchDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMemSearchDlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemSearchDlg, CDialog)
   //{{AFX_MSG_MAP(CMemSearchDlg)
   ON_BN_CLICKED(IDC_MEMSRH_CANCEL, OnMemsrhCancel)
   ON_BN_CLICKED(IDC_MEMSRH_OK, OnMemsrhOk)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg message handlers

void CMemSearchDlg::OnMemsrhCancel()
{
   // TODO: Add your control notification handler code here
   EndDialog(0);
}

void CMemSearchDlg::OnMemsrhOk()
{
   // TODO: Add your control notification handler code here
   char text[200];
   char input[100], input2[100];
   BOOL bOK;
   int len;
   CWnd* ctrl;
   unsigned short addr;

   char separation[3];
   char str1[200];
   char* temp;
   int i;
   char strToken[6];
   
   bOK=TRUE;
   
   GetDlgItemText(IDC_MEMSRH_EDIT1, text, 190);
   len = strlen(text);
   if ( len <= 0 ) bOK=FALSE;
   input[0]='\0';
   
   if (bOK) {
      if (text[0]=='"') {
         if (text[len-1]=='"') {
            if (len > 32 || len < 3)
               bOK=FALSE;
            else { 
               bOK=FALSE;             	
               lstrcpy(input, text);
               input[len]='\0';
            }  
         }
         else
            bOK = FALSE;
      }
      else {  
//#ifdef _server_      
         len = GetTokenNum(text);
//#else    len= 20;
//#endif         
         if ((len <= 0) || (len > 32))
            bOK=FALSE;
         else {
            separation[0]=' ';
            separation[1]=',';
            separation[2]='\0';       
            
            strcpy(str1, text);
            
            //
            // The tokens is by hexdecimal(default)
            // No leading '0x'
            // In the input radix is changed to the hexidecimal must have
            // leading '0x', the following statment must change
            //
            
            temp = strtok(str1, separation);
            i = strlen(temp);
            
            if (i > 6) bOK=FALSE;
            else {
              ADDRESS  token;  
//#ifdef _server_              
              if (ADR_OK != AdrTextToAddr(temp, token, 0))  // For data
                 bOK = FALSE;
//#else bOK=TRUE;
//#endif
              token.adrSpace = SPACE_UNDEFINE;
//#ifdef _server_              
              if (ADR_OK != AdrAddrToHex(token, strToken))
                 bOK = FALSE;
//#else bOK=TRUE;
//#endif
            }
            
            strcpy(input, strToken+2);
            strcpy(input2, strToken);
            i = lstrlen(input);
            input[i]=' ';
            input[i+1]='\0';
            i = lstrlen(input2);
            input2[i]=' ';
            input2[i+1]='\0';
            
            while(temp!=NULL) {
               temp = strtok(NULL, separation);
               if (temp==NULL) break;
               i = strlen(temp);
               if (i > 6) bOK=FALSE;
               else {
                 ADDRESS  token;
//#ifdef _server_ 
                 if (ADR_OK != AdrTextToAddr(temp, token, 0))    // For data
                   bOK = FALSE;
//#else bOK=TRUE;
//#endif
                 token.adrSpace = SPACE_UNDEFINE;
//#ifdef _server_
                 if (ADR_OK != AdrAddrToHex(token, strToken))
                   bOK = FALSE;
//#else bOK=TRUE;
//#endif
               }  
               
               strcat(input, strToken+2);
               strcat(input2, strToken);
               i = strlen(input);
               input[i]=' ';
               input[i+1]='\0';
               i = strlen(input2);               
               input2[i]=' ';
               input2[i+1]='\0';
            }    
         }
      }
   }
      
   if (bOK) {
      BeginWaitCursor();
      strcpy(m_str, input2);
      
//#ifndef _NOABI
       // Has ABI                             
      CPUMEMORYRANGE stRange; 
      GetMemoryRange(&stRange);
      if (!MemServerSearch(m_StartAddress,
                           stRange.pMax,                     //0xFFFF,
                           m_nSpaceType,
                           input,
                           0, 
                           addr))
         m_lFindAddress = -1;
      else
         m_lFindAddress = (long)addr;
//#endif   // _NOABI
         
      EndWaitCursor();
      EndDialog(1);
   }
   else {
      MessageBox("Input Error",NULL, MB_OK | MB_ICONEXCLAMATION);
      ctrl=GetDlgItem(IDC_MEMSRH_EDIT1);
      ctrl->SetFocus();
      ((CEdit *)ctrl)->SetSel(0,-1);
   }
}
                                             
                                             
BOOL CMemSearchDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();
   
   // TODO: Add extra initialization here
   SetDlgItemText(IDC_MEMSRH_EDIT1,m_str);
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

//////////////////////(EOF of MEMSCHDG.CPP)///////////////////////////

