
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMSRCH.CPP   1.13   13 Dec 1996 11:19:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMSRCH.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:00   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:18   ZJRD
** PIC/SLD Versio 0.96
** 
**    Rev 1.10   06 Nov 1996 12:59:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:24   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:34   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:10   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:44   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:08   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:43:52   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:16   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:02   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:17:34   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMSRCH.CPP
//
//  Description: The implementation file for the class: CMemorySearch.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemorySearch.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memsrch.h"
#include "hosterrs.h"
#include "abiextfn.h"
#include "cpuserver.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CPURegisterFileRange GetCpuRFileRange();


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void SearchCmd(int nArgc, char* pszArgv[]);
BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
    unsigned char uchType, char* pszPattern, int nInsensitive,
    unsigned short& uRetAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiSearch(ADDR addr1, ADDR addr2, 
//                            SEARCH_INFO searchInfo, ADDR* retAddr);
//#endif  // _SERVER_NO_ABI
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SearchCmd().
//
//  Description: The main control routine of Search command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void SearchCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc || 6 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Search EMM contents.
    char tempstr[128];    
    CMemorySearch* pMemorySearch = new CMemorySearch;
    if ( !pMemorySearch ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            ::ErrGetErrorText( ER_GOFLY_ERR_MSG, tempstr );
            ::ShowLine (/*"EP running. Stop EP first"*/tempstr);
          }    
          else {
           pMemorySearch->SearchAction(nArgc, pszArgv);
           delete pMemorySearch;
          }           
       }   
    }

//    CMemorySearch objSearch;
//    objSearch.MemorySearch(nArgc, pszArgv);

}   // End of SearchCmd().


// Memory Search server.
BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
    unsigned char uchType, char* pszPattern, int nInsensitive,
    unsigned short& uRetAddr)
{
    // Assertion of the input parameters.

    // Search EMM contents.
    CMemorySearch* pMemorySearch = new CMemorySearch;
    if ( !pMemorySearch ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (FALSE);
    }
    else {
		BOOL isMatch = pMemorySearch->MemServerSearch(uStart, uEnd, uchType,
				pszPattern, nInsensitive, uRetAddr);
        delete pMemorySearch;
        return (isMatch);
    }

}   // End of MemServerSearch().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemorySearch.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemorySearch::CMemorySearch().
//
//  Description: The construction of the class: CMemorySearch.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemorySearch::CMemorySearch()
{

}   // End of CMemorySearch::CMemorySearch().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemorySearch::~CMemorySearch().
//
//  Description: The destruction of the class: CMemorySearch.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemorySearch::~CMemorySearch()
{

}   // End of CMemorySearch::~CMemorySearch().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemorySearch::SearchAction().
//
//  Description: Search EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemorySearch::SearchAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc || 6 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address, End address & Pattern.
    switch ( nArgc ) {
        case 4:
            // Search adr1 adr2 {"string"|data}
            SetAddrVar(pszArgv[1], m_StartAddr);
            SetAddrVar(pszArgv[2], m_EndAddr);
            SetPattern(pszArgv[3]);
            SetInsensitive(0);
            break;
        case 5:
            if ( !stricmp(pszArgv[3], "INSENSITIVE") ) {
                // SEarch adr1 adr2 Insensitive "string"
                SetAddrVar(pszArgv[1], m_StartAddr);
                SetAddrVar(pszArgv[2], m_EndAddr);
                SetPattern(pszArgv[4]);
                SetInsensitive(1);
            }
            else {
                // SEarch adr1 Length length {"string"|data..}
                SetAddrVar(pszArgv[1], m_StartAddr);
                SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
                SetPattern(pszArgv[4]);
                SetInsensitive(0);
            }
            break;
        case 6:
            // SEarch adr1 Length length Insensitive "string"
            SetAddrVar(pszArgv[1], m_StartAddr);
            SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
            SetPattern(pszArgv[5]);
            SetInsensitive(1);
            break;
        default:
            ASSERT( FALSE );
            return;
    }
    
    // Set SearchInfo.
    SetSearchInfo();
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Search kernel routine.
    MemorySearchKernel();
        
}   // End of CMemorySearch::SearchAction().


void CMemorySearch::SetInsensitive(int nInsensitive)
{
    // Assertion of the input parameters.
    ASSERT( 0 == nInsensitive || 1 == nInsensitive );
    
    // Set the insensitive flag.
    m_uchInsensitive = (unsigned char) nInsensitive;

}   // End of CMemorySearch::SetInsensitive().


void CMemorySearch::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    if ( '\"' == *pszPattern ) {
        // Set "string".
        m_chPatternLen = (char)(strlen(pszPattern) - 2);
        pszPattern[m_chPatternLen+1] = 0;
        for (int i = 0; i < m_chPatternLen;i++)
            m_pchSearch[i] =  pszPattern[i+1];
//        strcpy((LPSTR)m_pchSearch, pszPattern+1);
    }
    else {
        // Set Data: "12 34 ".
        int nNum = 2;
        if (m_StartAddr.m_uchType == MEM_PROGRAM) nNum = 4;
        m_chPatternLen = 0;
        while ( *pszPattern ) {
            char pszData[5];
            memset(pszData, 0, sizeof(pszData));
            for ( int i = 0; i <= nNum; i++ ) {
                if ( ' ' != *pszPattern ) {
                    pszData[i] = *pszPattern++;
                }
                else {
                    pszPattern++;
                    break;
                }
            }
            StrToVar(pszData);
            m_pchSearch[m_chPatternLen++] = (WORD) m_ulVar;
        }
    }

}   // End of CMemorySearch::SetPattern().


void CMemorySearch::SetSearchInfo(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == m_uchInsensitive || 1 == m_uchInsensitive );
    ASSERT( m_chPatternLen >= 1 && m_chPatternLen <= MAX_SEARCH_SIZE );
    
    // Set m_SearchInfo.
    m_SearchInfo.caseFlag = m_uchInsensitive;
    m_SearchInfo.srchBufLen = m_chPatternLen;
    for ( int i = 0; i < m_chPatternLen; i++ ) {
        m_SearchInfo.srchBuf[i] = m_pchSearch[i];
    }

}   // End of CMemorySearch::SetSearchInfo().


void CMemorySearch::MemorySearchKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
	if ( m_StartAddr.m_uchType == MEM_INTERNAL ) {
		CPURegisterFileRange bankRange;
		bankRange = GetCpuRFileRange();
		unsigned short uStart =  m_StartAddr.m_uAddr;
		unsigned short uEnd = m_EndAddr.m_uAddr;
		m_nErrorID = 5;

		for ( int i = 0; i < bankRange.nBanks; i++ ) {
			if ( uStart <= (unsigned short)bankRange.RFileRange[i].nEndAddr &&
				  uEnd >= (unsigned short)bankRange.RFileRange[i].nStartAddr ) {
				m_StartAddr.m_uAddr = 
					max( (unsigned short)bankRange.RFileRange[i].nStartAddr,uStart);
				m_EndAddr.m_uAddr = 
					min( (unsigned short)bankRange.RFileRange[i].nEndAddr,uEnd);

				m_nErrorID = AbiSearch((ADDR&) m_StartAddr, (ADDR&) m_EndAddr,
                           (SEARCH_INFO&) m_SearchInfo, &(ADDR&) m_RetAddr);

				if ( uEnd <= (unsigned short) bankRange.RFileRange[i].nEndAddr ) break;
				else if ( 5 == m_nErrorID ) uStart = m_EndAddr.m_uAddr + 1;
				else  break;
			}
		}
	}
	else {
		m_nErrorID = AbiSearch((ADDR&) m_StartAddr, (ADDR&) m_EndAddr,
                           (SEARCH_INFO&) m_SearchInfo, &(ADDR&) m_RetAddr);
	}
    if ( 5 == m_nErrorID ) {
        // No matched data.
        ShowLine("No such data matched.");
        m_bServerRet = FALSE;
    }
    else if ( 6 == m_nErrorID ) {
        // The data matched.
        DisplayMatchedAddr();
        m_bServerRet = TRUE;
    }
    else if ( 0 != m_nErrorID ) {
        // Display error message.
        DisplayErrorMessage();
        m_bServerRet = FALSE;
    }
    else {
        ASSERT( FALSE );
    }
    
        
}   // End of CMemorySearch::MemorySearchKernel().


void CMemorySearch::DisplayMatchedAddr(void)
{
    // Assertion of the input parameters.
    
    // Format result string.
    strcpy(m_pszResult, "Data matched at: ");
    
    char chType;
    switch ( m_RetAddr.m_uchType ) {
        case MEM_PROGRAM:
            chType = 'P';
            break;
        case MEM_EXTERNAL:
            chType = 'X';
            break;
        case MEM_INTERNAL:
            chType = 'R';
//            chType = 'I';
            break;
        case MEM_SFR:
            chType = 'R';
            break;
        case MEM_BIT:
            chType = 'B';
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    char pszAddr[20];
    wsprintf(pszAddr, "%c:%04X", chType, m_RetAddr.m_uAddr);
    strcat(m_pszResult, pszAddr);
        
    // Display the Search result.
    ShowLine(m_pszResult);

}   // End of CMemorySearch::DisplayMatchedAddr().


// Memory Search server.
BOOL CMemorySearch::MemServerSearch(unsigned short uStart,
    unsigned short uEnd, unsigned char uchType, char* pszPattern,
    int nInsensitive, unsigned short& uRetAddr)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_BIT );

    // Set the server flag.
    m_isServer = TRUE;
        
    // Set parameters.
    m_StartAddr = CMemoryAddr(uStart, uchType);
    m_EndAddr = CMemoryAddr(uEnd, uchType);
    SetPattern(pszPattern);
    SetInsensitive(nInsensitive);
    SetSearchInfo();
    
    // Memory Search kernel routine.
    MemorySearchKernel();
    uRetAddr = m_RetAddr.m_uAddr;
    return (m_bServerRet);

}   // End of CMemorySearch::MemServerSearch().

//////////////////////////////// End of File ////////////////////////////////
