
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMSRCH.H__   1.13   13 Dec 1996 11:19:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMSRCH.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:00   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:18   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:10   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:22   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:38   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:58   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:00   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:12   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:10   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMSRCH.H
//
//  Description: The header file for the class: CMemorySearch.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemorySearch.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMSRCH_
#define _MEMSRCH_

#include "membase.h"
#include "abitype.h"

/////////////////////////////////////////////////////////////////////////////
// CMemorySearch class.
class CMemorySearch : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemorySearch();
    ~CMemorySearch();
    
// Member variables.
public:
    enum { MAX_SEARCH_SIZE = 32 };

private:
    WORD m_pchSearch[MAX_SEARCH_SIZE+1];

    char m_chPatternLen;
    
    unsigned char m_uchInsensitive;
    
    CMemoryAddr m_StartAddr, m_EndAddr, m_RetAddr;
/*    
    struct tagSearchInfo {
        unsigned char uchInsensitive;
        char chPatternLen;
        char pchPattern[MAX_SEARCH_SIZE+1];
    } m_SearchInfo;
*/    
    SEARCH_INFO m_SearchInfo;
    
    BOOL m_bServerRet;
    
// Implementations.
private:
    void SetPattern(char* pszPattern);
    void SetInsensitive(int nInsensitive);
    void SetSearchInfo(void);
    void MemorySearchKernel(void);
    void DisplayMatchedAddr(void);

public:
    void SearchAction(int nArgc, char* pszArgv[]);
    BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
        unsigned char uchType, char* pszPattern, 
        int nInsensitive, unsigned short& uRetAddr);

};  // End of class: CMemorySearch.

#endif
//////////////////////////////// End of File ////////////////////////////////
