
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMWIVW.CPP   1.13   13 Dec 1996 11:19:02   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMWIVW.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:02   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.12   22 Nov 1996 11:00:02   ZJRD
** PIC/SLD Version 0.97
** 
**    Rev 1.11   11 Nov 1996 12:47:20   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:16   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:38   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:51:04   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:54   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:18:02   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:47:36   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:58   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:51:42   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:32:50   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:58   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:16   ZJRD
** Initial revision.
** 
****************************************************************************/

// memwivw.cpp : implementation of the CMemwinView class
//
 
#include "stdafx.h"
#include "memwin.h"

// Added by Gates Hua
#include "cpust.h"   

#include "memwivw.h"
#include "memgtdlg.h"    
#include "memschdg.h" 
#include "address.h"
#include "addrapi.h"
#include "mempage.h"
#include "memdlg.h"
#include "uicom.h"
#include "btnbar.h"
#include "mainfrm.h"
#include "cpuserve.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                     
void UnsignToSign(char* text, int);
extern BOOL GetCpuStatus(unsigned char & uchStatus);                  
#define XM_GETMEM WM_USER+1
extern BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
    unsigned char uchType, char* pszPattern, int nInsensitive,
    unsigned short& uRetAddr);
extern int gSpace;
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
/////////////////////////////////////////////////////////////////////////////
// CMemwinView

IMPLEMENT_DYNCREATE(CMemwinView, CView)


/////////////////////////////////////////////////////////////////////////////
// CMemwinView construction/destruction
int gFirstViewableCol=0;
CPoint gptCaretPos=CPoint(0,0);
extern int gFirstViewableLine;
WORD gwViewStatus ;//=0x0004;
WORD gwGPRFViewStatus ;

 //0x8000=Dsm;
 //0x0104=Byte Hex; 0x0101=Byte Signed;0x0102=Byte Unsigned ;
 //0x0004=Word Hex; 0x0001=Word Signed;0x0002=Word Unsigned;	
void GetMemViewStatus(CWinApp* pWinApp)
{                                     
	gwViewStatus=pWinApp->GetProfileInt("MemWindow","Program_Status" ,0);
    if(gwViewStatus!=0x8000|
       gwViewStatus!=0x0001|
       gwViewStatus!=0x0002|
       gwViewStatus!=0x0004)
       gwViewStatus=0x0004; 

	gwGPRFViewStatus=pWinApp->GetProfileInt("MemWindow","GPRF_Status" ,0);
    if(gwGPRFViewStatus!=0x0101|
       gwGPRFViewStatus!=0x0102|
       gwGPRFViewStatus!=0x0104|
       gwGPRFViewStatus!=0x0001|
       gwGPRFViewStatus!=0x0002|
       gwGPRFViewStatus!=0x0004)
       gwGPRFViewStatus=0x0104; 
}      

void WriteMemViewStatus(CWinApp* pWinApp)
{                                     
	pWinApp->WriteProfileInt("MemWindow","Program_Status" ,gwViewStatus);
	pWinApp->WriteProfileInt("MemWindow","GPRF_Status" ,gwGPRFViewStatus);
}      


CMemwinView::CMemwinView()
{            
//    gwViewStatus=AfxGetApp()->GetProfileInt("MemWindow","Program_Status" ,0);
//    if(gwViewStatus==0) gwViewStatus=0x0004;

    m_isDsm=(BOOL)(gwViewStatus&0x8000);
//    m_ptFirst=CPoint(0,0);
	m_ptFirst.x=0;
	m_ptFirst.y=gFirstViewableLine;
    m_szScroll=CSize(0,0);
    m_isByte=(BOOL)(gwViewStatus&0x0100);
    m_isSigned=(BOOL)(gwViewStatus&0x0001);
    m_nHexORDec=(gwViewStatus&0x0004)?16:10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    m_nLineHeight=18;
    m_ptCaretPos=gptCaretPos;      
    m_nFirstViewableCol=gFirstViewableCol;  
    SetCellEndPos(); 
    m_pMemDsm=NULL;
}

CMemwinView::~CMemwinView()
{               
	gwViewStatus=0;
	if(m_isDsm)	gwViewStatus=0x8000;
	else if(m_nHexORDec==16) gwViewStatus|=0x0004;
	else if(m_isSigned) gwViewStatus|=0x0001;
	else gwViewStatus|=0x0002;         
	
	gFirstViewableCol=m_nFirstViewableCol;
	gptCaretPos=m_ptCaretPos;
    delete m_pMemLayout; 
    m_pMemLayout=NULL;
    if(m_pMemDsm!=NULL){ delete m_pMemDsm;m_pMemDsm=NULL;}
    
}
int CMemwinView::CaretPos2Col(int CaretX)
{
    int n;
    CaretX-=m_nAddrColWidth;
    n=CaretX%m_nColWidth;
    n=n%m_szFont.cx;
    return n;
}            

void CMemwinView::SetCellEndPos()
{
    if(m_isByte)
       if(m_nHexORDec==16)
            m_nCellEndPos=1;
       else if(m_isSigned)
            m_nCellEndPos=3;
       else m_nCellEndPos=2;
    else if(m_nHexORDec==16)
            m_nCellEndPos=3;
         else if(m_isSigned)
                m_nCellEndPos=5;
              else                       
                m_nCellEndPos=4;
}                 

BOOL CMemwinView::CaretOnWndEdge()
{
    CPoint pt;
    pt=GetCaretPos();
    if(m_rectClient.right-pt.x<=m_szFont.cx+m_szFont.cx/2)
       return 1;
    else return 0;   
    
}                    
                    
void CMemwinView::CaretMove(int flag)
{                                                          
            //AfxMessageBox("Your press right arrow.",MB_OK);
    CRect rect=m_rectClient;
    switch(flag){
    //right
    case 0: 
    		if(CaretOnWndEdge()&&
    		   m_pMemLayout->m_nCurrentCaretLine<m_pMemLayout->m_nLines-1)
            {   
                SendMessage(WM_HSCROLL,SB_LINEDOWN, 0);
//              return ;
            }   
            if(m_ptCaretPos.x<m_nCellEndPos)
            {
                m_ptCaretPos.x++;
            }       
            else
            {   if(m_pMemLayout->m_nCurrentCaretCol==m_nCellsPerLine-1)
                {   
                    if(m_pMemLayout->m_nCurrentCaretLine>=m_pMemLayout->m_nLines-1)
                    	return;
                    if(m_nFirstViewableCol!=0)
                        SendMessage(WM_HSCROLL,SB_PAGELEFT,0);
                    m_pMemLayout->m_nCurrentCaretLine++;
                    if(m_pMemLayout->m_nCurrentCaretLine>=\
                       m_pMemLayout->m_nFirstViewableLine+m_nLines-1)//add Dec.14.96
//                     m_pMemLayout->m_nLastViewableLine-1)   // remove on Dec.14,96
                    {
                        SendMessage(WM_VSCROLL,SB_LINEDOWN,0); 
                        m_ptCaretPos.y++; 
//                      m_ptCaretPos.y=m_rectClient.bottom/m_nLineHeight-1;
                    }
                    else m_ptCaretPos.y++;                         
                    m_ptCaretPos.x=0;                  
                    m_pMemLayout->m_nCurrentCaretCol=0;
                }
                else                                    
                {   m_pMemLayout->m_nCurrentCaretCol++; 
                    m_ptCaretPos.x=0;
                }       
            }   
//          m_ptCaretPos.y++; 

            SetMemCaretPos(m_ptCaretPos);       
            break;
    //left
    case 1: if(m_ptCaretPos.x)
                m_ptCaretPos.x--;
            else
            {   
            	if(m_pMemLayout->m_nCurrentCaretCol==0)
                {   
                    if(m_pMemLayout->m_nCurrentCaretLine==0)
                    	break;
                    if(m_pMemLayout->m_nCurrentCaretLine==\
                       m_pMemLayout->m_nFirstViewableLine)
                    {
						  SendMessage(WM_VSCROLL,SB_LINEUP,0);
						  m_ptCaretPos.y--;
						  ASSERT(m_ptCaretPos.y==0);
						    
                    }        
                    m_pMemLayout->m_nCurrentCaretLine--; 
                    SendMessage(WM_HSCROLL,SB_PAGERIGHT,0);
                    m_ptCaretPos.y--;
                  
                    m_ptCaretPos.x=m_nCellEndPos;                  
                    m_pMemLayout->m_nCurrentCaretCol=m_nCellsPerLine-1;
                }
                else                                    
                {   
                    if(m_pMemLayout->m_nCurrentCaretCol==m_nFirstViewableCol)
  						SendMessage(WM_HSCROLL,SB_LINELEFT,0);  
				    m_pMemLayout->m_nCurrentCaretCol--; 
                    m_ptCaretPos.x=m_nCellEndPos;  
                    
                }       
            }   
            SetMemCaretPos(m_ptCaretPos);
            break;
    //Up
    case 2: if(m_pMemLayout->m_nCurrentCaretLine==0) break;
            if(m_pMemLayout->m_nCurrentCaretLine==m_pMemLayout->m_nFirstViewableLine)
            {   SendMessage(WM_VSCROLL,SB_LINEUP,0);
            	m_ptCaretPos.y--;
                ASSERT(m_ptCaretPos.y==0);
            }   
            else m_ptCaretPos.y--;
            m_pMemLayout->m_nCurrentCaretLine--; 
            SetMemCaretPos(m_ptCaretPos);
            break;
    //Down
	case 3: 
			if(m_pMemLayout->m_nCurrentCaretLine>=m_pMemLayout->m_nLines-1) break;
			if(m_pMemLayout->m_nCurrentCaretLine>=
               m_pMemLayout->m_nFirstViewableLine+m_nLines-1)//add Dec.14.96			
//				m_pMemLayout->m_nLastViewableLine)
			{    
				 SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
//				 m_ptCaretPos.y=m_rectClient.bottom/m_nLineHeight-2;
				 m_ptCaretPos.y++;	
			}	 
			else m_ptCaretPos.y++;
			m_pMemLayout->m_nCurrentCaretLine++; 
			SetMemCaretPos(m_ptCaretPos);
			break;
    //Home      
    case 4: if(m_nFirstViewableCol!=0)
                SendMessage(WM_HSCROLL,SB_PAGELEFT,0);
            m_pMemLayout->m_nCurrentCaretCol=0; 
            m_ptCaretPos.x=0;
            SetMemCaretPos(m_ptCaretPos);   
            break;
    //End       
    case 5: 
            SendMessage(WM_HSCROLL,SB_PAGERIGHT,0);
            m_pMemLayout->m_nCurrentCaretCol=m_nCellsPerLine-1; 
            m_ptCaretPos.x=m_nCellEndPos;
            SetMemCaretPos(m_ptCaretPos);
            break;
    //Tab       
    case 6: if(m_pMemLayout->m_nCurrentCaretCol<m_nCellsPerLine-1)
            {   m_pMemLayout->m_nCurrentCaretCol++;
                SetMemCaretPos(m_ptCaretPos);
            }
            break;  
    default:break;
    }           
}                        
                        
BOOL CMemwinView::InputCheck(UINT nChar,int N, BOOL bSign,BOOL isByte) 
{                                          
    int pos;
    pos=m_ptCaretPos.x;
    return m_pMemLayout->CheckInput(nChar,pos,N,bSign,isByte);

}                        

CRect CMemwinView::Caret2Cell(CPoint pt)
{
    CRect rect(0,0,m_nColWidth,m_nLineHeight);
    rect.top=(1+pt.y)*m_nLineHeight;
    rect.left=(m_pMemLayout->m_nCurrentCaretCol-m_nFirstViewableCol)*\
              m_nColWidth+m_nAddrColWidth; 
    rect.right=rect.left+m_nColWidth;
    rect.bottom=rect.top+m_nLineHeight;
    return rect;
}         
 
int CMemwinView::GetGridWidth()
{
    int t=m_nAddrColWidth;
    for(int i=m_nFirstViewableCol;i<m_nCellsPerLine;i++)
        t+=m_nColWidth;
    return t;    
}                
 
void CMemwinView::DrawGrid(CDC* pDC,int nCols,int nRows)
{
    int nWidth=GetGridWidth(); 
    CPen *pGrayPen,* pOldPen;
    pGrayPen=new CPen;
    pGrayPen->CreatePen(PS_SOLID,1,PALETTEINDEX(11));
    pOldPen=pDC->SelectObject(pGrayPen);
    CRect  rect(0,0,min(nWidth,m_rectClient.right),m_nLineHeight);
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    rect.right=min(m_nAddrColWidth,m_rectClient.right);
    rect.bottom=m_rectClient.bottom;
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    pDC->MoveTo(m_nAddrColWidth,0);
    pDC->LineTo(m_nAddrColWidth,m_rectClient.bottom);

    int nGridWidth=m_nAddrColWidth,nGridHeight=m_nLineHeight;         
    for(int i=1;i<nCols;i++)
    {
        nGridWidth+=m_nColWidth;
        if(nGridWidth-m_ptFirst.x>m_nAddrColWidth){
            pDC->MoveTo(nGridWidth-m_ptFirst.x,0);
            pDC->LineTo(nGridWidth-m_ptFirst.x,m_rectClient.bottom);
        }   
    }
    pDC->MoveTo(0,m_nLineHeight);
    pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),m_nLineHeight);
    for(i=1;i<nRows-1;i++)
    {   
        nGridHeight+=m_nLineHeight;
        pDC->MoveTo(0,nGridHeight);
        pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),nGridHeight);//-m_ptFirst.y*m_nLineHeight);
    }            
    pDC->SelectObject(pOldPen);
    pGrayPen->DeleteObject();
    delete pGrayPen;
    pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
//3D Style White                                         
    pDC->MoveTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),0);
    pDC->LineTo(0,0);
    pDC->LineTo(0,m_rectClient.bottom);
    nGridHeight=m_nLineHeight+1;
    for(i=1;i<nRows;i++)    
    {
          pDC->MoveTo(0,nGridHeight);
          pDC->LineTo(m_nAddrColWidth,nGridHeight);
          nGridHeight+=m_nLineHeight;
    }
    nGridWidth=m_nAddrColWidth+1;
    for(i=1;i<nCols;i++)
    {     
          pDC->MoveTo(nGridWidth,0);
          pDC->LineTo(nGridWidth,m_nLineHeight);
          nGridWidth+=m_nColWidth;
    }               
    pDC->SelectObject(pOldPen);

//3D Style Black 
    pDC->MoveTo(m_nAddrColWidth,0);
    pDC->LineTo(m_nAddrColWidth,m_rectClient.bottom);
    pDC->MoveTo(0,m_nLineHeight);
    pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),m_nLineHeight);      
    nGridHeight=m_nLineHeight;
    for(i=1;i<nRows;i++)    
    {
          pDC->MoveTo(0,nGridHeight);
          pDC->LineTo(m_nAddrColWidth,nGridHeight);
          nGridHeight+=m_nLineHeight;
    }
    nGridWidth=m_nAddrColWidth;
    for(i=1;i<nCols;i++)
    {     
          pDC->MoveTo(nGridWidth,0);
          pDC->LineTo(nGridWidth,m_nLineHeight);
          nGridWidth+=m_nColWidth;
    }               

}

BEGIN_MESSAGE_MAP(CMemwinView, CView)
    //{{AFX_MSG_MAP(CMemwinView)
    ON_WM_LBUTTONDOWN()
    ON_WM_CREATE()
    ON_WM_VSCROLL()
    ON_WM_CHAR()
    ON_WM_SIZE()
    ON_WM_HSCROLL()
    ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHex)
    ON_COMMAND(ID_VIEW_SIGNEDDECIMAL, OnViewSigned)
    ON_COMMAND(ID_VIEW_UNSIGNEDDECIMAL, OnViewUnsigned)
    ON_WM_SETFOCUS()
    ON_WM_KILLFOCUS()
    ON_WM_KEYDOWN()
    ON_WM_MOUSEMOVE()
    ON_WM_SETCURSOR()
    ON_WM_LBUTTONUP()
    ON_WM_RBUTTONDOWN()
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchnext)
    ON_COMMAND(ID_EDIT_GOTO, OnEditGoto)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTO, OnUpdateEditGoto)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCH, OnUpdateEditSearch)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchnext)
    ON_WM_LBUTTONDBLCLK()
    ON_COMMAND(ID_VIEW_DISASSEMBLE, OnViewDisassemble)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISASSEMBLE, OnUpdateViewDisassemble)
	ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SIGNEDDECIMAL, OnUpdateViewSigneddecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_UNSIGNEDDECIMAL, OnUpdateViewUnsigneddecimal)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	//}}AFX_MSG_MAP
    ON_MESSAGE(XM_GETMEM,OnXmGetMem)
	ON_MESSAGE(XM_REPAINT,OnXmRepaint)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemwinView drawing



/////////////////////////////////////////////////////////////////////////////
// CMemwinView message handlers
// Modified by Gates Hua
/*  
LONG CMemwinView::OnXmRepaint(UINT,LONG)
{
	m_pMemLayout->GetMemory(1);
	Invalidate();
	UpdateWindow();
	return 1;	
}   
*/
LONG CMemwinView::OnXmRepaint(UINT,LONG)
{
	m_pMemLayout->GetMemory(1);
	if(m_isDsm) {
        delete m_pMemDsm;
	    m_pMemDsm=new CMemDsm(m_pMemLayout->m_nFirstViewableLine*m_nCellsPerLine,
	                  m_pMemLayout->m_nLines*m_nCellsPerLine); 
	    m_pMemDsm->m_nFirstViewableWord=m_pMemLayout->m_nFirstViewableLine*m_nCellsPerLine;
	    m_isDsm=1; 
	    m_pMemDsm->m_szScroll.cy-=m_rectClient.bottom/17; 
	    SetScrollRange(SB_VERT,0,m_pMemDsm->m_szScroll.cy+1);
	    m_pMemDsm->GetInstruction(m_pMemDsm->m_nFirstViewableWord,50,m_pMemDsm->m_dsm);
	    SetScrollPos(SB_HORZ,0);
	}
	Invalidate();
	UpdateWindow();
	return 1;	
}   


LONG CMemwinView::OnXmGetMem(UINT uFlag,LONG)
{
     m_pMemLayout->GetMemory(uFlag);   
     return 0;
}                      
void CMemwinView::SetMemCaretPos(CPoint pt)
{
    CPoint point;
    point.y=(1+pt.y)*m_nLineHeight;
    point.x=(m_pMemLayout->m_nCurrentCaretCol-m_nFirstViewableCol)*\
            m_nColWidth+m_nAddrColWidth+m_szFont.cx/2+pt.x*m_szFont.cx;
    SetCaretPos(point); 
    if(pt.y==-1||point.x<m_nAddrColWidth
       ||pt.y+m_pMemLayout->m_nFirstViewableLine>=m_pMemLayout->m_nLines)
    {ShowCaret(); HideCaret();}
    else ShowCaret();       
}    


void CMemwinView::OnLButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    

if(!m_isDsm){   
    if(!HitTest(point))  return ;
    CPoint ptCell;
    ptCell=Point2Cell(point);
    m_pMemLayout->m_nCurrentCaretLine=ptCell.y+m_pMemLayout->m_nFirstViewableLine;
    m_pMemLayout->m_nCurrentCaretCol=ptCell.x;
    m_ptCaretPos.y=ptCell.y;
    int t;
    t=point.x-m_nAddrColWidth-(ptCell.x-m_nFirstViewableCol)*m_nColWidth;
    if(t<m_szFont.cx/2) m_ptCaretPos.x=0;
    else  m_ptCaretPos.x=(t-m_szFont.cx)/m_szFont.cx;
    SetMemCaretPos(m_ptCaretPos);
    SetActiveWindow();
//    SendMessage(WM_KILLFOCUS);
    SetFocus();
    }
    CView::OnLButtonDown(nFlags, point);
}

BOOL CMemwinView::HitTest(CPoint pt)
{
    if(pt.x<m_nAddrColWidth||pt.y<m_nLineHeight||
       pt.x>m_nAddrColWidth+(m_nCellsPerLine-m_nFirstViewableCol)*m_nColWidth)
        return 0;
    if(pt.y/m_nLineHeight-1+m_ptFirst.y>=m_pMemLayout->m_nLines)
    	return 0;
    return 1;    
}                                                           

CPoint CMemwinView::Point2Cell(CPoint pt)
{
     CPoint point;
     point.y=pt.y/m_nLineHeight-1;
     point.x=(pt.x-m_nAddrColWidth)/m_nColWidth+m_nFirstViewableCol;
     
     return point;
}

int CMemwinView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{

    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;

    m_pMemLayout=new CMemLayout; 
    if(!m_pMemLayout->AllocMemory()) return -1 ; 
    m_pMemLayout->GetMemory(1);
          
    TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    pDC->GetTextMetrics(&tm);
    ReleaseDC(pDC); 

    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
    
    if(m_isByte)
       if(m_nHexORDec==16)
            m_nColWidth=3*m_szFont.cx;
       else if(m_isSigned)
                 m_nColWidth=5*m_szFont.cx;
       else m_nColWidth=4*m_szFont.cx;
    else if(m_nHexORDec==16)
            m_nColWidth=5*m_szFont.cx;
         else if(m_isSigned)
                  m_nColWidth=7*m_szFont.cx;
              else                       
                  m_nColWidth=6*m_szFont.cx;  
    
    m_nAddrColWidth=5*m_szFont.cx; 
    
    DWORD dwStyle=GetStyle();
    dwStyle|=WS_HSCROLL;
    SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);     
    SetScrollPos(SB_VERT,m_ptFirst.y);
	if(m_isDsm) { m_isDsm=FALSE;OnViewDisassemble();}
    return 0;
}
 
void CMemwinView::OnDraw(CDC* pDC)
{
    pDC->SetBkMode(TRANSPARENT );
    pDC->SelectStockObject(ANSI_FIXED_FONT);
  if(!m_isDsm){
    if( m_pMemLayout->m_nFirstViewableLine!=m_ptFirst.y)
        ASSERT( m_pMemLayout->m_nFirstViewableLine==m_ptFirst.y);
    int lines; 
    lines=m_rectClient.bottom/m_nLineHeight+1;
    DrawGrid(pDC,1+m_nCellsPerLine,lines);
    CRect rect(0,0,m_nAddrColWidth,m_nLineHeight);
    pDC->DrawText("Addr",4,&rect,DT_VCENTER|DT_CENTER);
    rect.SetRect(m_nAddrColWidth,0,m_nAddrColWidth+m_nColWidth,m_nLineHeight);
    char text[4]="";
    for(int i=m_nFirstViewableCol;i<m_nCellsPerLine;i++)
    {
        sprintf(text,"%X",i);
        pDC->DrawText(text,1,&rect,DT_VCENTER|DT_CENTER);
        rect.OffsetRect(m_nColWidth,0);
    }
        
    for(i=0;i<lines;i++)
    {
        DrawLine(pDC,i);
    }           
//    if(!m_pMemLayout->m_bWriteDone)
    DrawNewData( pDC);
  }
  else
    m_pMemDsm->Draw(pDC,m_rectClient);          
}                     
    
void CMemwinView::DrawNewData(CDC* pDC)
{
    pDC->SetTextColor(RGB(255,0,0));
    pDC->SetBkMode(OPAQUE);
    CRect rect;
    int x,y; 
    for(int i=0;i<m_pMemLayout->m_arrayNewData.GetSize();i++)
    {
        x=m_pMemLayout->m_arrayNewData[i]&0x000f;
        y=m_pMemLayout->m_arrayNewData[i]>>4;
        if(y<m_pMemLayout->m_nFirstViewableLine) continue;
        
        rect.top=(y-m_pMemLayout->m_nFirstViewableLine+1)*m_nLineHeight+1;
        rect.left=(x-m_nFirstViewableCol)*m_nColWidth+m_nAddrColWidth;
        rect.bottom=rect.top+m_nLineHeight;
        rect.right=rect.left+m_nColWidth;    

        int* pMemInt=(int*)( m_pMemLayout->m_pMemByte ); 
        int addr=(y-m_pMemLayout->m_nStartLine)*m_nCellsPerLine+x; 
        int integer;
        char text[7]="";
        integer=pMemInt[addr];
        if(m_nHexORDec==16)
        {   sprintf(text,"%04X",integer); 
            text[4]=0;
        }    
        else
        if(!m_isSigned)
        {  sprintf(text,"%05u",integer); text[5]=0;}
        else{ UnsignToSign(text,integer);text[6]=0;}
        if(rect.left>=m_nAddrColWidth)
            pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
        
    }
    
    pDC->SetTextColor(RGB(0,0,0));
    pDC->SetBkMode(TRANSPARENT);

    
}    
    
void CMemwinView::DrawLine(CDC* pDC,int line)
{
//  pDC->SetBkMode(OPAQUE);
    if(m_pMemLayout->m_nFirstViewableLine+line>4094) return;
    CRect rect(0,(line+1)*m_nLineHeight+1,m_nAddrColWidth,(line+2)*m_nLineHeight);
    char text[7]="";
    UINT addr; 
    addr=(m_pMemLayout->m_nFirstViewableLine+line)*m_nCellsPerLine;
    if(addr>m_pMemLayout->m_nMemRangeMax||
       addr<m_pMemLayout->m_nMemRangeMin)   
       return ;
    sprintf(text,"%03X",addr); 
    pDC->DrawText(text,3,&rect,DT_VCENTER|DT_CENTER);
    rect.SetRect(m_nAddrColWidth-m_ptFirst.x,(line+1)*m_nLineHeight+1,\
                 m_nAddrColWidth+m_nColWidth-m_ptFirst.x,(line+2)*m_nLineHeight);
    
    if(m_isByte)
    {
        unsigned char uch;
        BYTE * pMemByte=(BYTE*)m_pMemLayout->m_pMemByte;
        addr=(m_pMemLayout->m_nFirstViewableLine+line-m_pMemLayout->\
              m_nStartLine)*16;         
        for(int i=0;i<m_nCellsPerLine;i++)
        {
            uch=m_pMemLayout->m_pMemByte[addr+i];
            if(m_nHexORDec==16)
            {   sprintf(text,"%02x",uch); 
                text[2]=0;
            }    
            else
               if(!m_isSigned)
               {  sprintf(text,"%03u",(UINT)uch); text[3]=0;}
               else{ sprintf(text,"%+04d",(int)uch); text[4]=0;}
            if(rect.left>=m_nAddrColWidth)
                pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
            rect.OffsetRect(m_nColWidth ,0);
        }

    }
    else 
    {
        int* pMemInt=(int*)( m_pMemLayout->m_pMemByte ); 
        addr=(m_pMemLayout->m_nFirstViewableLine+line-m_pMemLayout->\
              m_nStartLine)*8; 
        int integer;
        for(int i=0;i<m_nCellsPerLine;i++)
        {
            integer=pMemInt[addr+i];
            if(m_nHexORDec==16)
            {   sprintf(text,"%04X",integer); 
                text[4]=0;
            }    
            else
               if(!m_isSigned)
               {  
               		sprintf(text,"%05u",(UINT)integer); 
               		text[5]=0;
               }
               else
               {    
               		UnsignToSign(text,integer);
               		text[6]=0;
               }
            if(rect.left>=m_nAddrColWidth)
                pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
            rect.OffsetRect(m_nColWidth ,0);
        }
    }
//  pDC->SetBkMode(TRANSPARENT);    
        
}
       

void CMemwinView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    
    CRect rect; 
    rect=m_rectClient;
    int i;
    rect.left=0;
    rect.top=m_nLineHeight+1;
    // TODO: Add your message handler code here and/or call default
if(!m_isDsm){
    switch(nSBCode) {
        case SB_LINEUP:
            if(m_ptFirst.y <= 0)  return;
             i = m_nLineHeight;
            if(m_pMemLayout->m_nFirstViewableLine==m_pMemLayout->m_nStartLine)
                SendMessage(XM_GETMEM,0,0);
            m_ptFirst.y --;      

            m_pMemLayout->m_nFirstViewableLine--;
            m_pMemLayout->m_nLastViewableLine--; 

            ScrollWindow(0, i,&rect, &rect);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            m_ptCaretPos.y++;
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINEDOWN:    
            if(m_ptFirst.y>= m_szScroll.cy)    return;
            if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nLines-1)
               return;
            i =m_nLineHeight;
            if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nEndLine-1)
                SendMessage(XM_GETMEM,1,0);
            m_ptFirst.y ++;;

            m_pMemLayout->m_nFirstViewableLine++;
            m_pMemLayout->m_nLastViewableLine++;

            ScrollWindow(0,-i,&rect,&rect);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            m_ptCaretPos.y--;
            SetMemCaretPos(m_ptCaretPos);

            break;
        case SB_PAGEUP: 
            if(m_ptFirst.y == 0)    return; 
            if(m_ptFirst.y<m_nPageRange)
                i=m_ptFirst.y;
            else
                i=m_nPageRange;
            m_pMemLayout->m_nFirstViewableLine-=i;
            m_pMemLayout->m_nLastViewableLine=\
              m_pMemLayout->m_nFirstViewableLine+m_nPageRange;  
//25/6
            m_pMemLayout->m_nCurrentCaretLine-=i;

            m_ptFirst.y -=i;
            if(m_pMemLayout->m_nFirstViewableLine<=m_pMemLayout->m_nStartLine)
                SendMessage(XM_GETMEM,0,0);
                  
            ScrollWindow(0,i*m_nLineHeight,&rect,&rect);
//            m_ptCaretPos.y-=m_nPageRange;
            SetScrollPos(SB_VERT, m_ptFirst.y);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_PAGEDOWN:
            if(m_ptFirst.y >= m_szScroll.cy)    return;
            if(m_pMemLayout->m_nFirstViewableLine+m_nPageRange>=
               m_pMemLayout->m_nLines)
                return;
//          if(m_szScroll.cy-m_ptFirst.y<m_nPageRange)
//              return;
//          i=m_szScroll.cy-m_ptFirst.y;
            else i=m_nPageRange;     
            m_pMemLayout->m_nFirstViewableLine+=i;
            m_pMemLayout->m_nLastViewableLine+=i;
            if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nLines)
               m_pMemLayout->m_nLastViewableLine=m_pMemLayout->m_nLines-1;
            
//25/6            
            m_pMemLayout->m_nCurrentCaretLine+=i;
            if(m_pMemLayout->m_nCurrentCaretLine>=m_pMemLayout->m_nLines)
            {
            	m_pMemLayout->m_nCurrentCaretLine=m_pMemLayout->m_nLines-1;	
                m_ptCaretPos.y-=(i-m_pMemLayout->m_nLines+1);
            }
            m_ptFirst.y +=i;
            if(m_ptFirst.y>=m_pMemLayout->m_nLines)
            {
                m_ptFirst.y=m_pMemLayout->m_nLines-1; 

            }       
            if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nEndLine-1)
                SendMessage(XM_GETMEM,1,0);
            InvalidateRect(&rect);
            ScrollWindow(0, -i*m_nLineHeight,&rect,&rect);
 
            //m_ptCaretPos.y+=m_nPageRange;
            SetScrollPos(SB_VERT, m_ptFirst.y);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_THUMBTRACK:  
//             CView::OnVScroll(nSBCode, nPos, pScrollBar);
//             return;                                        
             
        case SB_THUMBPOSITION:           
        
            if(int(nPos) == m_ptFirst.y) return;     
            int t=0;
            t=nPos-m_ptFirst.y;                    
            int FirstViewLine;
            FirstViewLine=m_pMemLayout->m_nFirstViewableLine;
            
            m_pMemLayout->m_nFirstViewableLine+=t;  
            if(m_pMemLayout->m_nFirstViewableLine<0)
                m_pMemLayout->m_nFirstViewableLine=0 ;
            else if(m_pMemLayout->m_nFirstViewableLine>m_pMemLayout->m_nLines-1)
                    m_pMemLayout->m_nFirstViewableLine=m_pMemLayout->m_nLines-1;      
            m_pMemLayout->m_nLastViewableLine+=t; 
            if(m_pMemLayout->m_nLastViewableLine<0)
                m_pMemLayout->m_nLastViewableLine=0 ;
            else if(m_pMemLayout->m_nLastViewableLine>m_pMemLayout->m_nLines-1)
                 {
                    m_pMemLayout->m_nLastViewableLine=m_pMemLayout->m_nLines-1;      
                    
                 }   
            m_ptFirst.y=m_pMemLayout->m_nFirstViewableLine;//m_ptFirst.y+t;
            
//add by jerry  on Dec.14, 1996            
            m_pMemLayout->m_nCurrentCaretLine+=\
            	(m_pMemLayout->m_nFirstViewableLine-FirstViewLine);
//            if(m_ptCaretPos.y+m_pMemLayout->m_nFirstViewableLine>=
//            	m_pMemLayout->m_nLines)
//            	HideCaret();		
//end of add.            	
            
            if(t>0)
            {
                if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nEndLine-1)
                     SendMessage(XM_GETMEM,0,0);
            }        
            else
            {            
                if(m_pMemLayout->m_nFirstViewableLine<=m_pMemLayout->m_nStartLine)
                     SendMessage(XM_GETMEM,0,0);
            }        
            ScrollWindow( 0,t,&rect,&rect);   
            SetScrollPos(SB_VERT, m_ptFirst.y);  
            SetMemCaretPos(m_ptCaretPos);
            Invalidate();
            UpdateWindow();                     
            CView::OnVScroll(nSBCode, nPos, pScrollBar);
            return;
    }  
  }
  else
    m_pMemDsm->VScroll(this,nSBCode,nPos,pScrollBar,m_rectClient);  

    rect=m_rectClient;        
    rect.top=rect.bottom-m_rectClient.bottom%m_nLineHeight-m_nLineHeight;
    InvalidateRect(&rect);
    UpdateWindow();    
    CView::OnVScroll(nSBCode, nPos, pScrollBar);
}       
 
void CMemwinView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
if(!m_isDsm){   
    if(!InputCheck(nChar,m_nHexORDec,m_isSigned,m_isByte) )
        return; 
    CRect rect;
    rect=Caret2Cell(m_ptCaretPos);  

////to support highlight the modified data
    UINT newdata=0;
    newdata=m_pMemLayout->m_nCurrentCaretLine<<4;
    newdata+=m_pMemLayout->m_nCurrentCaretCol;
    m_pMemLayout->m_arrayNewData.Add(newdata);  
    m_pMemLayout->m_bWriteDone=1; //change 0 to 1 for foolish idea of someone
//end of add
    CaretMove(0);// move right      
    InvalidateRect(&rect);
    UpdateWindow();
    }
    CView::OnChar(nChar, nRepCnt, nFlags);
    
}

void CMemwinView::OnSize(UINT nType, int cx, int cy)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    

	CView::OnSize(nType, cx, cy);
	
	GetClientRect(&m_rectClient);
	if(!m_isDsm)                           
	{
//	  int nLine;
	  m_nLines=(m_rectClient.bottom+m_nLineHeight/2)/m_nLineHeight-1;
	  m_pMemLayout->m_nLastViewableLine=m_pMemLayout->m_nFirstViewableLine+\
	    m_nLines-1;
      if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nLines-1)
     	m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nLines-1;
      if(m_pMemLayout->m_nLastViewableLine>=m_pMemLayout->m_nEndLine)
     	SendMessage(XM_GETMEM,1,0);	
	  m_szScroll.cx=m_nColWidth*(m_nCellsPerLine); 
	  if(cy/m_nLineHeight>m_pMemLayout->m_nLines+1)
		m_szScroll.cy=0;
	  else	
		m_szScroll.cy=m_pMemLayout->m_nLines+2-cy/m_nLineHeight;

	  m_szScroll.cx=m_szScroll.cx-(cx-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	  SetScrollRange(SB_HORZ,0,m_szScroll.cx);

	  SetScrollRange(SB_VERT,0,m_szScroll.cy);   
	  m_nPageRange=cy/m_nLineHeight-1;
////////////////////////////////////////////////
	  m_ptFirst.x=0;
	  m_nFirstViewableCol=0;  
	  SetMemCaretPos(m_ptCaretPos);
	  SetScrollPos(SB_HORZ,0);
	}
	else m_pMemDsm->Size(this ,nType,cx,cy);
}

void CMemwinView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    

if(!m_isDsm){
    CRect rect;
    rect=m_rectClient;
    rect.top=0;
    rect.left=m_nAddrColWidth+1;
    int i;                                
    switch(nSBCode) {
        
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  return;  
//            ASSERT(m_nFirstViewableCol!=1);
              i = m_nColWidth;
            m_ptFirst.x -= i;;   
            m_nFirstViewableCol--;
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
//            m_ptCaretPos.x--;
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
               i =m_nColWidth;
            m_nFirstViewableCol++;     
            m_ptFirst.x += i;
            ScrollWindow(-i,0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            SetMemCaretPos(m_ptCaretPos);
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    return;
            i = m_ptFirst.x;
            m_ptFirst.x =0;   
            m_nFirstViewableCol=0;
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x); 
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_PAGERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
            i =m_szScroll.cx-m_ptFirst.x;
            m_nFirstViewableCol+=(m_szScroll.cx-m_ptFirst.x)/m_nColWidth;    
            m_ptFirst.x =m_szScroll.cx;
            ScrollWindow(-i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_THUMBTRACK:
            
            break;
        case SB_THUMBPOSITION:           
            if(int(nPos) == m_ptFirst.x) return;       
            if(nPos>m_ptFirst.x)
            {
                if(m_ptFirst.x >= m_szScroll.cx)    return;
                i =m_szScroll.cx-m_ptFirst.x;
                m_nFirstViewableCol+=(m_szScroll.cx-m_ptFirst.x)/m_nColWidth;    
                m_ptFirst.x =m_szScroll.cx;
                ScrollWindow(-i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }   
            else
            {
                if(m_ptFirst.x == 0)    return;
                i = m_ptFirst.x;
                m_ptFirst.x =0;   
                m_nFirstViewableCol=0;
                ScrollWindow(i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }
            SetMemCaretPos(m_ptCaretPos);
            break;
    } 
    CView::OnHScroll(nSBCode, nPos, pScrollBar);
  }
  else
    m_pMemDsm->HScroll(this ,nSBCode,nPos,pScrollBar,m_rectClient);     
}

void CMemwinView::OnViewHex()
{
    if(m_isDsm)
    {   m_isDsm=0;
        ASSERT(m_pMemDsm!=NULL);
        delete m_pMemDsm;
        m_pMemDsm=NULL;
        SetScrollRange(SB_VERT,0,m_szScroll.cy);
        CreateSolidCaret(1,12);  
        SendMessage(XM_GETMEM,0,0);
//		m_pMemLayout->m_n
    }  

	SendMessage(WM_HSCROLL,SB_PAGELEFT,0);    
    m_isSigned=0;
    m_nHexORDec=16;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
//    m_ptCaretPos=CPoint(0,0);      

    if(m_isByte)
    { 
        m_nColWidth=3*m_szFont.cx;
        m_nCellsPerLine=16;
    }   
    else
    {
        m_nColWidth=5*m_szFont.cx;
        m_nCellsPerLine=8;
    }    

	//modifed by jerry 2/7
	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);

	SetScrollPos(SB_VERT,m_ptFirst.y);
	SetCellEndPos();
//	SetMemCaretPos(m_ptCaretPos); 
  
    Invalidate();
    UpdateWindow(); 
    SetMemCaretPos(m_ptCaretPos); 
//  SendMessage(WM_KILLFOCUS,0,0);
//    SetActiveWindow();
    SetFocus();
}

void CMemwinView::OnViewSigned()
{
    
    if(m_isDsm)
    {   m_isDsm=0;
        ASSERT(m_pMemDsm!=NULL);
        delete m_pMemDsm;
        m_pMemDsm=NULL;
        SetScrollRange(SB_VERT,0,m_szScroll.cy);
        CreateSolidCaret(1,12);
        SendMessage(XM_GETMEM,0,0);  
//        ShowCaret();
    } 
    SendMessage(WM_HSCROLL,SB_PAGELEFT,0);     
    m_isSigned=1;
    m_nHexORDec=10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    //m_ptCaretPos=CPoint(0,0);      
    
//    int pos=GetScrollPos(SB_VERT);
//    ScrollWindow(SB_VERT,-pos);
//    SetScrollPos(SB_VERT,0);
//    m_nFirstViewableCol=0;   
    if(m_isByte)
    { 
        m_nColWidth=5*m_szFont.cx;
        m_nCellsPerLine=16;
    }   
    else
    {
        m_nColWidth=7*m_szFont.cx;
        m_nCellsPerLine=8;
    }    
//    m_ptFirst.x=0;
	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
    SetScrollRange(SB_HORZ,0,m_szScroll.cx);  
    SetScrollPos(SB_VERT,m_ptFirst.y);
    SetCellEndPos();
    SetMemCaretPos(m_ptCaretPos); 
    Invalidate();
    UpdateWindow();
}

void CMemwinView::OnViewUnsigned()
{
    SendMessage(WM_HSCROLL,SB_PAGELEFT,0);    
    if(m_isDsm)
    {   m_isDsm=0;
        ASSERT(m_pMemDsm!=NULL);
        delete m_pMemDsm;
        m_pMemDsm=NULL;
        SetScrollRange(SB_VERT,0,m_szScroll.cy);
        CreateSolidCaret(1,12); 
        SendMessage(XM_GETMEM,0,0);
//        ShowCaret();
    }   
    m_isSigned=0;
    m_nHexORDec=10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
//    m_ptCaretPos=CPoint(0,0);      
//	int pos=GetScrollPos(SB_VERT);
    //ScrollWindow(SB_VERT,-pos);
//    SetScrollPos(SB_VERT,0);
//    m_nFirstViewableCol=0; 
    if(m_isByte)
    {
       m_nColWidth=4*m_szFont.cx;
       m_nCellsPerLine=16;
    }   
    else
    {  
       m_nColWidth=6*m_szFont.cx;
       m_nCellsPerLine=8;
    }             
//    m_ptFirst.x=0; 
//modifed by jerry 2/7
	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);  
	SetScrollPos(SB_VERT,m_ptFirst.y);
    SetCellEndPos(); 
    SetMemCaretPos(m_ptCaretPos); 
    Invalidate();
    UpdateWindow();
}
    
    
void CMemwinView::OnSetFocus(CWnd* pOldWnd)
{
    CView::OnSetFocus(pOldWnd); 
    if(!m_isDsm){
    CreateSolidCaret(1,12);
    SetMemCaretPos(m_ptCaretPos);
    }
}      
       
void CMemwinView::OnKillFocus(CWnd* pNewWnd)
{
    CView::OnKillFocus(pNewWnd);
    
    ::DestroyCaret();
    
}
 
/////////////////////////////////////////////////////////////////////////////
// CMemwinView diagnostics

#ifdef _DEBUG
void CMemwinView::AssertValid() const
{
    CView::AssertValid();
}

void CMemwinView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CMemwinDoc* CMemwinView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMemwinDoc)));
    return (CMemwinDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMemwinView message handlers

void CMemwinView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    
     switch (nChar) {
        case VK_RIGHT:
               if(!m_isDsm)
               CaretMove(0);
               break;
        case VK_LEFT:      
        	if(!m_isDsm)
               CaretMove(1);
               break;
        case VK_UP:     
        	if(!m_isDsm)
               CaretMove(2);
            else SendMessage(WM_VSCROLL,SB_LINEUP,0);                  
               break;
        case VK_DOWN:     	                            
        	if(!m_isDsm)
               CaretMove(3);  
            else SendMessage(WM_VSCROLL,SB_LINEDOWN,0);             
               break;
        case VK_PRIOR:
               SendMessage(WM_VSCROLL,SB_PAGEUP,0); 
               break;         
        case VK_NEXT:
               SendMessage(WM_VSCROLL,SB_PAGEDOWN,0);           
               break;    
        case VK_HOME:       
               if(!m_isDsm)
               CaretMove(4);
               break;
        case VK_END:
               if(!m_isDsm)
               CaretMove(5);               
               break;
    
        case VK_TAB:
               CaretMove(6);                       
               break; 
        case VK_RETURN:
                if(!m_pMemLayout->m_bWriteDone)
                {  m_pMemLayout->WriteMemory();
                   Invalidate();    
                   m_pMemLayout->m_arrayNewData.RemoveAll();
                   m_pMemLayout->m_bWriteDone=1;
                   UpdateWindow();
                }   
                break;
                   
    }
    CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMemwinView::OnMouseMove(UINT nFlags, CPoint point)
{

 if(!m_isDsm){    
    if(HitTest(point))
    {
        SetCursor(::LoadCursor(NULL,IDC_IBEAM)); 
    }
    else                                 
    {
        SetCursor(::LoadCursor(NULL,IDC_ARROW));
    }             
 }   
    CView::OnMouseMove(nFlags, point);
}

BOOL CMemwinView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
////        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
//    ((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
//    return CView::OnSetCursor(pWnd, nHitTest, message);
//    }   
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
		if ( STATUS_GO == uchStatus ) 
	    	((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
	    else 
	    	((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is sleeping !");		
    	return CView::OnSetCursor(pWnd, nHitTest, message);
    }   

    // TODO: Add your message handler code here and/or call default
    if(!m_isDsm){
      if((message==WM_LBUTTONDOWN||
        message==WM_RBUTTONDOWN||
        message==WM_LBUTTONUP||
        message==WM_RBUTTONUP||
        message==WM_MOUSEMOVE)&&HTCLIENT==nHitTest)
        return FALSE;
    }
    else if(!m_pMemDsm->SetCursor(pWnd,nHitTest,message))  return FALSE;   
    return CView::OnSetCursor(pWnd, nHitTest, message);
}

void CMemwinView::OnLButtonUp(UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    
    // TODO: Add your message handler code here and/or call default
    CView::OnLButtonUp(nFlags, point);
}



void CMemwinView::OnRButtonDown(UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    
    // TODO: Add your message handler code here and/or call default
        CMenu * pLocalMenu = new CMenu;

    ASSERT(pLocalMenu!=NULL);
    pLocalMenu->CreatePopupMenu();
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_GROUP_MEMORY, "&Memory...");
//  pLocalMenu->AppendMenu(MF_STRING, ID_MAP, "Ma&p...");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTO, "&Goto...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
UINT flag;
	flag=(m_nHexORDec==16&&(!m_isDsm))?MF_STRING|MF_CHECKED:MF_STRING|MF_UNCHECKED;   
//    pLocalMenu->AppendMenu(flag,ID_VIEW_HEXADECIMAL, "&Hexadecimal");
    pLocalMenu->AppendMenu(MF_STRING,ID_VIEW_HEXADECIMAL, "&Hexadecimal");    


    flag=(m_nHexORDec==10&&m_isSigned&&(!m_isDsm))?MF_STRING|MF_CHECKED:MF_STRING|MF_UNCHECKED;
    pLocalMenu->AppendMenu(MF_STRING,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    
    flag=(m_nHexORDec==10&&(!m_isSigned)&&(!m_isDsm))?MF_STRING|MF_CHECKED:MF_STRING|MF_UNCHECKED;
    pLocalMenu->AppendMenu(MF_STRING,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    
    flag=m_isDsm?MF_STRING|MF_CHECKED:MF_STRING|MF_UNCHECKED;
    pLocalMenu->AppendMenu(MF_STRING,ID_VIEW_DISASSEMBLE, "&Disassemble");
    
//  pLocalMenu->AppendMenu(MF_SEPARATOR);

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_CENTERALIGN, point.x, point.y, GetParent());
    delete pLocalMenu;
    CView::OnRButtonDown(nFlags, point);
}

void CMemwinView::OnEditSearch()
{
    // TODO: Add your command handler code here
    CMemSearchDlg dlg(this);
    int i;
    dlg.m_nSpaceType =1;
    dlg.m_StartAddress = (unsigned short)m_pMemLayout->m_nFirstViewableLine*\
                          m_nCellsPerLine;
    dlg.m_StartAddress += (unsigned short)(m_pMemLayout->m_nCurrentCaretCol);

    strcpy(dlg.m_str, m_searchStr);
    i = dlg.DoModal();
    if (i)
    {
        m_searchStr=dlg.m_str;
        if (dlg.m_lFindAddress == -1)
        {
           MessageBox("Not Found!",NULL, MB_OK);
           return;
        } 
        GotoAddress(dlg.m_lFindAddress);
    }   
}
     
     
void CMemwinView::OnEditSearchnext()
{  
    int i;
    unsigned short startAddress;
    unsigned short addr;
    long FindAddress;
    BOOL bFind;
    char *text;

    text = new char [200];
    ASSERT(NULL != text);
    i = strlen(m_searchStr);
    if (i<=0) 
       OnEditSearch();
    else
    {
       BeginWaitCursor();
       startAddress =(unsigned short)m_pMemLayout->m_nFirstViewableLine*\
                       m_nCellsPerLine;
       startAddress +=(unsigned short)(m_pMemLayout->m_nCurrentCaretCol)+1;
       strcpy(text,m_searchStr.GetBuffer(16)+2);
       m_searchStr.ReleaseBuffer();  
//9/19/96 jerry       
       CPUMEMORYRANGE stRange;
       GetMemoryRange(&stRange);
       bFind = MemServerSearch((WORD)startAddress,stRange.pMax,
                               1,text,0,addr);
       EndWaitCursor();
       if (!bFind)
       {
          MessageBox("Not Found!",NULL, MB_OK);
          return;
       }
       else
       {
          FindAddress = (long)addr;
		  GotoAddress(FindAddress); 
//        SetScrollPos(SB_VERT, (UINT)(m_lStartAddress/0x10), TRUE);
//		  InvalidateRect(NULL, FALSE);
       }
    }
    delete []text;
}

void CMemwinView::GotoAddress(long address)
{
      if(!m_isDsm){ 
        int addrQ,addrM;
        addrQ=address/8;  //m_nCellsPerLine
        addrM=address%8;
//        m_pMemLayout->m_nLastViewableLine+=addrQ-m_pMemLayout->m_nFirstViewableLine;
//        m_pMemLayout->m_nFirstViewableLine=addrQ;
//        m_pMemLayout->GetMemory(1);
//        m_ptFirst.y=addrQ;
//		ScrollWindow(0,
//        SetScrollPos(SB_VERT,m_ptFirst.y);
		SendMessage(WM_VSCROLL,SB_THUMBPOSITION,addrQ);
        m_ptCaretPos.y=0;
        m_ptCaretPos.x=0;
        m_pMemLayout->m_nCurrentCaretLine=addrQ;        
        m_pMemLayout->m_nCurrentCaretCol=addrM;
        SetMemCaretPos(m_ptCaretPos);
      }
      else{
        ASSERT(m_pMemDsm!=NULL);
//        m_pMemDsm->m_nFirstViewableWord=address;
//        m_pMemDsm->GetInstruction(address,40,m_pMemDsm->m_dsm);
//        m_pMemDsm->m_ptFirst.y=address;
//      SetScrollPos(SB_VERT,m_pMemDsm->m_ptFirst.y);
		SendMessage(WM_VSCROLL,SB_THUMBPOSITION,address);
      }         

} 
 
void CMemwinView::OnEditGoto()
{
	CMemGtDlg* pMemGtDlg;
	pMemGtDlg=new CMemGtDlg; 
	pMemGtDlg->m_nSpace=1;
	if(1==pMemGtDlg->DoModal() )
	{
      GotoAddress(pMemGtDlg->m_lAddress);
   	  Invalidate();
	  UpdateWindow();
	}	
	delete pMemGtDlg;
}


void CMemwinView::OnUpdateEditGoto(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    if (IsIconic())
       pCmdUI->Enable(FALSE);
    else
       pCmdUI->Enable(TRUE);
#ifndef _NOABI        
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }      
    }         
#endif    
}

void CMemwinView::OnUpdateEditSearch(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
        unsigned char  uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus 
          || STATUS_SLEEPING == uchCpuStatus
          || m_isDsm) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        
        pCmdUI->Enable(TRUE);
      }             
   }   
}

void CMemwinView::OnUpdateEditSearchnext(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
        unsigned char  uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus 
          || STATUS_SLEEPING == uchCpuStatus
          || m_isDsm ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }     
   }   
} 


void CMemwinView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {	
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	return ;
    }    
    
    if(m_isDsm)
    {
        m_pMemDsm->LButtonDblClk(this,nFlags,point);
        ASSERT(m_pMemDsm!=NULL);
    }   
    CView::OnLButtonDblClk(nFlags, point);
}   


void CMemwinView::OnViewDisassemble()
{
    // TODO: Add your command handler code here
 if(!m_isDsm)
 {
    m_pMemDsm=new CMemDsm(m_pMemLayout->m_nFirstViewableLine*m_nCellsPerLine,
                  m_pMemLayout->m_nLines*m_nCellsPerLine); 
    m_pMemDsm->m_nFirstViewableWord=m_pMemLayout->m_nFirstViewableLine*m_nCellsPerLine;
    m_isDsm=1; 
    m_pMemDsm->m_szScroll.cy-=m_rectClient.bottom/17; 
    SetScrollRange(SB_VERT,0,m_pMemDsm->m_szScroll.cy+1);
    m_pMemDsm->GetInstruction(m_pMemDsm->m_nFirstViewableWord,50,m_pMemDsm->m_dsm);
    SetScrollPos(SB_HORZ,0);
    ShowCaret();
    HideCaret();
    Invalidate();
    UpdateWindow();
 }  
}

void CMemwinView::OnUpdateViewDisassemble(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char  uchCpuStatus;
    pCmdUI->SetCheck(m_isDsm);
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }      
	}
    
}


void CMemwinView::OnGroupMemory()
{
	// TODO: Add your command handler code here
	gSpace=0;
	CMemDlg memoryDlg(this); 
    memoryDlg.DoModal();
}

void CMemwinView::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_nHexORDec==16&&!m_isDsm); 
	    unsigned char  uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }     
    }  
}


void CMemwinView::OnUpdateViewSigneddecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_isSigned&&m_nHexORDec==10&&!m_isDsm); 
	    unsigned char  uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }
    }       
}

void CMemwinView::OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(!m_isSigned&&m_nHexORDec==10&&!m_isDsm);
	    unsigned char  uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua
//     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
     if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }
    }    
}
void CMemwinView::OnViewRefresh()
{
	SendMessage(XM_GETMEM,1,0);	
	Invalidate();
	UpdateWindow();
}


