
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/METER.H__   1.13   13 Dec 1996 11:19:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/METER.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:04   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:04   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:14   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:28   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:02   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:42   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:08   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:14   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:38   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  METER.H
//
//  Description:The header file for the class: CMeterControl
//
//  Author:     Roger Zhang
//
//  Date:       10/16/95
//
//  Modification:
//
//      1. 10/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _METER_
#define _METER_

// Meter control sends WM_CTLCOLOR message to parent window 
// with the following identifier with in the HIWORD of the lParam.
#define CTLCOLOR_METER     (100)

// Meter control doesn't have any class-specific window styles.

// Meter control's class-specific window messages.
#define MM_SETPARTSINJOB         (WM_USER + 0)
#define MM_GETPARTSINJOB         (WM_USER + 1)
#define MM_SETPARTSCOMPLETE      (WM_USER + 2)
#define MM_GETPARTSCOMPLETE      (WM_USER + 3)

// Meter control has no notification codes to send to parent.

#define DLG_STYLEDLG    1000
#define ID_VALUE        100


class CMeterControl : public CWnd
{
    DECLARE_DYNAMIC(CMeterControl)

// Constructors
public:
    CMeterControl();
    BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);

// Attributes                                  
    void SetPartsInJob(WORD wParts);
    WORD GetPartsInJob(void);
    void SetPartsComplete(WORD wParts);
    WORD GetPartsComplete(void);

// Implementation
protected:
    virtual WNDPROC* GetSuperWndProcAddr();
};

/////////////////////////////////////////////////////////////////////////////
// inlines                      
inline CMeterControl::CMeterControl() {}
inline void CMeterControl::SetPartsInJob(WORD wParts)
{ SendMessage(MM_SETPARTSINJOB, wParts); }
inline WORD CMeterControl::GetPartsInJob(void)
{ return (WORD)SendMessage(MM_GETPARTSINJOB); }
inline void CMeterControl::SetPartsComplete(WORD wParts)
{ SendMessage(MM_SETPARTSCOMPLETE, wParts); }
inline WORD CMeterControl::GetPartsComplete(void)
{ return (WORD)SendMessage(MM_GETPARTSCOMPLETE); }

#endif
//////////////////////////////(EOF)//////////////////////////////////////////
