
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/NWMEM.H__   1.13   13 Dec 1996 11:19:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/NWMEM.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:26   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:40   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:06   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:40   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:44   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:09:00   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  NWMEM.H
//
//  Description:The header file for the class: CNewMemory
//
//  Author:     Lane Li
//
//  Modification:
//
//      3. 03/15/1996   1.0 version          Daniel Lin
//                   Add some remark
//
//      2. 19/10/95, 0.1d version
//                   Modified        CNewMemory
//                                   add private variable m_lLastStart;
//
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// nwmem.h : header file

/////////////////////////////////////////////////////////////////////////////
// CNewMemory frame

class CNewMemory : public CMDIChildWnd
{
        DECLARE_DYNCREATE(CNewMemory)
public:
        CNewMemory();                   // protected constructor used by dynamic creation
        BOOL Create(LPCSTR szTitle, LONG style = 0,
                    const RECT& rect = rectDefault, 
                    CMDIFrameWnd * pParent = NULL );

// Attributes
public:
        //CWnd* m_wnd;
        static CMenu NEAR m_menu;
        unsigned char m_nSpaceType;
        long  m_lStartAddress;
        int m_nWndNo;
        BOOL m_bFocus;

        int m_nLines;
        BOOL m_bModeLine;
        BYTE* m_byMem;
        struct dsm *m_dsm;

        BOOL m_bGetMemory;
        BOOL m_bEndOfMem;

        CGrid m_gridAddr;           // Address grid
        CGrid m_gridMem;            // Memory grid
        CGrid m_gridAscii;          // Ascii grid
        CGrid m_gridInstruction;    // Instruction grid(only for disassembly)
        UINT m_nInstructionWidth;

        BOOL m_bGridRedraw;
        BOOL m_bGridDrawn;
        int m_nScrollFlags;
        
        // m_nViewMode1    1  --    Byte
        //                 2  --    WORD
        //                 3  --    LONG
        //
        // m_nViewMode2    1  --    Signed Decimal
        //                 2  --    Unsigned Decimal
        //                 3  --    Hexdecimal
        //                 4  --    Disassenbly
        //
        
        int m_nViewMode1;
        int m_nViewMode2;
        BOOL m_bShowAscii;

        int m_nPosX;          // Scroll increase
        

        UINT m_nCaretPosX1;   // Indicate the every grid position
        UINT m_nCaretPosX2;   // Indicate every char in one grid
        UINT m_nCaretPosY;
        int m_nCaretArea;

        int m_nCharWidth;

        int m_nCursor;

        int m_nKeyFlag;

        long m_lValue;
        WORD m_wValue;
        BYTE m_byValue;
        char* m_lpszValue;

        static char m_searchStr[200];

// Operations
public:             
        void   ShowStatusGo();
        
        void SetWindowTitle();

        void GetMemory();

        void FillText(LPCSTR,UINT,RECT,CDC*);
        void FillText2(LPCSTR,UINT,RECT,CDC*);
        void FillText3(LPCSTR,UINT,RECT,CDC*);
        void SetScrollBar();
        void ScrollMemWnd(int);

        void SetByteSignedDecimal();
        void SetWordSignedDecimal();
        void SetLongSignedDecimal();

        void SetByteUnsignedDecimal();
        void SetWordUnsignedDecimal();
        void SetLongUnsignedDecimal();

        void SetByteHexadecimal();
        void SetWordHexadecimal();
        void SetLongHexadecimal();

        void SetDisassemble();

        void SetAddress();

        void SetAscii();

        void SetInstruction();

        void SetMemoryWindow();

        void ShowByteSignedDecimal(CDC*);
        void ShowWordSignedDecimal(CDC*);
        void ShowLongSignedDecimal(CDC*);

        void ShowByteUnsignedDecimal(CDC*);
        void ShowWordUnsignedDecimal(CDC*);
        void ShowLongUnsignedDecimal(CDC*);

        void ShowByteHexadecimal(CDC*);
        void ShowWordHexadecimal(CDC*);
        void ShowLongHexadecimal(CDC*);

        void ShowDisassemble(CDC*);

        void ShowAddress(CDC*);

        void ShowAscii(CDC*);

        void ShowInstruction(CDC*);

        void ShowMemoryWindow(CDC*);

        void SetMyCaretPos();

        void GotoCursor();

        BOOL InWnd();

        void Right();
        void Left();
        void Up();
        void Down();
        void Home();
        void End();
        void Tab();
        void Tab2();
        void Back();
        void Space();

        BOOL InputCheck(UINT);
        void WriteMemory(UINT);
        void GetValue();
        void ValueToStr();
        BOOL StrToValue();

// Implementation
public:
        virtual ~CNewMemory();

        // Generated message map functions
        //{{AFX_MSG(CNewMemory)
        afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
        afx_msg void OnPaint();
        afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
        afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
        afx_msg void OnViewByte();
        afx_msg void OnUpdateViewByte(CCmdUI* pCmdUI);
        afx_msg void OnViewWord();
        afx_msg void OnUpdateViewWord(CCmdUI* pCmdUI);
        afx_msg void OnViewLong();
        afx_msg void OnUpdateViewLong(CCmdUI* pCmdUI);
        afx_msg void OnViewFloat();
        afx_msg void OnUpdateViewFloat(CCmdUI* pCmdUI);
        afx_msg void OnViewDouble();
        afx_msg void OnUpdateViewDouble(CCmdUI* pCmdUI);
        afx_msg void OnViewSigneddecimal();
        afx_msg void OnUpdateViewSigneddecimal(CCmdUI* pCmdUI);
        afx_msg void OnViewHexadecimal();
        afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
        afx_msg void OnViewDisassemble();
        afx_msg void OnUpdateViewDisassemble(CCmdUI* pCmdUI);
        afx_msg void OnViewAscii();
        afx_msg void OnUpdateViewAscii(CCmdUI* pCmdUI);
        afx_msg void OnViewUnsigneddecimal();
        afx_msg void OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI);
        afx_msg void OnSize(UINT nType, int cx, int cy);
        afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
        afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
        afx_msg void OnSetFocus(CWnd* pOldWnd);
        afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
        afx_msg void OnMouseMove(UINT nFlags, CPoint point);
        afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg long OnXMRepaint(UINT,LONG);
        afx_msg void OnKillFocus(CWnd* pNewWnd);
        afx_msg void OnEditGoto();
        afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
        afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
        afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
        afx_msg void OnViewRefresh();
        afx_msg void OnUpdateViewRefresh(CCmdUI* pCmdUI);
        afx_msg void OnEditSearch();
        afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
        afx_msg void OnEditSearchnext();
        afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
        afx_msg void OnStkTab();
        afx_msg void OnShiftreturn();
        afx_msg void OnGroupMemory();
        afx_msg void OnMap();
        afx_msg void OnUpdateMap(CCmdUI* pCmdUI);
        afx_msg void OnUpdateGroupMemory(CCmdUI* pCmdUI);
   afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
   afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
	afx_msg UINT OnNcHitTest(CPoint point);
	//}}AFX_MSG
        DECLARE_MESSAGE_MAP()
private:
        //long  m_lLastStart;           // Added by Daniel Lin.  
        unsigned short pMax,pMin,xMax,xMin,iMax,iMin;        
};

/////////////////////////////////////////////////////////////////////////////
#define AddressWidth       36//66
#define AsciiWidth         130
#define InstructionWidth   200

#define ByteSignedDecimalWidth   38   //34
#define WordSignedDecimalWidth   55   //50
#define LongSignedDecimalWidth   95   //90

#define ByteUnsignedDecimalWidth 30 //26
#define WordUnsignedDecimalWidth 47 //42
#define LongUnsignedDecimalWidth 87 //82

#define ByteHexadecimalWidth  22  //18
#define WordHexadecimalWidth  38  //34
#define LongHexadecimalWidth  72  //66

#define DisassembleWidth      80

struct dsm
{
        long address;
        char code[10];
        char instruction[256];
};
