 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/PER6VIEW.CPP   1.13   13 Dec 1996 11:19:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/PER6VIEW.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:32   ZJRD
** PIC/SLD Version 0.95
** 
**    Rev 1.9   02 Nov 1996 09:48:18   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:42   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:30   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:17:42   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:47:16   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:12   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:46   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:52   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:06   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  PER6VIEW.CPP
//
//  Description:The implementation file of the CPer6View class for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// per6view.cpp : implementation of the CPer6View class
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"

#include "per6doc.h"
#include "per6view.h"
#include "flddlg.h"

#include "mylist.h" 
#include "listcol.h"   
#include "spin.h" 
#include "perwin.h"
#include "abibase.h"    
#include "uicom.h"  
#include "hosterrs.h"  
#include "abiextfn.h"
#include "cpucom.h"
//#include "cpuserve.h"
                          
#define CPU_INFOR_START   20000                            
                          
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  

extern STATUS AbiGetCpuId(UINT*);
//extern STATUS AbiGetOneReg(REG_ID,UINT*);


int ITEMRANGE; 
int START_ID;
extern UINT cpuid; 
REGISTER  RegVal[MAXRANGE];
HINSTANCE hPerLib;
/////////////////////////////////////////////////////////////////////////////
// CPer6View

IMPLEMENT_DYNCREATE(CPer6View, CView)

BEGIN_MESSAGE_MAP(CPer6View, CView)
    //{{AFX_MSG_MAP(CPer6View)
        ON_WM_CREATE()  
    ON_WM_SIZE()
    ON_LBN_DBLCLK(IDC_LIST1, OnDblclkList1)
    ON_COMMAND(ID_VIEW_PER6TYPE_FRESH, OnFresh)
    ON_COMMAND(ID_VIEW_COMPRESS, OnViewCompress)
    ON_COMMAND(ID_VIEW_EXPAND, OnViewExpand)
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
    //ON_COMMAND(IDR_FILE_EXIT, OnFileExit)

/////////////////////////////////////////////////////////////////////////////
// CPer6View construction/destruction

CPer6View::CPer6View()
{     
     m_Expanded=FALSE;   
     m_pList=NULL;   
    
}

CPer6View::~CPer6View()
{ 

	if(hPerLib!=NULL)
		FreeLibrary(hPerLib);
	if(m_pList!=NULL)
		delete m_pList;
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View drawing

void CPer6View::OnDraw(CDC* )
{
    CPer6Doc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View diagnostics

#ifdef _DEBUG
void CPer6View::AssertValid() const
{
    CView::AssertValid();
}

void CPer6View::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CPer6Doc* CPer6View::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPer6Doc)));
    return (CPer6Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPer6View message handlers
int CPer6View::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
//  char buffer[64]="";
 /////////////////////////////////////////////////      
     AbiGetCpuId(&cpuid); 
 //////////////////////////////////////////
    char szcupid[8]="";  
    char sztemp[256]="";
     _itoa(cpuid,szcupid,10);
    LPSTR lpDLLName; 
    switch (cpuid)  {
           case 0:  
           case 1:
           case 2:
           case 3:
           case 4:
           case 5:
           case 6: 
           case 7:
           case 8: 
     
               lpDLLName="pic_5x.DLL";
               break; 
           case 9:
    	   case 13:
    	   case 14:
           case 15:
           case 16:

	       	   lpDLLName="pic_6x.DLL";
	       	   break;
           case 11:
           case 12:
           case 10:
           
           		lpDLLName="pic_62x.dll";
           		break;	       	   
	       case 18:
	       case 19:
	       case 17:
	       case 21:
	       	   lpDLLName="pic_7x.DLL";	   
	       	   break;
    	   case 20:
    	   	   lpDLLName="pic_84.DLL";	   
    	   		break;
	       default :
//             AfxMessageBox("No Information for this CPU!",MB_OK);
               ErrDisplayError(ER_PRE_CPU_NO_INFO);
               return -1;
       }
    if ( (hPerLib= LoadLibrary(lpDLLName)) < HINSTANCE_ERROR)
	{
		ErrDisplayError(ER_PRE_CPU_NO_INFO);
		return -1;
	 }  
	 if(0==::LoadString(hPerLib,20000+cpuid, sztemp, 255))
	 {	ErrDisplayError(ER_PRE_CPU_NOT_SUPPORT); 
        return -1;
	  }                        
     char*token;         
     token=strtok(sztemp,",");
     ITEMRANGE=atoi(token);
     token=strtok(NULL,",");
     START_ID=atoi(token);
     token=strtok(NULL,",");
     for (int i=0;i<ITEMRANGE;i++)                
      {
        RegVal[i].id=atoi(token);  // the hardware register id
        AbiGetOneReg((WORD)RegVal[i].id,(WORD*)&(RegVal[i].value));
        token=strtok(NULL,",");
      }    
   
    CRect rect(1,1,100,100);  	
    m_pList=new CMyList(this);
    m_pList->Create(WS_VSCROLL|WS_HSCROLL|LBS_NOINTEGRALHEIGHT|WS_VISIBLE|\
 	  	LBS_NOTIFY|WS_CHILD|LBS_OWNERDRAWFIXED,rect, this, IDC_LIST1); 
    m_pList->ShowWindow(SW_SHOW);
    return 0;
}


void CPer6View::OnSize(UINT nType, int cx, int cy)
{   
	
    CView::OnSize(nType, cx, cy);
    
    CRect rect(0,0,0,0);   
   	GetClientRect(&rect) ; 
	rect.InflateRect(::GetSystemMetrics(SM_CXBORDER),::GetSystemMetrics(SM_CYBORDER)); 
	GetDlgItem(IDC_LIST1)->MoveWindow(&rect,TRUE);
  
    
}

void CPer6View::OnDblclkList1()
{
    int cursel;
    cursel=( (CListBox*)GetDlgItem(IDC_LIST1) )->GetCurSel(); 
    if(cursel<0) return;
    
    HINSTANCE hLibrary;
    if ((hLibrary = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        int k;
        k=0;
//      AfxMessageBox("Can not do this test without custom control library",MB_OK);
		ErrDisplayError(ER_PRE_NO_LIBRARY);
     } 
                                                   
    CFldDlg *bitdlg  ; 
   	bitdlg=new CFldDlg(this,cursel); 
    bitdlg->DoModal();  
    delete bitdlg;
    FreeLibrary(hLibrary);
}

void CPer6View::OnFresh()
{   
    int i;
    for (i=0;i<ITEMRANGE;i++) 
    { 
        AbiGetOneReg(RegVal[i].id,(WORD*)&(RegVal[i].value) );
    }
        
    ((CMyList*)GetDlgItem(IDC_LIST1))->ResetContent(); 
    ((CMyList*)GetDlgItem(IDC_LIST1))->InitList();
    
}


void CPer6View::OnViewCompress()
{                                 
    m_Expanded=FALSE;
    int i;
    i=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
	PERI_DRAWDATA *lpDrawData;
    while (i)
    { 
      i--;
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemDataPtr(i));
      if( !(lpDrawData->isBit) )  //OBYTE(LOWORD(dw)) )) 
         {
            if(lpDrawData->isExpanded)
               { 
                  lpDrawData->isExpanded=0;
                  ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,(LPSTR)lpDrawData);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemDataPtr(i,lpDrawData);
                  ((CMyList*)(GetDlgItem(IDC_LIST1)))->DeleteBitItem(i,lpDrawData);
                }
         } 
    } 
    ((CListBox*)GetDlgItem(IDC_LIST1))->SetCurSel(0);   
}

void CPer6View::OnViewExpand()
{
    m_Expanded=TRUE;
    int i;
    i=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
	PERI_DRAWDATA *lpDrawData;
    while (i)
    { 
      i--;
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemDataPtr(i));
      if(!(lpDrawData->isBit) ) 
      {
          if(!(lpDrawData->isExpanded) )
          { 
              lpDrawData->isExpanded=1;
              ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
              ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,(LPSTR)lpDrawData);
              ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemDataPtr(i,lpDrawData);
              ((CMyList*)(GetDlgItem(IDC_LIST1)))->InsertBitItem(i,lpDrawData);
          }
      }
    }                   
}



void CPer6View::OnRButtonDown(UINT, CPoint point) 
{

    CMenu m_menu;
    m_menu.CreatePopupMenu() ;  
    m_menu.AppendMenu(MF_STRING	,ID_VIEW_COMPRESS,"&Compress All");	
    m_menu.AppendMenu(MF_STRING	,ID_VIEW_EXPAND,"&Expand All");
	
	ClientToScreen(&point);
// Modified by Gates Hua -- start	
//    m_menu.TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);    
    m_menu.TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, GetParent() );
// -- end    
	m_menu.DestroyMenu();
}
