/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/PICADDR.CPP   1.13   13 Dec 1996 11:19:26   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/PICADDR.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:26   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:24   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:40   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:34   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:00   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:48   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:17:58   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:30   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:28   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:38   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:50   ZJRD
** PIC/SLD Version 0.20
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Picaddr.cpp
**
**  Description:  The sub class CPicadr deprived from the CFormatAddress
**                This class is process the PICxx based family address
**                PICxx base family address has the format as following
**                      prefix:address
**                prefix is the space area. Those are :
**                      p: program
**                      i: internal
**                The address has two format: Hex and Dec
**                      Hex has the prefix before address that is 0x or not
**
**                Another : the address is a symbol. The symbol has the format
**                as following:
**                      #ModuleName#SymbolName etc.
**                The process must deal all the statment described as before.
**
**  Status: Initialization
**          1996/05/28        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                        
#include "address.h"                // Include main head file
#include "cpuserve.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//extern int GetMemoryRange(CPUMEMORYRANGE *stRange);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/                        
char  *SpaceStr[6] = {
             "UndefineSpace",       // Undefine space
             "Program",             // Program area
             "External(Data)",      // External area(Data)
             "SFR",                 // Special function register area
             "Internal(OnChip)",    // Internal area(On chip)
             "Bit",                 // Bit area
      };

char  *SpacePrefix[6] = {
             "",        // Undefine space
             "P",       // Program area
             "X",       // External area(Data)
             "R",       // Special function register area
             "I",       // Internal area(On chip)
             "B",       // Bit area
      };

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/
ADDR_SIZE  dwpMax;        // program  max address
ADDR_SIZE  dwpMin;        // program  min address
ADDR_SIZE  dwxMax;        // external max address
ADDR_SIZE  dwxMin;        // external min address
ADDR_SIZE  dwiMax;        // internal max address
ADDR_SIZE  dwiMin;        // internal min address
ADDR_SIZE  dwrMax;        // SFR max address
ADDR_SIZE  dwrMin;        // SFR min address
ADDR_SIZE  dwbMax;        // bit max address
ADDR_SIZE  dwbMin;        // bit min address
extern struct CPURegisterFileRange SFRRange;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/****************************************************************************
**  Name:   CPicAddress
**
**  Description: Constructor
**
**  Parameters:
**     input:  any possible
**
**     output: none
**
*****************************************************************************/

// From CString
//
CPicAddress::CPicAddress(const CString &str)
{
   Initialize();

   m_strOriginAdr = str;   // Only set the origin string
   m_nDefaultIsHex = 1;
   IsString = TRUE;        // Construct from string
}

// From char*
//
CPicAddress::CPicAddress(const LPSTR str)
{
   Initialize();
   
   m_strOriginAdr = str;   // Only set the origin string
   m_nDefaultIsHex = 1;
   IsString = TRUE;        // Construct from string
}

// From CString
//
CPicAddress::CPicAddress(const CString &str, const UINT isHex)
{
   Initialize();

   m_strOriginAdr = str;   // Only set the origin string
   m_nDefaultIsHex = isHex;
   IsString = TRUE;        // Construct from string
}

// From char*
//
CPicAddress::CPicAddress(const LPSTR str, const UINT isHex)
{
   Initialize();
   
   m_strOriginAdr = str;   // Only set the origin string
   m_nDefaultIsHex = isHex;   
   IsString = TRUE;        // Construct from string
}

// Can not construct from only numberica, must construct form the ADDR struct
// From DWORD(no use)
//
CPicAddress::CPicAddress(ADDR_SIZE dw)
{
   Initialize();
   m_dwAddress = dw;
}

// From ADDR struct
//
CPicAddress::CPicAddress(ADDRESS adr)
{
   Initialize();
   m_dwAddress = adr.adrAddress;
   m_enumSpace = adr.adrSpace;
   m_strSpace  = SpaceStr[m_enumSpace];
   m_strPrefix = SpacePrefix[m_enumSpace];
}

// Copy constructor
//
/*
CPicAddress::CPicAddress(const CPicAddress &c51adr)
{
   Initialize();
   // Can not copy the m_strOriginAdr because the c51adr has checked OK
   m_strSpace     = c51adr.m_strSpace;    // Space string
   m_enumSpace    = c51adr.m_enumSpace;   // Space style
   m_strPrefix    = c51adr.m_strPrefix;   // prefix string
   m_strAddress   = c51adr.m_strAddress;  // address text string
   IsString       = TRUE;                 // Construct from string
}
*/  
  
/****************************************************************************
**  Name:   Initialize
**
**  Description: Initialize the CPicAddress. Call this function before any
**               Implenmentation but after the SetAdrRange();
**
**  Parameters:
**     input: none
**
**     output: none
*****************************************************************************/

void
CPicAddress :: Initialize()
{
   // Init base class 
      m_strOriginAdr = "";    // Original address string. No any change
                              // Get from construct or Set function
      m_dwAddress = 0;        // The data of address(converted form string,
                              // or get from constructor)
                              // After converted successful, the m_dwAddress
                              // is the address.
                              // In
      m_strPrefix = "";       // Prefix front the address.
                              // Such as in 51 base family the prefix of
                              // p:0x987 is "p"
                              // In 86 family, the prefix is the segment or
                              // descriptor
                              // etc;
      m_strAddress = "";      // After split the prefix,
                              // In 51 family, it is the absoluted address
                              // In 86 family, it is the offset
                              // etc;

      m_strAddressHex = "";   // The converted hex address
      m_strAddressDec = "";   // The converted dec address
   
      m_strSpace     = "";
      m_enumSpace    = SPACE_UNDEFINE;
      IsString       = FALSE;
      m_enumRetCode  = ADR_OK;
      m_nDefaultIsHex = 1;	  // Is Hex		
}


/****************************************************************************
**  Name:   ConvertCheck
**
**  Description:  The virtual function deprived from parent class.
**                Call this function to convert the address between text 
**                string and numberic. Check the address.
**                This function call the main processor -- Process()
**
**  Parameters:
**     input:  none
**
**     output: none
*****************************************************************************/

BOOL
CPicAddress :: ConvertCheck()
{
   char  *lpszTemp1;
   FORMATTYPE ft;
   BOOL  bProcessOk = FALSE;

   if (IsString) {            // Construct from string
      // If the input text string is empty, return false
      if (m_strOriginAdr.IsEmpty()) {
         m_enumRetCode = ADR_EMPTY;
         return FALSE;
      }         
      
      lpszTemp1 = new char[m_strOriginAdr.GetLength()+2];
      ASSERT(NULL != lpszTemp1);
      if (NULL == lpszTemp1) {
         AfxMessageBox("memory alloc error");
         return FALSE;
      }         
      memset(lpszTemp1, 0, m_strOriginAdr.GetLength()+2);
      strcpy(lpszTemp1, m_strOriginAdr.GetBuffer(m_strOriginAdr.GetLength()));
      
      SkipHeadWS(lpszTemp1);     // Skip the leading white space
      CutTailWS(lpszTemp1);      // Skip the tail white space

      if (!SplitPrefix(lpszTemp1)) { // Split the prefix and the address text
         delete []lpszTemp1;
         m_enumRetCode = ADR_FORMATERROR;
         return FALSE;
      }
      // Has already set m_enumSpace, m_strSpace, m_strAddress by SplitPrefix
      
      delete []lpszTemp1;
      
      ft = IsWhichFormat();
      
      CFormatHexStr   fmtHex(m_strAddress);
      CFormatDecStr   fmtDec(m_strAddress);
      CFormatSymbol   fmtSymbol(m_strAddress);

      switch (ft) {
         case  IS_HEX:          
               bProcessOk = Process(&fmtHex);
               if (!bProcessOk) {
                  m_enumRetCode = ADR_INVALIDCHAR;
                  return FALSE;
               }
               else {                             
                  m_strAddressHex = fmtHex.GetHexString();
                  m_dwAddress     = fmtHex.GetAddress();
               }
               /*
               strcpy(tempAddr,
                      m_strAddress.GetBuffer(m_strAddress.GetLength())+2);
               SkipHeadZero(tempAddr);                       
               if (!CheckLength(IS_HEX, tempAddr)) {
                  m_enumRetCode = ADR_OVERFLOW;                  
                  return FALSE;
               }
               delete []tempAddr;
               */
               break;

         case  IS_DEC:
               bProcessOk = Process(&fmtDec);
               if (!bProcessOk) {
                  m_enumRetCode = ADR_INVALIDCHAR;
                  return FALSE;
               }
               else {
                  m_strAddressDec = fmtDec.GetDecString();
                  m_dwAddress  = fmtDec.GetAddress();
               }
               /*
               strcpy(tempAddr,
                       m_strAddress.GetBuffer(m_strAddress.GetLength()));
               SkipHeadZero(tempAddr);
               if (!CheckLength(IS_DEC, tempAddr)) {
                  m_enumRetCode = ADR_OVERFLOW;                  
                  return FALSE;
               }
               */
               break;
               
         case  IS_SYM:
               fmtSymbol.m_uSymData = 0;             // Symbol 0
               if (SPACE_UNDEFINE != m_enumSpace) {
                  m_enumRetCode = ADR_FORMATERROR;
                  return FALSE;   
               }
               bProcessOk = Process(&fmtSymbol);
               if (!bProcessOk) {
                  m_enumRetCode = ADR_NOSYMBOL;
                  return FALSE;
               }
               else {
                  m_dwAddress  = (DWORD)fmtSymbol.GetAddress();
                  m_enumSpace = (ADDR_SPACE)fmtSymbol.GetSpace();
               }
               break;                       
         
         case  IS_SYM_DATA:
               fmtSymbol.m_uSymData = 1;             // Symbol Data 1
               if (SPACE_UNDEFINE != m_enumSpace) {
                    m_enumRetCode = ADR_FORMATERROR;
                    return FALSE;   
               }
               bProcessOk = Process(&fmtSymbol);
               if (!bProcessOk) {
                  m_enumRetCode = ADR_NOSYMBOL;
                  return FALSE;
               }
               else {
                  m_dwAddress  = (DWORD)fmtSymbol.GetAddress();
                  m_enumSpace = SPACE_UNDEFINE; //(ADDR_SPACE)fmtSymbol.GetSpace();
               }
               break;                       
               
         case  IS_UNKNOWN:
               return FALSE;         
      }
   }
   else {               // Construct from others
      CFormatNumber   fmtNumber(m_dwAddress);
      
      bProcessOk = Process(&fmtNumber);
      if (!bProcessOk) {
         m_enumRetCode = ADR_INVALIDCHAR;
         return FALSE;
      }
      else {
         m_strAddressHex = fmtNumber.GetHexString();
         m_strAddressDec = fmtNumber.GetDecString();
      }
   }

   // Check the range
   //
   int nBank = -1;
   BOOL   bInRange = FALSE;
   
   if (SPACE_UNDEFINE != m_enumSpace) {
      switch(m_enumSpace) {
         case  SPACE_PROGRAME  :
               if (m_dwAddress > dwpMax || m_dwAddress < dwpMin) {
                  m_enumRetCode = ADR_OUTRANGE;
                  return FALSE;
               }
               break;
/*
         case  SPACE_EXTERNAL  :
               if (m_dwAddress > dwxMax || m_dwAddress < dwxMin) {
                  m_enumRetCode = ADR_OUTRANGE;
                  return FALSE;
               }
               break;

         case  SPACE_INTERNAL  :
               if (m_dwAddress > dwiMax || m_dwAddress < dwiMin) {
                  m_enumRetCode = ADR_OUTRANGE;
                  return FALSE;
               }
               break;
*/
///////////
//
// Modify for SFR bank switch
//
//

         case  SPACE_SFR       :
	      		for ( nBank = 0; nBank < SFRRange.nBanks; nBank ++ ) {
		            if (m_dwAddress <= ADDR_SIZE(SFRRange.RFileRange[nBank].nEndAddr)
		            	&& m_dwAddress >= ADDR_SIZE(SFRRange.RFileRange[nBank].nStartAddr) ) {
		            	bInRange = TRUE;
		            	break;	
		            }
		            else {
		            
					}		            
	      		}
	      		if ( !bInRange ) {
	                 m_enumRetCode = ADR_OUTRANGE;
	                 return FALSE;
	            }     

                break;

/*
         case  SPACE_BIT       :
               if (m_dwAddress > dwbMax || m_dwAddress < dwbMin) {
                  m_enumRetCode = ADR_OUTRANGE;
                  return FALSE;
               }
               break;
*/               
      }
   }

   m_enumRetCode = ADR_OK;
   
   return TRUE;
}

/****************************************************************************
**  Name:   Process
**
**  Description: Process the format. Call the format Convert() processor
**
**  Parameters:
**     input:  CFormatType &format
**
**     output: BOOL  TRUE if convert successful
*****************************************************************************/

BOOL
CPicAddress :: Process(CFormatType *format)
{
   format->Convert();
   return format->m_bIsOk;
   // if m_IsOk is FALSE, the format may include invalid char
}

/****************************************************************************
**  Name: SplitPrefix
**
**  Description: Split the origin address text string. Set the m_strAddress
**               and m_strPrefix
**
**  Parameters:
**     input:    char *lpsz
**
**     output:   BOOL   the format is correct, return TRUE
*****************************************************************************/

BOOL
CPicAddress :: SplitPrefix(const char* lpsz)
{
   int   nCount = 0;
   int   nstrLength = strlen(lpsz);
   char  *lpszPrefix;
   char  *lpszAddr;
      
   do {
      if (':' == lpsz[nCount]) {
         lpszPrefix = new char[nCount+1];
         if (NULL == lpszPrefix)
            return FALSE;
         memset(lpszPrefix, 0, nCount+1);   
         strncpy(lpszPrefix, lpsz, nCount);
         lpszAddr = new char[nstrLength-nCount+1];
         if (NULL == lpszAddr)
            return FALSE;
         memset(lpszAddr, 0, nstrLength-nCount+1);   
         strcpy(lpszAddr, lpsz+nCount+1);
         
         if (0 == strlen(lpszAddr)) {
            delete []lpszPrefix;
            delete []lpszAddr;
            return FALSE;
         }            
         else   
            m_strAddress= lpszAddr;
         m_strPrefix = lpszPrefix;            
         
         // Process the case: "p   :   0x100"
         // Area has tail space
         //
         if (strlen(lpszPrefix) > 1) {
            delete []lpszPrefix;
            delete []lpszAddr;
            return FALSE;            
         }
                  
         if (' ' == lpszPrefix[strlen(lpszPrefix)-1]) {
            delete []lpszPrefix;
            delete []lpszAddr;
            return FALSE;            
         }
         // Address string has leading space           
         //
         if (' ' == lpszAddr[0]) {
            delete []lpszPrefix;
            delete []lpszAddr;
            return FALSE;
         }
                    
         delete []lpszPrefix;
         delete []lpszAddr;
      }
      nCount++;
   }while ((nCount < nstrLength) && (':' != lpsz[nCount-1]));

   if ("" == m_strPrefix) {
      m_strAddress = lpsz;    // no any prefix
      m_enumSpace = SPACE_UNDEFINE;
      m_strSpace = SpaceStr[m_enumSpace];
   }
   else {
      m_strPrefix.MakeUpper();
      char charPrefix = m_strPrefix.GetBuffer(m_strPrefix.GetLength())[0];
      switch(charPrefix) {
         case  'P':
               m_enumSpace = SPACE_PROGRAME;
               m_strSpace = SpaceStr[m_enumSpace];
               break;
/*
         case  'X':
               m_enumSpace = SPACE_EXTERNAL;
               m_strSpace = SpaceStr[m_enumSpace];
               break;

         case  'I':
               m_enumSpace = SPACE_INTERNAL;
               m_strSpace = SpaceStr[m_enumSpace];
               break;
*/               

         case  'R':
               m_enumSpace = SPACE_SFR;
               m_strSpace = SpaceStr[m_enumSpace];
               break;
/*
         case  'B':
               m_enumSpace = SPACE_BIT;
               m_strSpace = SpaceStr[m_enumSpace];
               break;
*/
         default:
               m_enumRetCode = ADR_FORMATERROR;
               return FALSE;
      }
   }

   return TRUE;
}

///////////////////////////////////////////
//Return value

CString
CPicAddress :: GetHexAddr()
{
   return   m_strAddressHex;
}

CString
CPicAddress :: GetDecAddr()
{
   return   m_strAddressDec;
}

ADDR_RETCODE
CPicAddress :: GetRetCode()
{
   return   m_enumRetCode;
}

ADDR_SPACE
CPicAddress :: GetSpace()
{
   return   m_enumSpace;
}

ADDR_SIZE   
CPicAddress :: GetAddress()
{
   return CFormatAddress::m_dwAddress;
};

//////////////////////////////(EOF)//////////////////////////////

