
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/REGFILEV.CPP   1.13   13 Dec 1996 11:19:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/REGFILEV.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:54   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:08   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:40   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:06   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:54   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:18:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:36   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:37:00   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:50   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:10:00   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:16   ZJRD
** Initial revision.
** 
****************************************************************************/

// regfilev.cpp : implementation file
//

#include "stdafx.h"
//#include "epsld52f.h"
#include "regfilev.h"
#include "resource.h"  
#include "uicom.h"  
#include "cpuwin.h"  
#include "cpureg.h"
#include "colors.h"         
#include "basictyp.h"


#define PORTC_ADDR 7
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                 
extern CPURegisterFileRange GetCpuRFileRange(); 
extern BOOL IsIDValid(REG_ID reg_id);
extern int AddrToSym(U8 type , U32 addr , char *str);                
extern unsigned char gEPModule;

/////////////////////////////////////////////////////////////////////////////
// CRegFileView

IMPLEMENT_DYNCREATE(CRegFileView, CView)

CRegFileView::CRegFileView() 
:m_nFont(STANDARD_FONT), m_ptFirst(0,0), m_isSel(FALSE)
{                      
    m_rangeRFile=GetCpuRFileRange();
//	CPURegisterFileRange  rFileRange;
//	rFileRange=GetCpuRFileRange();
	m_nRFileSize=0;
	for(int i=0;i<m_rangeRFile.nBanks;i++)
	{
		m_nRFileSize+=m_rangeRFile.RFileRange[i].nEndAddr\
		    -m_rangeRFile.RFileRange[i].nStartAddr+1;
	}
	if( (!IsIDValid( (REG_ID)PORTC ))&&(gEPModule==0))	
		m_nRFileSize++;
}

CRegFileView::~CRegFileView()
{
}     

void CRegFileView::CalcXY(int nIdx, int &x, int &y)
{
//  ASSERT(nIdx >= 0 && nIdx < ::nCurRegs);
    
    if(nIdx < 0)    nIdx = 0;
    else if(nIdx > m_nRFileSize - 1)    nIdx = m_nRFileSize - 1;
    x = nIdx % m_nCols;
    y = nIdx / m_nCols;
}  

void CRegFileView::CalcPoint(BOOL isName, int nIdx, int &x, int &y)
{   
    CalcXY(nIdx, x, y);
    y = m_szGap.cy + y * (m_szName.cy + m_szGap.cy);
    x = m_szGap.cx + x * (m_szName.cx + m_szGap.cx 
        + m_szValue.cx + 2 * m_szGap.cx);
    if(!isName)  x += m_szName.cx + m_szGap.cx; 
    x -= m_ptFirst.x; y -= m_ptFirst.y;    
}   

void CRegFileView::DrawFrame(CDC * pdc, BOOL isName, int nIdx, int nConvex)
{
    ASSERT_VALID(pdc);
    
    CPen pen1(PS_SOLID, 1, PALETTEINDEX(COLOR_DKGRAY));    
    CPen pen2(PS_SOLID, 1, PALETTEINDEX(COLOR_WHITE)); 
    CPen* pOldPen;
    CPoint pt;
    CalcPoint(isName, nIdx, pt.x, pt.y);
    if(isName)
    { 
       ::DrawFrame(pdc, CRect(pt.x, pt.y, 
        			pt.x + m_szName.cx - 1, pt.y + m_szName.cy - 1), nConvex);
	   pOldPen=pdc->SelectObject(&pen1);
	   pdc->MoveTo(pt.x,pt.y+m_szValue.cy);
	   pdc->LineTo(pt.x + m_szName.cx - 1,pt.y+m_szValue.cy);
	   pdc->SelectObject(&pen2);
	   pdc->MoveTo(pt.x,pt.y+m_szValue.cy+1);
	   pdc->LineTo(pt.x + m_szName.cx - 1,pt.y+1+m_szValue.cy);
	   pdc->SelectObject(pOldPen);
	   
	}	   					        			
    else    ::DrawFrame(pdc, CRect(pt.x, pt.y+m_szValue.cy/2, 
        pt.x + m_szValue.cx - 1, pt.y + m_szValue.cy+m_szValue.cy/2-1), nConvex);
}                                                 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Show register name
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegFileView::ShowRegName(CDC * pdc, int nIdx, int addr)
{
    ASSERT_VALID(pdc);

    int x, y;
    CalcPoint(TRUE, nIdx, x, y);    
    pdc->SelectStockObject(m_nFont);
    pdc->SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
    pdc->SetTextColor(PALETTEINDEX(COLOR_BLACK));
   
//  Draw Symbol            
	char szSymbol[64];
	
	if(0!=AddrToSym(3,(U32)addr,szSymbol))
		strcpy(szSymbol,"--");
//  GetSymbol(addr,szSymbol);
    int nLen = strlen(szSymbol); 
    if(nLen>8){ nLen=8;szSymbol[6]='.';szSymbol[7]='.';}    
 	int x1 = (m_szName.cx - 2 - nLen * m_szFont.cx) / 2;
    pdc->TextOut(x + 1 + x1, y + 1,szSymbol, nLen);
//  Draw Address                         
	char szaddr[5];
	sprintf(szaddr,"%03X",addr);
    x1=(m_szName.cx-2-3*m_szFont.cx)/2;
    pdc->TextOut(x+1+x1,y+m_szName.cy+2,szaddr,3);
}
                                                             
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Show register value
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegFileView::ShowRegValue(CDC * pdc, int nIdx, UINT uVal, BOOL isNormal)
{
    ASSERT_VALID(pdc);

    int x, y;
    char tmp1[VAL_LEN+1], tmp2[VAL_LEN+1];         
    
    if(nCpuRadix == CPU_HEX) {
//        if(RegSelect[nIdx] > 1)
            x = wsprintf(tmp2, "%02.2X", uVal);
//        else
//            x = wsprintf(tmp2, "%04.4X", uVal);
    } else {               
        x = wsprintf(tmp2, "%u", uVal);
    }
    memset(tmp1, ' ', VAL_LEN);
    strcpy(tmp1 + VAL_LEN - x, tmp2);
    
    CalcPoint(FALSE, nIdx, x, y);    
    pdc->SelectStockObject(m_nFont);
    if(isNormal) {
        pdc->SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
        pdc->SetTextColor(PALETTEINDEX(COLOR_BLACK));
    } else {
        pdc->SetTextColor(PALETTEINDEX(COLOR_WHITE));
        pdc->SetBkColor(PALETTEINDEX(COLOR_BLUE));
    }
    //pdc->TextOut(x + 1, y + 1, tmp1, VAL_LEN);
    pdc->TextOut(x + 3, y+m_szValue.cy/2 + 1, tmp1, VAL_LEN);
}                                                    
                 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Called when change size or config registers
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegFileView::Resize(int cx, int cy)
{
    SaveOldValue();
    #ifdef _ZLR_
    GetRegs();
    #endif

    CSize sz(m_szName.cx + m_szGap.cx + m_szValue.cx + m_szGap.cx * 2,
        m_szGap.cy + m_szName.cy);
    m_nCols = cx / sz.cx;
    if(m_nCols < 1)   m_nCols = 1;
    m_ptFirst.x = m_ptFirst.y = 0;
    m_nRows = (m_nRFileSize + m_nCols - 1) / m_nCols;
    
    if(sz.cx > cx) 
        m_szScroll.cx = sz.cx - cx;
    else m_szScroll.cx = 0;
    SetScrollRange(SB_HORZ, 0, m_szScroll.cx);
    
    if(m_nRows * sz.cy > cy)    
        m_szScroll.cy = m_nRows * sz.cy - cy;
    else m_szScroll.cy = 0;
    SetScrollRange(SB_VERT, 0, m_szScroll.cy);
    
    SetScrollPos(SB_HORZ, m_ptFirst.x);
    SetScrollPos(SB_VERT, m_ptFirst.y);
}            


void CRegFileView::SaveOldValue(void)
{
    for(int i = 0; i < MAX_REGISTERS; i ++) {
     	m_OldValue[i] = m_NewValue[i];
    }
}

BOOL CRegFileView::GetRegs(void)
{
 	if(!CpuGetAllReg())	return	FALSE;//
     
	if((!IsIDValid((REG_ID)PORTC))&&(gEPModule==0))
	{
	   m_NewValue[0]=RegValue[PORTC];	 	
	   for(int i = 1; i < m_nRFileSize; i ++)
	  	 m_NewValue[i] = RegValue[ID_GPRF_START+i-1];
	}
	else  	 
   	   for(int i = 0; i < m_nRFileSize; i ++)
	  	 m_NewValue[i] = RegValue[ID_GPRF_START+i];
			
	return TRUE;
}


BEGIN_MESSAGE_MAP(CRegFileView, CView)
	//{{AFX_MSG_MAP(CRegFileView)    
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHexadecimal)
	ON_COMMAND(ID_VIEW_DECIMAL, OnViewDecimal)  
	ON_COMMAND(ID_VIEW_CLOSE,   OnViewClose)  
	ON_WM_CREATE()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_SIZE()
	ON_WM_SETCURSOR()
	ON_MESSAGE(XM_REPAINT, OnXMRepaint)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DECIMAL, OnUpdateViewDecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LONG CRegFileView::OnXMRepaint(UINT /*wParam*/, LONG /*lParam*/)
{
	if(!m_isSel)	SaveOldValue();
	m_isSel = FALSE;
    GetRegs();                                 
    ((CCpuWindow*)GetParent())->CpuChangeTitle();
    InvalidateRect(NULL);
    return  0;
}


/////////////////////////////////////////////////////////////////////////////
// CRegFileView drawing

void CRegFileView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here    
   int i=0,m=0;
   while(i<m_nRFileSize)
   {
        if( (!IsIDValid((REG_ID)PORTC) )&&(i==0)&&(gEPModule==0))
   		{   
   		 	DrawFrame(pDC, TRUE, i, 1);
       		ShowRegName(pDC, i,PORTC_ADDR);   //will be modified
       		DrawFrame(pDC, FALSE, i, 0);
       		if(m_NewValue[i] != m_OldValue[i])
           		ShowRegValue(pDC, i, m_NewValue[i], 0);
       		else
           		ShowRegValue(pDC, i, m_NewValue[i], 1);
       		i++;    
   		}    
        	
        for(m=0;m<m_rangeRFile.nBanks;m++)
        {
        	for(int j=m_rangeRFile.RFileRange[m].nStartAddr;
        	        j<=m_rangeRFile.RFileRange[m].nEndAddr; 
        	        j++)
    		{   DrawFrame(pDC, TRUE, i, 1);
        		ShowRegName(pDC, i,j);   //will be modified
        		DrawFrame(pDC, FALSE, i, 0);
        		if(m_NewValue[i] != m_OldValue[i])
            		ShowRegValue(pDC, i, m_NewValue[i], 0);
        		else
            		ShowRegValue(pDC, i, m_NewValue[i], 1);
        		i++;    
    		}    
		}
	}
}		 
       
int CRegFileView::Index2Addr(int index)
{
	int i=0,nbank=0,count=0; 
	int addr;
	BOOL bDone=0;
	while(!bDone)
	{
		count=1+m_rangeRFile.RFileRange[i].nEndAddr-m_rangeRFile.RFileRange[i].nStartAddr;
		if(index<count)
		{
			bDone=1; 
			addr=m_rangeRFile.RFileRange[nbank].nStartAddr+index;
		}
		else
		{	index-=count;i++;}
	}			              
	return addr;
}       
       
BOOL CRegFileView::PreCreateWindow( CREATESTRUCT& cs )
{
	cs.style|=WS_VSCROLL;
	cs.lpszClass=
	AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(GetStockObject(LTGRAY_BRUSH)),
            AfxGetApp()->LoadIcon(IDI_CPU));      
	return 1;            
}
/////////////////////////////////////////////////////////////////////////////
// CRegFileView message handlers
 

void CRegFileView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	 CMenu * pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );

    pLocalMenu->CreatePopupMenu();
    pLocalMenu->AppendMenu(MF_STRING, ID_RUN_RESET, "&Reset");
	
	pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_CLOSE, "&Close");
    
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_HEXADECIMAL,
                            "&Hexadecimal");

    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DECIMAL, "&Decimal");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->SetMenuItemBitmaps(ID_VIEW_HEXADECIMAL, MF_BYCOMMAND, 
        &bmpMenuUncheck, &bmpMenuCheck);
    pLocalMenu->SetMenuItemBitmaps(ID_VIEW_DECIMAL, MF_BYCOMMAND, 
        &bmpMenuUncheck, &bmpMenuCheck);

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
	CView::OnRButtonDown(nFlags, point);

}

void CRegFileView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	    CClientDC dc(this);
    
    
    int x, y;            
    CRect rect;  
    CRegisterDialog * pDlg;
	int addr;
    for(int i = 0; i < m_nRFileSize; i ++) {
        CalcPoint(TRUE, i, x, y);      
        rect.SetRect(x, y, x + m_szName.cx, y + m_szName.cy);
        if(rect.PtInRect(point)) {
            DrawFrame(&dc, TRUE, i, 0);                     
            if(IsIDValid( (REG_ID)PORTC )||(gEPModule!=0)) 
            {
				 addr=Index2Addr(i);	            
    	         pDlg = new CRegisterDialog(ID_GPRF_START+i,addr,1,this);
            }
            else
            {
            	if(i==0)
            	{
            		addr= PORTC_ADDR ;	
			    	pDlg = new CRegisterDialog(PORTC,addr,1,this); 			      
			    }	
			    else
			    {  addr=Index2Addr(i-1);
				   pDlg = new CRegisterDialog(ID_GPRF_START+i-1,addr,1,this); 			      
				}   
			}

            x = pDlg->DoModal();
            delete pDlg;
            DrawFrame(&dc, TRUE, i, 1);
            break;
        }
    }                                           
    
	if(x == IDOK) {
		SaveOldValue();    
	    m_isSel = TRUE;
	    GetRegs();
    	RepaintWindows();
    }	
    

    // Added by Chen
    SetFocus();    
    CView::OnLButtonDown(nFlags,point);
	
}

void CRegFileView::OnViewHexadecimal()
{
		// TODO: Add your command handler code here
    SaveOldValue();
    #ifdef _ZLR_
    GetRegs();
    #endif
    InvalidateRect(NULL);
    if(nCpuRadix != CPU_HEX) {
        nCpuRadix = CPU_HEX;    
//        SetWindowText("CPU[Hex]");
//        InvalidateRect(NULL);
    }                           

	((CCpuWindow*)GetParent())->CpuChangeTitle();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->Invalidate();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->UpdateWindow();
}

void CRegFileView::OnViewDecimal()
{
	// TODO: Add your command handler code here
	    SaveOldValue();
    #ifdef _ZLR_
    GetRegs();
    #endif
    InvalidateRect(NULL);
    if(nCpuRadix != CPU_DEC) {
        nCpuRadix = CPU_DEC;    
//      SetWindowText("CPU[Dec]");
//      InvalidateRect(NULL);
    }

	((CCpuWindow*)GetParent())->CpuChangeTitle();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->Invalidate();
    ((CCpuWindow*)pCpuWnd)->m_wndSplitter.GetPane(0,0)->UpdateWindow();

}
   
void CRegFileView::OnViewClose()
{                                                   
	CRect rect;
	GetParentFrame()->GetClientRect(&rect);
	((CCpuWindow*)GetParentFrame())->m_wndSplitter.SetColumnInfo(0,3000,0);
	((CCpuWindow*)GetParentFrame())->m_wndSplitter.SetColumnInfo(1,0,0);
	((CCpuWindow*)GetParentFrame())->m_bRegFileOn=0;
	((CCpuWindow*)GetParentFrame())->SetWindowPos(NULL,0,0,rect.right,rect.bottom,SWP_NOMOVE|SWP_NOZORDER);
	((CCpuWindow*)GetParent())->CpuChangeTitle();
}
   
int CRegFileView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	
	// TODO: Add your specialized creation code here
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
          
    // Get font size          
    TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(m_nFont);
    pDC->GetTextMetrics(&tm);
    ReleaseDC(pDC); 

    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
    
    //m_szValue.cx = m_szFont.cx * VAL_LEN + 2;
    m_szValue.cx = m_szFont.cx * VAL_LEN + 6;
    m_szValue.cy = m_szFont.cy + 2;
    m_szName.cx = m_szFont.cx * NAME_LEN + 2;
    m_szName.cy = m_szValue.cy*2+2;
    m_szGap.cx = m_szFont.cx;
    m_szGap.cy = 4;
	// TODO: Add your specialized creation code here
	
	
	return 0;
}

void CRegFileView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: Add your message handler code here and/or call default
	
		    CRect rect;
    GetClientRect(&rect);     
    int i;    
         
    switch(nSBCode) {
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  break;
            if(m_ptFirst.x > 7)   i = 8;
            else i = m_ptFirst.x; 
            m_ptFirst.x -= i;;
            ScrollWindow(i, 0);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    break;
            if(m_ptFirst.x < m_szScroll.cx - 7) i = 8;
            else i = m_szScroll.cx - m_ptFirst.x;
            m_ptFirst.x += i;;
            ScrollWindow(-i, 0);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    break;
            if(m_ptFirst.x > rect.Width()) {
                ScrollWindow(rect.Width(), 0);
                m_ptFirst.x -= rect.Width();
            }
            else {
                ScrollWindow(m_ptFirst.x, 0);
                m_ptFirst.x = 0;
            }
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_PAGERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    break;
            if(m_ptFirst.x + rect.Width() <= m_szScroll.cx) {
                ScrollWindow(-rect.Width(), 0);
                m_ptFirst.x += rect.Width();
            }
            else {
                ScrollWindow(-(m_szScroll.cx - m_ptFirst.x), 0);
                m_ptFirst.x = m_szScroll.cx;
            }
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.x) break;
            ScrollWindow(m_ptFirst.x - nPos, 0);
            m_ptFirst.x = nPos;
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
    }      	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CRegFileView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: Add your message handler code here and/or call default
    CRect rect;
    GetClientRect(&rect);                   
    int i;
    switch(nSBCode) {
        case SB_LINEUP:
            if(m_ptFirst.y <= 0)  break;
            if(m_ptFirst.y > 7)   i = 8;
            else i = m_ptFirst.y;
            m_ptFirst.y -= i;
            ScrollWindow(0, i);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_LINEDOWN:    
            if(m_ptFirst.y >= m_szScroll.cy)    break;
            if(m_ptFirst.y < m_szScroll.cy - 7) i = 8;
            else i = m_szScroll.cy - m_ptFirst.y;
            m_ptFirst.y += i;;
            ScrollWindow(0,-i);
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_PAGEUP: 
            if(m_ptFirst.y == 0)    break;
            if(m_ptFirst.y > rect.Height()) {
                ScrollWindow(0, rect.Height());
                m_ptFirst.y -= rect.Height();
            }
            else {
                ScrollWindow(0, m_ptFirst.y);
                m_ptFirst.y = 0;
            }
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_PAGEDOWN:
            if(m_ptFirst.y >= m_szScroll.cy)    break;
            if(m_ptFirst.y + rect.Height() <= m_szScroll.cy) {
                ScrollWindow(0, -rect.Height());
                m_ptFirst.y += rect.Height();
            }
            else {
                ScrollWindow(0, -(m_szScroll.cy - m_ptFirst.y));
                m_ptFirst.y = m_szScroll.cy;
            }
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.y) break;
            ScrollWindow(0, m_ptFirst.y - nPos);
            m_ptFirst.y = nPos;
            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
    }    
	CView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CRegFileView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	// TODO: Add your message handler code here
	CView::OnSize(nType, cx, cy);
	Resize(cx, cy);
}

BOOL CRegFileView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	if(message == WM_RBUTTONDOWN)   return FALSE;
	return CView::OnSetCursor(pWnd, nHitTest, message);
}

void CRegFileView::OnUpdateViewDecimal(CCmdUI* pCmdUI)
{
	pCmdUI->SetRadio(nCpuRadix == CPU_DEC);
}

void CRegFileView::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
	pCmdUI->SetRadio(nCpuRadix == CPU_HEX); 
}
