
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLBUF.CPP   1.13   13 Dec 1996 11:20:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLBUF.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:58   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:10   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:38   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:54   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:10   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:44   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:44   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:44   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:04   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLBUF.CPP
//
//  Description:The implement file for the class: ShellBuffer
//
//  Author:     Roger Zhang
//
//  Date:       03/22/95
//
//  Modification:
//
//      1. 03/22/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "shlcom.h"
#include "shlbuf.h"

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class : ShellBufLine                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::ShellBufLine()
: m_nLength(0), m_isOK(TRUE)
{ }        

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::ShellBufLine(char * pch, int nLen)
: m_nLength(0), m_isOK(TRUE)
{
    ASSERT(pch);
    ASSERT(nLen >= 0);

    if(nLen == 0)   return;
    if(nLen > MAX_SHELL_LEN)    nLen = MAX_SHELL_LEN;
    if((m_pchLine = new char [nLen])==0)  m_isOK = FALSE;
    else {
        memcpy(m_pchLine, pch, nLen);
        m_nLength = nLen;    
    }
}                                          

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::~ShellBufLine()
{
    if(m_isOK && m_nLength) delete [] m_pchLine;
}                                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: make the buffer size equal to the text length
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void ShellBufLine::Shrink(void)
{             
    if(m_nLength == 0)    delete [] m_pchLine;
    else {                                
    	//Annie, 8/14/96
        //char * pch = new char [m_nLength]; 
        char * pch = new char [m_nLength+1];
        if(!pch) {
            AfxMessageBox(IDS_ERR_MEM);
            return;
        }
        //memcpy(pch, m_pchLine, m_nLength); 
        memcpy(pch, m_pchLine, m_nLength+1);
        delete [] m_pchLine;
        m_pchLine = pch;
    }
}
                                                  
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: ShellBuffer                        //            
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBuffer::ShellBuffer()
: m_nLines(0), m_isOK(TRUE)
{                                                 
}       

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBuffer::~ShellBuffer()
{              
    for(int i = 0; i < m_nLines; i ++)    delete m_LinePtr[i];
}                                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddLine(char * pch, int nLen)
{                                                 
	ASSERT(nLen >= 0);
	
    if(m_nLines == MAX_SHELL_LINES) {
        delete m_LinePtr[0];
        for(int i = 0; i < m_nLines - 1; i ++)
            m_LinePtr[i] = m_LinePtr[i+1];        
    } else  ++ m_nLines;
    m_LinePtr[m_nLines - 1] = new ShellBufLine(pch, nLen);
    if(!m_LinePtr[m_nLines - 1] || !( * m_LinePtr[m_nLines - 1])) {
        -- m_nLines;
        return FALSE;
    } /*else*/
     return TRUE;
}
              
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddInputLine(void)
{
    if(!AddLine(PromptStr[nShellPrompt], MAX_SHELL_LEN))    return FALSE;
    m_LinePtr[m_nLines - 1]->m_nLength = PromptLen[nShellPrompt];
    return TRUE;
}
      
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddDispLine(char * pch, int nLen, BOOL isWS)
{
	ASSERT(nLen >= 0);
	
    if(nLen > MAX_SHELL_LEN - 1)    nLen = MAX_SHELL_LEN - 1;
    if(isWS) {
        if(!AddLine(" ", nLen + 1))    return FALSE;
        memcpy(m_LinePtr[m_nLines - 1]->m_pchLine + 1, pch, nLen);
    } else {
        if(!AddLine(pch, nLen + 1))    return FALSE;
    }
    return TRUE;
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::OvrDispLine(char * pch, int nLen)
{
	ASSERT(nLen >= 0);
	
    if(m_nLines == 0) return FALSE;
    delete m_LinePtr[--m_nLines];
    return AddDispLine(pch, nLen);    
}

///////////////////////////////(EOF)/////////////////////////////////////////
