

/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLEDIT.H__   1.13   13 Dec 1996 11:20:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLEDIT.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:58   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:12   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:30   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:06   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:48   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:22   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:44   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:44   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT.H
//
//  Description:The header file for the class: ShellEditor
//
//  Author:     Roger Zhang
//
//  Date:       03/25/95
//
//  Modification:
//
//      1. 03/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLEDIT_
#define _SHLEDIT_
    
class ShellEditor
{
// attributes
public:
    char * m_pchText;   // not end with '\0'
    int m_nMaxLen;
    int m_nLength;
    int m_nPos;         // Current caret position
             
// operations             
public:
    void SetNew(char * pch, int nMax = 0);
 
    BOOL GotoPrev(void);
    BOOL GotoNext(void);
    BOOL GotoHome(void);
    BOOL GotoEnd(void);
    BOOL SetPos(int nIdx);
    
    BOOL InsChar(char ch);
    BOOL OvrChar(char ch);
    BOOL DelChar(void);
    BOOL BackChar(void);
    
    BOOL InsString(char * pch, int nLen);
    BOOL OvrString(char * pch, int nLen);
    BOOL DelString(int nLen);
    BOOL BackString(int nLen);        
    
    BOOL Clear(void);
};

#endif
////////////////////////////(EOF)////////////////////////////////////////////
