

/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLMACRO.H__   1.13   13 Dec 1996 11:20:04   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLMACRO.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:04   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:02   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:18   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:16   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:16   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:20   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:44   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:30   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SHLMACRO.H
//
//  Description: The header file for the class: CMacroFile.
//
//  Author: Annie Yi
//
//  Date: 04/02/96
//
//  Modification:
//      1. 04/02/96, Initial version of the class: CMacroFile.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SHLMACRO_
#define _SHLMACRO_

#include "tstbase.h"


/////////////////////////////////////////////////////////////////////////////
// CMacroFile class.
class CMacroFile : public CFileBase
{
// Construction & Destruction.
public:
    CMacroFile();
    ~CMacroFile();
    
// Member variables.
private:
    char m_pszOneLine[maxChar+1];
    enum { TOKEN_KEY = 0x20 };

    // Parameter token.
    int m_nArgc;
    char* m_pszMacroArgv[10];  //Macro Argument(0-9)
    
    char* m_pszArgv[(maxChar+1)/2];
    
    // Inner error.
    int m_nCommandID;
    enum { minInner = 0,
           MACRO_IF = minInner,
           MACRO_IFNOT,
		   MACRO_ELSE,
           MACRO_BEGINMARK,
           MACRO_ENDMARK,
           MACRO_WHILE,
           MACRO_REM,
           MACRO_BELL,
           MACRO_ERROR,
           MACRO_GOTO,
           MACRO_LOOP,
           MACRO_LOOPEND,
           MACRO_PAUSE,
           MACRO_WAIT,
           maxInner = MACRO_WAIT
    };
    
    // Error.
    BOOL m_isStop;

    // Goto Label.
    char m_pszLabel[maxChar-5+1];
    
    // Loop & Loopend.
    enum { maxLoop = 256 };
    long m_lLoopIndex;
    long m_lLoopCount[maxLoop];
    DWORD m_dwLoopPos[maxLoop];

    // If, If_not & Else.
    char m_pszCondition[maxChar+1];
    BOOL m_isMatchedIF;
    BOOL m_isMatchedELSE;
    BOOL m_isSkipELSE;

    // { & }.
    BOOL m_isMatchedBegin;

// While 
	BOOL m_isSkipWhile;
	
public:
    BOOL m_isEOF;                       
    enum { maxFileNo = 5};//20 };
    
// Implementations.
private:
    void CheckInnerCommand(char* pszIncLine);
    BOOL CommandParse(void);
    void CommandKernel(void);
    void ExecuteInnerCommand(void);

    void MacroIf(void);
    void MacroIfnot(void);
    void MacroElse(void);
    void MacroWhile(void);
    void MacroBeginMark(void);
    void MacroEndMark(void);
    void MacroRem(void);
    void MacroBell(void);
    void MacroError(void);
    void MacroGoto(void);
    void MacroLoop(void);
    void MacroLoopend(void);
    void MacroPause(void); 
    void MacroWait(void);

    BOOL IsLabel(char* pszArgv) const;
    
    void GotoLabel(void);

    BOOL JudgeCondition(void);
    void PassBlockBranch(void);
    BOOL SearchELSE(void);
    void SkipELSE(void);

    int TestKey(WORD wKey);
    
public:
    BOOL MacroAction(int nArgc, char* pszArgv[]);

    void ReadOneLine(char* pszBuf);
    BOOL MacroFilter(char* pszMacroLine);
    void CreateMacro(char* pszMacroName);
    void CloseMacro();
    void DefineMacro(char* pszBuf);
    void DelMacro(char* pszMacroName);
	BOOL ShowMacro(char* pszMacroName);
	
};  // End of class: CMacroFile.

#endif
//////////////////////////////// End of File ////////////////////////////////
    
