
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLSYNCO.CPP   1.13   13 Dec 1996 11:20:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLSYNCO.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:04   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:20   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:30   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:52   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:40   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:16:56   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.4   23 Sep 1996 10:34:38   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:48   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:56   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:07:44   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:19:12   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLSYNCO.CPP
//
//  Description:The implement file of the class ShellSyntaxColor
//
//  Author:     Annie Yi
//
//  Date:       06/17/96
//
//  Modification:
//
//      1. 06/17/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
                                           
/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include <ctype.h>
#include <direct.h>

#include "colors.h" 
#include "shlsynco.h"
#include "address.h"
#include "addrapi.h"
#include "aliaspub.h"
#include "hosterrs.h"
  
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  

/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.     
int nMaxCmdNo = 52;
HintsList* pHintsList;
BOOL bFile = FALSE;
//BOOL bCmdSelect = FALSE; // if the CPU is PIC16C6X bCmdSelect = TRUE;

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern char szAppPath[_MAX_PATH+1];

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[]) ;                        
void SplitCommand(CString strLine, CString& strCommand, int& nCount,
	 CStringList* listHints);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
BOOL AdrIsP(const char* addrStr);

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[])
{                             
    int nPos; 
    BOOL isOk = FALSE;
    CSyntaxCheckSub* pSyntax = new CSyntaxCheckSub;     
	isOk = pSyntax->CheckCommandSyntaxSub(pszText, nLength, nPos);    
	pSyntax->SetSyntaxColor(nPos, nArgc, syncolor);
	delete pSyntax;          
    
}

void MakeHints(void)
{   
	CString strPath, strFile;
	
	strPath = ::szAppPath;
	mkdir(strPath);                 
	strFile = strPath + "hints.dat";
	// Assign the open flag.
    CFileStatus status;
	if ( !CFile::GetStatus(strFile, status) ) {
	    //AfxMessageBox("Error: Cannot find the file:hints.dat");
        char pchText[256];
        ErrGetErrorText(ER_NOT_FIND_FILE, pchText);
		AfxMessageBox(pchText);
		return;
	}                                       
	
	pHintsList = new HintsList[nMaxCmdNo];		
    // Open the record file.
	UINT nOpenFlag = CFile::modeRead | CFile::typeText;
	CStdioFile* fp = new CStdioFile(strFile, nOpenFlag);
	
		// Read from the record file.
	int nMax = 300;
	char* pszLine = new char[nMax];
	CString strCommand("");
	int nCount = 0;
		
	int i=0;
	while ( fp->ReadString(pszLine, nMax) ) {
		// Split string.                                          
		pHintsList[i].plistHints = new CStringList;
		
		SplitCommand(CString(pszLine), strCommand, nCount, pHintsList[i].plistHints);
		pHintsList[i].strCommand = strCommand;
		pHintsList[i].nCount = nCount;
		i++;
		if (i > nMaxCmdNo) break;							
	}
	while (i<nMaxCmdNo) {
		pHintsList[i].strCommand = "";
		pHintsList[i].nCount = 0;
		pHintsList[i].plistHints = 0;	
	    i++;	
    }
	delete []pszLine;
	
	// Close the record file.
	fp->Close();
	delete fp;	    
	
    bFile = TRUE;	
}                                                                       


void SplitCommand(CString strLine, CString& strCommand, int& nCount,
	 CStringList* plistHints)
{
	// Get Command token.        
	enum { delimiter = ';', space = ' ' };
	CString strTemp(strLine);
	int nFind = strLine.Find(delimiter);
	if ( -1 == nFind ) {
		return;
	}
	strCommand = strLine.Left(nFind);
	strTemp = strLine.Right(strLine.GetLength()-nFind-1);
	nFind = strTemp.Find(delimiter);             
	plistHints->RemoveAll();                                
	plistHints->AddTail(strCommand);         
	while ( -1 != nFind ) {
		plistHints->AddTail(strTemp.Left(nFind));         
		strTemp = strTemp.Right(strTemp.GetLength()-nFind-1);	
		nFind = strTemp.Find(delimiter);
	}
	nCount = plistHints->GetCount();
}	


void FreeHints(void)
{                        
	if ( !bFile ) return;
	if ( pHintsList == 0 ) return;
		 
	for (int i = 0; i < nMaxCmdNo; i++) {
	    if (pHintsList[i].plistHints) {
		   	POSITION posHead  = pHintsList[i].plistHints->GetHeadPosition();
		    while (posHead) {
				(pHintsList[i].plistHints->GetNext(posHead)).Empty();    
		    }               
		    pHintsList[i].plistHints->RemoveAll();
		    delete pHintsList[i].plistHints;
		    pHintsList[i].plistHints = 0;
	    }                                                
		
	}
	
	delete []pHintsList;
	pHintsList = 0;	
}

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCheckSub.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::CSyntaxCheckSub().
//
//  Description: The construction of the class: CSyntaxCheckSub.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheckSub::CSyntaxCheckSub()
{
	
	m_nEvent = 0;
	
}   // End of CSyntaxCheckSub::CSyntaxCheckSub().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::~CSyntaxCheckSub().
//
//  Description: The destruction of the class: CSyntaxCheckSub.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheckSub::~CSyntaxCheckSub()
{

}   // End of CSyntaxCheckSub::~CSyntaxCheckSub().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::CheckCommandSyntaxSub().
//
//  Description: Main control routine of the class: CSyntaxCheckSub.
//
//  Input:  pchEditBuf - The line editor buffer.
//          nLen - The number of the characters in the line editor buffer.
//
//  Output: None.
//
//  Return: FALSE - syntax error; TRUE - syntax OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCheckSub::CheckCommandSyntaxSub(const char* pchEditBuf, const int nLen, int& nPos)
{                           
    BOOL isTrue = FALSE;
    
    // Make a copy from the editor buffer.
    CopyCommandLine(pchEditBuf, nLen);

    // Parse the command's parameters.


    if ( !CommandParseSub() ) {
        ASSERT( FALSE );
        return (FALSE);
    }
 
    // Check command keyword.
    if ( !CheckCommandKeywordSub() ) {
    	return FALSE;
    }
     
    // Call the syntax core.
    isTrue = SyntaxDispatchSub(m_nCommandID);

    nPos = m_nPos;
	
	return isTrue;
}    
                  
BOOL CSyntaxCheckSub::CommandParseSub(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nLen > 0 && m_nLen <= MAX_CMDLINE+1 );
    for ( int i = 0; i < m_nLen; i++ ) {
        ASSERT( m_pchLineBuf[i] >= MIN_KEY && m_pchLineBuf[i] <= MAX_KEY );
    }

	char* pszTemp = new char[m_nLen+4];
	memset(pszTemp, 0, m_nLen+4);
	strcpy(pszTemp, m_pchLineBuf);
	CString str(pszTemp);
	int nPos = str.ReverseFind(';');
	if (nPos != -1) {
		str = str.Right(str.GetLength()-nPos-1);
   		m_nLen = str.GetLength();
   		strcpy(m_pchLineBuf, str);
    }                       
    
    delete []pszTemp;
    
    //For macro variable
    char* p = m_pchLineBuf;
    while (*p) {
    	if ( isspace(*p) )
    		p++;
    	else
    		break;	
    }           
    if ( '$' == *p ) {
		m_nArgc = 1;
		NewMem(m_pszArgv[0], m_nLen);

		strcpy(m_pszArgv[0], p);		    
		return(TRUE);
    }                        
    
    // Get the token of the commands.
    char pszToken[MAX_CMDLINE+1];
    int nTokenLen = 0;
    BOOL isToken = FALSE;
    
    for ( i = 0; i < m_nLen; i++ ) {
        // Only for: "xxxx".
        if ( KEY_DQ == m_pchLineBuf[i] && TOKEN_KEY == m_pchLineBuf[i-1] ) {
			NewMem(m_pszArgv[m_nArgc], m_nLen-i+1);            
            if ( !m_pszArgv[m_nArgc] ) {
                ASSERT( FALSE );
                return (FALSE);
            }
            else {
                memcpy(m_pszArgv[m_nArgc], m_pchLineBuf+i, m_nLen-i);
                //m_pszArgv[m_nArgc++][m_nLen-i] = 0;
                int nPos = m_nLen-i-1;
                while (m_pszArgv[m_nArgc][nPos] == ' ') {
					nPos--;                	
                }          
				m_pszArgv[m_nArgc++][nPos+1] = 0;                
				m_nToken = m_nArgc;
                return (TRUE);
            }    
        }

        // Normal case.
        if ( TOKEN_KEY == m_pchLineBuf[i] ) {
            if ( TRUE == isToken ) {
                pszToken[nTokenLen] = 0;
                NewMem(m_pszArgv[m_nArgc], nTokenLen*sizeof(char)+1);
                if ( !m_pszArgv[m_nArgc] ) {
                    ASSERT( FALSE );
                    return (FALSE);
                }
                else {
                    isToken = FALSE;
                    strcpy(m_pszArgv[m_nArgc++], pszToken);
                    nTokenLen = 0;
                }    
            }
        }
        else {
            if ( FALSE == isToken ) {
                isToken = TRUE;
            }
            pszToken[nTokenLen++] = m_pchLineBuf[i];
        }
    }
                         
	if ( m_pchLineBuf[m_nLen-2] != ' ') {
		m_nToken = (m_nArgc == 1) ? 1 : (m_nArgc - 1);		
	}                       
	else {
		m_nToken = m_nArgc;
	}	

    // Return back.
    return (TRUE);

}   // End of CSyntaxCheckSub::CommandParseSub(). 

                  
BOOL CSyntaxCheckSub::CheckCommandKeywordSub(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == m_nCommandID );
    if ( 0 == m_nArgc ) {
	    m_nErrorID = NO_COMMAND;
        return (FALSE);
    }
    ASSERT( m_nArgc > 0 );
    ASSERT( m_pszArgv[0] );
    
    if ('@' == m_pszArgv[0][0]) {
		m_nCommandID = CMDID_RUNMACRO;
        return (TRUE);			
	}
	
    if ('$' == m_pszArgv[0][0]) {
		m_nCommandID = CMDID_VARDEFINE;
        return (TRUE);			
	}

	char* pszExpand = new char[21];
	char* pszHints = new char[400];
                                             
    int nRet = ::ExpandCommand(m_pszArgv[0], pszExpand, pszHints);
	
	if ( nRet != CCommandSet::NO_COMMAND) {
		NewMem(m_pszArgv[0], strlen(pszExpand) + 1);
		strcpy(m_pszArgv[0] , pszExpand); 
	}                                    
	delete []pszExpand;
	pszExpand = 0;
	
	delete []pszHints;
	pszHints = 0;
	
    // Detect the command ID.
    nRet = GetTotalCommandId(m_pszArgv[0]);
	
	if (nRet == CCommandSet::NO_COMMAND) {
		m_nErrorID = NO_SUCH_COMMAND;    
		return FALSE;
	}	
	else {
		m_nCommandID = nRet;
		return TRUE;
	}	   
    return (FALSE);

}   // End of CSyntaxCheckSub::CheckCommandKeywordSub().
                                                                                                              

BOOL CSyntaxCheckSub::SyntaxDispatchSub(const int nCommandID)
{
    // Assertion of the input parameters.
    ASSERT( nCommandID >= MIN_CMDID && nCommandID <= MAX_CMDID );

    BOOL isTrue = FALSE;
    // Reset the error ID.
    m_nErrorID = 0;
    
    // Dispatch the syntax checking routine.
    switch ( nCommandID ) {    
    
        case CMDID_RUNMACRO:
			isTrue = SyntaxCheckRunMacroSub();
			break;
		case CMDID_VARDEFINE:
			isTrue = SyntaxCheckVarDefineSub();
			break;			
		case CMDID_ALIAS:
			isTrue = SyntaxCheckAliasSub();
			break;	
        case CMDID_ASSEMBLE:
            isTrue = SyntaxCheckAssembleSub();
            break;
        case CMDID_BREAKPOINT:
            isTrue = SyntaxCheckBreakpointSub();
            break;                 
        case CMDID_BYTE:
            isTrue = SyntaxCheckByteSub();
            break;                             
        case CMDID_CHECKSUM:
            isTrue = SyntaxCheckChecksumSub();
            break;
        case CMDID_CLEAR:
            isTrue = SyntaxCheckClearSub();
            break;             
        case CMDID_CLOCK:
        	isTrue = SyntaxCheckClockSub();
        	break;    
        case CMDID_COMPARE:
            isTrue = SyntaxCheckCompareSub();
            break;
        case CMDID_CONTROL:
            isTrue = SyntaxCheckControlSub();
            break;
        case CMDID_COPY:                  
        	//The syntax is same as Compare
            isTrue = SyntaxCheckCompareSub();
            break;
        case CMDID_DISASSEMBLE:
            isTrue = SyntaxCheckChecksumSub();
            break;          
        case CMDID_DIAGNOSIS:
            //isTrue = SyntaxCheckDiagnosisSub();
        	break;
        case CMDID_EVENT:
            isTrue = SyntaxCheckEventSub();
            break;
        case CMDID_EV1:  
            isTrue = SyntaxCheckEv1Sub();
            break;
        case CMDID_EV2:
            isTrue = SyntaxCheckEv2Sub();
            break;
        case CMDID_EV3:
            isTrue = SyntaxCheckEv3Sub();
            break;
        case CMDID_FILL:
            isTrue = SyntaxCheckFillSub();
            break;
        case CMDID_GO:
            isTrue = SyntaxCheckGoSub();
            break;
        case CMDID_HALT:
            isTrue = SyntaxCheckHaltSub();
            break;
        case CMDID_HELP:
            isTrue = SyntaxCheckHelpSub();
            break;
        case CMDID_IDENTIFY:
            isTrue = SyntaxCheckIdentifySub();
            break;
        case CMDID_INCLUDE:
            isTrue = SyntaxCheckIncludeSub();                      
            break;
        case CMDID_INPORT:
            isTrue = SyntaxCheckInportSub();
            break;
        case CMDID_JUMP:
            isTrue = SyntaxCheckJumpSub();
            break;
        case CMDID_LIST:
            isTrue = SyntaxCheckListSub();
            break;
        case CMDID_LOG:
            isTrue = SyntaxCheckLogSub();
            break;
        case CMDID_MACRO:
        	isTrue = SyntaxCheckMacroSub(); 
        	break;
        case CMDID_MDEL:
        	isTrue = SyntaxCheckMdelSub(); 
        	break;
        case CMDID_MEMORY:
            isTrue = SyntaxCheckMemorySub();
            break;
        case CMDID_MEND:
        	isTrue = SyntaxCheckMendSub(); 
        	break;
        case CMDID_MLIST:
        	isTrue = SyntaxCheckMlistSub(); 
        	break;
        case CMDID_OUTPORT:
            isTrue = SyntaxCheckOutportSub();
            break;
        case CMDID_QUALIFY:
            isTrue = SyntaxCheckQualifySub();
            break;
        case CMDID_REGISTER:
            isTrue = SyntaxCheckRegisterSub();
            break;
        case CMDID_RESET:
            isTrue = SyntaxCheckResetSub();
            break;
        case CMDID_SEARCH:
            isTrue = SyntaxCheckSearchSub();
            break;       
        /*
        case CMDID_SELECTBREAKTYPE:
        	isTrue = SyntaxCheckSelectBreakTypeSub();    
        	break;
        */
        case CMDID_STEP:
            isTrue = SyntaxCheckStepSub();
            break;
        case CMDID_TEST:
            isTrue = SyntaxCheckTestSub();
            break;
        case CMDID_TRACE:
            isTrue = SyntaxCheckTraceSub();
            break;
        case CMDID_TRIGGER:
            isTrue = SyntaxCheckTriggerSub();
            break;
        case CMDID_UPLOAD:
            isTrue = SyntaxCheckUploadSub();
            break;
        case CMDID_VERIFY:
            isTrue = SyntaxCheckVerifySub();
            break;
        case CMDID_WORD:
            isTrue = SyntaxCheckWordSub();
            break;
        case CMDID_CREATE:
            isTrue = SyntaxCheckCreateSub();
            break;
        case CMDID_DELETE:
            isTrue = SyntaxCheckDeleteSub();
            break;
        case CMDID_LOAD:
            isTrue = SyntaxCheckLoadSub();
            break;
        case CMDID_QUERY:
            isTrue = SyntaxCheckQuerySub();
            break;
        case CMDID_SSAVE:
            isTrue = SyntaxCheckSsaveSub();
            break;
        case CMDID_SRECALL:
            isTrue = SyntaxCheckSrecallSub();
            break;
        case CMDID_SYMBOL:
            isTrue = SyntaxCheckSymbolSub();
            break;
        case CMDID_WATCH:
            isTrue = SyntaxCheckWatchSub();
            break;
            
        default:
            ASSERT( FALSE );
            break;
    }              

    return isTrue;
    
}   // End of CSyntaxCheckSub::SyntaxDispatchSub().

                                                    
BOOL CSyntaxCheckSub::SyntaxCheckRunMacroSub(void)
{                
    BOOL isTrue = FALSE;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;  
        	break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
	        m_nPos = 1;
			break;
		default:           
			m_nPos = 100;
            break;
    }	
	    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckRunMacroSub(). 

BOOL CSyntaxCheckSub::SyntaxCheckVarDefineSub(void)
{                
    BOOL isTrue = FALSE;
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckVarDefineSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckAliasSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( !IsCommandName(m_pszArgv[1]) ) {
				m_nPos = 1;
			}              
			else {
			    m_nPos = 2;
			    isTrue = TRUE;
			}
        	break;                    
        case 3:               
			if ( !IsCommandName(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}    
			if ( !IsCommandName(m_pszArgv[2]) ) {
				m_nPos = 2;
				break;
			}        
			m_nPos = 3;      
			//isTrue = TRUE;        	
			break;        
		default:
			if ( !IsCommandName(m_pszArgv[1]) ) {
				m_nPos = 2;
				break;
			}    
			if ( !IsCommandName(m_pszArgv[2]) ) {
				m_nPos = 3;
				break;
			}        
            break;
    }        
    
	return isTrue;    
	
}	//End of CSyntaxCheckSub::SyntaxCheckAliasSub().                                                    
                                              
                                              
BOOL CSyntaxCheckSub::SyntaxCheckAssembleSub(void)
{                
    BOOL isTrue = FALSE;


    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2: 
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 2;  
        		isTrue = TRUE;
        	}              
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 2;  
        	}              
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckAssembleSub().                                                    
                                                 
                                                 
BOOL CSyntaxCheckSub::SyntaxCheckBreakpointSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;                    
        	isTrue = TRUE;
        	break;
        case 2: 
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 2;  
        		isTrue = TRUE;
        	}              
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 2;  
        	}              
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckBreakpointSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckByteSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;      
        	isTrue = TRUE;
        	break;
        case 2:                  
        	if ( IsRAddrDefault(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        	}                 
        	else {
        		m_nPos = 1;
        	}
        	break;                 
        case 3:            
        	if ( IsRAddrDefault(m_pszArgv[1]) ) {
            	if ( IsData(m_pszArgv[2]) ) {
            		m_nPos = 3;
            		isTrue = TRUE;
            	}	
	            else {
			   		m_nPos = 2;
	        	}                 
	        }	
        	else {
        		m_nPos = 1;
        	}
			break;        
		default:
        	if ( IsRAddrDefault(m_pszArgv[1]) ) {
            	if ( IsData(m_pszArgv[2]) ) {
            		m_nPos = 3;
            		isTrue = TRUE;
            	}	
	            else {
			   		m_nPos = 2;
	        	}                 
	        }	
        	else {
        		m_nPos = 1;
        	}
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckByteSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckChecksumSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;                            
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	                  
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 4;           
        		isTrue = TRUE;
        	}	
			break;        
        case 4:	         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
					isTrue = TRUE;
				}	
			}
			break;
		default:         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
				}	
			}
			//m_nPos = 4;	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckChecksumSub().


BOOL CSyntaxCheckSub::SyntaxCheckClearSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:                
        	m_nPos = 1;           
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( IsKeywordAll(m_pszArgv[1]) || AdrIsP(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        	}             
        	else {
        		m_nPos = 1;
        	}	
        	break;
		default:
        	if ( IsKeywordAll(m_pszArgv[1]) || AdrIsP(m_pszArgv[1]) ) {
        		m_nPos = 2;
        	}             
        	else {
        		m_nPos = 1;
        	}	
            break;
    }        

	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckClearSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckClockSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:           
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( IsClockOption(m_pszArgv[1]) ) {
        		m_nPos = 2;
            	isTrue = TRUE;
			}             
			else {
				m_nPos = 1;
			}	
        	break;                    
		default:
        	if ( IsClockOption(m_pszArgv[1]) ) {
        		m_nPos = 2;
			}             
			else {
				m_nPos = 1;
			}	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckClockSub().
                                                    

BOOL CSyntaxCheckSub::SyntaxCheckCompareSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 4;   
        		isTrue = TRUE;
        	}	
			break;        
        case 4:	         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
					isTrue = TRUE;
				}	                 
				break;
			}         
			if ( !IsAddrPR(m_pszArgv[3]) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5;
				isTrue = TRUE;
			} 
			break;           
		case 5:
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					if ( !IsAddrPR(m_pszArgv[4]) ) {
						m_nPos = 4;
					}
					else {
						m_nPos = 5;	
						isTrue = TRUE;
					}	
				}	              
				break;
			}         
			if ( !IsAddrPR(m_pszArgv[3]) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5; 
				isTrue = TRUE;
			} 			
			break;           
		default:
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					if ( !IsAddrPR(m_pszArgv[4]) ) {
						m_nPos = 4;
					}
					else {
						m_nPos = 5;	
					}	
				}	
				break;
			}                        
			if ( !IsAddrPR(m_pszArgv[3]) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5;
			} 			
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckCompareSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckControlSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
			if ( IsKeywordControlOption(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;
			}              
			else {
				m_nPos = 1;				
			}
        	break;                 
		case 3:
			if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}         
			if ( !IsKeywordEnable(m_pszArgv[2]) && 
                 !IsKeywordDisable(m_pszArgv[2]) ) {
            	m_nPos = 2;   
            	break;       
			}                           
			else {
				m_nPos = 3;
				isTrue = TRUE;				
				break;
			}
			break;		
		default:
			if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}              
			if ( !IsKeywordEnable(m_pszArgv[2]) && 
                 !IsKeywordDisable(m_pszArgv[2]) ) {
            	m_nPos = 2;          
			}                           
			else {
				m_nPos = 3;
			}
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckControlSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEventSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;      
        	//SetSyntaxColorEvent();
			m_nEvent = 0;
			isTrue = TRUE;        	
        	break;
        default:
        	if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        		break;
        	}                 
        	if ( IsEventOption(m_pszArgv[1]) ) {
        	    if ( 0 == stricmp(m_pszArgv[1], "1") ) {
        	    	for ( int i = 0 ; i < (m_nToken-1); i++) {
        	    		NewMem(m_pszArgv[i], 300);
        	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
        	    	}                                        
        	    	m_nPos--;
        	    	m_nToken--;
        	    	m_nCommandID = CMDID_EV1;
        	    	isTrue = SyntaxCheckEv1Sub();
        	    	m_nEvent = 1;
        	    	break;
        	    }
        	    if ( 0 == stricmp(m_pszArgv[1], "2") ) {
        	    	for ( int i = 0 ; i < (m_nToken-1); i++) {
        	    		NewMem(m_pszArgv[i], 300);
        	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
        	    	}                                        
        	    	m_nPos--;
        	    	m_nToken--;
        	    	m_nCommandID = CMDID_EV2;
        	    	isTrue = SyntaxCheckEv2Sub();
        	    	m_nEvent = 2;
        	    	break;
        	    }
        	    if ( 0 == stricmp(m_pszArgv[1], "3") ) {
        	    	for ( int i = 0 ; i < (m_nToken-1); i++) {
        	    		NewMem(m_pszArgv[i], 300);
        	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
        	    	}        
        	    	m_nPos--;  
        	    	m_nToken--;             
        	    	m_nCommandID = CMDID_EV3;                 
        	    	isTrue = SyntaxCheckEv3Sub();
        	    	m_nEvent = 3;
        	    	break;
        	    }
        	}            	
        	m_nPos = 1;
        	break;
		
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckEventSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv1Sub(void)
{                
    BOOL isTrue = FALSE;
	int nClear = 0; 
	BOOL nDup = FALSE;
	
    // Check command syntax.
    
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsKeywordAddress(m_pszArgv[1]) ) {
				m_nPos = 2;   
				isTrue = TRUE;
				break;
			}              
			if ( IsKeywordDatum(m_pszArgv[1]) ) {
				m_nPos = 3;   
				isTrue = TRUE;
				break;    
			}             
			if ( IsKeywordCount(m_pszArgv[1]) ) {
				m_nPos = 4;   
				isTrue = TRUE;
				break;
			}              
			if ( IsKeywordClear(m_pszArgv[1]) ) {
				m_nPos = 100;     
				isTrue = TRUE;
				break;
			}              
			m_nPos = 1;  
        	break;             
		default:    
			int nAddr = 0;
			int nDatum = 0;
			int nCount = 0;
			int nIndex = 0;
			for (int i = 1; i < m_nToken; i++) {
				if ( IsKeywordAddress(m_pszArgv[i]) ) {
					if ( nAddr == 0 ) {
						nAddr = i;	
					}
					else nDup = TRUE;	
				}			
				if ( IsKeywordDatum(m_pszArgv[i]) ) {
					if ( nDatum == 0 ) 
						nDatum = i;	    
					else nDup = TRUE;		
				}			
				if ( IsKeywordCount(m_pszArgv[i]) ) {
					if ( nCount == 0 )
						nCount = i;	
					else nDup = TRUE;		
				}								       
				if ( IsKeywordClear(m_pszArgv[i]) ) {
					nClear = i;														
				}
			}			
			nIndex = (nAddr > nDatum) ? nAddr : nDatum;
			nIndex = (nIndex > nCount) ? nIndex : nCount;
			if (nIndex == 0) {
				m_nPos = 1;
				break;
			}	
			if (nIndex == nAddr) {
			    nIndex++;
				if (nIndex < m_nToken) {
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( AdrIsP(m_pszArgv[nIndex]) &&
	                    		 AdrIsP(m_pszArgv[nIndex+1] ) ) {
	                    		if ( (nDatum == 0) && (nCount == 0) ) {
	                    			m_nPos = 7;
	                    			isTrue = TRUE;
	                    			break;	                    		 
	                    		}
	                    		if ( nDatum == 0 ) {
	                    			m_nPos = 15;       
                    				isTrue = TRUE;
	                    			break;
	                    		}	                    		
	                    		else {
	                    		    m_nPos = 14;  
                    		    	isTrue = TRUE;
	                    			break;
	                    		}	
	                    	}	 	  
	                    	if ( !AdrIsP(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 12;  
	                    		break;
	                    	}	            
	                    	if ( !AdrIsP(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 5;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !AdrIsP(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 5;
	                    		break;
	                    	}
	                    	else {
	                    		isTrue = TRUE;
	                    		m_nPos = 12;
	                    		break;
	                    	}		                    	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 5;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }        
	                if ( !AdrIsP(m_pszArgv[nIndex]) &&
	                	 !IsWildcardAddr(m_pszArgv[nIndex]) ) {
						m_nPos = 2;
						break;	                	
	                }
	                if ( AdrIsP(m_pszArgv[nIndex]) ) {         
	            		if ( (nDatum == 0) && (nCount == 0) ) {
	            			m_nPos = 19;                       
	            			isTrue = TRUE;
	            			break;	                    		 
	            		}
	            		if ( nDatum == 0 ) {
	            			m_nPos = 21;  
	            			isTrue = TRUE;
	            			break;
	            		}	           
	            		else {
	            		    m_nPos = 20;  
	            		    isTrue = TRUE;
	            			break;
	            		}
	            	}
	            	else {
	            		if ( (nDatum == 0) && (nCount == 0) ) {
	            			m_nPos = 7;                        
	            			isTrue = TRUE;
	            			break;	                    		 
	            		}
	            		if ( nDatum == 0 ) {
	            			m_nPos = 15;  
	            			isTrue = TRUE;
	            			break;
	            		}	           
	            		else {
	            		    m_nPos = 14;  
	            		    isTrue = TRUE;
	            			break;
	            		}
	            	}		
				}
				m_nPos = 2;				
				isTrue = TRUE;
				break;
			}	      
			if (nIndex == nDatum) {
				nIndex++;
				if (nIndex < m_nToken) {
					//Datum Range adr1 adr2
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( IsEventData(m_pszArgv[nIndex]) &&
	                    		 IsEventData(m_pszArgv[nIndex+1] ) ) {
	                    		if ( (nAddr == 0) && (nCount == 0) ) {
	                    			m_nPos = 17;
                    				isTrue = TRUE;
	                    			break;	                    		 
	                    		}
	                    		if ( nAddr == 0 ) {
	                    			m_nPos = 16;  
                    				isTrue = TRUE;
	                    			break;
	                    		}	           
	                    		else {
	                    		    m_nPos = 14;  
                    		    	isTrue = TRUE;
	                    			break;
	                    		}	
	                    	}	 	  
	                    	if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 13;
	                    		break;
	                    	}	            
	                    	if ( !IsEventData(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 8;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !IsEventData(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 8;
	                    		break;
	                    	}	          
	                    	else {
	                    	    m_nPos = 13;      
	                    	    isTrue = TRUE;
	                    		break;
	                    	}          	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 8;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }    
	                //Datum xadr or badrs..
	                if ( !IsEventData(m_pszArgv[nIndex]) &&
	                	 !IsWildcardData(m_pszArgv[nIndex]) ) {
						m_nPos = 3;
						break;	                	
	                }             
            		if ( (nAddr == 0) && (nCount == 0) ) {
            			m_nPos = 17;                      
            			isTrue = TRUE;
            			break;	                    		 
            		}
            		if ( nAddr == 0 ) {
            			m_nPos = 16;  
            			isTrue = TRUE;
            			break;
            		}	           
            		else {
            		    m_nPos = 14;  
            		    isTrue = TRUE;
            			break;
            		}	
				}
				m_nPos = 3;	
				isTrue = TRUE;			
				break;
			}	      
			if (nIndex == nCount) {
				nIndex++;
				if (nIndex < m_nToken) {
					if ( !IsAddrData(m_pszArgv[nIndex]) ) {
						m_nPos = 11;
						break;
					}		
					m_nPos = 100;	
					isTrue = TRUE;	
					break;
				}				 
				m_nPos = 11;  
				isTrue = TRUE;
			}                        
            break;
    }        
    
	if ( nClear != 0 || nDup == TRUE ) {
		isTrue = FALSE;
	}
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckEv1Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv2Sub(void)
{                
    BOOL isTrue = FALSE;
	int nClear = 0;                  
	BOOL nDup = FALSE;
	
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
			if ( IsKeywordAddress(m_pszArgv[1]) ) {
				m_nPos = 2;   
				isTrue = TRUE;
				break;
			}              
			if ( IsKeywordDatum(m_pszArgv[1]) ) {
				m_nPos = 3;   
				isTrue = TRUE;
				break;    
			}             
			if ( IsKeywordClear(m_pszArgv[1]) ) {
				m_nPos = 100;     
				isTrue = TRUE;
				break;
			}              
			m_nPos = 1;  
	       	break;             
		default:    
			int nAddr = 0;
			int nDatum = 0;
			int nIndex = 0;          
			for (int i = 1; i < m_nToken; i++) {
				if ( IsKeywordAddress(m_pszArgv[i]) ) {
					if ( nAddr == 0 )
						nAddr = i;	
					else nDup = TRUE;		
				}			
				if ( IsKeywordDatum(m_pszArgv[i]) ) {
					if ( nDatum == 0 )
						nDatum = i;	
					else nDup = TRUE;		
				}			
				if ( IsKeywordClear(m_pszArgv[i]) ) {
					nClear = i;														
				}
			}			
			nIndex = (nAddr > nDatum) ? nAddr : nDatum;
			if (nIndex == 0) {
				m_nPos = 1;
				break;
			}	
			if (nIndex == nAddr) {
			    nIndex++;
				if (nIndex < m_nToken) {
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( AdrIsP(m_pszArgv[nIndex]) &&
	                    		 AdrIsP(m_pszArgv[nIndex+1] ) ) {
								if (nDatum ==0) {                    			
	                    			m_nPos = 7;
									isTrue = TRUE;	                    			
	                    			break;	     
	                    		}
	                    		else {
	                    			m_nPos = 100; 
									isTrue = TRUE;	                    			
	                    			break;	     
	                    		}	               		 	                    			
	                    	}	 	  
	                    	if ( !AdrIsP(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 5; 
	                    		break;
	                    	}	            
	                    	if ( !AdrIsP(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 4;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !AdrIsP(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 4;
	                    		break;
	                    	}
	                    	else {
	                    		m_nPos = 5;       
	                    		isTrue = TRUE;
	                    		break;
	                    	}		                    	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 4;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }        
	                if ( !AdrIsP(m_pszArgv[nIndex]) &&
	                	 !IsWildcardAddr(m_pszArgv[nIndex]) ) {
						m_nPos = 2;
						break;	                	
	                }
	                if ( AdrIsP(m_pszArgv[nIndex]) ) {         
            			if (nDatum == 0) {
            				m_nPos = 8;   
            				isTrue = TRUE;
            				break;	                    		 
            			}
            			else {
            				m_nPos = 6;   
            				isTrue = TRUE;
            				break;	                    		 
            			}	
	            	}
	            	else {                     
	            		if (nDatum == 0) {
	            			m_nPos = 7;
	            			isTrue = TRUE;
	            			break;	                    		 
	            		}
	            		else {
							m_nPos = 100; 
							isTrue = TRUE;
	            			break;	                    		 	            		
	            		}	              
	            	}
				}
				m_nPos = 2;				
				isTrue = TRUE;
				break;
			}	      
			if (nIndex == nDatum) {
				nIndex++;
				if (nIndex < m_nToken) {
					//Datum Range adr1 adr2
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( IsEventData(m_pszArgv[nIndex]) &&
	                    		 IsEventData(m_pszArgv[nIndex+1] ) ) {
                    			if (nAddr == 0) {
	                    			m_nPos = 11;
	                    			break;	                    		 
	                    		}
	                    		else {
	                    			m_nPos = 100;
	                    			break;	                    		 
	                    		}	
	                    		isTrue = TRUE;	                    			
	                    	}	 	  
	                    	if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 10;
	                    		break;
	                    	}	            
	                    	if ( !IsEventData(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 9;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !IsEventData(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 9;
	                    		break;
	                    	}	          
	                    	else {
	                    	    m_nPos = 10;  
	                    	    isTrue = TRUE;
	                    		break;
	                    	}          	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 9;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }    
	                //Datum xadr or badrs..
	                if ( !IsEventData(m_pszArgv[nIndex]) &&
	                	 !IsWildcardData(m_pszArgv[nIndex]) ) {
						m_nPos = 3;
						break;	                	
	                }             
            		if ( nAddr == 0 ) {
            			m_nPos = 11;      
            			isTrue = TRUE;
            			break;	                    		 
            		}
            		else {
            			m_nPos = 100; 
            			isTrue = TRUE;
            			break;	                    		 
            		}
				}
				m_nPos = 3;				
           		isTrue = TRUE;
				break;
			}	      
            break;
    }        

	if ( nClear != 0 || nDup == TRUE ) {
		isTrue = FALSE;
	}
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckEv2Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv3Sub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
            if ( IsEvent3Option(m_pszArgv[1]) ) {
            	m_nPos = 2;
            	isTrue = TRUE; 
            }
            else {
				m_nPos = 1;            
            }	                  	
        	break;                
		default:
            if ( !IsEvent3Option(m_pszArgv[1]) ) {
            	m_nPos = 1;
            }
            else {
				m_nPos = 2;            
            }	                  	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckEv3Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckFillSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
				if ( IsAddrR(m_pszArgv[1]) ) {             		
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else {
					m_nPos = 5;   
					isTrue = TRUE;     		
        		}	
        	}	
			break;        
        case 4:	         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					if ( IsAddrR(m_pszArgv[1]) ) {             		
						m_nPos = 4;
						isTrue = TRUE;     
					}	
					else {
						m_nPos = 5;
						isTrue = TRUE;					
					}	
				}	                 
				break;
			}    
			if ( IsAddrR(m_pszArgv[1]) ) {     
				if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
					m_nPos = 4;			
				}              
				else {
					m_nPos = 100;       
					isTrue = TRUE;
				} 							
			}				
			else {
				if ( !IsDataWordSub(m_pszArgv[3]) ) {
					m_nPos = 5;			
				}              
				else {
					m_nPos = 100;
					isTrue = TRUE;
				} 
			}
			break;           
		case 5:
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {                         
					if ( IsAddrR(m_pszArgv[1]) ) {     
						if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
							m_nPos = 4;			
						}              
						else {
							m_nPos = 100; 
							isTrue = TRUE;
						} 			
					}						
					else {
						if ( !IsDataWordSub(m_pszArgv[4]) ) {
							m_nPos = 5;
						}
						else {
							m_nPos = 100;	
							isTrue = TRUE;
						}	  
					}	
				}	              
				break;
			}                                          
			if ( IsAddrR(m_pszArgv[1]) ) {     
				if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
					m_nPos = 4;			
				}              
				else {
					m_nPos = 100; 
					isTrue = TRUE;
				} 			
			}						
			else {
				if ( !IsDataWordSub(m_pszArgv[4]) ) {
					m_nPos = 5;			
				}              
				else {
					m_nPos = 100;
					isTrue = TRUE;
				} 			
			}	
			break;           
		default:
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {                         
					if ( IsAddrR(m_pszArgv[1]) ) {     
						if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
							m_nPos = 4;			
						}              
						else {
							m_nPos = 100; 
						} 			
					}												
					else {
						if ( !IsDataWordSub(m_pszArgv[4]) ) {
							m_nPos = 5;
						}
						else {
							m_nPos = 100;	
						}	            
					}	
				}	
				break;
			}                                       
			if ( IsAddrR(m_pszArgv[1]) ) {     
				if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
					m_nPos = 4;			
				}              
				else {
					m_nPos = 100; 
				} 			
			}												
			else {
				if ( !IsDataWordSub(m_pszArgv[3]) ) {
					m_nPos = 5;			
				}              
				else {
					m_nPos = 100;
				} 		
			}						
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckFillSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckGoSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;     
        	isTrue = TRUE;
        	break;
        case 2:           
            if ( IsKeywordRun(m_pszArgv[1]) ) {
            	m_nPos = 2;
            	isTrue = TRUE;
            	break;
            }	          
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
            	m_nPos = 3;
            	isTrue = TRUE;
            	break;
            }	              
            if ( IsKeywordTill(m_pszArgv[1]) ) {
            	m_nPos = 4;
            	isTrue = TRUE;
            	break;
            }	              
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
            	m_nPos = 5;
            	isTrue = TRUE;
            	break;
            }	              
           	m_nPos = 1;  
        	break;                   
        case 3:              
        	if ( IsKeywordRun(m_pszArgv[1]) ) {
        		if ( IsKeywordFrom(m_pszArgv[2]) ) {
					m_nPos = 6;
            		isTrue = TRUE;	        			
        		}   
        		else {
        			m_nPos = 2;
        		}              
        		break;
        	}	      
			if ( IsKeywordFrom(m_pszArgv[1]) ) {
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 7;
            		isTrue = TRUE;	        			
        		}   
        		else {
        			m_nPos = 3;
        		}              
        		break;
			}       			
			if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
            		isTrue = TRUE;	        			
        		}   
        		else {
        			m_nPos = 4;
        		}              
        		break;
			}       		        		
        	if ( IsKeywordMonitor(m_pszArgv[1]) ) {
        		if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 100;
            		isTrue = TRUE;	        			
        		}   
        		else {
        			m_nPos = 5;
        		}              
        		break;
        	}	      
			m_nPos = 1;
			break;        
        case 4:	            
        	if ( IsKeywordRun(m_pszArgv[1]) ) {
        		if ( IsKeywordFrom(m_pszArgv[2]) ) {
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 100;
	            		isTrue = TRUE;	        			
	            	}	
        			else {
        				m_nPos = 6;
        			}
        		}                          		
        		else {
        			m_nPos = 2;
        		}              
        		break;
        	}	
        	if ( IsKeywordFrom(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						m_nPos = 8;
	            		isTrue = TRUE;	        			
	            	}	
        			else {
        				m_nPos = 7;
        			}
        		}                          		
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordTill(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
            	}	
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordMonitor(m_pszArgv[1]) ) {
        		if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 5;	            		
        		}                          		
        		else {
        			m_nPos = 100; 
        		}              
        		break;
        	}	
			m_nPos = 1;        
			break;                              
        case 5:	            
        	if ( IsKeywordRun(m_pszArgv[1]) ) {
        		if ( IsKeywordFrom(m_pszArgv[2]) ) {
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 100; 
	            	}	
        			else {
        				m_nPos = 6;
        			}
        		}                          		
        		else {
        			m_nPos = 2;
        		}              
        		break;
        	}	
        	if ( IsKeywordFrom(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						if ( AdrIsP(m_pszArgv[4]) ) {
							m_nPos = 100;
		            		isTrue = TRUE;	        			
		            	}	
	            	}	
        			else {
        				m_nPos = 7;
        			}
        		}                          		
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordTill(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;     
            	}	
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordMonitor(m_pszArgv[1]) ) {
        		if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 5;	            		
        		}                          		
        		else {
        			m_nPos = 100;         			
        		}              
        		break;
        	}	
			m_nPos = 1;        
			break;                              
		default:
        	if ( IsKeywordRun(m_pszArgv[1]) ) {
        		if ( IsKeywordFrom(m_pszArgv[2]) ) {
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 100;
	            	}	
        			else {
        				m_nPos = 6;
        			}
        		}                          		
        		else {
        			m_nPos = 2;
        		}              
        		break;
        	}	
        	if ( IsKeywordFrom(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						if ( AdrIsP(m_pszArgv[4]) ) {
							m_nPos = 100;
						}
						else {	
							m_nPos = 8;
		            	}	
	            	}	
        			else {
        				m_nPos = 7;
        			}
        		}                          		
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordTill(m_pszArgv[1]) ) {
        		if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
            	}	
        		else {
        			m_nPos = 3;
        		}              
        		break;
        	}	
        	if ( IsKeywordMonitor(m_pszArgv[1]) ) {
        		if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 5;	            		
        		}                          		
        		else {
        			m_nPos = 100;
        		}              
        		break;
        	}	
			m_nPos = 1;        
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckGoSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckHaltSub(void)
{                
    BOOL isTrue = TRUE;

	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckHaltSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckHelpSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsCommand(m_pszArgv[1]) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
			if ( IsCommand(m_pszArgv[1]) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckHelpSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckIdentifySub(void)
{                
    BOOL isTrue = TRUE;

	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckIdentifySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckIncludeSub(void)
{                

    BOOL isTrue = FALSE;
	int nRet = 0;
	
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsFilename(m_pszArgv[1], nRet) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
			if ( IsFilename(m_pszArgv[1], nRet) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckIncludeSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckInportSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:        
        	if ( IsPort(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        		break;
        	}      
        	m_nPos = 1;
        	break;                    
        case 3:
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordBit(m_pszArgv[2]) ) {
        			m_nPos = 3;
        			isTrue = TRUE;
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;        
        case 4:	         
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordBit(m_pszArgv[2]) ) { 
        			if ( IsBitNo(m_pszArgv[3]) ) { 
        				m_nPos = 100;   
        				isTrue = TRUE;
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;                              
		default:
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordBit(m_pszArgv[2]) ) { 
        			if ( IsBitNo(m_pszArgv[3]) ) { 
        				m_nPos = 100;   
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckInportSub().                                                    

BOOL CSyntaxCheckSub::SyntaxCheckJumpSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2: 
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 100;  
        		isTrue = TRUE;
        	}              
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 100;  
        	}              
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        

	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckJumpSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckListSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:                               
        	if ( IsKeywordBuffer1(m_pszArgv[1]) ||
        		 IsKeywordBuffer2(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        		break;	 
        	}	      
        	m_nPos = 1;
        	break;             
        case 3:        
        	if ( IsKeywordBuffer1(m_pszArgv[1]) ||
        		 IsKeywordBuffer2(m_pszArgv[1]) ) {
				if ( IsKeywordNumber(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
					break;
				}
				if ( IsListOptionSub(m_pszArgv[2]) ) {
					m_nPos = 3;
					isTrue = TRUE;
					break;
				}             
				if ( IsListFrameSub(m_pszArgv[2]) ) {
					m_nPos = 4;
					isTrue = TRUE;
					break;
				}             
				if ( IsKeywordAddress(m_pszArgv[2]) ) {
					m_nPos = 5;
					isTrue = TRUE;
					break;
				}
        		m_nPos = 2;
        		break;	 
        	}	      
        	m_nPos = 1;
			break;        
        case 4:	         
        	if ( IsKeywordBuffer1(m_pszArgv[1]) ||
        		 IsKeywordBuffer2(m_pszArgv[1]) ) {
				if ( IsKeywordNumber(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}
				if ( IsListOptionSub(m_pszArgv[2]) ) {
					if ( IsListFrameSub(m_pszArgv[3]) ) {
						m_nPos = 4;
						isTrue = TRUE;
						break;
					}         
					if ( IsKeywordAddress(m_pszArgv[3]) ) {
						m_nPos = 5;
						isTrue = TRUE;
						break;
					}
					m_nPos = 3;
					break;	
				}         					
				if ( IsListFrameSub(m_pszArgv[2]) ) {
					if ( IsKeywordAddress(m_pszArgv[3]) ) {
						m_nPos = 5;
						isTrue = TRUE;
						break;
					}
					m_nPos = 4;
					break;
				}             
				if ( IsKeywordAddress(m_pszArgv[2]) ) {
					if ( IsKeywordRange(m_pszArgv[3]) ) {
						m_nPos = 6;
						isTrue = TRUE;
						break;
					}					
					if ( IsWildcardAddr(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
						break;
					}
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 8;
						isTrue = TRUE;
						break;
					}					  					
					m_nPos = 5;
					break;
				}
        		m_nPos = 2;
        		break;	 
        	}	      
        	m_nPos = 1;
			break;                              
        case 5:	         
        	if ( IsKeywordBuffer1(m_pszArgv[1]) ||
        		 IsKeywordBuffer2(m_pszArgv[1]) ) {
				if ( IsKeywordNumber(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}
				if ( IsListOptionSub(m_pszArgv[2]) ) {
					if ( IsListFrameSub(m_pszArgv[3]) ) {
						if ( IsKeywordAddress(m_pszArgv[4]) ) {
							m_nPos = 5;
							isTrue = TRUE;
							break;
						}        					
						m_nPos = 4;
						break;
					}         
					if ( IsKeywordAddress(m_pszArgv[3]) ) {
						if ( IsKeywordRange(m_pszArgv[4]) ) {
							m_nPos = 6;
							isTrue = TRUE;
							break;
						}					           
						if ( IsWildcardAddr(m_pszArgv[4]) ) {
							m_nPos = 100;
							isTrue = TRUE;
							break;
						}
						if ( AdrIsP(m_pszArgv[3]) ) {
							m_nPos = 8;
							isTrue = TRUE;
							break;
						}         	
						m_nPos = 5;
						break;
					}
					m_nPos = 3;
					break;	
				}         					
				if ( IsListFrameSub(m_pszArgv[2]) ) {
					if ( IsKeywordAddress(m_pszArgv[3]) ) {
						m_nPos = 5;
						isTrue = TRUE;
						break;
					}
					m_nPos = 4;
					break;
				}             
				if ( IsKeywordAddress(m_pszArgv[2]) ) {
					if ( IsKeywordRange(m_pszArgv[3]) ) {
						if ( AdrIsP(m_pszArgv[4]) ) {
							m_nPos = 7;
							isTrue = TRUE;
							break;
						}
						m_nPos = 6;
						break;
					}					
					if ( IsWildcardAddr(m_pszArgv[3]) ) {
						m_nPos = 100;
						break;
					}
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 8;
						break;
					}         					
					m_nPos = 5;
					break;
				}
        		m_nPos = 2;
        		break;	 
        	}	      
        	m_nPos = 1;
			break;                              
		default:
        	if ( !IsKeywordBuffer1(m_pszArgv[1]) &&
        		 !IsKeywordBuffer2(m_pszArgv[1]) ) {
        		 m_nPos = 1;
        		 break;
        	}	 	   
			if ( IsKeywordNumber(m_pszArgv[2]) ) {
				m_nPos = 100;
				break;
			}                   
	        int nIndex = 0;
	        int nPos = ( m_nToken > 4 ) ? 4 : 3;
	        for ( int k = 1; k <= nPos; k++ ) {
	            if ( IsKeywordAddress(m_pszArgv[k]) ) {
	                nIndex = k;
	                break;
	            }
	        }     
	        if ( 0 == nIndex ) {
            	if ( !IsListOptionSub(m_pszArgv[2]) &&
            		 !IsListFrameSub(m_pszArgv[2]) ) {
            		m_nPos = 2;
            		break;	 
            	}	                  
			    if ( IsListOptionSub(m_pszArgv[2]) ) {
			    	if ( !IsListFrameSub(m_pszArgv[3]) ) {	
	            		m_nPos = 3;
	            		break;	  
	            	}				    		
			    }
	        }
            if ( nIndex == 3 ) {
            	if ( !IsListOptionSub(m_pszArgv[2]) &&
            		 !IsListFrameSub(m_pszArgv[2]) ) {
            		m_nPos = 2;
            		break;	 
            	}	                  
            }
			if ( nIndex == 4 ) {
            	if ( !IsListOptionSub(m_pszArgv[2]) &&
            		 !IsListFrameSub(m_pszArgv[2]) ) {
            		m_nPos = 2;
            		break;	 
            	}	                  
			    if ( IsListOptionSub(m_pszArgv[2]) ) {
			    	if ( !IsListFrameSub(m_pszArgv[3]) ) {	
	            		m_nPos = 3;
	            		break;	  
	            	}				    		
			    }
			}                                   
			nIndex++;
			if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
				if ( (nIndex+2) < m_nToken ) {
					if ( AdrIsP(m_pszArgv[nIndex+1]) ) {
						if ( AdrIsP(m_pszArgv[nIndex+2]) ) {
							m_nPos = 100;
							isTrue = TRUE;
							break;
						}
						m_nPos = 7;
						break;
					}
					m_nPos = 6;
					break;
				}
				if ( (nIndex+2) == m_nToken ) {
					if ( AdrIsP(m_pszArgv[nIndex+1]) ) {
						m_nPos = 7;
						isTrue = TRUE;
						break;
					}
					m_nPos = 6;
					break;
				}
				if ( (nIndex+1) == m_nToken ) {
					m_nPos = 6;
					isTrue = TRUE;
					break;
				}
				break;
			}
			if ( AdrIsP(m_pszArgv[nIndex]) ) {
				m_nPos = 8;   
				isTrue = TRUE;
				break;
			}
			if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
				m_nPos = 100; 
				isTrue = TRUE;
				break;
			}           
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckListSub().                                                    
                    
                    
BOOL CSyntaxCheckSub::SyntaxCheckLogSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;                                                
	                                                    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) {
            	m_nPos = 2;
            	isTrue = TRUE;
            	break;
			}
            m_nPos = 1;
        	break;              
        case 3:         
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {                    
                    m_nPos = 3;
                    isTrue = TRUE;
                    break;
                }   
                if (IsKeywordAppend(m_pszArgv[2]) ) { 
                	m_nPos = 100;
                	isTrue = TRUE;
                	break;
                }	
                m_nPos = 2;
                break;
			}             
			m_nPos = 1;			
			break;        
        case 4:         
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
	                    m_nPos = 100;
	                    isTrue = TRUE;   
	                }
	                else {
	                    m_nPos = 3;
	                }                    
	                break;
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                	m_nPos = 100;
                }
                else {
                	m_nPos = 2;
                }     
                break;
			}             
			m_nPos = 1;			
			break;               
		default:
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
	                    m_nPos = 100;
	                }
	                else {
	                    m_nPos = 3;
	                }
	                break;                    
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                	m_nPos = 100;
                }
                else {
                	m_nPos = 2;
                }     
                break;
			}             
			m_nPos = 1;			
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckLogSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMacroSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
			if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckMacroSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMdelSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:                
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}             
        	else {
        		m_nPos = 1;
        	}	
        	break;
		default:
        	if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;
        	}             
        	else {
        		m_nPos = 1;
        	}	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckMdelSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMemorySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;                           
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}        
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 4;               
        		isTrue = TRUE;
        	}	
			break;        
        case 4:	         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
					isTrue = TRUE;
				}	
			}
			break;
		default:         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
				}	
			}
			//m_nPos = 4;	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckMemorySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMendSub(void)
{                
    BOOL isTrue = FALSE;

	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckMendSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMlistSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
			if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
			if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckMlistSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckOutportSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( IsPort(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        		break;
        	}            
        	m_nPos = 1;  
        	break;
        case 3:
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordMask(m_pszArgv[2]) ) {
        			m_nPos = 3;
        			isTrue = TRUE;
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			m_nPos = 5;
        			isTrue = TRUE;
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;        
        case 4:	         
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordMask(m_pszArgv[2]) ) { 
        			if ( IsByteData(m_pszArgv[3]) ) { 
        				m_nPos = 4;
        				isTrue = TRUE;
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			if ( IsByteData(m_pszArgv[3]) ) {
	        			m_nPos = 100; 
	        			isTrue = TRUE;
	        		}
	        		else {
	        			m_nPos = 5;
	        		}		
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;   
		case 5:	                           
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordMask(m_pszArgv[2]) ) { 
        			if ( IsByteData(m_pszArgv[3]) ) { 
        				if ( IsKeywordByte(m_pszArgv[4]) ) {
        					m_nPos = 5;
        					isTrue = TRUE;
        				}
        				else {	
        					m_nPos = 4;
        				}	
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			if ( IsByteData(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        		}
	        		else {
	        			m_nPos = 5;
	        		}		
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;
		case 6:	                           
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordMask(m_pszArgv[2]) ) { 
        			if ( IsByteData(m_pszArgv[3]) ) { 
        				if ( IsKeywordByte(m_pszArgv[4]) ) {
        					if ( IsByteData(m_pszArgv[5]) ) { 
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}	
        					else {
								m_nPos = 5;        					        					
        					}
        				}
        				else {	
        					m_nPos = 4;
        				}	
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			if ( IsByteData(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        		}
	        		else {
	        			m_nPos = 5;
	        		}		
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
			break;
		default:
        	if ( IsPort(m_pszArgv[1]) ) {
        		if ( IsKeywordMask(m_pszArgv[2]) ) { 
        			if ( IsByteData(m_pszArgv[3]) ) { 
        				if ( IsKeywordByte(m_pszArgv[4]) ) {
        					if ( IsByteData(m_pszArgv[5]) ) { 
    	    					m_nPos = 100;
	        				}
	        				else {
								m_nPos = 5;        					        					
        					}
        				}
        				else {	
        					m_nPos = 4;
        				}	
        			}
        			else {	
        				m_nPos = 3;
        			}	
        			break; 
        		}	
        		if ( IsKeywordByte(m_pszArgv[2]) ) {
        			if ( IsByteData(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        		}
	        		else {
	        			m_nPos = 5;
	        		}		
        			break;
        		}	              		
        		m_nPos = 2;
        		break;        		
        	}         
        	m_nPos = 1;        	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckOutportSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckQualifySub(void)
{                
    BOOL isTrue = FALSE;
	int nClear = 0;                  
	BOOL nDup = FALSE;
	
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
			if ( IsKeywordAddress(m_pszArgv[1]) ) {
				m_nPos = 2;   
				isTrue = TRUE;
				break;
			}              
			if ( IsKeywordDatum(m_pszArgv[1]) ) {
				m_nPos = 3;   
				isTrue = TRUE;
				break;    
			}             
			if ( IsKeywordClear(m_pszArgv[1]) ) {
				m_nPos = 100;     
				isTrue = TRUE;
				break;
			}              
			m_nPos = 1;  
	       	break;             
		default:    
			int nAddr = 0;
			int nDatum = 0;
			int nIndex = 0;          
			for (int i = 1; i < m_nToken; i++) {
				if ( IsKeywordAddress(m_pszArgv[i]) ) {
					if ( nAddr == 0 )
						nAddr = i;	
					else nDup = TRUE;		
				}			
				if ( IsKeywordDatum(m_pszArgv[i]) ) {
					if ( nDatum == 0 )
						nDatum = i;	
					else nDup = TRUE;		
				}			
				if ( IsKeywordClear(m_pszArgv[i]) ) {
					nClear = i;														
				}
			}			
			nIndex = (nAddr > nDatum) ? nAddr : nDatum;
			if (nIndex == 0) {
				m_nPos = 1;
				break;
			}	
			if (nIndex == nAddr) {
			    nIndex++;
				if (nIndex < m_nToken) {
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( AdrIsP(m_pszArgv[nIndex]) &&
	                    		 AdrIsP(m_pszArgv[nIndex+1] ) ) {
								if (nDatum ==0) {                    			
	                    			m_nPos = 7;
									isTrue = TRUE;	                    			
	                    			break;	     
	                    		}
	                    		else {
	                    			m_nPos = 100; 
									isTrue = TRUE;	                    			
	                    			break;	     
	                    		}	               		 	                    			
	                    	}	 	  
	                    	if ( !AdrIsP(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 5; 
	                    		break;
	                    	}	            
	                    	if ( !AdrIsP(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 4;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !AdrIsP(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 4;
	                    		break;
	                    	}
	                    	else {
	                    		m_nPos = 5;       
	                    		isTrue = TRUE;
	                    		break;
	                    	}		                    	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 4;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }        
	                if ( !AdrIsP(m_pszArgv[nIndex]) &&
	                	 !IsWildcardAddr(m_pszArgv[nIndex]) ) {
						m_nPos = 2;
						break;	                	
	                }
	                if ( AdrIsP(m_pszArgv[nIndex]) ) {         
            			if (nDatum == 0) {
            				m_nPos = 8;   
            				isTrue = TRUE;
            				break;	                    		 
            			}
            			else {
            				m_nPos = 6;   
            				isTrue = TRUE;
            				break;	                    		 
            			}	
	            	}
	            	else {                     
	            		if (nDatum == 0) {
	            			m_nPos = 7;
	            			isTrue = TRUE;
	            			break;	                    		 
	            		}
	            		else {
							m_nPos = 100; 
							isTrue = TRUE;
	            			break;	                    		 	            		
	            		}	              
	            	}
				}
				m_nPos = 2;				
				isTrue = TRUE;
				break;
			}	      
			if (nIndex == nDatum) {
				nIndex++;
				if (nIndex < m_nToken) {
					//Datum Range adr1 adr2
					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( (nIndex+2) <= m_nToken ) {
	                    	if ( IsEventData(m_pszArgv[nIndex]) &&
	                    		 IsEventData(m_pszArgv[nIndex+1] ) ) {
                    			if (nAddr == 0) {
	                    			m_nPos = 11;
	                    			break;	                    		 
	                    		}
	                    		else {
	                    			m_nPos = 100;
	                    			break;	                    		 
	                    		}	
	                    		isTrue = TRUE;	                    			
	                    	}	 	  
	                    	if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
	                    		m_nPos = 10;
	                    		break;
	                    	}	            
	                    	if ( !IsEventData(m_pszArgv[nIndex] ) ) {
	                    		m_nPos = 9;
	                    		break;
	                    	}	                    	
	                    }
	                    if ( (nIndex+1) == m_nToken ) {
	                    	if ( !IsEventData(m_pszArgv[nIndex]) ) {
	                    		m_nPos = 9;
	                    		break;
	                    	}	          
	                    	else {
	                    	    m_nPos = 10;  
	                    	    isTrue = TRUE;
	                    		break;
	                    	}          	              	
	                    }    
	                    if ( nIndex == m_nToken ) {
	                    	m_nPos = 9;       
	                    	isTrue = TRUE;
	                    	break;
	                    }
	                    break;
	                }    
	                //Datum xadr or badrs..
	                if ( !IsEventData(m_pszArgv[nIndex]) &&
	                	 !IsWildcardData(m_pszArgv[nIndex]) ) {
						m_nPos = 3;
						break;	                	
	                }             
            		if ( nAddr == 0 ) {
            			m_nPos = 11;      
            			isTrue = TRUE;
            			break;	                    		 
            		}
            		else {
            			m_nPos = 100; 
            			isTrue = TRUE;
            			break;	                    		 
            		}
				}
				m_nPos = 3;				
           		isTrue = TRUE;
				break;
			}	      
            break;
    }        

	if ( nClear != 0 || nDup == TRUE ) {
		isTrue = FALSE;
	}
    
	return isTrue;    

}	//End of CSyntaxCheckSub::SyntaxCheckQualifySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckRegisterSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:                          
        	if ( IsRegName(m_pszArgv[1]) ) {
        		m_nPos = 2;              
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;
        	}	
        	break;                 
        case 3:            
        	if ( IsRegName(m_pszArgv[1]) ) {
				if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        		}
        		else {	
        			m_nPos = 2;
        		}
        	}
        	else {
        		m_nPos = 1;
        	}	
			break;        
		default:
        	if ( IsRegName(m_pszArgv[1]) ) {
				if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
        			m_nPos = 100;
        		}
        		else {	
        			m_nPos = 2;
        		}
        	}
        	else {
        		m_nPos = 1;
        	}	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckRegisterSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckResetSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2: 
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 100;  
        		isTrue = TRUE;
        	}              
        	else {
        		m_nPos = 1;
        	}	  
        	break;
		default:
        	if ( AdrIsP(m_pszArgv[1]) ){
        		m_nPos = 100;  
        	}              
        	else {
        		m_nPos = 1;
        	}	  
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckResetSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckSearchSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else { 
				if ( IsAddrR(m_pszArgv[1]) ) {             			
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else {
        		    m_nPos = 6;   
        		    isTrue = TRUE;
        		}	
        	}	
			break;        
        case 4:	         
        	if ( IsAddrPR(m_pszArgv[1]) ) {
        		if ( IsAddrPR(m_pszArgv[2]) ) {
        			if ( IsAddrR(m_pszArgv[1]) ) {     
	        			if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
	        				m_nPos = 5;
	        				isTrue = TRUE;        				
	        				break;
	        			}                 
	        			if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
	        				m_nPos = 100;
	        				isTrue = TRUE;
	        				break;
	        			}     
	        			m_nPos = 4;                      
	        		}	           
	        		else {
	        			if ( IsDataWordSub(m_pszArgv[3]) ) {
	        				m_nPos = 100; 
	        				isTrue = TRUE;
	        				break;
	        			}      
	        			m_nPos = 6;                     	        		
	        		}                      			
        			break;
        		}         
        		if ( IsKeywordLength(m_pszArgv[2]) ) {
        			if ( IsAddrLen(m_pszArgv[3]) ) {
        				if ( IsAddrR(m_pszArgv[1]) ) {     
        					m_nPos = 4;
        				}
        				else {
        				    m_nPos = 6;
        				}	
        				isTrue = TRUE;        				
        				break;
        			}
        			m_nPos = 3;
        			break;
        		}
        		m_nPos = 2;
        		break;
        	}        	
			m_nPos = 1;
			break;           
		case 5:
        	if ( IsAddrPR(m_pszArgv[1]) ) {
        		if ( IsAddrPR(m_pszArgv[2]) ) {
					if ( IsAddrR(m_pszArgv[1]) ) {             			
	        			if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
	        				if ( IsString(m_pszArgv[4]) ) {
	        					m_nPos = 100; 
	        					isTrue = TRUE;
	        				}
	        				else {	
	        					m_nPos = 5;
	        				}
	        				break;
	        			}                 
	        			if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
	        				m_nPos = 100;
	        				break;
	        			}     
	        			m_nPos = 4;           
	        		}
	        		else {
	        			if ( IsDataWordSub(m_pszArgv[3])) {
	        				m_nPos = 100;
	        				break;
	        			}         
	        			m_nPos = 6;	        		
	        		}	
        			break;
        		}         
        		if ( IsKeywordLength(m_pszArgv[2]) ) {
        			if ( IsAddrLen(m_pszArgv[3]) ) {
						if ( IsAddrR(m_pszArgv[1]) ) {             			        			        			
	        				if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
	        					m_nPos = 5;
	        					isTrue = TRUE;        				
	        					break;
	        				}
							if ( IsData(m_pszArgv[4]) || IsString(m_pszArgv[4])) {
		        				m_nPos = 100;
		        				isTrue = TRUE;
		        				break;		        			
		        			}         
		        			m_nPos = 4;       
		        		}	
		        		else {
							if ( IsDataWordSub(m_pszArgv[4])) {
		        				m_nPos = 100;
		        				isTrue = TRUE;
		        				break;
		        			}                		        		
		        			m_nPos = 6;
		        		}                     					
        				break;
        			}
        			m_nPos = 3;
        			break;
        		}
        		m_nPos = 2;
        		break;
        	}        	
			m_nPos = 1;
			break;           
        default:                  
        	if ( IsAddrPR(m_pszArgv[1]) ) {
        		if ( IsAddrPR(m_pszArgv[2]) ) {       
        			if ( IsAddrR(m_pszArgv[1]) ) {
	        			if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
	        				if ( IsString(m_pszArgv[4]) ) {
	        					m_nPos = 100;
	        				}
	        				else {	
	        					m_nPos = 5;
	        				}
	        				break;
	        			}                 
	        			if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
	        				m_nPos = 100;
	        				break;
	        			}
	        			m_nPos = 4;                
	        		}
	        		else {
	        			if ( IsDataWordSub(m_pszArgv[3])) {
	        				m_nPos = 100;
	        				break;
	        			}          
	        			m_nPos = 6;      	        		
	        		}	                  			
        			break;
        		}         
        		if ( IsKeywordLength(m_pszArgv[2]) ) {
        			if ( IsAddrLen(m_pszArgv[3]) ) {
        			    if ( IsAddrR(m_pszArgv[1]) ) {
	        				if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
	        					if ( IsString(m_pszArgv[5]) ) {
	        						m_nPos = 100;
	        					}
	        					else {	
	        						m_nPos = 5;
	        					}	
	        					break;
	        				}
							if ( IsData(m_pszArgv[4]) || IsString(m_pszArgv[4])) {
		        				m_nPos = 100;
		        				break;
		        			}   
		        			m_nPos = 4;             
		        		}
		        		else {
							if ( IsDataWordSub(m_pszArgv[4]) ) {
		        				m_nPos = 100;
		        				break;
		        			}         
		        			m_nPos = 6;		        		
		        		}       					
        				break;
        			}
        			m_nPos = 3;
        			break;
        		}
        		m_nPos = 2;
        		break;
        	}        	
			m_nPos = 1;
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckSearchSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckStepSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:              
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;
				break;
			}	
			if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;
				isTrue = TRUE;
				break;
			}	             
			if ( AdrIsP(m_pszArgv[1]) ) {
				m_nPos = 3;
				isTrue = TRUE;
				break;
			}	
			if ( IsKeywordTill(m_pszArgv[1]) ) {
				m_nPos = 4;
				isTrue = TRUE;
				break;
			}	             
			if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;
				isTrue = TRUE;
				break;
			}         
			m_nPos = 1;			
        	break;             
        case 3:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
					break;
				}	             
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 5;
					isTrue = TRUE;
					break;
				}	
				if ( IsKeywordTill(m_pszArgv[2]) ) {
					m_nPos = 6;
					isTrue = TRUE;
					break;
				}	             
				if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
					break;
				}                   
				m_nPos = 2;
				break;
			}	
			if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}	             
			if ( AdrIsP(m_pszArgv[1]) ) {
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}
				else {
					m_nPos = 3;
				}			
				break;
			}	
			if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ||
					 IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}	                             
				else {
					m_nPos = 4;
				}
				break;
			}	             
			if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}         
			m_nPos = 1;			
			break;        
        case 4:	            
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}	             
				if ( AdrIsP(m_pszArgv[2]) ) {
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
					}
					else {
						m_nPos = 5;
					}
					break;	
				}	
				if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ||
						 IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
					}	                          
					else {					
						m_nPos = 6;
					}	
					break;
				}	             
				if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}                   
				m_nPos = 2;
				break;
			}	
			if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}	             
			if ( AdrIsP(m_pszArgv[1]) ) {
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
				}
				else {
					m_nPos = 3;
				}			
				break;
			}	
			if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ||
					 IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
				}	                             
				else {
					m_nPos = 4;
				}
				break;
			}	             
			if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}         
			m_nPos = 1;			
			break;                              
		default:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}                   
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					break;
				}	             
				if ( AdrIsP(m_pszArgv[2]) ) {
					if ( AdrIsP(m_pszArgv[3]) ) {
						m_nPos = 100;
					}
					else {
						m_nPos = 5;
					}
					break;	
				}	
				if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ||
						 IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
					}	                          
					else {					
						m_nPos = 6;
					}	
					break;
				}	             
				m_nPos = 2;
				break;
			}	
			if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}         
			if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;
				break;
			}	             
			if ( AdrIsP(m_pszArgv[1]) ) {
				if ( AdrIsP(m_pszArgv[2]) ) {
					m_nPos = 100;
				}
				else {
					m_nPos = 3;
				}			
				break;
			}	
			if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ||
					 IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
				}	                             
				else {
					m_nPos = 4;
				}
				break;
			}	             
			m_nPos = 1;			
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckStepSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTestSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;
        
        case 3:
	       	if ( !IsAddrPR(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	
        
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 4;   
        		isTrue = TRUE;
        	}	
			break;        
        case 4:	         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
					isTrue = TRUE;
				}	
			}
			break;
		default:         
        	if ( !IsAddrPR(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPR(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
				}	
			}
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckTestSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTraceSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1; 
        	isTrue = TRUE; 
        	break;
        case 2:           
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordBuffer1(m_pszArgv[1]) ||
                 IsKeywordBuffer2(m_pszArgv[1]) ) {
				m_nPos = 100;                 
				isTrue = TRUE;                 
			}                 
			else {
				m_nPos = 1;
			}	
        	break;
		default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordBuffer1(m_pszArgv[1]) ||
                 IsKeywordBuffer2(m_pszArgv[1]) ) {
				m_nPos = 100;                 
			}                 
			else {
				m_nPos = 1;
			}	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckTraceSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTriggerSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        default:
	        if ( IsKeywordOn(m_pszArgv[1]) ||
	             IsKeywordOff(m_pszArgv[1]) ||
	             IsKeywordForward(m_pszArgv[1]) ||
	             IsKeywordBackward(m_pszArgv[1]) ) {
	             //IsKeywordCenter(m_pszArgv[1]) ) {             
				 m_nPos = 100;
				 isTrue = TRUE;				 
				 break;
	        }		                         
	        if ( IsKeywordOr(m_pszArgv[1]) ) {
	        	m_nPos = 1; 
	        	break;
	        }
	        isTrue = TRUE;
	        char pszEventSeq[255];
	        int nIndex = 2;
	        memset(pszEventSeq, 0, sizeof(pszEventSeq));
	        for ( int i = 1; i < m_nToken; i++ ) {
	            if ( 0 != stricmp(m_pszArgv[i], "FORWARD") &&
	                 0 != stricmp(m_pszArgv[i], "BACKWARD") ) {
	                 //0 != stricmp(m_pszArgv[i], "CENTER")) {
	                strcat(pszEventSeq, m_pszArgv[i]);
	                strcat(pszEventSeq, " ");
	                nIndex++;
	            }
	            else {
	                break;
	            }
	        }
        	if ( !IsEventSequence(pszEventSeq) ) {	        	              
        		m_nPos = 1;
        		//isTrue = FALSE;
        		break;
        	}             
   	        if ( m_nToken - nIndex == 1) {         
		        if ( !IsKeywordForward(m_pszArgv[m_nToken-1]) &&
		             !IsKeywordBackward(m_pszArgv[m_nToken-1]) ) {
		             //!IsKeywordCenter(m_pszArgv[m_nToken-1]) ) {
	        		m_nPos = 2;
	        		break;
		        }              
		        m_nPos = 100;  
		        isTrue = FALSE;
		        break;
		    }                 
        	m_nPos = 2;
        	isTrue = TRUE;
        	break;             
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckTriggerSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckUploadSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
        	if ( !AdrIsP(m_pszArgv[1]) ) {
				m_nPos = 1;
			}	        	
			else {
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
        	break;
        case 3:
	       	if ( !AdrIsP(m_pszArgv[1]) ) { 
				m_nPos = 1;
				break;
			}	        	
        	if ( !IsKeywordLength(m_pszArgv[2]) && 
        		 !AdrIsP(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}         
        	if ( IsKeywordLength(m_pszArgv[2])) {
        		m_nPos = 3;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 4;
        	}	
			break;        
        case 4:	         
        	if ( !AdrIsP(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !AdrIsP(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					m_nPos = 4;
					isTrue = TRUE;
				}	                 
				break;
			}         
			if ( !IsFilename(m_pszArgv[3], nRet) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5;     
				isTrue = TRUE;
			} 
			break;           
		case 5:
        	if ( !AdrIsP(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !AdrIsP(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					if ( !IsFilename(m_pszArgv[4], nRet) ) {
						m_nPos = 4;
					}
					else {
						m_nPos = 5;	
						isTrue = TRUE;
					}	
				}	              
				break;
			}         
			if ( !IsFilename(m_pszArgv[3], nRet) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5;
			} 			
			break;           
		default:
        	if ( !AdrIsP(m_pszArgv[1]) ) {
				m_nPos = 1;
				break;
			}	        
        	if ( !IsKeywordLength(m_pszArgv[2]) && !AdrIsP(m_pszArgv[2])) {
        		m_nPos = 2;
        		break;
        	}             
			if ( IsKeywordLength(m_pszArgv[2]) ) {
				if ( !IsAddrLen(m_pszArgv[3]) ) {
					m_nPos = 3;
				}
				else {
					if ( !IsFilename(m_pszArgv[4], nRet) ) {
						m_nPos = 4;
					}
					else {
						m_nPos = 5;	
					}	
				}	
				break;
			}                        
			if ( !IsFilename(m_pszArgv[3], nRet) ) {
				m_nPos = 4;			
			}              
			else {
				m_nPos = 5;
			} 			
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckUploadSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckVerifySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            }	              
            else {
            	m_nPos = 1;
            }                      	
        	break;
		default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
            	m_nPos = 100;
            }	              
            else {
            	m_nPos = 1;
            }                      	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckVerifySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckWordSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:                  
        	if ( IsAddrPR(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        	}                 
        	else {
        		m_nPos = 1;
        	}
        	break;                 
        case 3:            
        	if ( IsAddrPR(m_pszArgv[1]) ) {
            	if ( IsDataWordSub(m_pszArgv[2]) ) {
            		m_nPos = 3;
            		isTrue = TRUE;
            	}	
	            else {
			   		m_nPos = 2;
	        	}                 
	        }	
        	else {
        		m_nPos = 1;
        	}
			break;        
		default:
        	if ( IsAddrPR(m_pszArgv[1]) ) {
            	if ( IsDataWordSub(m_pszArgv[2]) ) {
            		m_nPos = 3;
            		isTrue = TRUE;
            	}	
	            else {
			   		m_nPos = 2;
	        	}                 
	        }	
        	else {
        		m_nPos = 1;
        	}
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckWordSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckCreateSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsVariableName(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;
			}                 
			else {
				m_nPos = 1;
			}
        	break;                 
        case 3:            
			if ( IsVariableName(m_pszArgv[1]) ) {
				if ( AdrIsOk(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}
				else {
					m_nPos = 2;
				}	
			}                 
			else {
				m_nPos = 1;
			}
			break;        
		default:
			if ( IsVariableName(m_pszArgv[1]) ) {
				if ( AdrIsOk(m_pszArgv[2]) ) {
					m_nPos = 100;
				}
				else {
					m_nPos = 2;
				}	
			}                 
			else {
				m_nPos = 1;
			}
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckCreateSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckDeleteSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
			if ( IsVariableName(m_pszArgv[1]) || 
            	 IsMacroVarName(m_pszArgv[1]) || 	
                 IsKeywordAll(m_pszArgv[1]) ) { 
            	m_nPos = 2;
            	isTrue = TRUE;
            }	  
            else {
            	m_nPos = 1;
            }   
        	break;        
		default:
			if ( IsVariableName(m_pszArgv[1]) || 
            	 IsMacroVarName(m_pszArgv[1]) || 	
                 IsKeywordAll(m_pszArgv[1]) ) { 
            	m_nPos = 2;
            }	  
            else {
            	m_nPos = 1;
            }   
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckDeleteSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckLoadSub(void)
{                
    BOOL isTrue = FALSE;
	int nRet = 0;
	
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	m_nPos = 2;
            	isTrue = TRUE;
            	break;
            }
           	m_nPos = 1;
        	break;                 
        case 3:
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	if ( IsLoadOption(m_nToken, m_pszArgv) ) {
            		if ( IsKeywordSymbols(m_pszArgv[2]) ||
            		     IsKeywordNosymbols(m_pszArgv[2]) ) {
            			m_nPos = 3;
            			isTrue = TRUE;
            			break;
            		}         
            		if ( IsKeywordCode(m_pszArgv[2]) ||
            		     IsKeywordNocode(m_pszArgv[2]) ) {
            			m_nPos = 4;
            			isTrue = TRUE;
            			break;
            		}         
            		if ( IsKeywordWarn(m_pszArgv[2]) ||
            		     IsKeywordNowarn(m_pszArgv[2]) ) {
            			m_nPos = 5;
            			isTrue = TRUE;
            			break;
            		}             		
            	}		
            	m_nPos = 2;               	
            	break;
            }
           	m_nPos = 1;
			break;        
        case 4:	         
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	if ( IsLoadOption(m_nToken, m_pszArgv) ) {
            		if ( IsKeywordSymbols(m_pszArgv[2]) ||
            		     IsKeywordNosymbols(m_pszArgv[2]) ) {
	            		if ( IsKeywordCode(m_pszArgv[3]) ||
	            		     IsKeywordNocode(m_pszArgv[3]) ) {
	            			m_nPos = 6;
	            			isTrue = TRUE;
	            			break;    
	            		}
	            		if ( IsKeywordWarn(m_pszArgv[3]) ||
	            		     IsKeywordNowarn(m_pszArgv[3]) ) {
	            			m_nPos = 7;
	            			isTrue = TRUE;
	            			break;
	            		}             		
	            			
            		}         
            		if ( IsKeywordCode(m_pszArgv[2]) ||
            		     IsKeywordNocode(m_pszArgv[2]) ) {
	            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
	            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
	            			m_nPos = 6;
	            			isTrue = TRUE;
	            			break;    
	            		}             
	            		if ( IsKeywordWarn(m_pszArgv[3]) ||
	            		     IsKeywordNowarn(m_pszArgv[3]) ) {
	            			m_nPos = 8;
	            			isTrue = TRUE;
	            			break;
	            		}             	            		     
            		}         
            		if ( IsKeywordWarn(m_pszArgv[2]) ||
            		     IsKeywordNowarn(m_pszArgv[2]) ) {
	            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
	            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
	            			m_nPos = 7;
	            			isTrue = TRUE;
	            			break;    
	            		}             
	            		if ( IsKeywordCode(m_pszArgv[3]) ||
	            		     IsKeywordNocode(m_pszArgv[3]) ) {
	            			m_nPos = 8;
	            			isTrue = TRUE;
	            			break;
	            		}             	            		     
            		}             		
            	}		
            	m_nPos = 2;               	
            	break;
            }
           	m_nPos = 1;
			break;                              
        case 5:	         
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	if ( IsLoadOption(m_nToken, m_pszArgv) ) {
            		m_nPos = 100;
            		isTrue = TRUE;      
            		break;
            	}     
        		if ( IsKeywordSymbols(m_pszArgv[2]) ||
        		     IsKeywordNosymbols(m_pszArgv[2]) ) {
            		if ( IsKeywordCode(m_pszArgv[3]) ||
            		     IsKeywordNocode(m_pszArgv[3]) ) {
            			m_nPos = 6;
            			break;    
            		}
            		if ( IsKeywordWarn(m_pszArgv[3]) ||
            		     IsKeywordNowarn(m_pszArgv[3]) ) {
            			m_nPos = 7;
            			break;
            		}             		
        		}         
        		if ( IsKeywordCode(m_pszArgv[2]) ||
        		     IsKeywordNocode(m_pszArgv[2]) ) {
            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
            			m_nPos = 6;
            			break;    
            		}             
            		if ( IsKeywordWarn(m_pszArgv[3]) ||
            		     IsKeywordNowarn(m_pszArgv[3]) ) {
            			m_nPos = 8;
            			break;
            		}             	            		     
        		}         
        		if ( IsKeywordWarn(m_pszArgv[2]) ||
        		     IsKeywordNowarn(m_pszArgv[2]) ) {
            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
            			m_nPos = 7;
            			break;    
            		}             
            		if ( IsKeywordCode(m_pszArgv[3]) ||
            		     IsKeywordNocode(m_pszArgv[3]) ) {
            			m_nPos = 8;
            			break;
            		}             	            		     
        		}             		
            	m_nPos = 2;
            	break;
            }		              
            m_nPos = 1;
		    break;
		default:                                        
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	if ( IsLoadOption(m_nArgc, m_pszArgv) ) {
            		m_nPos = 100;
            		break;
            	}     
        		if ( IsKeywordSymbols(m_pszArgv[2]) ||
        		     IsKeywordNosymbols(m_pszArgv[2]) ) {
            		if ( IsKeywordCode(m_pszArgv[3]) ||
            		     IsKeywordNocode(m_pszArgv[3]) ) {
	            		if ( IsKeywordWarn(m_pszArgv[4]) ||
	            		     IsKeywordNowarn(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            			
            			m_nPos = 6;
            			break;    
            		}
            		if ( IsKeywordWarn(m_pszArgv[3]) ||
            		     IsKeywordNowarn(m_pszArgv[3]) ) {
	            		if ( IsKeywordCode(m_pszArgv[4]) ||
	            		     IsKeywordNocode(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            			
            			m_nPos = 7;
            			break;
            		}             		
        		}         
        		if ( IsKeywordCode(m_pszArgv[2]) ||
        		     IsKeywordNocode(m_pszArgv[2]) ) {
            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
	            		if ( IsKeywordWarn(m_pszArgv[4]) ||
	            		     IsKeywordNowarn(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            	            		     
            			m_nPos = 6;
            			break;    
            		}             
            		if ( IsKeywordWarn(m_pszArgv[3]) ||
            		     IsKeywordNowarn(m_pszArgv[3]) ) {
	            		if ( IsKeywordSymbols(m_pszArgv[4]) ||
	            		     IsKeywordNosymbols(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            	            		     
            			m_nPos = 8;
            			break;
            		}             	            		     
        		}         
        		if ( IsKeywordWarn(m_pszArgv[2]) ||
        		     IsKeywordNowarn(m_pszArgv[2]) ) {
            		if ( IsKeywordSymbols(m_pszArgv[3]) ||
            		     IsKeywordNosymbols(m_pszArgv[3]) ) {
	            		if ( IsKeywordCode(m_pszArgv[4]) ||
	            		     IsKeywordNocode(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            		     
            			m_nPos = 7;
            			break;    
            		}             
            		if ( IsKeywordCode(m_pszArgv[3]) ||
            		     IsKeywordNocode(m_pszArgv[3]) ) {
	            		if ( IsKeywordSymbols(m_pszArgv[4]) ||
	            		     IsKeywordNosymbols(m_pszArgv[4]) ) {
	            			m_nPos = 100;
	            			break;
	            		}             	            		     
            			m_nPos = 8;
            			break;
            		}             	            		     
        		}             		
            	m_nPos = 2;
            	break;
            }		              
            m_nPos = 1;
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckLoadSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckQuerySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
            if ( IsSymbolName(m_pszArgv[1]) ||   
                 IsHexAddr(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            }
            else {
            	m_nPos = 1;
            }			
        	break;                 
		default:
            if ( IsSymbolName(m_pszArgv[1]) ||   
                 IsHexAddr(m_pszArgv[1]) ) {
            	m_nPos = 100;
            }
            else {
            	m_nPos = 1;
            }			
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckQuerySub().                                                    
                    

BOOL CSyntaxCheckSub::SyntaxCheckSsaveSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:   
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;
        	}		
        	break;
		default:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        	}
        	else {
        		m_nPos = 1;
        	}		
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckSsaveSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckSrecallSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:   
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;
        	}		
        	break;
		default:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        	}
        	else {
        		m_nPos = 1;
        	}		
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckSrecallSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckSymbolSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:           
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
				m_nPos = 100;
				isTrue = TRUE;
			}
			else {
				m_nPos = 1;
			}		        
        	break;
		default:
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
				m_nPos = 100;
			}
			else {
				m_nPos = 1;
			}		        
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckSymbolSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckWatchSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;
        	break;
        case 2:                       
			if (IsString(m_pszArgv[1]) ) {
	        	m_nPos = 100;
	        	isTrue = TRUE;
	        }
	        else {
				m_nPos = 1;	        
	        }	
        	break;
		default:
			if (IsString(m_pszArgv[1]) ) {
	        	m_nPos = 100;
	        }
	        else {
				m_nPos = 1;	        
	        }	
            break;
    }        
    
	return isTrue;    
}	//End of CSyntaxCheckSub::SyntaxCheckWatchSub().                                                    


void CSyntaxCheckSub::SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[])
{

    // Reset the error ID.
    m_nErrorID = 0;
    
    // Dispatch the syntax checking routine.
    switch ( m_nCommandID ) {    
        case CMDID_RUNMACRO:
			SetSyntaxColorRunMacro(nPos, nArgc, syncolor);
			break;
		case CMDID_VARDEFINE:
			SetSyntaxColorVarDefine(nPos, nArgc, syncolor);
			break;			
		case CMDID_ALIAS:
			SetSyntaxColorAlias(nPos, nArgc, syncolor);
			break;	
        case CMDID_ASSEMBLE:
            SetSyntaxColorAssemble(nPos, nArgc, syncolor);
            break;
        case CMDID_BREAKPOINT:
            SetSyntaxColorBreakpoint(nPos, nArgc, syncolor);
            break;               
		case CMDID_BYTE:
			SetSyntaxColorByte(nPos, nArgc, syncolor);
			break;	                                          
        case CMDID_CHECKSUM:
            SetSyntaxColorChecksum(nPos, nArgc, syncolor);
            break;
        case CMDID_CLEAR:
            SetSyntaxColorClear(nPos, nArgc, syncolor);
            break;             
        case CMDID_CLOCK:
        	SetSyntaxColorClock(nPos, nArgc, syncolor);
        	break;    
        case CMDID_COMPARE:
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
        case CMDID_CONTROL:
            SetSyntaxColorControl(nPos, nArgc, syncolor);
            break;
        case CMDID_COPY:         
        	//The syntax is same as Compare
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
        case CMDID_DISASSEMBLE:
            SetSyntaxColorDisassemble(nPos, nArgc, syncolor);
            break;          
        case CMDID_DIAGNOSIS:
            //SetSyntaxColorDiagnosis(nPos, nArgc, syncolor);
        	break;
        case CMDID_EVENT:
            if ( m_nEvent == 0 )
            	SetSyntaxColorEvent(nPos, nArgc, syncolor);
			if ( m_nEvent == 1 )
            	SetSyntaxColorEv1(nPos, nArgc, syncolor);
            if ( m_nEvent == 2 )
            	SetSyntaxColorEv2(nPos, nArgc, syncolor);
            if ( m_nEvent == 3 )
            	SetSyntaxColorEv3(nPos, nArgc, syncolor);		             	
            break;
        case CMDID_EV1:  
            SetSyntaxColorEv1(nPos, nArgc, syncolor);
            break;
        case CMDID_EV2:
            SetSyntaxColorEv2(nPos, nArgc, syncolor);
            break;
        case CMDID_EV3:
            SetSyntaxColorEv3(nPos, nArgc, syncolor);
            break;
        case CMDID_FILL:
            SetSyntaxColorFill(nPos, nArgc, syncolor);
            break;
        case CMDID_GO:
            SetSyntaxColorGo(nPos, nArgc, syncolor);
            break;
        case CMDID_HALT:
            SetSyntaxColorHalt(nPos, nArgc, syncolor);
            break;
        case CMDID_HELP:
            SetSyntaxColorHelp(nPos, nArgc, syncolor);
            break;             
        case CMDID_IDENTIFY:
            SetSyntaxColorIdentify(nPos, nArgc, syncolor);
            break;
        case CMDID_INCLUDE:
            SetSyntaxColorInclude(nPos, nArgc, syncolor);                      
            break;
        case CMDID_INPORT:
            SetSyntaxColorInport(nPos, nArgc, syncolor);
            break;
        case CMDID_JUMP:
            SetSyntaxColorJump(nPos, nArgc, syncolor);
            break;
        case CMDID_LIST:
            SetSyntaxColorList(nPos, nArgc, syncolor);
            break;
        case CMDID_LOG:
            SetSyntaxColorLog(nPos, nArgc, syncolor);
            break;
        case CMDID_MACRO:
        	SetSyntaxColorMacro(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MDEL:
        	SetSyntaxColorMdel(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MEMORY:
            SetSyntaxColorMemory(nPos, nArgc, syncolor);
            break;
        case CMDID_MEND:
        	SetSyntaxColorMend(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MLIST:
        	SetSyntaxColorMlist(nPos, nArgc, syncolor); 
        	break;
        case CMDID_OUTPORT:
            SetSyntaxColorOutport(nPos, nArgc, syncolor);
            break;
        case CMDID_QUALIFY:
            SetSyntaxColorQualify(nPos, nArgc, syncolor);
            break;
        case CMDID_REGISTER:
            SetSyntaxColorRegister(nPos, nArgc, syncolor);
            break;
        case CMDID_RESET:
            SetSyntaxColorReset(nPos, nArgc, syncolor);
            break;
        case CMDID_SEARCH:
            SetSyntaxColorSearch(nPos, nArgc, syncolor);
            break;              
        /*
        case CMDID_SELECTBREAKTYPE:
        	SetSyntaxColorSelectBreakType(nPos, nArgc, syncolor);    
        	break;
        */
        case CMDID_STEP:
            SetSyntaxColorStep(nPos, nArgc, syncolor);
            break;                      
        case CMDID_TEST:
            SetSyntaxColorTest(nPos, nArgc, syncolor);
            break;
        case CMDID_TRACE:
            SetSyntaxColorTrace(nPos, nArgc, syncolor);
            break;
        case CMDID_TRIGGER:
            SetSyntaxColorTrigger(nPos, nArgc, syncolor);
            break;
        case CMDID_UPLOAD:
            SetSyntaxColorUpload(nPos, nArgc, syncolor);
            break;
        case CMDID_VERIFY:
            SetSyntaxColorVerify(nPos, nArgc, syncolor);
            break;
        case CMDID_WORD:
            SetSyntaxColorWord(nPos, nArgc, syncolor);
            break;
        case CMDID_CREATE:
            SetSyntaxColorCreate(nPos, nArgc, syncolor);
            break;
        case CMDID_DELETE:
            SetSyntaxColorDelete(nPos, nArgc, syncolor);
            break;
        case CMDID_LOAD:
            SetSyntaxColorLoad(nPos, nArgc, syncolor);
            break;
        case CMDID_QUERY:
            SetSyntaxColorQuery(nPos, nArgc, syncolor);
            break;
        case CMDID_SSAVE:
            SetSyntaxColorSsave(nPos, nArgc, syncolor);
            break;
        case CMDID_SRECALL:
            SetSyntaxColorSrecall(nPos, nArgc, syncolor);
            break;
        case CMDID_SYMBOL:
            SetSyntaxColorSymbol(nPos, nArgc, syncolor);
            break;
        case CMDID_WATCH:
            SetSyntaxColorWatch(nPos, nArgc, syncolor);
            break;
        default:
            ASSERT( FALSE );
            break;
    }              

}

void CSyntaxCheckSub::SetSyntaxColorInit(int& nArgc, SynColor syncolor[])
{
	int i;                        
	nArgc = pHintsList[m_nCommandID].nCount;
    for ( i = 0; i < nArgc; i++ ) {
   		syncolor[i].nColor = COLOR_BLACK; 	    
    }

	i = 0;	                                                  
   	POSITION posHead  = pHintsList[m_nCommandID].plistHints->GetHeadPosition();
    while (posHead) {
		syncolor[i].strText = pHintsList[m_nCommandID].plistHints->GetNext(posHead); 
		i++;
	}	
	                                                  
}



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::SetSyntaxColor***().
//
//  Description: Set Syntax color routine. 51 routines.
//
//  Input:  nPos - The total token number of shell line          
//
//  Output: nArgc - The total token number of hints
//          syncolor - The struct of hints
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////


void CSyntaxCheckSub::SetSyntaxColorRunMacro(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                          
			//@macroname (arg0,...,arg9)
			syncolor[2].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	
}


void CSyntaxCheckSub::SetSyntaxColorVarDefine(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
}


void CSyntaxCheckSub::SetSyntaxColorAlias(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
		
	switch (nPos) {
		case 1:                         
			//Alias (original_name)
			syncolor[2].nColor = COLOR_RED;						
			break;
		case 2:       
			//Alias original_name (new_name)
			syncolor[3].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorAssemble(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:                             
			//Assemble (adr)
			syncolor[2].nColor = COLOR_RED;						
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorBreakpoint(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:            
			//Breakpoint (adr)
			syncolor[2].nColor = COLOR_RED;						
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorByte(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Byte (adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Byte adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Byte adr data1 (data32)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	
}
                                            
                                            
void CSyntaxCheckSub::SetSyntaxColorChecksum(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:               
			//Checksum (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:
			//Checksum adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;                       
		case 3:
			//Checksum adr1 Length length
			syncolor[6].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	

}


void CSyntaxCheckSub::SetSyntaxColorClear(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:                          
			//Clear (All|adr)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[4].nColor = COLOR_RED;			
			break;
		default:
			break;
	}			
}             


void CSyntaxCheckSub::SetSyntaxColorClock(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:             
			//Clock (Lp|Hs|Rc|Xt)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;				
			syncolor[8].nColor = COLOR_RED;			
			break;
		default:
			break;
	}			

}             


void CSyntaxCheckSub::SetSyntaxColorCompare(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                  
			//Compare (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:             
			//Compare adr1 (adr2|Length)                        
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                         
			//Compare adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 4:                           
			//Compare adr1 adr2 (adr3)
			//Compare adr1 Length length (adr3)
			syncolor[8].nColor = COLOR_RED;						
        default:
        	break;  
     }   	


}

void CSyntaxCheckSub::SetSyntaxColorControl(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);   
    
	switch (nPos) {
		case 1:                             
			//Control (Mclr|Watchdog)
			syncolor[2].nColor = COLOR_RED;						 
			syncolor[4].nColor = COLOR_RED;									
			break;
		case 2:           
			//Control Mclr (Enable|Disable)			
			syncolor[6].nColor = COLOR_RED;						
			syncolor[8].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	


}

/*
void CSyntaxCheckSub::SetSyntaxColorCopy(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

}
*/

void CSyntaxCheckSub::SetSyntaxColorDisassemble(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                            
			//Disassemble (adr1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 2:                 
			//Disassemble adr1 (adr2|Length)
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 3:                             
			//Disassemble adr1 Length (length)
			syncolor[7].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	

}

/*
void CSyntaxCheckSub::SetSyntaxColorDiagnosis(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			break;
		case 2:
			break;
		case 3:
			break;
		
        default:
        	break;  
     }   	

}
*/


void CSyntaxCheckSub::SetSyntaxColorEvent(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:        
			//Event (1|2|3|Clear)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheckSub::SetSyntaxColorEv1(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	if ( m_nEvent == 1) {	
		syncolor[0].strText = "Event 1 ";
	}	
	
	switch (nPos) {
		case 1:
			//Ev1 (Address|Datum|Count|Clear)
			syncolor[2].nColor = COLOR_RED;	  //Address			
			syncolor[12].nColor = COLOR_RED;  //Datum			
			syncolor[22].nColor = COLOR_RED;  //Count			
			syncolor[25].nColor = COLOR_RED;  //Clear				
			break;
		case 2:
			//Ev1 Address (Range|xadr|badrs)
			syncolor[4].nColor = COLOR_RED;	  
			syncolor[8].nColor = COLOR_RED;   
			syncolor[10].nColor = COLOR_RED;  			
			break;
		case 3:
			//Ev1 Datum (Range|xdata|bdata)
			syncolor[14].nColor = COLOR_RED;	  
			syncolor[18].nColor = COLOR_RED;   
			syncolor[20].nColor = COLOR_RED;  			
			break;
		case 4:                                   
			//Ev1 Count (data)
			syncolor[23].nColor = COLOR_RED;	  
			break;		
		case 5:
			//Ev1 Address Range (adr1)            
			syncolor[5].nColor = COLOR_RED;	  
			break;
		case 6:
			//Ev1 Address badrs..
			syncolor[10].nColor = COLOR_RED;	  	
			break;
		case 7:
			//Ev1 Address xadr (Datum|Count)			
			syncolor[12].nColor = COLOR_RED;  //Datum			
			syncolor[22].nColor = COLOR_RED;  //Count			
        	break;
        case 8:
        	//Ev1 Datum Range (data1)
        	syncolor[15].nColor = COLOR_RED;	  
        	break;	
        case 9:
        	//Ev1 Datum (bdata)
        	syncolor[20].nColor = COLOR_RED;	  
        	break;	
        case 10:
        	//Ev1 Datum (xdata)
        	syncolor[18].nColor = COLOR_RED;	  
        	break;	
        case 11:
        	//Ev1 Count (data)
        	syncolor[23].nColor = COLOR_RED;	  
        	break;  
        case 12:
        	//Ev1 Address Range adr1 (adr2)
        	syncolor[6].nColor = COLOR_RED;	  
        	break;	
        case 13:
        	//Ev1 Datum Range data1 (data2)
        	syncolor[16].nColor = COLOR_RED;	  
        	break;	                            
        case 14:
        	//Ev1 Address .. Datum ..(Count)
			syncolor[22].nColor = COLOR_RED;  //Count			
        	break;                          
        case 15:
        	//Ev1 Address ..Count ..(Datum)	                            
        	syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;                              
        case 16:
        	//Ev1 Datum .. Count .. (Address)	                
        	syncolor[2].nColor = COLOR_RED;	  //Address			
        	break;
        case 17:
        	//Ev1 Datum ..(Address|Count)                       
        	syncolor[2].nColor = COLOR_RED;	  //Address			
        	syncolor[22].nColor = COLOR_RED;  //Count			
        	break;
        case 18:
        	//Ev1 Count .. (Address|Datum)	        		
			syncolor[2].nColor = COLOR_RED;	  //Address			
			syncolor[12].nColor = COLOR_RED;  //Datum			
    		break;    	
		case 19:
			//Ev1 Address (badr..|Datum|Count)			
			syncolor[10].nColor = COLOR_RED;  			
			syncolor[12].nColor = COLOR_RED;  //Datum			
			syncolor[22].nColor = COLOR_RED;  //Count			
        	break;
        case 20:
        	//Ev1 Datum ..Address .. (badr..|Count)            
        	syncolor[10].nColor = COLOR_RED;  			
			syncolor[22].nColor = COLOR_RED;  //Count			
        	break;                          
        case 21:
        	//Ev1 Count ..Address (badr..|Datum)	            
        	syncolor[10].nColor = COLOR_RED;  			                
        	syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;                        
		default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorEv2(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);

	if ( m_nEvent == 2) {	
		syncolor[0].strText = "Event 2 ";
	}	
	
	switch (nPos) {
		case 1:
			//Ev2 (Address|Datum|Clear)
			syncolor[2].nColor = COLOR_RED;	  //Address			
			syncolor[12].nColor = COLOR_RED;  //Datum			
			syncolor[22].nColor = COLOR_RED;  //Clear				
			break;
		case 2:
			//Ev2 Address (Range|xadr|badrs)
			syncolor[4].nColor = COLOR_RED;	  
			syncolor[8].nColor = COLOR_RED;   
			syncolor[10].nColor = COLOR_RED;  			
			break;
		case 3:
			//Ev2 Datum (Range|xdata|bdata)
			syncolor[14].nColor = COLOR_RED;	  
			syncolor[18].nColor = COLOR_RED;   
			syncolor[20].nColor = COLOR_RED;  			
			break;
		case 4:
			//Ev2 Address Range (adr1)            
			syncolor[5].nColor = COLOR_RED;	  
			break;
        case 5:
        	//Ev2 Address Range adr1 (adr2)
        	syncolor[6].nColor = COLOR_RED;	  
        	break;	
		case 6:
			//Ev2 Address (badrs..)
			syncolor[10].nColor = COLOR_RED;	  	
			break;
		case 7:
			//Ev2 Address.. (Datum)			
			syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;         
		case 8:
			//Ev2 Address.. (badrs..|Datum)			
			syncolor[10].nColor = COLOR_RED;	  	
			syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;         
        case 9:
        	//Ev2 Datum Range (data1)
        	syncolor[15].nColor = COLOR_RED;	  
        	break;	
        case 10:
        	//Ev2 Datum Range data1 (data2)
        	syncolor[16].nColor = COLOR_RED;	  
        	break;
        case 11:
        	//Ev2 Datum..(Address)	                
        	syncolor[2].nColor = COLOR_RED;	  //Address			
        	break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorEv3(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);

	if ( m_nEvent == 3) {	
		syncolor[0].strText = "Event 3 ";
	}	
	
	switch (nPos) {
		case 1:                        
			//Ev3 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;			
			syncolor[12].nColor = COLOR_RED;			
			syncolor[14].nColor = COLOR_RED;							
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheckSub::SetSyntaxColorFill(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Fill (adr1)
			syncolor[1].nColor = COLOR_RED;				
			break;
		case 2:          
			//Fill adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;				
			syncolor[5].nColor = COLOR_RED;				
			break;
		case 3:                      
			//Fill adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;						
			break;
		case 4:                 
			//Fill adr1 ...("string"|data..)
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;									
			break;
		case 5:
			//Fill p:0 ...(data..)
			syncolor[10].nColor = COLOR_RED;									
			break;
        default:                                                
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorGo(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:               
			//Go (Run|From|Till|Monitor)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[7].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;				
			syncolor[13].nColor = COLOR_RED;				
			break;
		case 2: 
			//Go Run (From)
			syncolor[4].nColor = COLOR_RED;						
			break;
		case 3: 
			//Go From (adr1)
			syncolor[8].nColor = COLOR_RED;						
			break;    
		case 4:      
			//Go Till (adr2)
			syncolor[11].nColor = COLOR_RED;							
		    break;                                                            
		case 5:		 
			//Go Monitor (timer)
			syncolor[14].nColor = COLOR_RED;							
		    break;                                                            
		case 6:
			//Go Run From (adr1)
			syncolor[5].nColor = COLOR_RED;										
			break;
		case 7:
			//Go From adr1 (Till)
			syncolor[10].nColor = COLOR_RED;							
			break;
		case 8:
			//Go From adr1 Till (adr2)
			syncolor[11].nColor = COLOR_RED;										
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorHalt(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheckSub::SetSyntaxColorHelp(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                  
			//Help (command)
			syncolor[2].nColor = COLOR_RED;							
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorIdentify(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheckSub::SetSyntaxColorInclude(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:             
			//Include (filename)
			syncolor[1].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorInport(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                            
			//Inport (port)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:          
			//Inport port (Bit|byte)
			syncolor[3].nColor = COLOR_RED;
			syncolor[6].nColor = COLOR_RED;
			break;
		case 3:       
			//Inport port Bit (bit_no)
			syncolor[4].nColor = COLOR_RED;
			break;    		
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorJump(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                 
			//Jump (adr)
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorList(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//List (Buffer1|Buffer2)
			syncolor[2].nColor = COLOR_RED;
			syncolor[4].nColor = COLOR_RED;
			break;
		case 2:       
			//List Buffer1 (Number|Source|Assemble|Mixed|Module|frame|Address) 
			syncolor[6].nColor = COLOR_RED;
			syncolor[8].nColor = COLOR_RED;
			syncolor[10].nColor = COLOR_RED;
			syncolor[12].nColor = COLOR_RED;
			syncolor[14].nColor = COLOR_RED;
			syncolor[16].nColor = COLOR_RED;
			syncolor[18].nColor = COLOR_RED;
			break;
		case 3:        
			//List Buffer1 Source (frame|Address)
			syncolor[16].nColor = COLOR_RED;
			syncolor[18].nColor = COLOR_RED;
			break;
		case 4:        
			//List Buffer1 Source frame (Address)
			syncolor[18].nColor = COLOR_RED;
			break;
		case 5:
			//List .. Address (Range|xadr|badrs..)
			syncolor[20].nColor = COLOR_RED;
			syncolor[24].nColor = COLOR_RED;
			syncolor[26].nColor = COLOR_RED;                       
			break;     			
		case 6:
			//List .. Address Range (adr1)
			syncolor[21].nColor = COLOR_RED;
			break;     			
		case 7:
			//List .. Address Range adr1 (adr2)
			syncolor[22].nColor = COLOR_RED;
			break;     			
		case 8:
			//List .. Address (badrs..)
			syncolor[26].nColor = COLOR_RED;
			break;     			
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorLog(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:         
			//Log (filename|On|Off|Close)
			syncolor[2].nColor = COLOR_RED;	
			syncolor[8].nColor = COLOR_RED;											
			syncolor[10].nColor = COLOR_RED;											
			syncolor[12].nColor = COLOR_RED;	
			break;
		case 2:                          
			//Log filename (Command|Append)
			syncolor[4].nColor = COLOR_RED;	
			syncolor[6].nColor = COLOR_RED;	
			break;
		case 3:
			//Log filename Command (Append)
			syncolor[6].nColor = COLOR_RED;					
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorMacro(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Macro (macroname)
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorMdel(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Mdel (macroname|All)
			syncolor[1].nColor = COLOR_RED;											
			syncolor[3].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorMemory(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1: 
			//Memory (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:           
			//Memory adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                   
			//Memory adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorMend(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheckSub::SetSyntaxColorMlist(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Mlist (macroname)
			syncolor[2].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorOutport(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Outport (port)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:  
			//Outport port (Mask|Byte)
			syncolor[3].nColor = COLOR_RED;						
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 3:       
			//Outport port Mask (data1)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
		case 4:       
			//Outport port Mask data1 (Byte)
			syncolor[6].nColor = COLOR_RED;			
			break;    		                        
		case 5:
			//Outport port Byte (data2)
			syncolor[7].nColor = COLOR_RED;								
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorQualify(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
  
	switch (nPos) {
		case 1:
			//Qualify (Address|Datum|Clear)
			syncolor[2].nColor = COLOR_RED;	  //Address			
			syncolor[12].nColor = COLOR_RED;  //Datum			
			syncolor[22].nColor = COLOR_RED;  //Clear				
			break;
		case 2:
			//Qualify Address (Range|xadr|badrs)
			syncolor[4].nColor = COLOR_RED;	  
			syncolor[8].nColor = COLOR_RED;   
			syncolor[10].nColor = COLOR_RED;  			
			break;
		case 3:
			//Qualify Datum (Range|xdata|bdata)
			syncolor[14].nColor = COLOR_RED;	  
			syncolor[18].nColor = COLOR_RED;   
			syncolor[20].nColor = COLOR_RED;  			
			break;
		case 4:
			//Qualify Address Range (adr1)            
			syncolor[5].nColor = COLOR_RED;	  
			break;
        case 5:
        	//Qualify Address Range adr1 (adr2)
        	syncolor[6].nColor = COLOR_RED;	  
        	break;	
		case 6:
			//Qualify Address (badrs..)
			syncolor[10].nColor = COLOR_RED;	  	
			break;
		case 7:
			//Qualify Address.. (Datum)			
			syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;         
		case 8:
			//Qualify Address.. (badrs..|Datum)			
			syncolor[10].nColor = COLOR_RED;	  	
			syncolor[12].nColor = COLOR_RED;  //Datum			
        	break;         
        case 9:
        	//Qualify Datum Range (data1)
        	syncolor[15].nColor = COLOR_RED;	  
        	break;	
        case 10:
        	//Qualify Datum Range data1 (data2)
        	syncolor[16].nColor = COLOR_RED;	  
        	break;
        case 11:
        	//Qualify Datum..(Address)	                
        	syncolor[2].nColor = COLOR_RED;	  //Address			
        	break;
        default:
        	break;  
     }   	

  
/*	
	switch (nPos) {
		case 1:                                 
			//Qualify (Address|Clear)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[12].nColor = COLOR_RED;											
			break;
		case 2:      
			//Qualify Address (Range |xadr|badrs..)
			syncolor[4].nColor = COLOR_RED;											
			syncolor[8].nColor = COLOR_RED;											
			syncolor[10].nColor = COLOR_RED;											
			break;
		case 3:
			//Qualify Address Range (adr1)
			syncolor[5].nColor = COLOR_RED;											
			break;
		case 4:
			//Qualify Address badrs..
			syncolor[10].nColor = COLOR_RED;											
			break;
		case 5:
			//Qualify Address Range adr1 (adr2)
			syncolor[6].nColor = COLOR_RED;											
			break;    
        default:
        	break;  
     }   	
*/
}

void CSyntaxCheckSub::SetSyntaxColorRegister(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Register (reg_id)
			syncolor[2].nColor = COLOR_RED;
			break;
		case 2:                
			//Register reg_id (data)            
			syncolor[4].nColor = COLOR_RED;
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorReset(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                     
			//Reset (adr)
			syncolor[2].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}
                                         
void CSyntaxCheckSub::SetSyntaxColorSearch(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Search (adr1)
			syncolor[1].nColor = COLOR_RED;				
			break;
		case 2:          
			//Search adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;				
			syncolor[5].nColor = COLOR_RED;				
			break;
		case 3:                      
			//Search adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;						
			break;
		case 4:                 
			//Search adr1 ...(Insensitive|"string"|data..)
			syncolor[8].nColor = COLOR_RED;							
			syncolor[10].nColor = COLOR_RED;				
			syncolor[12].nColor = COLOR_RED;					
			break;				
		case 5:
			//Search adr1 adr2 Insensitive ("string")
			syncolor[10].nColor = COLOR_RED;					
			break;
		case 6:                 
			//Search p:0 ...(data..)
			syncolor[12].nColor = COLOR_RED;					
			break;							
        default:                                                
        	break;  
     }   	

}

/*
void CSyntaxCheckSub::SetSyntaxColorSelectBreakType(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			syncolor[2].nColor = COLOR_RED;				
			break;
        default:                                                
        	break;  
     }   	
		
}
*/

void CSyntaxCheckSub::SetSyntaxColorStep(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:        
			//Step (Over|count|Forever|adr1|Till)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[4].nColor = COLOR_RED;											
			syncolor[6].nColor = COLOR_RED;											
			syncolor[8].nColor = COLOR_RED;											
			syncolor[11].nColor = COLOR_RED;											
			break;
		case 2:   
			//Step Over (count|Forever|adr1|Till)
			syncolor[4].nColor = COLOR_RED;											
			syncolor[6].nColor = COLOR_RED;											
			syncolor[8].nColor = COLOR_RED;											
			syncolor[11].nColor = COLOR_RED;											
			break;
		case 3:
			//Step adr1 (adr2)
			syncolor[9].nColor = COLOR_RED;											
			break;    
		case 4:	
			//Step Till (Ret|Call)
        	syncolor[13].nColor = COLOR_RED;											
        	syncolor[15].nColor = COLOR_RED;
        	break;
        case 5:   
        	//Step Over adr1 (adr2) 
        	syncolor[9].nColor = COLOR_RED;											
        	break;	
        case 6:   
        	//Step Over Till (Ret|Call)
        	syncolor[13].nColor = COLOR_RED;											
        	syncolor[15].nColor = COLOR_RED;
        	break;	
        default:
        	break;  
     }   	

}


void CSyntaxCheckSub::SetSyntaxColorTest(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:          
			//Test (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:          
			//Test adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                      
			//Test adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		
        default:
        	break;  
     }   	                            

}


void CSyntaxCheckSub::SetSyntaxColorTrace(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                        
			//Trace (On|Off|Buffer1|Buffer2)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorTrigger(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:    
			//Trigger (EV1|..|EV3 Then EV2|On|Off|Backward|Forward)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			syncolor[10].nColor = COLOR_RED;			
			syncolor[12].nColor = COLOR_RED;			
			syncolor[14].nColor = COLOR_RED;			
			syncolor[16].nColor = COLOR_RED;			
			syncolor[18].nColor = COLOR_RED;			
			syncolor[20].nColor = COLOR_RED;			
			syncolor[22].nColor = COLOR_RED;			
			syncolor[24].nColor = COLOR_RED;			
			syncolor[26].nColor = COLOR_RED;			
			syncolor[28].nColor = COLOR_RED;		
			syncolor[30].nColor = COLOR_RED;			
			break;
		case 2:                                     
			//Trigger EV1 (Forward|Backward)
			syncolor[24].nColor = COLOR_RED;		
			syncolor[26].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorUpload(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                             
			//Upload (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:            
			//Upload adr1 (adr2|Length)                         
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                        
			//Upload adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 4:                          
			//Upload adr1 adr2 (filename)
			syncolor[8].nColor = COLOR_RED;						
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorVerify(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                          
			//Verify (On|Off)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheckSub::SetSyntaxColorWord(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Word (adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Word adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Word adr data1 (..data16)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorCreate(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                        
			//Create (#symbol)             
			syncolor[1].nColor = COLOR_RED;					
			break;
		case 2:               
			//Create #symbol (adr)
			syncolor[2].nColor = COLOR_RED;					
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorDelete(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                   
			//Delete (#symbol|$variable|All)                          
			syncolor[1].nColor = COLOR_RED;					
			syncolor[3].nColor = COLOR_RED;					
			syncolor[5].nColor = COLOR_RED;													
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorLoad(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Load (filename)
			syncolor[1].nColor = COLOR_RED;					
			break;
		case 2:
			//Load filename (Symbols|Nosymbols|Code|Nocode|Warn|Nowarn)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			break;
		case 3:   
			//Load filename Symbols (Code|Nocode|Warn|Nowarn)		
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			break;
		case 4:
			//Load filename Code (Symbols|Nosymbols|Warn|Nowarn)		
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			break;
		case 5:
			//Load filename Warn (Symbols|Nosymbols|Code|Nocode)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			break;
		case 6:
			//Load filename Symbols Code (Warn|Nowarn)
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			break;
		case 7:
			//Load filename Symbols Warn (Code|Nocode)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			break;
		case 8: 
			//Load filename Code Warn (Symbols|Nosymbols)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			break;
        default:                                                    
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorQuery(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                    
			//Query (#symbol|hex_adr)
			syncolor[1].nColor = COLOR_RED;					
			syncolor[3].nColor = COLOR_RED;					
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorSsave(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                      
			//Ssave (filename)      
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorSrecall(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Srecall (filename)
			syncolor[1].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorSymbol(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:      
			//Symbol (Global|Module|#module|Lines)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[4].nColor = COLOR_RED;									
			syncolor[6].nColor = COLOR_RED;															
			syncolor[8].nColor = COLOR_RED;												
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheckSub::SetSyntaxColorWatch(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                                 
			//Watch ("C-Expression")			
			syncolor[1].nColor = COLOR_RED;	
			break;
        default:
        	break;  
     }   	

}

